/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapIterator;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DapDataset
extends DapGroup {
    protected List<DapNode> nodelist = new ArrayList<DapNode>();
    protected Map<String, DapNode> fqnmap = new HashMap<String, DapNode>();
    protected List<DapDimension> anonymousdims = new ArrayList<DapDimension>();
    protected String dapversion = null;
    protected String dmrversion = null;
    protected String base = null;
    protected String ns = null;
    protected List<DapVariable> topvariables = null;
    protected List<DapVariable> allvariables = null;
    protected List<DapGroup> allgroups = null;
    protected List<DapEnum> allenums = null;
    protected List<DapDimension> alldimensions = null;
    protected boolean finished = false;

    public DapDataset() {
        this.addNode(this);
    }

    public DapDataset(String name) {
        super(name);
        this.addNode(this);
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.topvariables = new ArrayList<DapVariable>();
        this.allvariables = new ArrayList<DapVariable>();
        this.allgroups = new ArrayList<DapGroup>();
        this.allenums = new ArrayList<DapEnum>();
        this.alldimensions = new ArrayList<DapDimension>();
        this.finishR(this);
    }

    protected void finishR(DapNode node) {
        switch (node.getSort()) {
            case DIMENSION: {
                this.alldimensions.add((DapDimension)node);
                break;
            }
            case ENUMERATION: {
                this.allenums.add((DapEnum)node);
                break;
            }
            case ATOMICVARIABLE: 
            case GRID: 
            case SEQUENCE: 
            case STRUCTURE: {
                if (node.isTopLevel()) {
                    this.topvariables.add((DapVariable)node);
                }
                this.allvariables.add((DapVariable)node);
                break;
            }
            case GROUP: 
            case DATASET: {
                DapGroup g = (DapGroup)node;
                this.allgroups.add(g);
                for (DapNode subnode : g.getDecls()) {
                    this.finishR(subnode);
                }
                break;
            }
        }
    }

    public String getDapVersion() {
        return this.dapversion;
    }

    public void setDapVersion(String value) {
        this.dapversion = value;
    }

    public String getDMRVersion() {
        return this.dmrversion;
    }

    public void setDMRVersion(String value) {
        this.dmrversion = value;
    }

    public String getNS() {
        return this.ns;
    }

    public void setNS(String value) {
        this.ns = value;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String value) {
        this.base = value;
    }

    public Map<String, DapNode> getFQNMap() {
        return this.fqnmap;
    }

    public void setFQNMap(Map<String, DapNode> fqnmap) {
        this.fqnmap = fqnmap;
    }

    public List<DapNode> getNodeList() {
        return this.nodelist;
    }

    public void addNode(DapNode newnode) {
        if (this.nodelist == null) {
            this.nodelist = new ArrayList<DapNode>();
        }
        newnode.setIndex(this.nodelist.size());
        this.nodelist.add(newnode);
    }

    public DapDimension createAnonymous(long size) throws DapException {
        for (DapDimension dim : this.anonymousdims) {
            if (dim.getSize() != size) continue;
            return dim;
        }
        DapDimension anon = new DapDimension();
        anon.setSize(size);
        this.anonymousdims.add(anon);
        this.addDecl(anon);
        return anon;
    }

    public DapIterator getIterator(EnumSet<DapSort> sortset) {
        return new DapIterator(this.nodelist, sortset);
    }

    public List<DapVariable> getTopVariables() {
        return this.topvariables;
    }

    public List<DapVariable> getAllVariables() {
        return this.allvariables;
    }

    public List<DapGroup> getAllGroups() {
        return this.groups;
    }

    public List<DapEnum> getAllEnums() {
        return this.enums;
    }

    public List<DapDimension> getAllDimensions() {
        return this.dimensions;
    }

    public List<DapNode> lookup(String fqn, EnumSet<DapSort> sortset) throws DapException {
        ArrayList<DapNode> matches = new ArrayList<DapNode>();
        if ((fqn = fqn.trim()) == null) {
            return null;
        }
        if ("".equals(fqn) || "/".equals(fqn)) {
            matches.add(this);
            return matches;
        }
        if (fqn.charAt(0) != '/') {
            return null;
        }
        fqn = fqn.substring(1);
        List<String> path = DapUtil.backslashSplit(fqn, '/');
        DapGroup current = this.dataset;
        for (int i = 0; i < path.size() - 1; ++i) {
            String groupname = Escape.backslashUnescape(path.get(i));
            DapNode g = current.findInGroup(groupname, DapSort.GROUP);
            if (g == null) {
                return null;
            }
            assert (g.getSort() == DapSort.GROUP);
            current = (DapGroup)g;
        }
        String varpart = path.get(path.size() - 1);
        List<String> structpath = DapUtil.backslashSplit(varpart, '.');
        String outer = Escape.backslashUnescape(structpath.get(0));
        if (structpath.size() == 1) {
            matches.addAll(current.findInGroup(outer, sortset));
        } else {
            DapVariable field;
            String fieldname;
            DapStructure currentstruct = (DapStructure)current.findInGroup(outer, DapSort.STRUCTURE);
            if (currentstruct == null) {
                return null;
            }
            for (int i = 1; i < structpath.size() - 1; ++i) {
                fieldname = Escape.backslashUnescape(structpath.get(i));
                DapVariable field2 = currentstruct.findByName(fieldname);
                if (field2 == null) {
                    throw new DapException("No such field: " + fieldname);
                }
                if (field2.getSort() != DapSort.STRUCTURE) break;
                currentstruct = (DapStructure)field2;
            }
            if ((field = currentstruct.findByName(fieldname = Escape.backslashUnescape(structpath.get(structpath.size() - 1)))) == null) {
                throw new DapException("No such field: " + fieldname);
            }
            if (sortset.contains((Object)field.getSort())) {
                matches.add(field);
            }
        }
        return matches;
    }

    public void sort() {
        ArrayList<DapNode> sorted = new ArrayList<DapNode>();
        this.sortR(this, sorted);
        for (int i = 0; i < sorted.size(); ++i) {
            ((DapNode)sorted.get(i)).setIndex(i);
        }
        this.nodelist = sorted;
    }

    public void sortR(DapNode node, List<DapNode> sortlist) {
        DapVariable var = null;
        Map<String, DapAttribute> attrs = null;
        sortlist.add(node);
        switch (node.getSort()) {
            case GROUP: 
            case DATASET: {
                List<DapGroup> groups;
                List<DapVariable> vars;
                List<DapEnum> enums;
                DapGroup group = (DapGroup)node;
                attrs = group.getAttributes();
                for (Map.Entry<String, DapAttribute> entry : attrs.entrySet()) {
                    this.sortR(entry.getValue(), sortlist);
                }
                List<DapDimension> dims = group.getDimensions();
                if (dims != null) {
                    for (int i = 0; i < dims.size(); ++i) {
                        this.sortR(dims.get(i), sortlist);
                    }
                }
                if ((enums = group.getEnums()) != null) {
                    for (int i = 0; i < enums.size(); ++i) {
                        this.sortR(enums.get(i), sortlist);
                    }
                }
                if ((vars = group.getVariables()) != null) {
                    for (int i = 0; i < vars.size(); ++i) {
                        this.sortR(vars.get(i), sortlist);
                    }
                }
                if ((groups = group.getGroups()) == null) break;
                for (int i = 0; i < groups.size(); ++i) {
                    this.sortR(groups.get(i), sortlist);
                }
                break;
            }
            case GRID: 
            case SEQUENCE: 
            case STRUCTURE: {
                DapStructure struct = (DapStructure)node;
                List<DapVariable> fields = struct.getFields();
                if (fields != null) {
                    for (int i = 0; i < fields.size(); ++i) {
                        this.sortR(fields.get(i), sortlist);
                    }
                }
            }
            case ATOMICVARIABLE: {
                List<DapDimension> dims;
                List<DapMap> maps;
                var = (DapVariable)node;
                attrs = var.getAttributes();
                if (attrs != null) {
                    for (Map.Entry<String, DapAttribute> entry : attrs.entrySet()) {
                        this.sortR(entry.getValue(), sortlist);
                    }
                }
                if ((maps = var.getMaps()) != null) {
                    for (int i = 0; i < maps.size(); ++i) {
                        this.sortR(maps.get(i), sortlist);
                    }
                }
                if ((dims = var.getDimensions()) == null) break;
                for (int i = 0; i < dims.size(); ++i) {
                    this.sortR(dims.get(i), sortlist);
                }
                break;
            }
            case ATTRIBUTE: {
                attrs = node.getAttributes();
                if (attrs == null) break;
                for (String name : attrs.keySet()) {
                    this.sortR(attrs.get(name), sortlist);
                }
                break;
            }
        }
    }
}

