/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataAtomic;
import dap4.core.data.DataException;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataVariable;
import dap4.dap4shared.Dap4Util;
import java.nio.ByteBuffer;
import java.util.List;

public class D4DataAtomic
extends D4DataVariable
implements DataAtomic {
    protected long product = 0L;
    protected DapType basetype = null;
    protected AtomicType atomictype = null;
    protected boolean isscalar = false;
    protected long varoffset = -1L;
    protected long varelementsize = 0L;
    protected boolean isbytestring = false;
    protected long totalbytestringsize = 0L;
    protected int[] bytestrings = null;

    public D4DataAtomic(D4DSP dsp, DapAtomicVariable dap, int offset) throws DataException {
        super(dsp, dap);
        this.dsp = dsp;
        this.varoffset = offset;
        this.basetype = dap.getBaseType();
        this.atomictype = this.basetype.getPrimitiveType();
        this.product = DapUtil.dimProduct(dap.getDimensions());
        this.varelementsize = Dap4Util.daptypeSize(this.basetype.getPrimitiveType());
        this.isbytestring = this.atomictype.isStringType() || this.atomictype.isOpaqueType();
    }

    void setByteStringOffsets(long totalsize, int[] offsets) {
        this.totalbytestringsize = totalsize;
        this.bytestrings = offsets;
    }

    @Override
    public DapType getType() {
        return this.basetype;
    }

    @Override
    public long getCount() {
        return this.product;
    }

    @Override
    public long getElementSize() {
        return 0L;
    }

    @Override
    public void read(List<Slice> slices, Object data, long offset) throws DataException {
        if (slices == null || slices.size() == 0) {
            this.extractObjectVector(this.basetype, this.dsp.getData(), 0L, 1L, data, 0L);
        } else {
            Odometer odom;
            boolean contig = DapUtil.isContiguous(slices);
            try {
                odom = Odometer.factory(slices, ((DapVariable)this.getTemplate()).getDimensions(), contig);
            }
            catch (DapException de) {
                throw new DataException(de);
            }
            long localoffset = offset;
            if (odom.isContiguous()) {
                List<Slice> pieces = odom.getContiguous();
                assert (pieces.size() == 1);
                Slice lastslice = pieces.get(0);
                assert (lastslice.getStride() == 1L);
                long first = lastslice.getFirst();
                long extent = lastslice.getCount();
                while (odom.hasNext()) {
                    long index = odom.next();
                    this.extractObjectVector(this.basetype, this.dsp.getData(), index + first, extent, data, localoffset);
                    localoffset += extent;
                }
            } else {
                while (odom.hasNext()) {
                    long index = odom.next();
                    this.extractObjectVector(this.basetype, this.dsp.getData(), index, 1L, data, localoffset);
                    ++localoffset;
                }
            }
        }
    }

    @Override
    public Object read(long index) throws DataException {
        Object result = this.extractObject(this.basetype, this.dsp.getData(), index);
        return result;
    }

    protected void setup(long index) {
        ByteBuffer databuffer = this.dsp.getData();
        if (index < 0L || index > this.product) {
            throw new IndexOutOfBoundsException("D4DataAtomic: " + index);
        }
        if (this.isbytestring) {
            databuffer.position(this.bytestrings[(int)index]);
        } else {
            databuffer.position((int)(this.varoffset + this.varelementsize * index));
        }
    }

    protected Object extractObject(DapType basetype, ByteBuffer dataset, long index) {
        Object result = null;
        long lvalue = 0L;
        AtomicType atomtype = basetype.getPrimitiveType();
        this.setup(index);
        switch (atomtype) {
            case Char: {
                lvalue = dataset.get();
                result = new Character((char)(lvalue &= 0xFFL));
                break;
            }
            case UInt8: 
            case Int8: {
                result = new Byte(dataset.get());
                break;
            }
            case Int16: 
            case UInt16: {
                result = new Short(dataset.getShort());
                break;
            }
            case Int32: 
            case UInt32: {
                result = new Integer(dataset.getInt());
                break;
            }
            case Int64: 
            case UInt64: {
                result = new Long(dataset.getLong());
                break;
            }
            case Float32: {
                result = new Float(dataset.getFloat());
                break;
            }
            case Float64: {
                result = new Double(dataset.getDouble());
                break;
            }
            case String: 
            case URL: {
                long count = dataset.getLong();
                byte[] bytes = new byte[(int)count];
                dataset.get(bytes);
                result = new String(bytes, DapUtil.UTF8);
                break;
            }
            case Opaque: {
                long count = dataset.getLong();
                byte[] bytes = new byte[(int)count];
                dataset.get(bytes);
                result = ByteBuffer.wrap(bytes);
                break;
            }
            case Enum: {
                result = this.extractObject(((DapEnum)basetype).getBaseType(), dataset, index);
            }
        }
        return result;
    }

    protected void extractObjectVector(DapType basetype, ByteBuffer dataset, long start, long count, Object vector, long offset) {
        int ioffset = (int)offset;
        long position = dataset.position();
        AtomicType atomtype = basetype.getPrimitiveType();
        this.setup(start);
        long elemsize = this.varelementsize;
        switch (atomtype) {
            case Char: {
                char[] cresult = (char[])vector;
                int i = 0;
                while ((long)i < count) {
                    int ascii = dataset.get();
                    cresult[ioffset + i] = (char)(ascii &= 0x7F);
                    ++i;
                }
                break;
            }
            case UInt8: 
            case Int8: {
                byte[] byresult = (byte[])vector;
                dataset.get(byresult, ioffset, (int)count);
                break;
            }
            case Int16: 
            case UInt16: {
                short[] shresult = (short[])vector;
                dataset.asShortBuffer().get(shresult, ioffset, (int)count);
                break;
            }
            case Int32: 
            case UInt32: {
                int[] iresult = (int[])vector;
                dataset.asIntBuffer().get(iresult, ioffset, (int)count);
                break;
            }
            case Int64: 
            case UInt64: {
                long[] lresult = (long[])vector;
                dataset.asLongBuffer().get(lresult, ioffset, (int)count);
                break;
            }
            case Float32: {
                float[] fresult = (float[])vector;
                dataset.asFloatBuffer().get(fresult, ioffset, (int)count);
                break;
            }
            case Float64: {
                double[] dresult = (double[])vector;
                dataset.asDoubleBuffer().get(dresult, ioffset, (int)count);
                break;
            }
            case String: 
            case URL: {
                String[] sresult = (String[])vector;
                int i = 0;
                while ((long)i < count) {
                    dataset.position(this.bytestrings[(int)start + i]);
                    long scount = dataset.getLong();
                    byte[] bytes = new byte[(int)scount];
                    dataset.get(bytes);
                    sresult[ioffset + i] = new String(bytes, DapUtil.UTF8);
                    ++i;
                }
                break;
            }
            case Opaque: {
                ByteBuffer[] oresult = (ByteBuffer[])vector;
                int i = 0;
                while ((long)i < count) {
                    dataset.position(this.bytestrings[(int)start + i]);
                    long scount = dataset.getLong();
                    byte[] bytes = new byte[(int)scount];
                    dataset.get(bytes);
                    oresult[ioffset + i] = ByteBuffer.wrap(bytes);
                    ++i;
                }
                break;
            }
            case Enum: {
                this.extractObjectVector(((DapEnum)basetype).getBaseType(), dataset, start, count, vector, offset);
            }
        }
    }
}

