/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthScope;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPUtil;

@Immutable
public abstract class HTTPAuthUtil {
    public static final String ANY_HOST = AuthScope.ANY_HOST;
    public static final int ANY_PORT = -1;
    public static final String ANY_REALM = AuthScope.ANY_REALM;
    public static final String ANY_SCHEME = AuthScope.ANY_SCHEME;
    public static final AuthScope ANY = AuthScope.ANY;

    static URI decompose(String suri) throws HTTPException {
        try {
            URI uri = new URI(suri);
            return uri;
        }
        catch (URISyntaxException use) {
            throw new HTTPException("HTTPAuthUtil: illegal url: " + suri);
        }
    }

    public static AuthScope urlToScope(String surl, String authscheme) throws HTTPException {
        if (surl == null) {
            throw new HTTPException("Null argument");
        }
        try {
            URI uri = HTTPAuthUtil.decompose(surl);
            AuthScope scope = new AuthScope(uri.getHost(), uri.getPort(), HTTPAuthUtil.makerealm(uri.toURL()), authscheme);
            return scope;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (MalformedURLException mue) {
            throw new HTTPException(mue);
        }
    }

    public static AuthScope urlToScope(String surl) throws HTTPException {
        return HTTPAuthUtil.urlToScope(surl, ANY_SCHEME);
    }

    public static URL scopeToURL(AuthScope scope) throws HTTPException {
        try {
            String scheme = scope.getScheme();
            scheme = scheme == ANY_SCHEME ? "http" : (scheme.equals("SSL") ? "https" : "http");
            URL url = new URL(scheme, scope.getHost(), scope.getPort(), "");
            return url;
        }
        catch (MalformedURLException mue) {
            throw new HTTPException(mue);
        }
    }

    public static boolean equivalent(AuthScope a1, AuthScope a2) {
        if (a1 == null || a2 == null) {
            throw new NullPointerException();
        }
        if (a1.getScheme() != ANY_SCHEME && a2.getScheme() != ANY_SCHEME && !a1.getScheme().equals(a2.getScheme())) {
            return false;
        }
        if (a1.getHost() != ANY_HOST && a2.getHost() != ANY_HOST && !a1.getHost().equals(a2.getHost())) {
            return false;
        }
        if (a1.getPort() != -1 && a2.getPort() != -1 && a1.getPort() != a2.getPort()) {
            return false;
        }
        return a1.getRealm() == ANY_REALM || a2.getRealm() == ANY_REALM || a1.getRealm().equals(a2.getRealm());
    }

    public static boolean equals(AuthScope a1, AuthScope a2) {
        if (a2 == null ^ a1 == null) {
            return false;
        }
        if (a1 == a2) {
            return true;
        }
        boolean b1 = HTTPUtil.equals(a1.getHost(), a2.getHost());
        if (!(b1 || a1.getHost() != AuthScope.ANY_HOST && a1.getHost() != AuthScope.ANY_HOST)) {
            b1 = true;
        }
        int aport = a2.getPort();
        boolean b2 = a1.getPort() == aport || a1.getPort() == -1 || aport == -1;
        boolean b4 = HTTPUtil.schemeEquals(a1.getScheme(), a2.getScheme());
        return b1 && b2 && b4;
    }

    public static AuthScope fixScopeRealm(AuthScope scope) {
        String realm = HTTPAuthUtil.makerealm(scope);
        return new AuthScope(scope.getHost(), scope.getPort(), realm, scope.getScheme());
    }

    public static String makerealm(URL url) {
        return HTTPAuthUtil.makerealm(url.getHost(), url.getPort());
    }

    public static String makerealm(AuthScope scope) {
        return HTTPAuthUtil.makerealm(scope.getHost(), scope.getPort());
    }

    public static String makerealm(String host, int port) {
        if (host == null) {
            host = ANY_HOST;
        }
        if (host == ANY_HOST) {
            return ANY_REALM;
        }
        String sport = port <= 0 || port == -1 ? "" : String.format("%d", port);
        return host + sport;
    }

    static boolean subsumes(AuthScope as, AuthScope has) {
        return HTTPAuthUtil.equivalent(as, has);
    }

    public static boolean wildcardMatch(String p1, String p2) {
        if (p1 == null ^ p2 == null || p1 == p2) {
            return true;
        }
        return p1.equals(p2);
    }

    public static void serializeScope(AuthScope scope, ObjectOutputStream oos) throws IOException {
        oos.writeObject(scope.getHost());
        oos.writeInt(scope.getPort());
        oos.writeObject(scope.getRealm());
        oos.writeObject(scope.getScheme());
    }

    public static AuthScope deserializeScope(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        String host = (String)oos.readObject();
        int port = oos.readInt();
        String realm = (String)oos.readObject();
        String scheme = (String)oos.readObject();
        return new AuthScope(host, port, realm, scheme);
    }
}

