/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapAttributeSet;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapFactory;
import dap4.core.dmr.DapGrid;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapOtherXML;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.util.DapSort;

public class DapFactoryDMR
implements DapFactory {
    @Override
    public Object newNode(DapSort sort) {
        return this.newNode(null, sort);
    }

    @Override
    public Object newNode(String name, DapSort sort) {
        switch (sort) {
            case ATTRIBUTE: {
                return new DapAttribute(name);
            }
            case ATTRIBUTESET: {
                return new DapAttributeSet(name);
            }
            case OTHERXML: {
                return new DapOtherXML(name);
            }
            case DIMENSION: {
                return new DapDimension(name);
            }
            case ENUMERATION: {
                return new DapEnum(name);
            }
            case MAP: {
                return new DapMap();
            }
            case ATOMICVARIABLE: {
                return new DapAtomicVariable(name);
            }
            case GRID: {
                return new DapGrid(name);
            }
            case SEQUENCE: {
                return new DapSequence(name);
            }
            case STRUCTURE: {
                return new DapStructure(name);
            }
            case GROUP: {
                return new DapGroup(name);
            }
            case DATASET: {
                return new DapDataset(name);
            }
        }
        assert (false) : "DapFactoryDefault: unknown sort: " + sort.name();
        return null;
    }
}

