/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.MultiOdometer;
import dap4.core.util.Slice;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Odometer
implements Iterator<Long> {
    protected STATE state = STATE.INITIAL;
    protected int rank = 0;
    protected Slice[] slices = null;
    protected DapDimension[] dimset = null;
    protected boolean usecontiguous = false;
    protected int contiguousdelta;
    protected long[] indices;
    protected long[] endpoint;

    public static Odometer factory(List<Slice> slices, List<DapDimension> dimset, boolean usecontiguous) throws DapException {
        boolean multi = false;
        if (slices != null) {
            for (int i = 0; i < slices.size(); ++i) {
                if (slices.get(i).getSort() != Slice.Sort.Multi) continue;
                multi = true;
                break;
            }
        }
        return multi ? new MultiOdometer(slices, dimset, usecontiguous) : new Odometer(slices, dimset, usecontiguous);
    }

    public Odometer() {
        this.contiguousdelta = this.usecontiguous ? 1 : 0;
    }

    public Odometer(List<DapDimension> dimset, boolean usecontiguous) throws DapException {
        this(DapUtil.dimsetSlices(dimset), dimset, usecontiguous);
    }

    public Odometer(List<Slice> set, List<DapDimension> dimset, boolean usecontiguous) throws DapException {
        int n = this.contiguousdelta = this.usecontiguous ? 1 : 0;
        if (set == null) {
            throw new DapException("Null slice list");
        }
        if (set.size() != dimset.size()) {
            throw new DapException("Rank mismatch");
        }
        this.rank = dimset.size();
        if (this.rank == 0) {
            throw new DapException("Rank == 0; use Scalar Odometer");
        }
        this.slices = set.toArray(new Slice[this.rank]);
        this.dimset = dimset.toArray(new DapDimension[dimset.size()]);
        this.indices = new long[this.rank];
        this.endpoint = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            DapDimension dim;
            this.dimset[i] = dim = dimset.get(i);
        }
        this.usecontiguous = usecontiguous;
        this.contiguousdelta = usecontiguous ? 1 : 0;
        this.reset();
    }

    protected void reset() {
        for (int i = 0; i < this.rank; ++i) {
            try {
                this.slices[i].setMaxSize(this.dimset[i].getSize());
                this.slices[i].finish();
                this.indices[i] = this.slices[i].getFirst();
                this.endpoint[i] = this.slices[i].getLast() - this.slices[i].getStride();
            }
            catch (DapException de) {
                throw new IllegalArgumentException(de);
            }
            if (!this.usecontiguous) continue;
            this.indices[this.rank - 1] = 0L;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.rank; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.dimset[i] != null ? this.dimset[i].getShortName() : "null");
            buf.append(this.slices[i].toString());
            buf.append(String.format("(%d)", this.slices[i].getCount()));
            if (this.indices == null) continue;
            buf.append(String.format("@%d", this.indices[i]));
        }
        return buf.toString();
    }

    public long index() {
        long offset = 0L;
        for (int i = 0; i < this.rank; ++i) {
            offset *= this.slices[i].getMaxSize();
            offset += this.indices[i];
        }
        return offset;
    }

    public long totalSize() {
        long size = 1L;
        for (int i = 0; i < this.rank; ++i) {
            size *= this.slices[i].getCount();
        }
        return size;
    }

    public long[] getIndices() {
        return this.indices;
    }

    @Override
    public boolean hasNext() {
        int stop = this.rank - this.contiguousdelta;
        switch (this.state) {
            case INITIAL: {
                return true;
            }
            case STARTED: {
                for (int i = stop - 1; i >= 0; --i) {
                    if (this.indices[i] > this.endpoint[i]) continue;
                    return true;
                }
                this.state = STATE.DONE;
                break;
            }
        }
        return false;
    }

    @Override
    public Long next() {
        int stop = this.rank - this.contiguousdelta;
        switch (this.state) {
            case INITIAL: {
                this.state = STATE.STARTED;
                break;
            }
            case STARTED: {
                int i;
                for (i = stop - 1; i >= 0; --i) {
                    if (this.indices[i] <= this.endpoint[i]) {
                        int n = i;
                        this.indices[n] = this.indices[n] + this.slices[i].getStride();
                        break;
                    }
                    this.indices[i] = this.slices[i].getFirst();
                }
                if (i >= 0) break;
                this.state = STATE.DONE;
                break;
            }
        }
        if (this.state == STATE.DONE) {
            throw new NoSuchElementException();
        }
        return this.index();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isContiguous() {
        return this.slices[this.slices.length - 1].isContiguous();
    }

    public List<Slice> getContiguous() {
        return this.slices[this.slices.length - 1].getContiguous();
    }

    protected static enum STATE {
        INITIAL,
        STARTED,
        DONE;

    }
}

