/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.util.ResponseFormat;
import dap4.core.util.XURI;
import dap4.dap4lib.DapCodes;
import dap4.dap4lib.RequestMode;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DapProtocol
implements DapCodes {
    protected static final String DAP4PROTO = "dap4";
    protected static final Set<String> DAP4EXTENSIONS = new HashSet<String>();
    protected static final Set<String> DAP4QUERYMARKERS;
    protected static final Set<String> DAP4SCHEMES;
    public static Map<String, ContentType> contenttypes;

    public static String contentKey(RequestMode mode, ResponseFormat format) {
        return mode.id() + "." + format.id();
    }

    public static boolean isDap4URI(XURI xuri) {
        boolean found = false;
        if (DAP4PROTO.equalsIgnoreCase(xuri.getScheme())) {
            return true;
        }
        if (!DAP4SCHEMES.contains(xuri.getScheme().toLowerCase())) {
            return false;
        }
        for (Map.Entry<String, String> entry : xuri.getQueryFields().entrySet()) {
            if (!DAP4QUERYMARKERS.contains(entry.getKey())) continue;
            return true;
        }
        String d4 = xuri.getFragFields().get(DAP4PROTO);
        if (d4 != null) {
            return true;
        }
        String p = xuri.getFragFields().get("protocol");
        if (p != null && p.equalsIgnoreCase(DAP4PROTO)) {
            return true;
        }
        String modes = xuri.getFragFields().get("mode");
        if (modes != null) {
            String[] modelist;
            for (String mode : modelist = modes.split("[,]")) {
                if (!mode.equalsIgnoreCase(DAP4PROTO)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDap4URI(String uri) {
        try {
            XURI xuri = new XURI(uri);
            return DapProtocol.isDap4URI(xuri);
        }
        catch (URISyntaxException use) {
            return false;
        }
    }

    static {
        DAP4EXTENSIONS.add("dmr");
        DAP4EXTENSIONS.add("dap");
        DAP4EXTENSIONS.add("dst");
        DAP4QUERYMARKERS = new HashSet<String>();
        DAP4QUERYMARKERS.add("dap4.checksum");
        DAP4QUERYMARKERS.add("dap4.ce");
        DAP4SCHEMES = new HashSet<String>();
        DAP4SCHEMES.add(DAP4PROTO);
        DAP4SCHEMES.add("http");
        DAP4SCHEMES.add("https");
        contenttypes = new HashMap<String, ContentType>();
        contenttypes.put(DapProtocol.contentKey(RequestMode.NONE, ResponseFormat.NONE), new ContentType(RequestMode.DSR, ResponseFormat.XML, "application/vnd.opendap.dap4.dataset-services+xml", "text/xml"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.DMR, ResponseFormat.NONE), new ContentType(RequestMode.DMR, ResponseFormat.XML, "application/vnd.opendap.dap4.dataset-metadata+xml", "text/xml"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.DMR, ResponseFormat.XML), new ContentType(RequestMode.DMR, ResponseFormat.XML, "application/vnd.opendap.dap4.dataset-metadata+xml", "text/xml"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.DAP, ResponseFormat.NONE), new ContentType(RequestMode.DAP, ResponseFormat.NONE, "application/vnd.opendap.dap4.data", "application/octet-stream"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.DSR, ResponseFormat.NONE), new ContentType(RequestMode.DSR, ResponseFormat.HTML, "application/vnd.opendap.dap4.dataset-services+html", "text/html"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.DSR, ResponseFormat.XML), new ContentType(RequestMode.DSR, ResponseFormat.XML, "application/vnd.opendap.dap4.dataset-services+xml", "text/xml"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.DSR, ResponseFormat.HTML), new ContentType(RequestMode.DSR, ResponseFormat.HTML, "application/vnd.opendap.dap4.dataset-services+html", "text/html"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.CAPABILITIES, ResponseFormat.NONE), new ContentType(RequestMode.CAPABILITIES, ResponseFormat.HTML, "application/vnd.opendap.dap4.capabilities+html", "text/html"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.CAPABILITIES, ResponseFormat.XML), new ContentType(RequestMode.CAPABILITIES, ResponseFormat.XML, "application/vnd.opendap.dap4.capabilities+xml", "text/xml"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.CAPABILITIES, ResponseFormat.HTML), new ContentType(RequestMode.CAPABILITIES, ResponseFormat.HTML, "application/vnd.opendap.dap4.capabilities+html", "text/html"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.ERROR, ResponseFormat.NONE), new ContentType(RequestMode.ERROR, ResponseFormat.XML, "application/vnd.opendap.dap4.error+xml", "text/xml"));
        contenttypes.put(DapProtocol.contentKey(RequestMode.ERROR, ResponseFormat.XML), new ContentType(RequestMode.ERROR, ResponseFormat.XML, "application/vnd.opendap.dap4.error+xml", "text/xml"));
    }

    public static class ContentType {
        public RequestMode mode;
        public ResponseFormat format;
        public String contenttype;
        public String mimetype;

        public ContentType(RequestMode mode, ResponseFormat format, String contenttype, String mimetype) {
            this.mode = mode;
            this.format = format;
            this.contenttype = contenttype;
            this.mimetype = mimetype;
        }
    }
}

