/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

public enum ChecksumMode {
    NONE,
    FALSE,
    TRUE;

    public static final ChecksumMode dfalt;
    static final String[] trues;
    static final String[] falses;

    public static String toString(ChecksumMode mode) {
        if (mode == null) {
            mode = dfalt;
        }
        switch (mode) {
            case NONE: {
                return ChecksumMode.toString(FALSE);
            }
            case FALSE: {
                return "false";
            }
            case TRUE: {
                return "true";
            }
        }
        return ChecksumMode.toString(dfalt);
    }

    public static ChecksumMode modeFor(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        for (String f : falses) {
            if (!f.equalsIgnoreCase(s)) continue;
            return FALSE;
        }
        for (String t : trues) {
            if (!t.equalsIgnoreCase(s)) continue;
            return TRUE;
        }
        return null;
    }

    public static ChecksumMode asTrueFalse(ChecksumMode mode) {
        if (mode == null || mode == NONE) {
            mode = dfalt;
        }
        return mode;
    }

    static {
        dfalt = TRUE;
        trues = new String[]{"true", "on", "yes", "1"};
        falses = new String[]{"false", "off", "no", "0"};
    }
}

