/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class Escape {
    static final String ENTITY_AMP = "amp";
    static final String ENTITY_LT = "lt";
    static final String ENTITY_GT = "gt";
    static final String ENTITY_QUOT = "quot";
    static final String ENTITY_APOS = "apos";
    public static final String[][] DEFAULTTRANSTABLE = new String[][]{{"amp", "&"}, {"lt", "<"}, {"gt", ">"}, {"quot", "\""}, {"apos", "'"}};
    private static final String nonAlphaNumeric = " !\"#$%&'()*+,-./:;<=>?@[]\\^_`|{}~";
    public static final String BACKSLASHESCAPE = "/.";
    public static final String ENTITYESCAPES = "\\<>&\"'";
    public static final String hexchars = "0123456789abcdef";
    static final String allhexchars = "0123456789abcdefABCDEF";
    static final String URLESCAPECHARS = " %";

    public static boolean entitychar(char c) {
        return "#_0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) >= 0;
    }

    public static String entityEscape(String s, String wrt) {
        if (wrt == null) {
            wrt = ENTITYESCAPES;
        }
        StringBuilder escaped = new StringBuilder();
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u0000') continue;
            int index = wrt.indexOf(c);
            if (index < 0) {
                escaped.append(c);
                continue;
            }
            switch (c) {
                case '&': {
                    escaped.append("&amp;");
                    continue block8;
                }
                case '<': {
                    escaped.append("&lt;");
                    continue block8;
                }
                case '>': {
                    escaped.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    escaped.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    escaped.append("&apos;");
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    escaped.append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ') continue block8;
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    public static String entityUnescape(String s) {
        return Escape.entityUnescape(s, null);
    }

    public static String entityUnescape(String s, String[][] translations) {
        if (translations == null) {
            translations = DEFAULTTRANSTABLE;
        }
        int len = s == null ? 0 : s.length();
        StringBuilder u = new StringBuilder();
        boolean p = false;
        int q = 0;
        int stop = len;
        StringBuilder entity = new StringBuilder();
        while (q < stop) {
            char c = s.charAt(q++);
            switch (c) {
                case '&': {
                    entity.setLength(0);
                    boolean found = true;
                    int count = 0;
                    while (q + count < len && (c = s.charAt(q + count)) != ';') {
                        if (!Escape.entitychar(c)) {
                            found = false;
                            break;
                        }
                        entity.append(c);
                        ++count;
                    }
                    if (q + count >= len || count == 0 || !found) {
                        u.append('&');
                        break;
                    }
                    String test = entity.toString();
                    String replacement = null;
                    for (String[] trans : translations) {
                        if (!trans[0].equals(test)) continue;
                        replacement = trans[1];
                        break;
                    }
                    if (replacement == null) {
                        u.append('&');
                        break;
                    }
                    q += count + 1;
                    u.append(replacement);
                    break;
                }
                default: {
                    u.append(c);
                }
            }
        }
        return u.toString();
    }

    public static String backslashEscape(String s, String wrt) {
        if (wrt == null) {
            wrt = BACKSLASHESCAPE;
        }
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c;
            block10: {
                block9: {
                    c = s.charAt(i);
                    if (c >= ' ' && c != '\u007f') break block9;
                    escaped.append('\\');
                    switch (c) {
                        case '\r': {
                            c = 'r';
                            break block10;
                        }
                        case '\n': {
                            c = 'n';
                            break block10;
                        }
                        case '\t': {
                            c = 't';
                            break block10;
                        }
                        case '\f': {
                            c = 'f';
                            break block10;
                        }
                        default: {
                            escaped.append('x');
                            escaped.append(Escape.toHex(c));
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\\' || wrt.indexOf(c) >= 0) {
                    escaped.append('\\');
                }
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    public static String backslashUnescape(String s) {
        StringBuilder clear = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                c = s.charAt(i++);
                switch (c) {
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                }
                clear.append(c);
                continue;
            }
            clear.append(c);
        }
        return clear.toString();
    }

    public static List<String> backslashsplit(String s, char sep) {
        ArrayList<String> path = new ArrayList<String>();
        int len = s.length();
        StringBuilder piece = new StringBuilder();
        for (int i = 0; i <= len - 1; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < len - 1) {
                piece.append(c);
                piece.append(s.charAt(++i));
                continue;
            }
            if (c == sep) {
                path.add(piece.toString());
                piece.setLength(0);
                continue;
            }
            piece.append(c);
        }
        path.add(piece.toString());
        return path;
    }

    public static String toHex(int i) {
        char digit1 = hexchars.charAt(i >>> 4 & 0xF);
        char digit2 = hexchars.charAt(i & 0xF);
        return Character.toString(digit1) + digit2;
    }

    public static int fromHex(char c) {
        int index = hexchars.indexOf(c = Character.toLowerCase(c));
        if (index < 0) {
            return -1;
        }
        return index;
    }

    public static boolean isHexDigit(char c) {
        return allhexchars.indexOf(c) >= 0;
    }

    public static String bytes2hex(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(2 + len * 2);
        buf.append("0x");
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            buf.append(hexchars.charAt(b >>> 4 & 0xF));
            buf.append(hexchars.charAt(i & 0xF));
        }
        return buf.toString();
    }

    public static String urlDecode(String s) {
        try {
            s = URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s;
    }

    public static String urlEncodeQuery(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (URLESCAPECHARS.indexOf(c) >= 0) {
                buf.append("%");
                String encode = Integer.toHexString(c);
                if (encode.length() == 1) {
                    buf.append("0");
                }
                buf.append(encode);
                continue;
            }
            buf.append(c);
        }
        return s;
    }

    public static String cleanString(String s) {
        int index = s.indexOf(0);
        if (index >= 0) {
            s = s.substring(0, index);
        }
        return s;
    }
}

