/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

public enum ResponseFormat {
    TEXT("text", "txt"),
    XML("xml", "xml"),
    HTML("html", "html"),
    NONE("none", null);

    private String id;
    private String format;

    private ResponseFormat(String id, String format) {
        this.id = id;
        this.format = format;
    }

    public String id() {
        return this.id;
    }

    public String format() {
        return this.format;
    }

    public static ResponseFormat formatFor(String s) {
        if (s == null) {
            return null;
        }
        for (ResponseFormat format : ResponseFormat.values()) {
            if (!s.equalsIgnoreCase(format.format) && !s.equalsIgnoreCase("." + format.format)) continue;
            return format;
        }
        return null;
    }

    public static ResponseFormat idFormat(String id) {
        if (id == null) {
            return null;
        }
        for (ResponseFormat format : ResponseFormat.values()) {
            if (!id.equalsIgnoreCase(format.id)) continue;
            return format;
        }
        return null;
    }

    public String toString() {
        return this.id;
    }
}

