/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.util.Slice;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SliceIterator
implements Iterator<Long> {
    protected STATE state;
    protected Slice slice;
    protected long index;

    public SliceIterator() {
    }

    public SliceIterator(Slice slice) {
        this.slice = slice;
        this.reset();
    }

    public void reset() {
        this.state = STATE.INITIAL;
        this.index = this.slice.getFirst();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.slice.toString());
        buf.append(String.format("(%d/%d)", this.slice.getCount(), this.slice.getMax()));
        buf.append(String.format("@%d", this.index));
        return buf.toString();
    }

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case INITIAL: {
                return this.slice.getFirst() < this.slice.getStop();
            }
            case STARTED: {
                return this.index < (long)this.slice.getLast();
            }
        }
        return false;
    }

    @Override
    public Long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        switch (this.state) {
            case INITIAL: {
                this.index = this.slice.getFirst();
                this.state = STATE.STARTED;
                break;
            }
            case STARTED: {
                this.index += (long)this.slice.getStride();
                if (this.index < (long)this.slice.getStop()) break;
                this.state = STATE.DONE;
                break;
            }
            case DONE: {
                throw new NoSuchElementException();
            }
        }
        return this.index;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Long getIndex() {
        return this.index;
    }

    protected static enum STATE {
        INITIAL,
        STARTED,
        DONE;

    }
}

