/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.util.Escape;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XURI {
    static final char QUERYSEP = '&';
    static final char FRAGMENTSEP = '&';
    static final char ESCAPECHAR = '\\';
    static final char PAIRSEP = '=';
    protected static final Pattern drivelettertest = Pattern.compile("^([/]?)[a-zA-Z][:]");
    protected static final Pattern filedrivelettertest = Pattern.compile("^(file://)([a-zA-Z][:].*)");
    public static final EnumSet<Parts> URLONLY = EnumSet.of(Parts.SCHEME, Parts.PWD, Parts.HOST, Parts.PATH);
    public static final EnumSet<Parts> URLALL = EnumSet.of(Parts.SCHEME, new Parts[]{Parts.PWD, Parts.HOST, Parts.PATH, Parts.QUERY, Parts.FRAG});
    public static final EnumSet<Parts> URLQUERY = EnumSet.of(Parts.SCHEME, Parts.PWD, Parts.HOST, Parts.PATH, Parts.QUERY);
    URI parent;
    protected boolean isfile = false;
    protected List<String> nonleadschemes = new ArrayList<String>();
    protected Map<String, String> queryfields = null;
    protected Map<String, String> fragfields = null;

    public XURI(String xu) throws URISyntaxException {
        xu = XURI.canonical(xu);
        if (xu == null) {
            throw new URISyntaxException("null", "null valued URI string");
        }
        xu = this.fixURI(xu);
        this.parent = new URI(xu);
        this.isfile = "file".equalsIgnoreCase(this.getScheme());
    }

    String fixURI(String xu) throws URISyntaxException {
        String[] schemes = XURI.allSchemes(xu);
        if (schemes.length == 0) {
            return xu;
        }
        int iremainder = xu.indexOf("//");
        xu = schemes[0] + ":" + xu.substring(iremainder);
        this.nonleadschemes.addAll(Arrays.asList(schemes).subList(1, schemes.length));
        Matcher m = filedrivelettertest.matcher(xu);
        if (m.lookingAt()) {
            String prefix = m.group(1);
            String pathplus = m.group(2);
            xu = prefix + XURI.hideDriveLetter(pathplus);
        }
        return xu;
    }

    String parseSchemes(String xu, List<String> schemelist) throws URISyntaxException {
        int iremainder = xu.indexOf("//");
        if (iremainder <= 0) {
            throw new URISyntaxException(xu, "URI has no scheme");
        }
        String[] schemes = xu.substring(0, iremainder).split(":");
        String lead = schemes[0];
        xu = lead + ":" + xu.substring(iremainder, xu.length());
        schemelist.clear();
        for (int i = 1; i < schemes.length; ++i) {
            schemelist.add(schemes[i]);
        }
        return xu;
    }

    public XURI(URL xu) throws URISyntaxException {
        this.parent = new URI(xu.getProtocol().toLowerCase(), xu.getUserInfo(), xu.getHost(), xu.getPort(), xu.getFile(), xu.getQuery(), xu.getRef());
    }

    public XURI(URI xu) throws URISyntaxException {
        this.parent = new URI(xu.getScheme().toLowerCase(), xu.getUserInfo(), xu.getHost(), xu.getPort(), xu.getPath(), xu.getQuery(), xu.getFragment());
    }

    public String getUserInfo() {
        return this.parent.getUserInfo();
    }

    public String getHost() {
        return this.parent.getHost();
    }

    public int getPort() {
        return this.parent.getPort();
    }

    public String getPath() {
        return this.parent.getPath();
    }

    public String getRealPath() {
        return XURI.truePath(this.getPath());
    }

    public String getQuery() {
        return this.parent.getQuery();
    }

    public String getFragment() {
        return this.parent.getFragment();
    }

    public String getScheme() {
        return this.parent.getScheme();
    }

    public List<String> getSchemes() {
        if (this.parent.getScheme() == null) {
            return null;
        }
        ArrayList<String> allschemes = new ArrayList<String>();
        allschemes.add(this.parent.getScheme());
        allschemes.addAll(this.nonleadschemes);
        return allschemes;
    }

    public void setScheme(String xscheme) {
        try {
            this.parent = new URI(xscheme.toLowerCase(), this.parent.getUserInfo(), this.parent.getHost(), this.parent.getPort(), this.parent.getPath(), this.parent.getQuery(), this.parent.getFragment());
        }
        catch (URISyntaxException use) {
            throw new AssertionError("URI.setScheme: Internal error: malformed URI", use);
        }
    }

    public void setUserInfo(String xuserinfo) {
        try {
            this.parent = new URI(this.parent.getScheme(), xuserinfo, this.parent.getHost(), this.parent.getPort(), this.parent.getPath(), this.parent.getQuery(), this.parent.getFragment());
        }
        catch (URISyntaxException use) {
            throw new AssertionError("URI.setUserInfo: Internal error: malformed URI", use);
        }
    }

    public void setHost(String xhost) {
        try {
            this.parent = new URI(this.parent.getScheme(), this.parent.getUserInfo(), xhost, this.parent.getPort(), this.parent.getPath(), this.parent.getQuery(), this.parent.getFragment());
        }
        catch (URISyntaxException use) {
            throw new AssertionError("URI.setHost: Internal error: malformed URI", use);
        }
    }

    public void setPort(int xport) {
        try {
            this.parent = new URI(this.parent.getScheme(), this.parent.getUserInfo(), this.parent.getHost(), xport, this.parent.getPath(), this.parent.getQuery(), this.parent.getFragment());
        }
        catch (URISyntaxException use) {
            throw new AssertionError("URI.setPort: Internal error: malformed URI", use);
        }
    }

    public void setPath(String xpath) {
        try {
            if (XURI.hasDriveLetter(xpath) && xpath.charAt(0) != '/') {
                xpath = "/" + xpath;
            }
            this.parent = new URI(this.parent.getScheme(), this.parent.getUserInfo(), this.parent.getHost(), this.parent.getPort(), xpath, this.parent.getQuery(), this.parent.getFragment());
        }
        catch (URISyntaxException use) {
            throw new AssertionError("URI.setPath: Internal error: malformed URI", use);
        }
    }

    public void setQuery(String xquery) {
        try {
            this.parent = new URI(this.parent.getScheme(), this.parent.getUserInfo(), this.parent.getHost(), this.parent.getPort(), this.parent.getPath(), xquery, this.parent.getFragment());
            this.queryfields = null;
        }
        catch (URISyntaxException use) {
            throw new AssertionError("URI.setQuery: Internal error: malformed URI", use);
        }
    }

    public void setFragment(String xfragment) {
        try {
            this.parent = new URI(this.parent.getScheme(), this.parent.getUserInfo(), this.parent.getHost(), this.parent.getPort(), this.parent.getPath(), this.parent.getQuery(), xfragment);
            this.fragfields = null;
        }
        catch (URISyntaxException use) {
            throw new AssertionError("URI.setFragment: Internal error: malformed URI", use);
        }
    }

    public String toString() {
        return this.assemble(URLALL);
    }

    public void insertQueryField(String key, String newval) {
        this.queryfields = this.insertAmpField(key, newval, this.parent.getQuery());
        this.rebuildQuery();
    }

    public void insertFragmentField(String key, String newval) {
        this.fragfields = this.insertAmpField(key, newval, this.parent.getFragment());
        this.rebuildQuery();
    }

    public void removeQueryField(String key) {
        this.queryfields = this.removeAmpField(key, this.parent.getQuery());
        this.rebuildQuery();
    }

    protected void rebuildQuery() {
        if (this.queryfields == null) {
            return;
        }
        StringBuffer query = new StringBuffer();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.queryfields.entrySet()) {
            if (!first) {
                query.append("&");
            }
            query.append(Escape.urlEncodeQuery(entry.getKey()));
            query.append("=");
            query.append(Escape.urlEncodeQuery(entry.getValue()));
            first = false;
        }
        String newquery = null;
        if (query.length() > 0) {
            newquery = query.toString();
        }
        this.setQuery(newquery);
    }

    public boolean isFile() {
        return this.isfile;
    }

    public Map<String, String> getQueryFields() {
        if (this.queryfields == null) {
            this.parseQuery();
        }
        return this.queryfields;
    }

    public Map<String, String> getFragFields() {
        if (this.fragfields == null) {
            this.parseFragment();
        }
        return this.fragfields;
    }

    protected void parseQuery() {
        this.queryfields = this.parseAmpList(this.getQuery(), '&', '\\');
    }

    protected void parseFragment() {
        this.fragfields = this.parseAmpList(this.getFragment(), '&', '\\');
    }

    protected Map<String, String> insertAmpField(String key, String value, String query) {
        Map<String, String> fields = this.parseAmpList(query, '&', '\\');
        fields.put(key, value);
        return fields;
    }

    protected Map<String, String> removeAmpField(String key, String query) {
        Map<String, String> fields = this.parseAmpList(query, '&', '\\');
        fields.remove(key);
        return fields;
    }

    protected Map<String, String> parseAmpList(String s, char sep, char escape) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (s == null) {
            s = "";
        }
        List<String> pieces = this.escapedsplit(s, sep, escape);
        for (String piece : pieces) {
            int plen;
            int index = this.findunescaped(piece, 0, '=', escape, plen = piece.length());
            if (index < 0) {
                index = plen;
            }
            String key = piece.substring(0, index);
            String value = index >= plen ? "" : piece.substring(index + 1, plen);
            key = Escape.urlDecode(key);
            key = key.toLowerCase();
            value = Escape.urlDecode(value);
            map.put(key, value);
        }
        return map;
    }

    protected List<String> escapedsplit(String s, char sep, char escape) {
        ArrayList<String> pieces = new ArrayList<String>();
        int len = s.length();
        int from = 0;
        while (from < len) {
            int index = this.findunescaped(s, from, sep, escape, len);
            if (index < 0) {
                index = len;
            }
            pieces.add(s.substring(from, index));
            from = index + 1;
        }
        return pieces;
    }

    protected int findunescaped(String s, int start, char sep, char escape, int len) {
        for (int i = start; i < len; ++i) {
            char c = s.charAt(i);
            if (c == escape) {
                ++i;
                continue;
            }
            if (c != sep) continue;
            return i;
        }
        return -1;
    }

    public String assemble(EnumSet<Parts> parts) {
        StringBuilder uri = new StringBuilder();
        if (parts.contains((Object)Parts.SCHEME) && this.getScheme() != null) {
            uri.append(this.getScheme());
            for (int i = 0; i < this.nonleadschemes.size(); ++i) {
                uri.append(':');
                uri.append(this.nonleadschemes.get(i));
            }
            uri.append("://");
        }
        if (parts.contains((Object)Parts.PWD) && this.getUserInfo() != null) {
            uri.append(this.getUserInfo());
            uri.append("@");
        }
        if (parts.contains((Object)Parts.HOST) && this.getHost() != null) {
            uri.append(this.getHost());
            if (this.getPort() > 0) {
                uri.append(":");
                uri.append(this.getPort());
            }
        }
        if (parts.contains((Object)Parts.PATH) && this.getPath() != null) {
            uri.append(this.getPath());
        }
        if (parts.contains((Object)Parts.QUERY) && this.getQuery() != null) {
            uri.append("?");
            uri.append(this.getQuery());
        }
        if (parts.contains((Object)Parts.FRAG) && this.getFragment() != null) {
            uri.append("#");
            uri.append(this.getFragment());
        }
        return uri.toString();
    }

    public String fixdriveletter(URI uri) throws URISyntaxException {
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            return uri.toString();
        }
        String tmp = uri.getHost();
        if (!XURI.hasDriveLetter(tmp)) {
            return uri.toString();
        }
        StringBuilder newxu = new StringBuilder();
        newxu.append(uri.getScheme());
        newxu.append("://");
        if (uri.getUserInfo() != null) {
            newxu.append(uri.getUserInfo());
            newxu.append("@");
        }
        newxu.append("/");
        newxu.append(uri.getHost());
        newxu.append(":");
        newxu.append(uri.getPath());
        if (uri.getQuery() != null) {
            newxu.append("?");
            newxu.append(uri.getQuery());
        }
        if (uri.getFragment() != null) {
            newxu.append("#");
            newxu.append(uri.getFragment());
        }
        return newxu.toString();
    }

    public static String canonical(String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    public static boolean hasDriveLetter(String path) {
        Matcher m = drivelettertest.matcher(path);
        return m.lookingAt();
    }

    public static String hideDriveLetter(String path) {
        Matcher m = drivelettertest.matcher(path);
        if (m.lookingAt() && m.group(1).equals("")) {
            path = "/" + path;
        }
        return path;
    }

    public static String[] allSchemes(String xu) {
        int endschemes = xu.indexOf("//");
        if (endschemes < 0) {
            return new String[0];
        }
        String[] schemes = xu.substring(0, endschemes).split(":");
        return schemes;
    }

    public static String truePath(String path) {
        Matcher m = drivelettertest.matcher(path);
        if (m.lookingAt() && m.group(1) != null) {
            path = path.substring(1);
        }
        return path;
    }

    public static enum Parts {
        SCHEME,
        PWD,
        HOST,
        PATH,
        QUERY,
        FRAG;

    }
}

