/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.util.ChecksumMode;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.XURI;
import dap4.dap4lib.D4DSP;
import dap4.dap4lib.RequestMode;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;

public class RawDSP
extends D4DSP {
    protected static final String[] EXTENSIONS = new String[]{".dap", ".raw"};

    @Override
    public D4DSP open(String fileurl, ChecksumMode cmode) throws DapException {
        this.mode = RequestMode.DAP;
        super.open(fileurl, cmode);
        String methodurl = this.getMethodUrl(this.mode, this.checksummode);
        this.parseURL(methodurl);
        String realpath = this.xuri.getRealPath();
        try {
            FileInputStream stream = new FileInputStream(realpath);
            this.setStream(stream, RequestMode.DAP);
        }
        catch (IOException ioe) {
            throw new DapException(ioe).setCode(500);
        }
        return this;
    }

    @Override
    public boolean dspMatch(String location, DapContext context) {
        try {
            XURI xuri = new XURI(location);
            if (xuri.isFile()) {
                String path = xuri.getPath();
                for (String ext : EXTENSIONS) {
                    if (!path.endsWith(ext)) continue;
                    return true;
                }
            }
        }
        catch (URISyntaxException use) {
            return false;
        }
        return false;
    }

    @Override
    public void loadDMR() throws DapException {
        String methodurl = this.getMethodUrl(this.mode, this.checksummode);
        this.parseURL(methodurl);
        String realpath = this.xuri.getRealPath();
        try {
            FileInputStream stream = new FileInputStream(realpath);
            this.setStream(stream, RequestMode.DAP);
            super.loadDMR();
        }
        catch (IOException ioe) {
            throw new DapException(ioe).setCode(500);
        }
    }

    @Override
    public void loadDAP() throws IOException {
        super.loadDAP();
    }
}

