/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

public enum RequestMode {
    DMR("dmr", "dmr"),
    DAP("dap", "dap"),
    DSR("dsr", "dsr"),
    CAPABILITIES("capabilities", ""),
    ERROR("error", null),
    NONE("none", null);

    private String id;
    private String extension;

    private RequestMode(String id, String extension) {
        this.id = id;
        this.extension = extension;
    }

    public String id() {
        return this.id;
    }

    public String extension() {
        return this.extension;
    }

    public static RequestMode modeFor(String s) {
        for (RequestMode mode : RequestMode.values()) {
            if ((mode.extension() == null || !s.equalsIgnoreCase(mode.extension)) && !s.equalsIgnoreCase("." + mode.extension)) continue;
            return mode;
        }
        return null;
    }

    public static RequestMode idMode(String id) {
        for (RequestMode mode : RequestMode.values()) {
            if (mode.id() == null || !id.equalsIgnoreCase(mode.id)) continue;
            return mode;
        }
        return null;
    }

    public String toString() {
        return this.id;
    }
}

