/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapType;
import dap4.core.dmr.TypeSort;
import dap4.core.util.ConversionException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class Convert {
    static final long INT8_MAX = 127L;
    static final long INT8_MIN = -128L;
    static final long UINT8_MAX = 255L;
    static final long UINT8_MIN = 0L;
    static final long INT16_MAX = 32767L;
    static final long INT16_MIN = -32768L;
    static final long UINT16_MAX = 65535L;
    static final long UINT16_MIN = 0L;
    static final long INT32_MAX = Integer.MAX_VALUE;
    static final long INT32_MIN = Integer.MIN_VALUE;
    static final long UINT32_MAX = 0xFFFFFFFFL;
    static final long UINT32_MIN = 0L;
    static final long INT64_MAX = Long.MAX_VALUE;
    static final long INT64_MIN = Long.MIN_VALUE;
    static final long UINT64_MIN = 0L;
    static final BigInteger BIG_INT64_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger BIG_INT64_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger BIG_UINT64_MAX = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    static final BigInteger BIG_UINT64_MIN = BigInteger.ZERO;

    public static Object convert(DapType dsttype, DapType srctype, Object values) {
        int i;
        if (dsttype == srctype) {
            return values;
        }
        TypeSort srcsort = srctype.getTypeSort();
        TypeSort dstsort = dsttype.getTypeSort();
        if (srcsort.isEnumType() && dstsort.isEnumType()) {
            throw new ConversionException("Cannot convert enum to enum");
        }
        Object[] result = null;
        int count = Array.getLength(values);
        if (srcsort == TypeSort.Char && dstsort.isStringType()) {
            String[] svals;
            result = svals = new String[count];
            for (int i2 = 0; i2 < count; ++i2) {
                svals[i2] = Character.toString(((char[])values)[i2]);
            }
            return result;
        }
        if (srcsort == TypeSort.Char && !dstsort.isIntegerType()) {
            throw new ConversionException("Cannot convert Char to " + dstsort.toString());
        }
        if (srcsort == TypeSort.Opaque && dstsort != TypeSort.Opaque) {
            throw new ConversionException("Cannot only convert Opaque to Opaque");
        }
        long[] lvalues = null;
        double[] dvalues = null;
        String[] svalues = null;
        ByteBuffer[] opvalues = null;
        switch (srcsort) {
            case Char: {
                if (dstsort.isIntegerType()) {
                    lvalues = new long[count];
                    for (int i3 = 0; i3 < count; ++i3) {
                        lvalues[i3] = ((char[])values)[i3];
                    }
                } else {
                    if (!dstsort.isStringType()) break;
                    svalues = new String[count];
                    for (int i4 = 0; i4 < count; ++i4) {
                        svalues[i4] = Character.toString(((char[])values)[i4]);
                    }
                }
                break;
            }
            case Int8: {
                lvalues = new long[count];
                for (int i5 = 0; i5 < count; ++i5) {
                    lvalues[i5] = ((byte[])values)[i5];
                }
                break;
            }
            case UInt8: {
                lvalues = new long[count];
                for (int i6 = 0; i6 < count; ++i6) {
                    lvalues[i6] = (long)((byte[])values)[i6] & 0xFFL;
                }
                break;
            }
            case Int16: {
                lvalues = new long[count];
                for (int i7 = 0; i7 < count; ++i7) {
                    lvalues[i7] = ((short[])values)[i7];
                }
                break;
            }
            case UInt16: {
                lvalues = new long[count];
                for (int i8 = 0; i8 < count; ++i8) {
                    lvalues[i8] = (long)((short[])values)[i8] & 0xFFFFL;
                }
                break;
            }
            case Int32: {
                lvalues = new long[count];
                for (int i9 = 0; i9 < count; ++i9) {
                    lvalues[i9] = ((int[])values)[i9];
                }
                break;
            }
            case UInt32: {
                lvalues = new long[count];
                for (int i10 = 0; i10 < count; ++i10) {
                    lvalues[i10] = (long)((int[])values)[i10] & 0xFFFFFFFFL;
                }
                break;
            }
            case Int64: {
                lvalues = new long[count];
                for (int i11 = 0; i11 < count; ++i11) {
                    lvalues[i11] = ((long[])values)[i11];
                }
                break;
            }
            case UInt64: {
                lvalues = new long[count];
                for (int i12 = 0; i12 < count; ++i12) {
                    long[] lv = (long[])values;
                    BigInteger bi = BigInteger.valueOf(lv[i12]);
                    bi = bi.and(BIG_UINT64_MAX);
                    lvalues[i12] = bi.longValue();
                }
                break;
            }
            case Float32: {
                dvalues = new double[count];
                for (int i13 = 0; i13 < count; ++i13) {
                    dvalues[i13] = ((float[])values)[i13];
                }
                break;
            }
            case Float64: {
                dvalues = new double[count];
                for (int i14 = 0; i14 < count; ++i14) {
                    dvalues[i14] = ((double[])values)[i14];
                }
                break;
            }
            case String: 
            case URL: {
                svalues = (String[])values;
                break;
            }
            case Opaque: {
                opvalues = (ByteBuffer[])values;
                break;
            }
            case Enum: {
                DapEnumeration srcenum = (DapEnumeration)srctype;
                DapType enumbase = srcenum.getBaseType();
                lvalues = new long[count];
                DapType vectype = Convert.vectorType(values);
                if (vectype.isIntegerType()) {
                    lvalues = (long[])Convert.convert(DapType.INT64, vectype, values);
                    break;
                }
                if (vectype.isStringType()) {
                    for (i = 0; i < count; ++i) {
                        String sval = ((String[])values)[i];
                        try {
                            lvalues[i] = Long.parseLong(sval);
                            if (srcenum.lookup(lvalues[i]) != null) continue;
                            throw new ConversionException("Illegal Enum constant: " + sval);
                        }
                        catch (NumberFormatException nfe) {
                            DapEnumConst dec = srcenum.lookup(sval);
                            if (dec == null) {
                                throw new ConversionException("Illegal Enum constant: " + sval);
                            }
                            lvalues[i] = dec.getValue();
                        }
                    }
                    break;
                }
                throw new ConversionException(String.format("Cannot convert values of type %s to enum", vectype));
            }
            default: {
                throw new ConversionException("Illegal srctype: " + srctype);
            }
        }
        switch (dstsort) {
            case Char: {
                char[] cresult = new char[count];
                result = cresult;
                if (svalues != null) {
                    for (int i15 = 0; i15 < count; ++i15) {
                        if (svalues[i15].length() != 1) {
                            throw new ConversionException("Cannot convert multi-char string to a char");
                        }
                        cresult[i15] = svalues[i15].charAt(0);
                    }
                } else {
                    if (lvalues == null && dvalues != null) {
                        lvalues = Convert.double2long(dvalues);
                    }
                    for (int i16 = 0; i16 < count; ++i16) {
                        cresult[i16] = (char)(lvalues[i16] & 0x7FL);
                    }
                }
                break;
            }
            case Int8: 
            case UInt8: {
                if (svalues != null) {
                    lvalues = Convert.string2long(svalues);
                } else if (dvalues != null) {
                    lvalues = Convert.double2long(dvalues);
                }
                byte[] bresult = new byte[count];
                result = bresult;
                for (int i17 = 0; i17 < count; ++i17) {
                    bresult[i17] = (byte)lvalues[i17];
                }
                break;
            }
            case Int16: 
            case UInt16: {
                if (svalues != null) {
                    lvalues = Convert.string2long(svalues);
                } else if (dvalues != null) {
                    lvalues = Convert.double2long(dvalues);
                }
                short[] shresult = new short[count];
                result = shresult;
                for (i = 0; i < count; ++i) {
                    shresult[i] = (short)lvalues[i];
                }
                break;
            }
            case Int32: 
            case UInt32: {
                if (svalues != null) {
                    lvalues = Convert.string2long(svalues);
                } else if (dvalues != null) {
                    lvalues = Convert.double2long(dvalues);
                }
                int[] iresult = new int[count];
                result = iresult;
                for (int i18 = 0; i18 < count; ++i18) {
                    iresult[i18] = (int)lvalues[i18];
                }
                break;
            }
            case Int64: 
            case UInt64: {
                if (svalues != null) {
                    lvalues = Convert.string2long(svalues);
                } else if (dvalues != null) {
                    lvalues = Convert.double2long(dvalues);
                }
                result = lvalues;
                break;
            }
            case Float32: {
                if (svalues != null) {
                    dvalues = Convert.string2double(svalues);
                } else if (lvalues != null) {
                    dvalues = Convert.long2double(lvalues);
                }
                float[] fresult = new float[count];
                for (int i19 = 0; i19 < count; ++i19) {
                    fresult[i19] = (float)dvalues[i19];
                }
                result = fresult;
                break;
            }
            case Float64: {
                if (svalues != null) {
                    dvalues = Convert.string2double(svalues);
                } else if (lvalues != null) {
                    dvalues = Convert.long2double(lvalues);
                }
                result = dvalues;
                break;
            }
            case String: 
            case URL: {
                if (svalues != null) {
                    result = svalues;
                    break;
                }
                String[] stresult = new String[count];
                result = stresult;
                if (lvalues != null) {
                    for (int i20 = 0; i20 < count; ++i20) {
                        stresult[i20] = Long.toString(lvalues[i20]);
                    }
                } else {
                    for (int i21 = 0; i21 < count; ++i21) {
                        stresult[i21] = Double.toString(dvalues[i21]);
                    }
                }
                break;
            }
            case Enum: {
                if (opvalues != null) {
                    throw new ConversionException("Cannot convert opaque to enum");
                }
                if (svalues == null && lvalues == null && dvalues != null) {
                    lvalues = Convert.double2long(dvalues);
                }
                DapEnumeration dstenum = (DapEnumeration)dsttype;
                if (svalues != null) {
                    svalues = dstenum.convert(svalues);
                } else if (lvalues != null) {
                    svalues = new String[count];
                    for (int i22 = 0; i22 < count; ++i22) {
                        DapEnumConst ec = dstenum.lookup(lvalues[i22]);
                        if (ec == null) {
                            throw new ConversionException("Illegal Enum Const: " + lvalues[i22]);
                        }
                        svalues[i22] = ec.getShortName();
                    }
                }
                result = svalues;
                break;
            }
            default: {
                throw new ConversionException("Illegal dsttype: " + dsttype);
            }
        }
        return result;
    }

    protected static long[] double2long(double[] in) {
        long[] out = new long[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = (long)in[i];
        }
        return out;
    }

    protected static double[] long2double(long[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    protected static long[] string2long(String[] in) {
        long[] out = new long[in.length];
        for (int i = 0; i < in.length; ++i) {
            try {
                out[i] = Long.parseLong(in[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("string->long: " + in[i]);
            }
        }
        return out;
    }

    protected static double[] string2double(String[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            try {
                out[i] = Double.parseDouble(in[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("string->double: " + in[i]);
            }
        }
        return out;
    }

    public static DapType vectorType(Object o) {
        Class<?> c = o.getClass();
        if (!c.isArray()) {
            return null;
        }
        if (o instanceof byte[]) {
            return DapType.INT8;
        }
        if (o instanceof short[]) {
            return DapType.INT16;
        }
        if (o instanceof int[]) {
            return DapType.INT32;
        }
        if (o instanceof String[]) {
            return DapType.STRING;
        }
        if (o instanceof char[]) {
            return DapType.CHAR;
        }
        if (o instanceof float[]) {
            return DapType.FLOAT32;
        }
        if (o instanceof double[]) {
            return DapType.FLOAT64;
        }
        if (o instanceof ByteBuffer[]) {
            return DapType.OPAQUE;
        }
        return null;
    }
}

