/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.interfaces.ArrayScheme;
import dap4.core.util.ChecksumMode;
import dap4.core.util.DapConstants;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.D4Array;
import dap4.dap4lib.D4DSP;
import dap4.dap4lib.DeChunkedInputStream;
import dap4.dap4lib.LibTypeFcns;
import dap4.dap4lib.cdm.CDMTypeFcns;
import dap4.dap4lib.cdm.CDMUtil;
import dap4.dap4lib.cdm.nc2.D4StructureDataIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;

public class D4DataCompiler {
    public static boolean DEBUG = false;
    protected DapDataset dmr = null;
    protected ChecksumMode checksummode = null;
    protected ByteOrder remoteorder = null;
    protected D4DSP dsp;
    protected DeChunkedInputStream stream = null;
    protected Map<DapVariable, Long> localchecksummap = new HashMap<DapVariable, Long>();
    protected Map<DapVariable, Long> remotechecksummap = new HashMap<DapVariable, Long>();

    public D4DataCompiler(D4DSP dsp, ChecksumMode checksummode, ByteOrder remoteorder) throws DapException {
        this.dsp = dsp;
        this.dmr = this.dsp.getDMR();
        this.stream = this.dsp.getStream();
        this.checksummode = ChecksumMode.asTrueFalse(checksummode);
        this.remoteorder = remoteorder;
    }

    public Map<DapVariable, Long> getChecksumMap(DapConstants.ChecksumSource src) {
        switch (src) {
            case LOCAL: {
                return this.localchecksummap;
            }
            case REMOTE: {
                return this.remotechecksummap;
            }
        }
        return null;
    }

    protected void setChecksum(DapConstants.ChecksumSource src, DapVariable dvar, Long csum) {
        switch (src) {
            case LOCAL: {
                this.localchecksummap.put(dvar, csum);
            }
            case REMOTE: {
                this.remotechecksummap.put(dvar, csum);
            }
        }
    }

    public void compile() throws IOException {
        assert (this.dmr != null && this.stream != null);
        for (DapVariable vv : this.dmr.getTopVariables()) {
            Object storage = this.compileVar(vv);
            D4Array data = new D4Array(ArrayScheme.schemeFor(vv), this.dsp, vv).setStorage(storage);
            assert (data.getArray() == null);
            data.setArray(this.createArray(vv, data.getStorage()));
            this.dsp.addVariableData(vv, data);
        }
    }

    protected Object compileVar(DapVariable dapvar) throws IOException {
        Object data = null;
        DapType type = dapvar.getBaseType();
        if (dapvar.isTopLevel() && this.checksummode == ChecksumMode.TRUE) {
            this.stream.startChecksum();
        }
        if (type.isAtomic()) {
            data = this.compileAtomicVar(dapvar);
        } else if (type.isStructType()) {
            data = this.compileStructureArray(dapvar);
        } else if (type.isSeqType()) {
            data = this.compileSequenceArray(dapvar);
        }
        if (dapvar.isTopLevel() && this.checksummode == ChecksumMode.TRUE) {
            long localcrc32 = this.stream.endChecksum();
            this.setChecksum(DapConstants.ChecksumSource.LOCAL, dapvar, localcrc32);
            long remotecrc32 = this.extractChecksum();
            this.setChecksum(DapConstants.ChecksumSource.REMOTE, dapvar, remotecrc32);
        }
        return data;
    }

    protected Object compileAtomicVar(DapVariable var) throws IOException {
        DapType daptype = var.getBaseType();
        if (daptype.isStringType()) {
            return this.compileStringVar(var);
        }
        if (daptype.isOpaqueType()) {
            return this.compileOpaqueVar(var);
        }
        long dimproduct = var.getCount();
        long total = dimproduct * (long)daptype.getSize();
        byte[] bytes = new byte[(int)total];
        int red = this.stream.read(bytes);
        if (red <= 0) {
            throw new IOException("D4DataCompiler: read failure");
        }
        if ((long)red < total) {
            throw new DapException("D4DataCompiler: short read");
        }
        Object storage = CDMTypeFcns.bytesAsTypeVec(daptype, bytes);
        CDMTypeFcns.decodebytes(this.remoteorder, daptype, bytes, storage);
        return storage;
    }

    protected Object compileStringVar(DapVariable var) throws IOException {
        DapType daptype = var.getBaseType();
        assert (daptype.isStringType());
        long dimproduct = var.getCount();
        String[] storage = new String[(int)dimproduct];
        int count = 0;
        int i = 0;
        while ((long)i < dimproduct) {
            int strsize = this.getCount();
            byte[] sbytes = new byte[strsize];
            int red = this.stream.read(sbytes);
            assert (red == strsize);
            storage[count] = new String(sbytes, DapUtil.UTF8);
            ++count;
            ++i;
        }
        return storage;
    }

    protected Object compileOpaqueVar(DapVariable var) throws IOException {
        DapType daptype = var.getBaseType();
        assert (daptype.isOpaqueType());
        long dimproduct = var.getCount();
        ByteBuffer[] storage = new ByteBuffer[(int)dimproduct];
        int count = 0;
        int i = 0;
        while ((long)i < dimproduct) {
            int osize = this.getCount();
            byte[] obytes = new byte[osize];
            int red = this.stream.read(obytes);
            assert (red == osize);
            storage[count] = ByteBuffer.wrap(obytes);
            ++count;
            ++i;
        }
        return storage;
    }

    protected Object compileStructureArray(DapVariable var) throws IOException {
        DapStructure dapstruct = (DapStructure)var.getBaseType();
        long dimproduct = var.getCount();
        Object[] storage = new Object[(int)dimproduct];
        Index idx = Index.factory((int[])CDMUtil.computeEffectiveShape(var.getDimensions()));
        long idxsize = idx.getSize();
        int offset = 0;
        while ((long)offset < idxsize) {
            Object instance;
            storage[offset] = instance = this.compileStructure(dapstruct);
            ++offset;
        }
        return storage;
    }

    protected Object compileStructure(DapStructure dapstruct) throws IOException {
        List<DapVariable> dfields = dapstruct.getFields();
        Object[] storage = new Object[dfields.size()];
        for (int m = 0; m < dfields.size(); ++m) {
            Object dvfield;
            DapVariable dfield = dfields.get(m);
            storage[m] = dvfield = this.compileVar(dfield);
        }
        return storage;
    }

    protected Object compileSequenceArray(DapVariable var) throws IOException {
        DapSequence dapseq = (DapSequence)var.getBaseType();
        long dimproduct = var.getCount();
        Object[] storage = new Object[(int)dimproduct];
        Index idx = Index.factory((int[])CDMUtil.computeEffectiveShape(var.getDimensions()));
        long idxsize = idx.getSize();
        int offset = 0;
        while ((long)offset < idxsize) {
            Object seq;
            storage[offset] = seq = this.compileSequence(dapseq);
            ++offset;
        }
        return storage;
    }

    public Object compileSequence(DapSequence dapseq) throws IOException {
        List<DapVariable> dfields = dapseq.getFields();
        long nrecs = this.getCount();
        Object[] records = new Object[(int)nrecs];
        int r = 0;
        while ((long)r < nrecs) {
            Object record;
            records[r] = record = this.compileStructure(dapseq);
            ++r;
        }
        return records;
    }

    protected long extractChecksum() throws IOException {
        assert (this.checksummode == ChecksumMode.TRUE);
        byte[] bytes = new byte[4];
        int red = this.stream.read(bytes);
        assert (red == 4);
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(this.remoteorder);
        long csum = bb.getInt();
        csum &= 0xFFFFFFFFFFFFFFFFL;
        return csum &= 0xFFFFFFFFL;
    }

    protected void skip(long count) throws IOException {
        int c;
        for (long i = 0L; i < count && (c = this.stream.read()) >= 0; ++i) {
        }
    }

    protected int getCount() throws IOException {
        byte[] bytes = new byte[8];
        int red = this.stream.read(bytes);
        assert (red == 8);
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(this.remoteorder);
        long count = bb.getLong();
        return (int)(count &= 0xFFFFFFFFFFFFFFFFL);
    }

    protected int computeTypeSize(DapType daptype) {
        return LibTypeFcns.size(daptype);
    }

    protected long walkByteStrings(long[] positions, ByteBuffer databuffer) throws IOException {
        int count = positions.length;
        long total = 0L;
        int savepos = databuffer.position();
        for (int i = 0; i < count; ++i) {
            int pos = databuffer.position();
            positions[i] = pos;
            int size = this.getCount();
            total += 8L;
            total += (long)size;
            this.skip(size);
        }
        databuffer.position(savepos);
        return total;
    }

    public Array createArray(DapVariable var, Object storage) {
        Array array = null;
        switch (ArrayScheme.schemeFor(var)) {
            case ATOMIC: {
                array = this.createAtomicArray(var, storage);
                break;
            }
            case STRUCTARRAY: {
                array = this.createStructureArray(var, storage);
                break;
            }
            case SEQARRAY: {
                array = this.createSequenceArray(var, storage);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected scheme = " + (Object)((Object)ArrayScheme.schemeFor(var)));
            }
        }
        return array;
    }

    protected Array createAtomicArray(DapVariable var, Object storage) {
        DapType dtype = var.getBaseType();
        if (dtype.isEnumType()) {
            dtype = (DapEnumeration)var.getBaseType();
        }
        DataType cdmtype = CDMTypeFcns.daptype2cdmtype(dtype);
        int[] shape = CDMUtil.computeEffectiveShape(var.getDimensions());
        Array array = Array.factory((DataType)cdmtype, (int[])shape, (Object)storage);
        return array;
    }

    protected Array createStructureArray(DapVariable var, Object storage) {
        DapType dtype = var.getBaseType();
        StructureMembers members = D4DataCompiler.computemembers(var);
        int[] shape = CDMUtil.computeEffectiveShape(var.getDimensions());
        Object[] instances = (Object[])storage;
        StructureData[] structdata = new StructureData[instances.length];
        for (int i = 0; i < instances.length; ++i) {
            Object[] fields = (Object[])instances[i];
            StructureDataW sdw = new StructureDataW(members);
            for (int f = 0; f < members.getMembers().size(); ++f) {
                StructureMembers.Member fm = (StructureMembers.Member)sdw.getMembers().get(f);
                DapVariable d4field = ((DapStructure)dtype).getField(f);
                Object fielddata = fields[f];
                Array fieldarray = this.createArray(d4field, fielddata);
                sdw.setMemberData(fm, fieldarray);
            }
            structdata[i] = sdw;
        }
        ArrayStructureW array = new ArrayStructureW(members, shape, structdata);
        return array;
    }

    protected Array createSequenceArray(DapVariable var, Object storage) {
        DapType dtype = var.getBaseType();
        StructureMembers members = D4DataCompiler.computemembers(var);
        int[] shape = CDMUtil.computeEffectiveShape(var.getDimensions());
        Object[] allinstancedata = (Object[])storage;
        int ninstances = allinstancedata.length;
        if (ninstances != 1) {
            throw new IndexOutOfBoundsException("Non-scalar Dap4 Sequences not supported");
        }
        Array[] allinstances = new Array[ninstances];
        for (int i = 0; i < ninstances; ++i) {
            Object[] ithelemdata = (Object[])allinstancedata[i];
            int nrecords = ithelemdata.length;
            StructureData[] allrecords = new StructureData[nrecords];
            for (int r = 0; r < nrecords; ++r) {
                Object[] onerecorddata = (Object[])ithelemdata[r];
                StructureDataW onerecord = new StructureDataW(members);
                for (int f = 0; f < members.getMembers().size(); ++f) {
                    StructureMembers.Member fm = members.getMember(f);
                    DapVariable d4field = ((DapStructure)dtype).getField(f);
                    Array fieldarray = this.createArray(d4field, onerecorddata[f]);
                    onerecord.setMemberData(fm, fieldarray);
                }
                allrecords[r] = onerecord;
            }
            D4StructureDataIterator onesequence = new D4StructureDataIterator().setList(allrecords);
            ArraySequence oneseq = new ArraySequence(members, (StructureDataIterator)onesequence, nrecords);
            allinstances[i] = oneseq;
        }
        return allinstances[0];
    }

    static StructureMembers computemembers(DapVariable var) {
        DapStructure ds = (DapStructure)var.getBaseType();
        StructureMembers sm = new StructureMembers(ds.getShortName());
        List<DapVariable> fields = ds.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = fields.get(i);
            DapType dt = field.getBaseType();
            DataType cdmtype = CDMTypeFcns.daptype2cdmtype(dt);
            StructureMembers.Member m = sm.addMember(field.getShortName(), "", null, cdmtype, CDMUtil.computeEffectiveShape(field.getDimensions()));
            m.setDataParam(i);
            if (!dt.getTypeSort().isStructType()) continue;
            StructureMembers subsm = D4DataCompiler.computemembers(field);
            m.setStructureMembers(subsm);
        }
        return sm;
    }
}

