/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.RequestMode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class DeChunkedInputStream
extends InputStream {
    static final int DFALTCHUNKSIZE = 0xFFFFFF;
    static final byte CR8 = DapUtil.extract(DapUtil.UTF8.encode("\r"))[0];
    static final byte LF8 = DapUtil.extract(DapUtil.UTF8.encode("\n"))[0];
    static final int HDRSIZE = 4;
    InputStream source = null;
    protected RequestMode mode = RequestMode.NONE;
    protected ByteOrder remoteorder = null;
    protected State state = State.INITIAL;
    protected Chunk chunk = null;
    protected Checksum crc32alg = new CRC32();
    protected long crc32 = 0L;
    protected boolean checksumming = false;
    protected String errortext = null;
    protected String dmrtext = null;

    public DeChunkedInputStream(InputStream src, RequestMode mode) throws IOException {
        this.source = src;
        this.chunk = new Chunk();
        this.mode = mode;
        this.readDMR(this.chunk);
        if (this.state == State.ERROR) {
            throw new DapException("DeChunkedInputStream: cannot read DMR");
        }
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        this.source.reset();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int red;
        if (this.chunk.avail == 0 && (red = this.readChunk(this.chunk)) <= 0) {
            return red;
        }
        assert (this.chunk.avail > 0);
        byte c = this.chunk.chunk[this.chunk.pos];
        ++this.chunk.pos;
        --this.chunk.avail;
        if (this.checksumming) {
            this.computeChecksum(c);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int toread;
        if (b.length < off + len) {
            throw new DapException("DeChunkedInputStream: illegal arguments: len+offset > |b|");
        }
        int pos = off;
        for (int remainder = len; remainder > 0; remainder -= toread) {
            int avail;
            if (this.chunk.avail == 0) {
                int red = this.readChunk(this.chunk);
                if (red <= 0) {
                    throw new IOException("DeChunkedInputStream: IO error");
                }
                assert (this.chunk.avail == red);
            }
            assert (this.chunk.avail > 0);
            toread = avail = this.chunk.avail;
            if (avail > remainder) {
                toread = remainder;
            }
            System.arraycopy(this.chunk.chunk, this.chunk.pos, b, pos, toread);
            this.chunk.pos += toread;
            this.chunk.avail -= toread;
            pos += toread;
        }
        if (this.checksumming) {
            this.computeChecksum(b, off, len);
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        long count;
        for (count = n; count > 0L; count -= (long)this.chunk.avail) {
            if (this.chunk.avail == 0) {
                int red = this.readChunk(this.chunk);
                if (red <= 0) {
                    return n - count;
                }
                assert (this.chunk.avail == red);
            }
            assert (this.chunk.avail > 0);
            if (count <= (long)this.chunk.avail) {
                this.chunk.pos = (int)((long)this.chunk.pos + count);
                this.chunk.avail = (int)((long)this.chunk.avail - count);
                count = n;
                break;
            }
            this.chunk.pos += this.chunk.avail;
            this.chunk.avail -= this.chunk.avail;
        }
        return count;
    }

    public State getState() {
        return this.state;
    }

    public String getErrorText() {
        return this.errortext;
    }

    public String getDMRText() {
        return this.dmrtext;
    }

    public byte[] getCurrentChunk() throws IOException {
        if (this.state == State.INITIAL) {
            this.readChunk(this.chunk);
        }
        byte[] truechunk = new byte[this.chunk.size];
        System.arraycopy(this.chunk.chunk, 0, truechunk, 0, this.chunk.size);
        return truechunk;
    }

    public ByteOrder getRemoteOrder() {
        return this.remoteorder;
    }

    protected int readChunk(Chunk chunk) throws IOException {
        assert (this.mode == RequestMode.DAP);
        switch (this.state) {
            case INITIAL: 
            case MORE: {
                if (!this.readHeader(this.chunk)) {
                    throw new DapException("Malformed chunked source");
                }
                if (this.state == State.INITIAL) {
                    ByteOrder byteOrder = this.remoteorder = (this.chunk.flags & 4) == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                }
                this.state = (this.chunk.flags & 2) == 1 ? State.ERROR : ((this.chunk.flags & 1) == 1 ? State.END : State.MORE);
                if (this.chunk.chunk == null || this.chunk.size > this.chunk.chunk.length) {
                    this.chunk.chunk = new byte[this.chunk.size];
                }
                this.chunk.pos = 0;
                this.chunk.avail = this.chunk.size;
                int red = DapUtil.readbinaryfilepartial(this.source, this.chunk.chunk, this.chunk.size);
                assert (red == this.chunk.size);
                if (this.state != State.ERROR) break;
                throw new DapException("DeChunkedInputStream: Error chunk encountered");
            }
            case END: 
            case ERROR: {
                throw new DapException("Illegal chunk state");
            }
        }
        return this.chunk.size;
    }

    protected int readDMR(Chunk chunk) throws IOException {
        assert (this.state == State.INITIAL);
        switch (this.mode) {
            case DMR: {
                this.remoteorder = ByteOrder.nativeOrder();
                this.chunk.chunk = DapUtil.readbinaryfile(this.source);
                this.chunk.size = this.chunk.chunk.length;
                if (this.chunk.size > 0) {
                    this.dmrtext = new String(this.chunk.chunk, DapUtil.UTF8);
                    this.chunk.pos = this.chunk.size;
                    this.chunk.avail = 0;
                    this.state = State.END;
                    this.remoteorder = ByteOrder.nativeOrder();
                    break;
                }
                this.state = State.ERROR;
                throw new DapException("DeChunkedInputStream: Error chunk encountered when reading DMR");
            }
            case DAP: {
                this.remoteorder = ByteOrder.nativeOrder();
                this.readChunk(this.chunk);
                this.dmrtext = new String(this.chunk.chunk, DapUtil.UTF8);
                this.skip(this.chunk.size);
                break;
            }
            default: {
                throw new DapException("Illegal request mode");
            }
        }
        return this.chunk.size;
    }

    protected boolean readHeader(Chunk chunk) throws IOException {
        int size;
        byte[] bytehdr = new byte[4];
        int red = this.source.read(bytehdr);
        if (red < 4) {
            return false;
        }
        int flags = bytehdr[0] & 0xFF;
        bytehdr[0] = 0;
        ByteBuffer buf = ByteBuffer.wrap(bytehdr).order(ByteOrder.BIG_ENDIAN);
        this.chunk.size = size = buf.getInt();
        this.chunk.flags = flags;
        return true;
    }

    public void startChecksum() {
        this.checksumming = true;
        this.crc32alg.reset();
    }

    public void computeChecksum(byte[] b, int offset, int extent) {
        this.crc32alg.update(b, offset, extent);
    }

    public void computeChecksum(int b) {
        this.crc32alg.update(b);
    }

    public long endChecksum() {
        this.crc32 = this.crc32alg.getValue();
        this.crc32 &= 0xFFFFFFFFL;
        this.checksumming = false;
        return this.crc32;
    }

    public static enum State {
        INITIAL,
        MORE,
        END,
        ERROR;

    }

    protected static class Chunk {
        public byte[] chunk = null;
        public int size = 0;
        public int avail = 0;
        public int pos = 0;
        public int flags = 0;
    }
}

