/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.cdm;

import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapType;
import dap4.core.dmr.TypeSort;
import dap4.core.util.ConversionException;
import dap4.core.util.CoreTypeFcns;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.nc2.EnumTypedef;

public abstract class CDMTypeFcns {
    static final BigInteger LONGMASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);

    public static Class cdmElementClass(DataType dt) {
        switch (dt) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case ENUM1: 
            case BYTE: {
                return Byte.class;
            }
            case CHAR: {
                return Character.class;
            }
            case ENUM2: 
            case SHORT: {
                return Short.class;
            }
            case ENUM4: 
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case STRING: {
                return String.class;
            }
            case OPAQUE: {
                return ByteBuffer.class;
            }
            case UBYTE: {
                return Byte.class;
            }
            case USHORT: {
                return Short.class;
            }
            case UINT: {
                return Integer.class;
            }
            case ULONG: {
                return Long.class;
            }
        }
        return null;
    }

    public static Object createVector(DataType type, long count) {
        int icount = (int)count;
        Object[] vector = null;
        switch (type) {
            case BOOLEAN: {
                vector = new boolean[icount];
                break;
            }
            case CHAR: {
                vector = new char[icount];
                break;
            }
            case ENUM1: 
            case BYTE: 
            case UBYTE: {
                vector = new byte[icount];
                break;
            }
            case ENUM2: 
            case SHORT: 
            case USHORT: {
                vector = new short[icount];
                break;
            }
            case ENUM4: 
            case INT: 
            case UINT: {
                vector = new int[icount];
                break;
            }
            case LONG: 
            case ULONG: {
                vector = new long[icount];
                break;
            }
            case FLOAT: {
                vector = new float[icount];
                break;
            }
            case DOUBLE: {
                vector = new double[icount];
                break;
            }
            case STRING: {
                vector = new String[icount];
                break;
            }
            case OPAQUE: {
                vector = new ByteBuffer[icount];
                break;
            }
            default: {
                throw new ForbiddenConversionException();
            }
        }
        return vector;
    }

    public static boolean signify(DapType type) {
        return CDMTypeFcns.daptype2cdmtype(type).isUnsigned();
    }

    public static Object createVector(DapType type, long count) {
        if (type.getAtomicType() == TypeSort.Enum) {
            return CDMTypeFcns.createVector(((DapEnumeration)type).getBaseType(), count);
        }
        return CoreTypeFcns.createVector(type.getTypeSort(), count);
    }

    public static DataType enumTypeFor(DapType type) {
        switch (type.getTypeSort()) {
            case Char: 
            case Int8: 
            case UInt8: {
                return DataType.ENUM1;
            }
            case Int16: 
            case UInt16: {
                return DataType.ENUM2;
            }
            case Int32: 
            case UInt32: {
                return DataType.ENUM4;
            }
            case Int64: 
            case UInt64: {
                return DataType.ENUM4;
            }
            case Enum: {
                return CDMTypeFcns.enumTypeFor(((DapEnumeration)type).getBaseType());
            }
        }
        return null;
    }

    public static DapType cdmtype2daptype(DataType datatype) {
        switch (datatype) {
            case CHAR: {
                return DapType.CHAR;
            }
            case BYTE: {
                return DapType.INT8;
            }
            case SHORT: {
                return DapType.INT16;
            }
            case INT: {
                return DapType.INT32;
            }
            case LONG: {
                return DapType.INT64;
            }
            case UBYTE: {
                return DapType.UINT8;
            }
            case USHORT: {
                return DapType.UINT16;
            }
            case UINT: {
                return DapType.UINT32;
            }
            case ULONG: {
                return DapType.UINT64;
            }
            case FLOAT: {
                return DapType.FLOAT32;
            }
            case DOUBLE: {
                return DapType.FLOAT64;
            }
            case STRING: {
                return DapType.STRING;
            }
            case OPAQUE: {
                return DapType.OPAQUE;
            }
            case ENUM1: {
                return DapType.INT8;
            }
            case ENUM2: {
                return DapType.INT16;
            }
            case ENUM4: {
                return DapType.INT32;
            }
        }
        return null;
    }

    public static DataType daptype2cdmtype(DapType type) {
        assert (type != null);
        switch (type.getTypeSort()) {
            case Char: {
                return DataType.CHAR;
            }
            case UInt8: {
                return DataType.UBYTE;
            }
            case Int8: {
                return DataType.BYTE;
            }
            case Int16: {
                return DataType.SHORT;
            }
            case UInt16: {
                return DataType.USHORT;
            }
            case Int32: {
                return DataType.INT;
            }
            case UInt32: {
                return DataType.UINT;
            }
            case Int64: {
                return DataType.LONG;
            }
            case UInt64: {
                return DataType.ULONG;
            }
            case Float32: {
                return DataType.FLOAT;
            }
            case Float64: {
                return DataType.DOUBLE;
            }
            case String: 
            case URL: {
                return DataType.STRING;
            }
            case Opaque: {
                return DataType.OPAQUE;
            }
            case Enum: {
                DapEnumeration dapenum = (DapEnumeration)type;
                switch (dapenum.getBaseType().getTypeSort()) {
                    case Char: 
                    case Int8: 
                    case UInt8: {
                        return DataType.ENUM1;
                    }
                    case Int16: 
                    case UInt16: {
                        return DataType.ENUM2;
                    }
                    case Int32: 
                    case UInt32: {
                        return DataType.ENUM4;
                    }
                    case Int64: 
                    case UInt64: {
                        return DataType.ENUM4;
                    }
                }
                break;
            }
            case Structure: {
                return DataType.STRUCTURE;
            }
            case Sequence: {
                return DataType.SEQUENCE;
            }
        }
        return null;
    }

    public static int daptypeSize(TypeSort atomtype) {
        switch (atomtype) {
            case Char: 
            case Int8: 
            case UInt8: {
                return 1;
            }
            case Int16: 
            case UInt16: {
                return 2;
            }
            case Int32: 
            case UInt32: 
            case Float32: {
                return 4;
            }
            case Int64: 
            case UInt64: 
            case Float64: {
                return 8;
            }
        }
        return 0;
    }

    public static long extract(TypeSort sort, Object value) {
        long lvalue = 0L;
        switch (sort) {
            case Int8: {
                lvalue = ((Byte)value).byteValue();
                break;
            }
            case Char: 
            case UInt8: {
                lvalue = ((Byte)value).byteValue();
                lvalue &= 0xFFL;
                break;
            }
            case Int16: {
                lvalue = ((Short)value).shortValue();
                break;
            }
            case UInt16: {
                lvalue = ((Short)value).shortValue();
                lvalue &= 0xFFFFL;
                break;
            }
            case Int32: {
                lvalue = ((Integer)value).intValue();
                break;
            }
            case UInt32: {
                lvalue = ((Integer)value).intValue();
                lvalue &= 0xFFFFFFFFL;
                break;
            }
            case Int64: 
            case UInt64: {
                lvalue = (Long)value;
                break;
            }
            case Float32: {
                lvalue = (long)((Float)value).floatValue();
                break;
            }
            case Float64: {
                lvalue = (long)((Double)value).doubleValue();
                break;
            }
            default: {
                throw new ForbiddenConversionException("Type not convertible to long");
            }
        }
        return lvalue;
    }

    public static Object convert(TypeSort dstsort, TypeSort srcsort, Object src) {
        boolean ok;
        Object[] result;
        block233: {
            result = null;
            ok = true;
            int len = 0;
            boolean srcunsigned = srcsort.isUnsigned();
            boolean dstunsigned = dstsort.isUnsigned();
            try {
                switch (srcsort) {
                    case Char: {
                        char[] csrc = (char[])src;
                        len = csrc.length;
                        switch (dstsort) {
                            case Char: 
                            case Int8: 
                            case UInt8: {
                                return src;
                            }
                            case Int16: 
                            case UInt16: {
                                short[] shresult;
                                result = shresult = new short[len];
                                for (int i = 0; i < len; ++i) {
                                    shresult[i] = (short)(csrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int32: 
                            case UInt32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    iresult[i] = csrc[i] & 0xFF;
                                }
                                break block233;
                            }
                            case Int64: 
                            case UInt64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    lresult[i] = csrc[i] & 0xFF;
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = csrc[i] & 0xFF;
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = csrc[i] & 0xFF;
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case Int8: {
                        byte[] bsrc = (byte[])src;
                        len = bsrc.length;
                        switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)(bsrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int16: 
                            case UInt16: {
                                int i;
                                short[] shresult = new short[len];
                                result = shresult;
                                for (i = 0; i < len; ++i) {
                                    shresult[i] = bsrc[i];
                                }
                                if (dstunsigned) {
                                    i = 0;
                                    while (i < len) {
                                        int n = i++;
                                        shresult[n] = (short)(shresult[n] & 0xFF);
                                    }
                                }
                                break block233;
                            }
                            case Int32: 
                            case UInt32: {
                                int i;
                                int[] iresult = new int[len];
                                result = iresult;
                                for (i = 0; i < len; ++i) {
                                    iresult[i] = bsrc[i];
                                }
                                if (dstunsigned) {
                                    i = 0;
                                    while (i < len) {
                                        int n = i++;
                                        iresult[n] = iresult[n] & 0xFF;
                                    }
                                }
                                break block233;
                            }
                            case Int64: 
                            case UInt64: {
                                int i;
                                long[] lresult = new long[len];
                                result = lresult;
                                for (i = 0; i < len; ++i) {
                                    lresult[i] = bsrc[i];
                                }
                                if (dstunsigned) {
                                    i = 0;
                                    while (i < len) {
                                        int n = i++;
                                        lresult[n] = lresult[n] & 0xFFL;
                                    }
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = bsrc[i];
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = bsrc[i];
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case UInt8: {
                        byte[] bsrc = (byte[])src;
                        len = bsrc.length;
                        switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)(bsrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int16: 
                            case UInt16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    shresult[i] = (short)(bsrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int32: 
                            case UInt32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    iresult[i] = bsrc[i] & 0xFF;
                                }
                                break block233;
                            }
                            case Int64: 
                            case UInt64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    lresult[i] = (long)bsrc[i] & 0xFFL;
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = bsrc[i] & 0xFF;
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = bsrc[i] & 0xFF;
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case Int16: {
                        short[] shsrc = (short[])src;
                        len = shsrc.length;
                        switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)(shsrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int8: 
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    bresult[i] = (byte)shsrc[i];
                                }
                                break block233;
                            }
                            case Int32: 
                            case UInt32: {
                                int i;
                                int[] iresult = new int[len];
                                result = iresult;
                                for (i = 0; i < len; ++i) {
                                    iresult[i] = shsrc[i];
                                }
                                if (dstunsigned) {
                                    i = 0;
                                    while (i < len) {
                                        int n = i++;
                                        iresult[n] = iresult[n] & 0xFFFF;
                                    }
                                }
                                break block233;
                            }
                            case Int64: 
                            case UInt64: {
                                int i;
                                long[] lresult = new long[len];
                                result = lresult;
                                for (i = 0; i < len; ++i) {
                                    lresult[i] = shsrc[i];
                                }
                                if (dstunsigned) {
                                    i = 0;
                                    while (i < len) {
                                        int n = i++;
                                        lresult[n] = lresult[n] & 0xFFFFL;
                                    }
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = shsrc[i];
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = shsrc[i];
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case UInt16: {
                        short[] shsrc = (short[])src;
                        len = shsrc.length;
                        switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)(shsrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int8: 
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    bresult[i] = (byte)shsrc[i];
                                }
                                break block233;
                            }
                            case Int32: 
                            case UInt32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    iresult[i] = shsrc[i] & 0xFFFF;
                                }
                                break block233;
                            }
                            case Int64: 
                            case UInt64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    lresult[i] = (long)shsrc[i] & 0xFFFFL;
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = shsrc[i] & 0xFFFF;
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = shsrc[i] & 0xFFFF;
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case Int32: {
                        int[] isrc = (int[])src;
                        len = isrc.length;
                        switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)(isrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int8: 
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    bresult[i] = (byte)isrc[i];
                                }
                                break block233;
                            }
                            case Int16: 
                            case UInt16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    shresult[i] = (short)isrc[i];
                                }
                                break block233;
                            }
                            case Int64: 
                            case UInt64: {
                                int i;
                                long[] lresult = new long[len];
                                result = lresult;
                                for (i = 0; i < len; ++i) {
                                    lresult[i] = isrc[i];
                                }
                                if (dstunsigned) {
                                    i = 0;
                                    while (i < len) {
                                        int n = i++;
                                        lresult[n] = lresult[n] & 0xFFFFL;
                                    }
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = isrc[i];
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = isrc[i];
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case UInt32: {
                        int[] isrc = (int[])src;
                        len = isrc.length;
                        switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)(isrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int8: 
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    bresult[i] = (byte)isrc[i];
                                }
                                break block233;
                            }
                            case Int16: 
                            case UInt16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    shresult[i] = (short)isrc[i];
                                }
                                break block233;
                            }
                            case Int64: 
                            case UInt64: {
                                int i;
                                long[] lresult = new long[len];
                                result = lresult;
                                for (i = 0; i < len; ++i) {
                                    lresult[i] = isrc[i];
                                }
                                if (dstunsigned) {
                                    i = 0;
                                    while (i < len) {
                                        int n = i++;
                                        lresult[n] = lresult[n] & 0xFFFFFFFFL;
                                    }
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = isrc[i] & 0xFFFF;
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = isrc[i] & 0xFFFF;
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case Int64: {
                        long[] lsrc = (long[])src;
                        len = lsrc.length;
                        switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)(lsrc[i] & 0xFFL);
                                }
                                break block233;
                            }
                            case Int8: 
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    bresult[i] = (byte)lsrc[i];
                                }
                                break block233;
                            }
                            case Int16: 
                            case UInt16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    shresult[i] = (short)lsrc[i];
                                }
                                break block233;
                            }
                            case Int32: 
                            case UInt32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    iresult[i] = (int)lsrc[i];
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = lsrc[i];
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = lsrc[i];
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case UInt64: {
                        long[] lsrc = (long[])src;
                        len = lsrc.length;
                        switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)(lsrc[i] & 0xFFL);
                                }
                                break block233;
                            }
                            case Int8: 
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    bresult[i] = (byte)lsrc[i];
                                }
                                break block233;
                            }
                            case Int16: 
                            case UInt16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    shresult[i] = (short)lsrc[i];
                                }
                                break block233;
                            }
                            case Int32: 
                            case UInt32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    iresult[i] = (int)lsrc[i];
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    BigInteger bi = BigInteger.valueOf(lsrc[i]);
                                    bi = bi.and(DapUtil.BIG_UMASK64);
                                    fresult[i] = bi.floatValue();
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    BigInteger bi = BigInteger.valueOf(lsrc[i]);
                                    bi = bi.and(DapUtil.BIG_UMASK64);
                                    dresult[i] = bi.doubleValue();
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case Float32: {
                        float[] fsrc = (float[])src;
                        len = fsrc.length;
                        block88 : switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)((int)fsrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    bresult[i] = (byte)fsrc[i];
                                }
                                break block233;
                            }
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    if (fsrc[i] < 0.0f) {
                                        ok = false;
                                        break block88;
                                    }
                                    bresult[i] = (byte)fsrc[i];
                                }
                                break block233;
                            }
                            case Int16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    shresult[i] = (short)fsrc[i];
                                }
                                break block233;
                            }
                            case UInt16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    if (fsrc[i] < 0.0f) {
                                        ok = false;
                                        break block88;
                                    }
                                    shresult[i] = (short)fsrc[i];
                                }
                                break block233;
                            }
                            case Int32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    if (fsrc[i] < 0.0f) {
                                        ok = false;
                                        break block88;
                                    }
                                    iresult[i] = (int)fsrc[i];
                                }
                                break block233;
                            }
                            case UInt32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    if (fsrc[i] < 0.0f) {
                                        ok = false;
                                        break block88;
                                    }
                                    iresult[i] = (int)fsrc[i];
                                }
                                break block233;
                            }
                            case Int64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    BigDecimal bd = new BigDecimal(fsrc[i]);
                                    lresult[i] = bd.toBigInteger().longValue();
                                }
                                break block233;
                            }
                            case UInt64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    if (fsrc[i] < 0.0f) {
                                        ok = false;
                                        break block88;
                                    }
                                    BigDecimal bd = new BigDecimal(fsrc[i]);
                                    lresult[i] = bd.toBigInteger().longValue();
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = fsrc[i];
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case Float64: {
                        double[] dsrc = (double[])src;
                        len = dsrc.length;
                        block100 : switch (dstsort) {
                            case Char: {
                                char[] cresult = new char[len];
                                result = cresult;
                                for (int i = 0; i < len; ++i) {
                                    cresult[i] = (char)((int)dsrc[i] & 0xFF);
                                }
                                break block233;
                            }
                            case Int8: 
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    bresult[i] = (byte)dsrc[i];
                                }
                                break block233;
                            }
                            case Int16: 
                            case UInt16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    shresult[i] = (short)dsrc[i];
                                }
                                break block233;
                            }
                            case Int32: 
                            case UInt32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    iresult[i] = (int)dsrc[i];
                                }
                                break block233;
                            }
                            case Int64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    BigDecimal bd = new BigDecimal(dsrc[i]);
                                    lresult[i] = bd.toBigInteger().longValue();
                                }
                                break block233;
                            }
                            case UInt64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    if (dsrc[i] < 0.0) {
                                        ok = false;
                                        break block100;
                                    }
                                    BigDecimal bd = new BigDecimal(dsrc[i]);
                                    lresult[i] = bd.toBigInteger().longValue();
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = (float)dsrc[i];
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    case String: {
                        String[] ssrc = (String[])src;
                        len = ssrc.length;
                        block109 : switch (dstsort) {
                            case Char: {
                                ok = false;
                                break;
                            }
                            case Int8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    long lval = Long.decode(ssrc[i]);
                                    if (lval < -128L || lval > 127L) {
                                        ok = false;
                                        break block109;
                                    }
                                    bresult[i] = (byte)lval;
                                }
                                break block233;
                            }
                            case UInt8: {
                                byte[] bresult = new byte[len];
                                result = bresult;
                                for (int i = 0; i < len; ++i) {
                                    long lval = Long.decode(ssrc[i]);
                                    if (lval < 0L || lval > 255L) {
                                        ok = false;
                                        break block109;
                                    }
                                    bresult[i] = (byte)lval;
                                }
                                break block233;
                            }
                            case Int16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    long lval = Long.decode(ssrc[i]);
                                    if (lval < -32768L || lval > 32767L) {
                                        ok = false;
                                        break block109;
                                    }
                                    shresult[i] = (short)lval;
                                }
                                break block233;
                            }
                            case UInt16: {
                                short[] shresult = new short[len];
                                result = shresult;
                                for (int i = 0; i < len; ++i) {
                                    long lval = Long.decode(ssrc[i]);
                                    if (lval < 0L || lval > 65535L) {
                                        ok = false;
                                        break block109;
                                    }
                                    shresult[i] = (short)lval;
                                }
                                break block233;
                            }
                            case Int32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    long lval = Long.decode(ssrc[i]);
                                    if (lval < Integer.MIN_VALUE || lval > Integer.MAX_VALUE) {
                                        ok = false;
                                        break block109;
                                    }
                                    iresult[i] = (int)lval;
                                }
                                break block233;
                            }
                            case UInt32: {
                                int[] iresult = new int[len];
                                result = iresult;
                                for (int i = 0; i < len; ++i) {
                                    long lval = Long.decode(ssrc[i]);
                                    if (lval < 0L || lval > 0xFFFFFFFFL) {
                                        ok = false;
                                        break block109;
                                    }
                                    iresult[i] = (int)lval;
                                }
                                break block233;
                            }
                            case Int64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    long lval;
                                    BigInteger bi = new BigInteger(ssrc[i]);
                                    try {
                                        lval = bi.longValueExact();
                                    }
                                    catch (ArithmeticException ae) {
                                        ok = false;
                                        break block109;
                                    }
                                    lresult[i] = lval;
                                }
                                break block233;
                            }
                            case UInt64: {
                                long[] lresult = new long[len];
                                result = lresult;
                                for (int i = 0; i < len; ++i) {
                                    long lval;
                                    BigInteger bi = new BigInteger(ssrc[i]);
                                    if (bi.compareTo(BigInteger.ZERO) < 0) {
                                        ok = false;
                                        break block109;
                                    }
                                    if (bi.compareTo(LONGMASK) > 0) {
                                        ok = false;
                                        break block109;
                                    }
                                    lresult[i] = lval = bi.longValue();
                                }
                                break block233;
                            }
                            case Float32: {
                                float[] fresult = new float[len];
                                result = fresult;
                                for (int i = 0; i < len; ++i) {
                                    fresult[i] = Float.parseFloat(ssrc[i]);
                                }
                                break block233;
                            }
                            case Float64: {
                                double[] dresult = new double[len];
                                result = dresult;
                                for (int i = 0; i < len; ++i) {
                                    dresult[i] = Double.parseDouble(ssrc[i]);
                                }
                                break block233;
                            }
                            default: {
                                ok = false;
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        ok = false;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                ok = false;
            }
        }
        if (!ok) {
            throw new ForbiddenConversionException(srcsort.name() + "->" + dstsort.name());
        }
        return result;
    }

    public static void vectorcopy(DapType datatype, Object src, Object dst, long srcoffset, long dstoffset) throws DapException {
        switch (datatype.getTypeSort()) {
            case Int8: 
            case UInt8: {
                ((byte[])dst)[(int)dstoffset] = ((byte[])src)[(int)srcoffset];
                break;
            }
            case Char: {
                ((char[])dst)[(int)dstoffset] = ((char[])src)[(int)srcoffset];
                break;
            }
            case Int16: 
            case UInt16: {
                ((short[])dst)[(int)dstoffset] = ((short[])src)[(int)srcoffset];
                break;
            }
            case Int32: 
            case UInt32: {
                ((int[])dst)[(int)dstoffset] = ((int[])src)[(int)srcoffset];
                break;
            }
            case Int64: 
            case UInt64: {
                ((long[])dst)[(int)dstoffset] = ((long[])src)[(int)srcoffset];
                break;
            }
            case Float32: {
                ((float[])dst)[(int)dstoffset] = ((float[])src)[(int)srcoffset];
                break;
            }
            case Float64: {
                ((double[])dst)[(int)dstoffset] = ((double[])src)[(int)srcoffset];
                break;
            }
            case Opaque: {
                Object o = ((Object[])src)[(int)srcoffset];
                ((ByteBuffer[])dst)[(int)dstoffset] = (ByteBuffer)o;
                break;
            }
            case String: {
                Object o = ((Object[])src)[(int)srcoffset];
                ((String[])dst)[(int)dstoffset] = (String)o;
                break;
            }
            case Enum: {
                CDMTypeFcns.vectorcopy(((DapEnumeration)datatype).getBaseType(), src, dst, srcoffset, dstoffset);
                break;
            }
            default: {
                throw new DapException("Attempt to read non-atomic value of type: " + datatype);
            }
        }
    }

    public static Object attributeParse(DataType cdmtype, EnumTypedef en, Object o) {
        String so = o.toString();
        if (en != null) {
            switch (cdmtype) {
                case ENUM1: 
                case ENUM2: 
                case ENUM4: {
                    if (!(o instanceof Integer)) {
                        throw new ConversionException(o.toString());
                    }
                    int eval = (Integer)o;
                    String econst = en.lookupEnumString(eval);
                    if (econst == null) {
                        throw new ConversionException(o.toString());
                    }
                    return econst;
                }
            }
            throw new ConversionException(o.toString());
        }
        long lval = 0L;
        double dval = 0.0;
        boolean islong = true;
        boolean isdouble = true;
        try {
            lval = Long.parseLong(so);
        }
        catch (NumberFormatException nfe) {
            islong = false;
        }
        try {
            dval = Double.parseDouble(so);
        }
        catch (NumberFormatException nfe) {
            isdouble = false;
        }
        o = null;
        switch (cdmtype) {
            case BOOLEAN: {
                if (so.equalsIgnoreCase("false") || islong && lval == 0L) {
                    o = Boolean.FALSE;
                    break;
                }
                o = Boolean.TRUE;
                break;
            }
            case BYTE: {
                if (!islong) break;
                o = (byte)lval;
                break;
            }
            case SHORT: {
                if (!islong) break;
                o = (short)lval;
                break;
            }
            case INT: {
                if (!islong) break;
                o = (int)lval;
                break;
            }
            case LONG: {
                if (!islong) break;
                o = lval;
                break;
            }
            case UBYTE: {
                if (!islong) break;
                o = (byte)(lval & 0xFFL);
                break;
            }
            case USHORT: {
                if (!islong) break;
                o = (short)(lval & 0xFFFFL);
                break;
            }
            case UINT: {
                if (!islong) break;
                o = (int)(lval & 0xFFFFFFFFL);
                break;
            }
            case ULONG: {
                BigInteger bi = new BigInteger(so);
                bi = bi.and(LONGMASK);
                o = bi.longValue();
                break;
            }
            case FLOAT: {
                if (islong && !isdouble) {
                    dval = lval;
                    isdouble = true;
                }
                if (!isdouble) break;
                o = Float.valueOf((float)dval);
                break;
            }
            case DOUBLE: {
                if (islong && !isdouble) {
                    dval = lval;
                    isdouble = true;
                }
                if (!isdouble) break;
                o = dval;
                break;
            }
            case STRING: {
                return so;
            }
            case OPAQUE: {
                if (so.startsWith("0x") || so.startsWith("0X")) {
                    so = so.substring(2);
                }
                BigInteger bi = new BigInteger(so, 16);
                byte[] bb = bi.toByteArray();
                o = ByteBuffer.wrap(bb);
                break;
            }
            default: {
                throw new ConversionException(o.toString());
            }
        }
        if (o == null) {
            throw new ConversionException(o.toString());
        }
        return o;
    }

    public static boolean isPrimitiveVector(DataType type, Object o) {
        Class<?> c = o.getClass();
        if (!c.isArray()) {
            return false;
        }
        switch (type) {
            case BOOLEAN: {
                return o instanceof boolean[];
            }
            case CHAR: {
                return o instanceof char[];
            }
            case ENUM1: 
            case BYTE: 
            case UBYTE: {
                return o instanceof byte[];
            }
            case ENUM2: 
            case SHORT: 
            case USHORT: {
                return o instanceof short[];
            }
            case ENUM4: 
            case INT: 
            case UINT: {
                return o instanceof int[];
            }
            case LONG: 
            case ULONG: {
                return o instanceof long[];
            }
            case FLOAT: {
                return o instanceof float[];
            }
            case DOUBLE: {
                return o instanceof double[];
            }
            case STRING: {
                return o instanceof String[];
            }
            case OPAQUE: {
                return o instanceof ByteBuffer[];
            }
        }
        return false;
    }

    public static Array arrayify(DataType datatype, Object o) {
        if (!o.getClass().isArray()) {
            Object ovec = CDMTypeFcns.createVector(datatype, 1L);
            java.lang.reflect.Array.set(ovec, 0, o);
            o = ovec;
        }
        int[] shape = new int[]{java.lang.reflect.Array.getLength(o)};
        return Array.factory((DataType)datatype, (int[])shape, (Object)o);
    }

    public static Array arrayify(DapType type, Object o) {
        if (type.getAtomicType() == TypeSort.Enum) {
            return CDMTypeFcns.arrayify(((DapEnumeration)type).getBaseType(), o);
        }
        return CDMTypeFcns.arrayify(CDMTypeFcns.daptype2cdmtype(type), o);
    }

    public static List listify(Object vector) {
        ArrayList<Object> list = new ArrayList<Object>();
        int icount = java.lang.reflect.Array.getLength(vector);
        for (int i = 0; i < icount; ++i) {
            list.add(java.lang.reflect.Array.get(vector, i));
        }
        return list;
    }

    public static Object bytesAsTypeVec(DapType daptype, byte[] bytes) {
        TypeSort tsort = daptype.getTypeSort();
        int count = bytes.length / daptype.getSize();
        switch (tsort) {
            case Char: {
                return new char[count];
            }
            case Int8: 
            case UInt8: {
                return new byte[count];
            }
            case Int16: 
            case UInt16: {
                return new short[count];
            }
            case Int32: 
            case UInt32: {
                return new int[count];
            }
            case Int64: 
            case UInt64: {
                return new long[count];
            }
            case Float32: {
                return new float[count];
            }
            case Float64: {
                return new double[count];
            }
            case Enum: {
                return CDMTypeFcns.bytesAsTypeVec(((DapEnumeration)daptype).getBaseType(), bytes);
            }
        }
        return null;
    }

    public static void decodebytes(ByteOrder remoteorder, DapType daptype, byte[] bytes, Object vector) {
        TypeSort tsort = daptype.getTypeSort();
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(remoteorder);
        switch (tsort) {
            case Char: {
                String cb = new String(bytes, DapUtil.UTF8);
                char[] cv = (char[])vector;
                for (int i = 0; i < cv.length; ++i) {
                    cv[i] = cb.charAt(i);
                }
                break;
            }
            case Int8: 
            case UInt8: {
                bb.get((byte[])vector);
                break;
            }
            case Int16: 
            case UInt16: {
                ShortBuffer sb = bb.asShortBuffer();
                short[] sv = (short[])vector;
                sb.get(sv);
                break;
            }
            case Int32: 
            case UInt32: {
                IntBuffer ib = bb.asIntBuffer();
                int[] iv = (int[])vector;
                ib.get(iv);
                break;
            }
            case Int64: 
            case UInt64: {
                LongBuffer lb = bb.asLongBuffer();
                long[] lv = (long[])vector;
                lb.get(lv);
                break;
            }
            case Float32: {
                FloatBuffer fb = bb.asFloatBuffer();
                float[] fv = (float[])vector;
                fb.get(fv);
                break;
            }
            case Float64: {
                DoubleBuffer db = bb.asDoubleBuffer();
                double[] dv = (double[])vector;
                db.get(dv);
                break;
            }
            case Enum: {
                CDMTypeFcns.decodebytes(remoteorder, ((DapEnumeration)daptype).getBaseType(), bytes, vector);
                break;
            }
        }
    }
}

