/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.interfaces;

import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;

public enum ArrayScheme {
    ATOMIC,
    STRUCTARRAY,
    STRUCTURE,
    SEQARRAY,
    SEQUENCE,
    RECORD;


    public static ArrayScheme schemeFor(DapVariable field) {
        boolean isscalar;
        DapType ftype = field.getBaseType();
        ArrayScheme scheme = null;
        boolean bl = isscalar = field.getRank() == 0;
        if (ftype.getTypeSort().isAtomic()) {
            scheme = ATOMIC;
        } else if (ftype.getTypeSort().isStructType()) {
            scheme = STRUCTARRAY;
        } else if (ftype.getTypeSort().isSeqType()) {
            scheme = SEQARRAY;
        }
        return scheme;
    }
}

