/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapVariable;
import dap4.core.interfaces.ArrayScheme;
import dap4.dap4lib.D4DSP;
import ucar.ma2.Array;

public class D4Array {
    static final long NULLOFFSET = -1L;
    static final int D4LENSIZE = 8;
    protected D4DSP dsp;
    protected ArrayScheme scheme;
    protected DapNode template;
    protected Array array = null;
    protected Object storage = null;

    public D4Array(ArrayScheme scheme, D4DSP dsp, DapVariable template) {
        this.scheme = scheme;
        this.template = template;
        this.dsp = dsp;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getScheme().toString());
        if (this.getScheme() == ArrayScheme.STRUCTARRAY || this.getScheme() == ArrayScheme.SEQARRAY) {
            buf.append("[]");
        }
        buf.append(":");
        buf.append(this.getTemplate().toString());
        return buf.toString();
    }

    public D4DSP getDSP() {
        return this.dsp;
    }

    public ArrayScheme getScheme() {
        return this.scheme;
    }

    public DapNode getTemplate() {
        return this.template;
    }

    public Array getArray() {
        return this.array;
    }

    public Object getStorage() {
        return this.storage;
    }

    public boolean isScalar() {
        return ((DapVariable)this.getTemplate()).getRank() == 0;
    }

    public D4Array setArray(Array a) {
        this.array = a;
        return this;
    }

    public D4Array setStorage(Object store) {
        this.storage = store;
        return this;
    }
}

