/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.parser.DOM4Parser;
import dap4.core.util.ChecksumMode;
import dap4.core.util.DapConstants;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.XURI;
import dap4.dap4lib.D4Array;
import dap4.dap4lib.D4DataCompiler;
import dap4.dap4lib.DeChunkedInputStream;
import dap4.dap4lib.RequestMode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public abstract class D4DSP {
    public static boolean DEBUG = false;
    protected static final boolean PARSEDEBUG = true;
    protected String dmrtext = null;
    protected DapDataset dmr = null;
    protected String location = null;
    protected DeChunkedInputStream stream = null;
    protected boolean streamclosed = false;
    protected XURI xuri = null;
    protected ByteOrder remoteorder = null;
    protected ChecksumMode checksummode = null;
    protected RequestMode mode = null;
    D4DataCompiler d4compiler = null;
    protected Map<DapVariable, D4Array> datamap = new HashMap<DapVariable, D4Array>();

    public D4DSP open(String location, ChecksumMode cmode) throws DapException {
        this.location = location;
        this.checksummode = cmode;
        this.parseURL(location);
        return this;
    }

    public DeChunkedInputStream getStream() {
        return this.stream;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksummode;
    }

    public Map<DapVariable, D4Array> getVariableDataMap() {
        return this.datamap;
    }

    public Map<DapVariable, Long> getChecksumMap(DapConstants.ChecksumSource src) {
        if (src == DapConstants.ChecksumSource.LOCAL) {
            return this.d4compiler.localchecksummap;
        }
        return this.d4compiler.remotechecksummap;
    }

    protected D4DSP setStream(InputStream input, RequestMode mode) throws IOException {
        this.mode = mode;
        this.stream = new DeChunkedInputStream(input, mode);
        this.streamclosed = false;
        if (this.stream.getState() == DeChunkedInputStream.State.ERROR) {
            this.reportError(this.stream.getErrorText());
        }
        this.dmrtext = this.stream.getDMRText();
        this.remoteorder = this.stream.getRemoteOrder();
        return this;
    }

    protected void addVariableData(DapVariable var, D4Array cursor) {
        this.datamap.put(var, cursor);
    }

    public DapDataset getDMR() {
        return this.dmr;
    }

    protected void setDMR(DapDataset dmr) {
        this.dmr = dmr;
        if (this.dmr != null) {
            this.dmr.setDataset(this.dmr);
            this.dmr.setDapVersion("4.0");
            this.dmr.setDMRVersion("1.0");
            this.dmr.setNS("http://xml.opendap.org/ns/DAP/4.0#");
        }
    }

    public abstract boolean dspMatch(String var1, DapContext var2);

    public void loadDMR() throws IOException {
        String document = this.readDMR();
        DapDataset dmr = this.parseDMR(document);
        this.setDMR(dmr);
        if (this.mode == RequestMode.DMR) {
            assert (!this.streamclosed);
            this.stream.close();
            this.streamclosed = true;
        }
    }

    public void loadDAP() throws IOException {
        try {
            this.d4compiler = new D4DataCompiler(this, this.checksummode, this.remoteorder);
            this.d4compiler.compile();
            assert (!this.streamclosed);
            this.stream.close();
            this.streamclosed = true;
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
    }

    public void loadContext(DapContext cxt, RequestMode mode) {
        switch (mode) {
            case DMR: {
                break;
            }
            case DAP: {
                cxt.put(DapConstants.ChecksumSource.REMOTE, this.d4compiler.getChecksumMap(DapConstants.ChecksumSource.REMOTE));
                cxt.put(DapConstants.ChecksumSource.LOCAL, this.d4compiler.getChecksumMap(DapConstants.ChecksumSource.LOCAL));
                cxt.put(D4Array.class, this.getVariableDataMap());
            }
        }
    }

    protected String readDMR() throws IOException {
        String dmrtext = this.stream.getDMRText();
        if ((dmrtext = dmrtext.trim()).length() == 0) {
            throw new DapException("Empty DMR");
        }
        StringBuilder buf = new StringBuilder(dmrtext);
        int len = buf.length();
        if (buf.charAt(len - 1) == '\n') {
            buf.setLength(--len);
        }
        if (buf.charAt(len - 1) != '\r') {
            buf.append('\r');
        }
        buf.append('\n');
        return buf.toString();
    }

    protected void parseURL(String url) throws DapException {
        try {
            this.xuri = new XURI(url);
        }
        catch (URISyntaxException use) {
            throw new DapException(use);
        }
    }

    protected String getMethodUrl(RequestMode mode, ChecksumMode csum) throws DapException {
        this.xuri.removeQueryField("dap4.checksum");
        csum = ChecksumMode.asTrueFalse(csum);
        String scsum = ChecksumMode.toString(csum);
        this.xuri.insertQueryField("dap4.checksum", scsum);
        String corepath = DapUtil.stripDap4Extensions(this.xuri.getPath());
        if (mode == RequestMode.DMR) {
            this.xuri.setPath(corepath + ".dmr.xml");
        } else if (mode == RequestMode.DAP) {
            this.xuri.setPath(corepath + ".dap");
        } else {
            throw new DapException("Unexpected mode: " + (Object)((Object)mode));
        }
        String methodurl = this.xuri.assemble(XURI.URLQUERY);
        return methodurl;
    }

    protected DapDataset parseDMR(String document) throws DapException {
        DOM4Parser parser = new DOM4Parser(null);
        parser.setDebugLevel(1);
        try {
            if (!parser.parse(document)) {
                throw new DapException("DMR Parse failed");
            }
        }
        catch (SAXException se) {
            throw new DapException(se);
        }
        if (parser.getErrorResponse() != null) {
            throw new DapException("Error Response Document not supported");
        }
        DapDataset result = parser.getDMR();
        this.processAttributes(result);
        this.processMaps(result);
        return result;
    }

    protected boolean suppressAttributes(String attrname) {
        if (attrname.startsWith("_Coord")) {
            return true;
        }
        return attrname.equals("_Unsigned");
    }

    void getEndianAttribute(DapDataset dataset) {
        DapAttribute a = dataset.findAttribute("_DAP4_Little_Endian");
        if (a == null) {
            return;
        }
        String[] v = a.getValues();
        int len = Array.getLength(v);
        if (len == 0) {
            this.remoteorder = ByteOrder.LITTLE_ENDIAN;
        } else {
            String onezero = Array.get(v, 0).toString();
            int islittle = 1;
            try {
                islittle = Integer.parseInt(onezero);
            }
            catch (NumberFormatException e) {
                islittle = 1;
            }
            this.remoteorder = islittle == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        }
    }

    protected void processAttributes(DapDataset dataset) throws DapException {
        List<DapNode> nodes = dataset.getNodeList();
        block3: for (DapNode node : nodes) {
            switch (node.getSort()) {
                case GROUP: 
                case DATASET: 
                case VARIABLE: {
                    Map<String, DapAttribute> attrs = node.getAttributes();
                    if (attrs.size() <= 0) break;
                    ArrayList<DapAttribute> suppressed = new ArrayList<DapAttribute>();
                    for (DapAttribute dattr : attrs.values()) {
                        if (!this.suppressAttributes(dattr.getShortName())) continue;
                        suppressed.add(dattr);
                    }
                    for (DapAttribute dattr : suppressed) {
                        node.removeAttribute(dattr);
                    }
                    continue block3;
                }
            }
        }
        this.getEndianAttribute(dataset);
    }

    protected void processMaps(DapDataset dataset) throws DapException {
        List<DapNode> nodes = dataset.getNodeList();
        for (DapNode node : nodes) {
            switch (node.getSort()) {
                case MAP: {
                    DapMap map = (DapMap)node;
                    String targetname = map.getTargetName();
                    DapVariable target = (DapVariable)dataset.findByFQN(targetname, DapSort.VARIABLE, DapSort.SEQUENCE, DapSort.STRUCTURE);
                    if (target == null) {
                        throw new DapException("Mapref: undefined target variable: " + targetname);
                    }
                    DapNode container = target.getContainer();
                    if (container.getSort() == DapSort.STRUCTURE || container.getSort() == DapSort.SEQUENCE) {
                        throw new DapException("Mapref: map target variable not in outer scope: " + targetname);
                    }
                    map.setVariable(target);
                    break;
                }
            }
        }
    }

    protected void reportError(String errmsg) throws IOException {
        throw new DapException(errmsg);
    }
}

