/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.dmr.DapDataset;
import dap4.core.util.ChecksumMode;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.dap4lib.D4DSP;
import dap4.dap4lib.DapProtocol;
import dap4.dap4lib.RequestMode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPIntercepts;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPUtil;

public class HttpDSP
extends D4DSP {
    protected static final boolean DEBUG = false;
    protected static final int DFALTPRELOADSIZE = 50000;
    protected boolean allowCompression = true;
    protected int status = 200;

    public static void setHttpDebug() {
        HTTPIntercepts.setGlobalDebugInterceptors((boolean)true);
    }

    @Override
    public D4DSP open(String fileurl, ChecksumMode cmode) throws DapException {
        super.open(fileurl, cmode);
        return this;
    }

    @Override
    public boolean dspMatch(String url, DapContext context) {
        return DapProtocol.isDap4URI(url);
    }

    @Override
    public void loadDMR() throws DapException {
        String methodurl = this.getMethodUrl(RequestMode.DMR, this.checksummode);
        try {
            InputStream stream = this.makeRequest(methodurl);
            this.setStream(stream, RequestMode.DMR);
            super.loadDMR();
        }
        catch (IOException e) {
            throw new DapException(e);
        }
    }

    @Override
    public void loadDAP() throws DapException {
        String methodurl = this.getMethodUrl(RequestMode.DAP, this.checksummode);
        try (InputStream stream = this.makeRequest(methodurl);){
            this.setStream(stream, RequestMode.DAP);
            super.loadDAP();
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
    }

    protected InputStream makeRequest(String methodurl) throws DapException {
        try {
            URI uri = HTTPUtil.parseToURI((String)methodurl);
        }
        catch (URISyntaxException mue) {
            throw new DapException("Malformed url: " + methodurl);
        }
        long start = System.currentTimeMillis();
        long stop = 0L;
        this.status = 0;
        HTTPMethod method = null;
        try {
            method = HTTPFactory.Get((String)methodurl);
            if (this.allowCompression) {
                method.setCompression("deflate,gzip");
            }
            this.status = method.execute();
            if (this.status != 200) {
                String msg = method.getResponseAsString();
                throw new DapException("Request failure: " + this.status + ": " + methodurl).setCode(this.status);
            }
            return method.getResponseAsStream();
        }
        catch (HTTPException e) {
            if (method != null) {
                method.close();
            }
            throw new DapException(e);
        }
    }

    protected static String buildURL(String baseurl, String suffix, DapDataset template, String ce) {
        StringBuilder methodurl = new StringBuilder();
        methodurl.append(baseurl);
        if (suffix != null) {
            methodurl.append('.');
            methodurl.append(suffix);
        }
        if (ce != null && ce.length() > 0) {
            methodurl.append("?");
            methodurl.append("dap4.ce");
            methodurl.append('=');
            methodurl.append(ce);
        }
        return methodurl.toString();
    }
}

