/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.cdm.nc2;

import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.ChecksumMode;
import dap4.core.util.DapConstants;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.XURI;
import dap4.dap4lib.D4Array;
import dap4.dap4lib.D4DSP;
import dap4.dap4lib.DSPRegistry;
import dap4.dap4lib.HttpDSP;
import dap4.dap4lib.RawDSP;
import dap4.dap4lib.RequestMode;
import dap4.dap4lib.cdm.CDMUtil;
import dap4.dap4lib.cdm.NodeMap;
import dap4.dap4lib.cdm.nc2.CDMCompiler;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.CDMNode;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;

public class DapNetcdfFile
extends NetcdfFile {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    static final boolean MERGE = false;
    static Set<NetcdfDataset.Enhance> ENHANCEMENT = EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
    protected static final NullCancelTask nullcancel = new NullCancelTask();
    protected static DSPRegistry dspregistry = new DSPRegistry();
    protected boolean allowCompression = true;
    protected boolean closed = false;
    protected String location = null;
    protected CancelTask cancel = null;
    protected String dsplocation = null;
    protected XURI xuri = null;
    protected DapContext cxt = null;
    protected D4DSP dsp = null;
    protected DapDataset dmr = null;
    protected CDMCompiler cdmCompiler = null;
    protected ChecksumMode checksummode = null;
    protected boolean daploaded = false;
    protected Map<Variable, Array> arraymap = null;

    public DapNetcdfFile(String location, CancelTask cancelTask) throws IOException {
        XURI xuri;
        this.location = location;
        try {
            xuri = new XURI(location);
        }
        catch (URISyntaxException use) {
            throw new IOException(use);
        }
        if ("dap4".equalsIgnoreCase(xuri.getScheme())) {
            xuri.setScheme("https");
        }
        this.dsplocation = xuri.assemble(XURI.URLQUERY);
        this.cancel = cancelTask == null ? nullcancel : cancelTask;
        this.cxt = new DapContext();
        this.cxt.insert(xuri.getFragFields(), true);
        this.cxt.insert(xuri.getQueryFields(), true);
        String csummode = (String)this.cxt.get("dap4.checksum");
        this.checksummode = ChecksumMode.modeFor(csummode);
        this.checksummode = ChecksumMode.asTrueFalse(this.checksummode);
        this.cxt.put(ChecksumMode.class, this.checksummode);
        this.dsp = dspregistry.findMatchingDSP(this.location, this.cxt);
        if (this.dsp == null) {
            throw new IOException("No matching DSP: " + this.location);
        }
        this.dsp.open(this.dsplocation, this.checksummode);
        this.ensuredmr();
        this.dmr = this.dsp.getDMR();
        this.cxt.put(DapDataset.class, this.dmr);
        this.setLocation(this.dmr.getDataset().getShortName());
        this.finish();
        this.dsp.loadContext(this.cxt, RequestMode.DMR);
    }

    public DapNetcdfFile(String url) throws IOException {
        this(url, null);
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.dsp = null;
    }

    public boolean isconstrainable() {
        return true;
    }

    public String getLocation() {
        return this.location;
    }

    public D4DSP getDSP() {
        return this.dsp;
    }

    public List<Array> readArrays(List<Variable> variables) throws IOException {
        ArrayList<Array> result = new ArrayList<Array>();
        for (Variable variable : variables) {
            result.add(variable.read());
        }
        return result;
    }

    public long readToByteChannel(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array result = this.readData(v, section);
        return IospHelper.transferData((Array)result, (WritableByteChannel)channel);
    }

    public Array readSection(String variableSection) throws IOException, InvalidRangeException {
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)this, (String)variableSection);
        return cer.v.read(cer.section);
    }

    protected Array readData(Variable cdmvar, Section section) throws IOException, InvalidRangeException {
        this.ensuredata();
        Array result = this.arraymap.get(cdmvar);
        if (result == null) {
            throw new IOException("No data for variable: " + cdmvar.getFullName());
        }
        if (section != null) {
            if (cdmvar.getRank() != section.getRank()) {
                throw new InvalidRangeException(String.format("Section rank != %s rank", cdmvar.getFullName()));
            }
            List ranges = section.getRanges();
            if (CDMUtil.hasVLEN(ranges)) {
                ranges = ranges.subList(0, ranges.size() - 1);
            }
            if (ranges.size() > 0 && !CDMUtil.isWhole((List<Range>)ranges, cdmvar)) {
                result = result.sectionNoReduce(ranges);
            }
        }
        return result;
    }

    protected void loadContext() {
        this.cxt.put(DapConstants.ChecksumSource.REMOTE, this.dsp.getChecksumMap(DapConstants.ChecksumSource.REMOTE));
        this.cxt.put(DapConstants.ChecksumSource.LOCAL, this.dsp.getChecksumMap(DapConstants.ChecksumSource.LOCAL));
        this.cxt.put(D4Array.class, this.dsp.getVariableDataMap());
    }

    protected void verifyChecksums() throws DapException {
        ChecksumMode cmode = (ChecksumMode)((Object)this.cxt.get(ChecksumMode.class));
        Map remotechecksummap = (Map)this.cxt.get((Object)DapConstants.ChecksumSource.REMOTE);
        Map localchecksummap = (Map)this.cxt.get((Object)DapConstants.ChecksumSource.LOCAL);
        if (cmode != ChecksumMode.TRUE) {
            return;
        }
        for (DapVariable dvar : this.dmr.getTopVariables()) {
            Long remotechecksum = (Long)remotechecksummap.get(dvar);
            Long localchecksum = (Long)localchecksummap.get(dvar);
            assert (localchecksum != null && remotechecksum != null);
            if (!this.cxt.containsKey("hyrax") && localchecksum.longValue() != remotechecksum.longValue()) {
                throw new DapException("Checksum mismatch: local=" + localchecksum + " remote=" + remotechecksum);
            }
            DapAttribute csumattr = dvar.getChecksumAttribute();
            if (csumattr == null) continue;
            assert (csumattr.getValues().length == 1 && csumattr.getBaseType() == DapType.INT32);
            Long attrcsum = 0L;
            try {
                attrcsum = Long.parseLong(csumattr.getValues()[0]);
            }
            catch (NumberFormatException nfe) {
                throw new DapException("Illegal Checksum attribute value", nfe);
            }
            if (this.cxt.containsKey("hyrax") || localchecksum.longValue() == attrcsum.longValue()) continue;
            throw new DapException("Checksum mismatch: local=" + localchecksum + " attribute=" + attrcsum);
        }
    }

    public void ensuredmr() throws IOException {
        if (this.dmr == null) {
            this.dsp.loadDMR();
            this.dmr = this.dsp.getDMR();
            if (this.cdmCompiler == null) {
                this.cdmCompiler = new CDMCompiler(this, this.dsp);
            }
            this.cdmCompiler.compileDMR();
        }
    }

    public void ensuredata() throws IOException {
        if (!this.daploaded) {
            this.daploaded = true;
            this.dsp.loadDAP();
            this.loadContext();
            this.verifyChecksums();
            this.dsp.loadContext(this.cxt, RequestMode.DAP);
            if (this.cdmCompiler == null) {
                this.cdmCompiler = new CDMCompiler(this, this.dsp);
            }
            this.cdmCompiler.compileData();
            assert (this.arraymap == null);
            this.arraymap = new HashMap<Variable, Array>();
            Map<DapVariable, D4Array> datamap = this.dsp.getVariableDataMap();
            NodeMap<CDMNode, DapNode> nodemap = this.cdmCompiler.getNodeMap();
            for (Map.Entry<DapVariable, D4Array> entry : datamap.entrySet()) {
                DapVariable dv = entry.getKey();
                D4Array dc = entry.getValue();
                Variable v = (Variable)nodemap.get(entry.getKey());
                assert (dc.getArray() != null);
                this.arraymap.put(v, dc.getArray());
            }
        }
    }

    static {
        dspregistry.register(RawDSP.class, false);
        dspregistry.register(HttpDSP.class, false);
    }

    protected static class NullCancelTask
    implements CancelTask {
        protected NullCancelTask() {
        }

        public boolean isCancel() {
            return false;
        }

        public boolean isDone() {
            return false;
        }

        public void setDone(boolean done) {
        }

        public void setError(String msg) {
        }

        public void setProgress(String msg, int progress) {
        }
    }
}

