/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.ce;

import dap4.core.ce.CEAST;
import dap4.core.ce.CEConstraint;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Slice;
import java.util.ArrayDeque;
import java.util.Deque;

public class CECompiler {
    protected Deque<DapVariable> scopestack = null;
    protected DapDataset dataset = null;
    protected CEConstraint ce = null;
    protected CEAST root = null;

    public CEConstraint compile(DapDataset template, CEAST root) throws DapException {
        this.dataset = template;
        this.root = root;
        this.ce = new CEConstraint(this.dataset);
        this.scopestack = new ArrayDeque<DapVariable>();
        this.compileAST(root);
        return this.ce;
    }

    protected void compileAST(CEAST ast) throws DapException {
        switch (ast.sort) {
            case CONSTRAINT: {
                for (CEAST clause : ast.clauses) {
                    this.compileAST(clause);
                }
                this.ce.expand();
                this.ce.finish();
                break;
            }
            case PROJECTION: {
                this.scopestack.clear();
                this.compileAST(ast.tree);
                break;
            }
            case SEGMENT: {
                this.compilesegment(ast);
                break;
            }
            case SELECTION: {
                this.scopestack.clear();
                this.compileselection(ast);
                break;
            }
            case DEFINE: {
                this.dimredef(ast);
                break;
            }
            default: {
                assert (false) : "uknown CEAST node type";
                break;
            }
        }
    }

    protected void compileselection(CEAST ast) throws DapException {
        DapVariable var = this.compilesegment(ast.projection);
        if (!var.isSequence()) {
            throw new DapException("Attempt to apply a filter to a non-sequence variable: " + var.getFQN());
        }
        this.compilefilter(var, (DapSequence)var.getBaseType(), ast.filter);
        this.ce.setFilter(var, ast.filter);
    }

    protected DapVariable compilesegment(CEAST ast) throws DapException {
        DapNode node = null;
        if (CECompiler.isFQN(ast.name)) {
            DapDataset root = this.dataset;
            DapNode match = root.findByFQN(ast.name, DapSort.VARIABLE);
            if (match == null) {
                throw new DapException("Undefined variable name: " + ast.name);
            }
            node = match;
        } else {
            DapNode parent = this.getParent();
            if (parent == null) {
                parent = this.dataset;
            }
            if (parent == null) assert (parent != null);
            switch (parent.getSort()) {
                case DATASET: {
                    DapDataset dataset = (DapDataset)parent;
                    node = dataset.findByName(ast.name, DapSort.VARIABLE);
                    break;
                }
                case VARIABLE: {
                    DapVariable v = (DapVariable)parent;
                    DapType t = v.getBaseType();
                    switch (t.getTypeSort()) {
                        case Structure: {
                            DapStructure struct = (DapStructure)t;
                            node = struct.findByName(ast.name);
                            break;
                        }
                        case Sequence: {
                            DapSequence seq = (DapSequence)t;
                            node = seq.findByName(ast.name);
                            break;
                        }
                        default: {
                            assert (false) : "Container cannot be atomic variable";
                            break;
                        }
                    }
                }
                default: {
                    throw new DapException("relative names must be WRT to structure|dataset object: " + parent.getFQN());
                }
            }
        }
        if (node == null) {
            throw new DapException("Constraint expression does not reference a known field: " + ast.name);
        }
        if (!(node instanceof DapVariable)) {
            throw new DapException("Attempt to use non-variable in projection: " + node.getFQN());
        }
        DapVariable var = (DapVariable)node;
        this.ce.addVariable(var, ast.slices);
        this.scopestack.push(var);
        return var;
    }

    public void compilefilter(DapVariable var, DapSequence seq, CEAST expr) throws DapException {
        if (expr == null) {
            return;
        }
        if (expr.sort == CEAST.Sort.SEGMENT) {
            if (expr.subnodes != null) {
                throw new DapException("compilefilter: Non-simple segment:" + expr.name);
            }
            DapVariable field = seq.findByName(expr.name);
            if (field == null) {
                throw new DapException("compilefilter: Unknown filter variable:" + expr.name);
            }
            expr.field = field;
        } else if (expr.sort == CEAST.Sort.EXPR) {
            if (expr.lhs != null) {
                this.compilefilter(var, seq, expr.lhs);
            }
            if (expr.rhs != null) {
                this.compilefilter(var, seq, expr.rhs);
            }
            if (expr.lhs != null && expr.rhs != null) {
                boolean rightvar;
                boolean leftvar = expr.lhs.sort == CEAST.Sort.SEGMENT;
                boolean bl = rightvar = expr.rhs.sort == CEAST.Sort.SEGMENT;
                if (rightvar && !leftvar) {
                    CEAST tmp = expr.lhs;
                    expr.lhs = expr.rhs;
                    expr.rhs = tmp;
                    switch (expr.op) {
                        case LT: {
                            expr.op = CEAST.Operator.GT;
                            break;
                        }
                        case LE: {
                            expr.op = CEAST.Operator.GE;
                            break;
                        }
                        case GT: {
                            expr.op = CEAST.Operator.LT;
                            break;
                        }
                        case GE: {
                            expr.op = CEAST.Operator.LE;
                            break;
                        }
                    }
                }
            }
        } else {
            if (expr.sort == CEAST.Sort.CONSTANT) {
                return;
            }
            throw new DapException("compilefilter: Unexpected node type:" + (Object)((Object)expr.sort));
        }
    }

    protected void dimredef(CEAST node) throws DapException {
        DapDimension dim = (DapDimension)this.dataset.findByFQN(node.name, DapSort.DIMENSION);
        if (dim == null) {
            throw new DapException("Constraint dim redef: no dimension name: " + node.name);
        }
        Slice slice = node.slice;
        slice.finish();
        this.ce.addRedef(dim, slice);
    }

    protected DapVariable getParent() {
        if (this.scopestack.size() > 0) {
            return this.scopestack.peek();
        }
        return null;
    }

    protected static boolean isFQN(String s2) {
        if (s2 == null || s2.length() == 0) {
            return false;
        }
        return s2.charAt(0) == '/';
    }
}

