/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapAttributeSet;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapOtherXML;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Escape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DapNode {
    protected DapSort sort = null;
    protected int index;
    protected String shortname = null;
    protected String escapedname = null;
    protected DapNode parent = null;
    protected DapDataset dataset = null;
    protected String fqn = null;
    protected Map<String, DapAttribute> attributes = new HashMap<String, DapAttribute>();
    protected Map<String, String> xmlattributes = new HashMap<String, String>();
    protected Map<Object, Object> annotations = null;

    public DapNode() {
        if (this instanceof DapVariable) {
            this.sort = DapSort.VARIABLE;
        } else if (this instanceof DapSequence) {
            this.sort = DapSort.SEQUENCE;
        } else if (this instanceof DapStructure) {
            this.sort = DapSort.STRUCTURE;
        } else if (this instanceof DapOtherXML) {
            this.sort = DapSort.OTHERXML;
        } else if (this instanceof DapAttributeSet) {
            this.sort = DapSort.ATTRIBUTESET;
        } else if (this instanceof DapAttribute) {
            this.sort = DapSort.ATTRIBUTE;
        } else if (this instanceof DapDataset) {
            this.sort = DapSort.DATASET;
        } else if (this instanceof DapGroup) {
            this.sort = DapSort.GROUP;
        } else if (this instanceof DapDimension) {
            this.sort = DapSort.DIMENSION;
        } else if (this instanceof DapEnumeration) {
            this.sort = DapSort.ENUMERATION;
        } else if (this instanceof DapType) {
            this.sort = DapSort.ATOMICTYPE;
        } else if (this instanceof DapEnumConst) {
            this.sort = DapSort.ENUMCONST;
        } else if (this instanceof DapEnumeration) {
            this.sort = DapSort.ENUMERATION;
        } else if (this instanceof DapMap) {
            this.sort = DapSort.MAP;
        } else assert (false) : "Internal error";
    }

    public DapNode(String shortname) {
        this();
        this.setShortName(shortname);
    }

    public DapNode annotate(Object id, Object value) {
        if (this.annotations == null) {
            this.annotations = new HashMap<Object, Object>();
        }
        assert (this.annotations.get(id) == null);
        this.annotations.put(id, value);
        return this;
    }

    public Object annotation(Object id) {
        return this.annotations.get(id);
    }

    public Map<String, DapAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, DapAttribute>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, DapAttribute> alist) {
        this.attributes = alist;
    }

    public synchronized DapAttribute setAttribute(DapAttribute attr) throws DapException {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, DapAttribute>();
        }
        DapAttribute old = this.attributes.get(attr.getShortName());
        this.attributes.put(attr.getShortName(), attr);
        attr.setParent(this);
        return old;
    }

    public synchronized void addAttribute(DapAttribute attr) throws DapException {
        String name = attr.getShortName();
        if (this.attributes == null) {
            this.attributes = new HashMap<String, DapAttribute>();
        }
        if (this.attributes.containsKey(name)) {
            throw new DapException("Attempt to add duplicate attribute: " + attr.getShortName());
        }
        this.setAttribute(attr);
    }

    public synchronized void removeAttribute(DapAttribute attr) throws DapException {
        if (this.attributes == null) {
            return;
        }
        String name = attr.getShortName();
        if (this.attributes.containsKey(name)) {
            this.attributes.remove(name);
        }
    }

    public synchronized DapAttribute findAttribute(String name) {
        return this.attributes.get(name);
    }

    public synchronized Map<String, String> getXMLAttributes() {
        return this.xmlattributes;
    }

    public synchronized void addXMLAttribute(String name, String value) throws DapException {
        if (this.xmlattributes == null) {
            this.xmlattributes = new HashMap<String, String>();
        }
        if (this.xmlattributes.containsKey(name)) {
            throw new DapException("Attempt to add duplicate XML attribute: " + name);
        }
        this.xmlattributes.put(name, value);
    }

    public synchronized void removeXMLAttribute(String name) throws DapException {
        if (this.xmlattributes == null) {
            return;
        }
        if (this.xmlattributes.containsKey(name)) {
            this.xmlattributes.remove(name);
        }
    }

    public DapSort getSort() {
        return this.sort;
    }

    public void setSort(DapSort sort) {
        this.sort = sort;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public DapDataset getDataset() {
        if (this.dataset == null) {
            DapNode curr;
            DapNode next = this;
            do {
                curr = next;
                assert (curr != null);
                next = curr.getGroup();
            } while (curr.getSort() != DapSort.DATASET);
            this.setDataset((DapDataset)curr);
        }
        return this.dataset;
    }

    public void setDataset(DapDataset dataset) {
        this.dataset = dataset;
        if (dataset != null && this != dataset) {
            dataset.addNode(this);
        }
    }

    public DapGroup getGroup() {
        DapNode group;
        if (this.sort == DapSort.DATASET) {
            return null;
        }
        for (group = this.parent; group != null; group = group.getParent()) {
            switch (group.getSort()) {
                case DATASET: 
                case GROUP: {
                    return (DapGroup)group;
                }
            }
        }
        return (DapGroup)group;
    }

    public DapNode getContainer() {
        DapNode parent = this.parent;
        switch (this.getSort()) {
            default: {
                break;
            }
            case ENUMCONST: {
                parent = ((DapEnumConst)this).getParent().getContainer();
                break;
            }
            case ATTRIBUTE: 
            case ATTRIBUTESET: 
            case OTHERXML: {
                parent = ((DapAttribute)this).getParent();
                if (!(parent instanceof DapVariable)) break;
                parent = parent.getContainer();
                break;
            }
            case MAP: {
                parent = ((DapMap)this).getVariable().getContainer();
            }
        }
        return parent;
    }

    public DapNode getParent() {
        return this.parent;
    }

    public void setParent(DapNode parent) {
        assert (this.parent == null);
        assert (this.getSort() == DapSort.ENUMCONST && parent.getSort() == DapSort.ENUMERATION || parent.getSort().isa(DapSort.GROUP) || parent.getSort() == DapSort.VARIABLE || parent.getSort() == DapSort.STRUCTURE || parent.getSort() == DapSort.SEQUENCE || this.getSort() == DapSort.ATTRIBUTE || this.getSort() == DapSort.ATTRIBUTESET);
        this.parent = parent;
    }

    public String getShortName() {
        return this.shortname;
    }

    public void setShortName(String shortname) {
        this.shortname = shortname;
        this.escapedname = null;
        this.fqn = null;
    }

    public String getEscapedShortName() {
        if (this.escapedname == null) {
            this.escapedname = Escape.backslashEscape(this.getShortName(), null);
        }
        return this.escapedname;
    }

    public String getFQN() {
        if (this.fqn == null) {
            this.fqn = this.computefqn();
        }
        assert (this.fqn.length() > 0 || this.getSort() == DapSort.DATASET);
        return this.fqn;
    }

    public List<DapNode> getPath() {
        ArrayList<DapNode> path = new ArrayList<DapNode>();
        DapNode current = this;
        do {
            path.add(0, current);
        } while ((current = current.getParent()) != null);
        return path;
    }

    public List<DapNode> getContainerPath() {
        ArrayList<DapNode> path = new ArrayList<DapNode>();
        DapNode current = this.getContainer();
        while (true) {
            path.add(0, current);
            if (current.getContainer() == null) break;
            current = current.getContainer();
        }
        return path;
    }

    public List<DapGroup> getGroupPath() {
        ArrayList<DapGroup> path = new ArrayList<DapGroup>();
        DapNode current = this;
        while (true) {
            if (current.getSort() == DapSort.GROUP || current.getSort() == DapSort.DATASET) {
                path.add(0, (DapGroup)current);
            }
            if (current.getContainer() == null) break;
            current = current.getContainer();
        }
        return path;
    }

    public String computefqn() {
        List<DapNode> path = this.getPath();
        StringBuilder fqn = new StringBuilder();
        DapNode parent = path.get(0);
        for (int i = 1; i < path.size(); ++i) {
            DapNode current = path.get(i);
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: 
                case ENUMERATION: {
                    fqn.append('/');
                    fqn.append(Escape.backslashEscape(current.getShortName(), "/."));
                    break;
                }
                case ENUMCONST: 
                case STRUCTURE: 
                case SEQUENCE: 
                case VARIABLE: {
                    fqn.append('.');
                    fqn.append(current.getEscapedShortName());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal FQN parent");
                }
            }
            parent = current;
        }
        return fqn.toString();
    }

    public boolean isTopLevel() {
        return this.parent == null || this.parent.getSort() == DapSort.DATASET || this.parent.getSort() == DapSort.GROUP;
    }

    public String toString() {
        String sortname = this.sort == null ? "undefined" : this.sort.name();
        String name = null;
        if (name == null) {
            name = this.getShortName();
        }
        if (name == null) {
            name = "?";
        }
        return sortname + "::" + name;
    }
}

