/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser;

import dap4.core.dmr.DapXML;
import dap4.core.dmr.parser.Dap4EventHandler;
import dap4.core.dmr.parser.ParseException;
import dap4.core.dmr.parser.SaxEvent;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class Dap4Actions
extends Dap4EventHandler {
    static final float DAPVERSION = 4.0f;
    static final float DMRVERSION = 1.0f;
    static final int RULENULL = 0;
    static final int RULEDIMREF = 1;
    static final int RULEMAPREF = 2;
    static final int RULEVAR = 3;
    static final int RULEMETADATA = 4;
    static final String[] RESERVEDTAGS = new String[]{"_edu.ucar"};
    static final BigInteger BIG_INT64_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    static final DapSort[] METADATASCOPES = new DapSort[]{DapSort.DATASET, DapSort.GROUP, DapSort.DIMENSION, DapSort.MAP, DapSort.VARIABLE, DapSort.STRUCTURE, DapSort.SEQUENCE, DapSort.ATTRIBUTESET};

    XMLAttributeMap xml_attribute_map() throws DapException {
        return new XMLAttributeMap();
    }

    XMLAttributeMap xml_attribute_map(XMLAttributeMap map, SaxEvent token) throws DapException {
        assert (map != null && token != null);
        if (map.containsKey(token.name)) {
            throw new DapException("XML attribute: duplicate xml attribute: " + token.name);
        }
        map.put(token.name.toLowerCase(), token);
        return map;
    }

    NamespaceList namespace_list() throws DapException {
        return new NamespaceList();
    }

    NamespaceList namespace_list(NamespaceList list, SaxEvent token) throws DapException {
        assert (list != null);
        if (token != null && !list.contains(token.name)) {
            list.add(token.name);
        }
        return list;
    }

    DapXML createxmltext(String text) throws DapException {
        DapXML node = new DapXML(DapXML.NodeType.TEXT, null);
        node.setText(text);
        return node;
    }

    DapXML createxmlelement(SaxEvent open, XMLAttributeMap map) throws DapException {
        DapXML node = new DapXML(DapXML.NodeType.ELEMENT, open.name);
        for (Map.Entry entry : map.entrySet()) {
            SaxEvent att = (SaxEvent)entry.getValue();
            DapXML a = new DapXML(DapXML.NodeType.ATTRIBUTE, att.name);
            a.addXMLAttribute(a);
        }
        return node;
    }

    abstract void enterdataset(XMLAttributeMap var1) throws ParseException;

    abstract void leavedataset() throws ParseException;

    abstract void entergroup(XMLAttributeMap var1) throws ParseException;

    abstract void leavegroup() throws ParseException;

    abstract void enterenumdef(XMLAttributeMap var1) throws ParseException;

    abstract void leaveenumdef() throws ParseException;

    abstract void enumconst(SaxEvent var1, SaxEvent var2) throws ParseException;

    abstract void enterdimdef(XMLAttributeMap var1) throws ParseException;

    abstract void leavedimdef() throws ParseException;

    abstract void dimref(SaxEvent var1) throws ParseException;

    abstract void enteratomicvariable(SaxEvent var1, XMLAttributeMap var2) throws ParseException;

    abstract void leaveatomicvariable(SaxEvent var1) throws ParseException;

    abstract void enterenumvariable(XMLAttributeMap var1) throws ParseException;

    abstract void leaveenumvariable(SaxEvent var1) throws ParseException;

    abstract void entermap(SaxEvent var1) throws ParseException;

    abstract void leavemap() throws ParseException;

    abstract void enterstructurevariable(XMLAttributeMap var1) throws ParseException;

    abstract void leavestructurevariable(SaxEvent var1) throws ParseException;

    abstract void entersequencevariable(XMLAttributeMap var1) throws ParseException;

    abstract void leavesequencevariable(SaxEvent var1) throws ParseException;

    abstract void enteratomicattribute(XMLAttributeMap var1, NamespaceList var2) throws ParseException;

    abstract void leaveatomicattribute() throws ParseException;

    abstract void entercontainerattribute(XMLAttributeMap var1, NamespaceList var2) throws ParseException;

    abstract void leavecontainerattribute() throws ParseException;

    abstract void value(SaxEvent var1) throws ParseException;

    abstract void value(String var1) throws ParseException;

    abstract void entererror(XMLAttributeMap var1) throws ParseException;

    abstract void leaveerror() throws ParseException;

    abstract void errormessage(String var1) throws ParseException;

    abstract void errorcontext(String var1) throws ParseException;

    abstract void errorotherinfo(String var1) throws ParseException;

    abstract void otherxml(XMLAttributeMap var1, DapXML var2) throws ParseException;

    abstract DapXML.XMLList xml_body(DapXML.XMLList var1, DapXML var2) throws ParseException;

    abstract DapXML element_or_text(SaxEvent var1, XMLAttributeMap var2, DapXML.XMLList var3, SaxEvent var4) throws ParseException;

    abstract DapXML xmltext(SaxEvent var1) throws ParseException;

    abstract String textstring(String var1, SaxEvent var2) throws ParseException;

    static class NamespaceList
    extends ArrayList<String> {
        NamespaceList() {
        }
    }

    static class XMLAttributeMap
    extends HashMap<String, SaxEvent> {
        XMLAttributeMap() {
        }
    }
}

