/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.data.ChecksumMode;
import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.parser.Dap4ParserImpl;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.dap4lib.DMRPrinter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public abstract class AbstractDSP
implements DSP {
    public static boolean TESTING = false;
    protected static final boolean DEBUG = false;
    protected static final boolean PARSEDEBUG = false;
    public static final boolean USEDOM = false;
    protected static final String DAPVERSION = "4.0";
    protected static final String DMRVERSION = "1.0";
    protected static final String DMRNS = "http://xml.opendap.org/ns/DAP/4.0#";
    public static final String UCARTAGVLEN = "_edu.ucar.isvlen";
    public static final String UCARTAGOPAQUE = "_edu.ucar.opaque.size";
    public static final String UCARTAGORIGTYPE = "_edu.ucar.orig.type";
    public static final String UCARTAGUNLIMITED = "_edu.ucar.isunlimited";
    protected DapContext context = null;
    protected DapDataset dmr = null;
    protected String location = null;
    private ByteOrder order = null;
    private ChecksumMode checksummode = ChecksumMode.DAP;
    protected Map<DapVariable, DataCursor> variables = new HashMap<DapVariable, DataCursor>();
    protected DataCursor rootcursor = null;

    @Override
    public abstract AbstractDSP open(String var1) throws DapException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public DataCursor getVariableData(DapVariable var) throws DapException {
        return this.variables.get(var);
    }

    @Override
    public DapContext getContext() {
        return this.context;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public AbstractDSP setLocation(String loc) {
        this.location = loc;
        return this;
    }

    @Override
    public DapDataset getDMR() {
        return this.dmr;
    }

    @Override
    public void setContext(DapContext context) {
        this.context = context;
        Object o = this.context.get("ucar.littleendian");
        if (o != null) {
            this.setOrder((ByteOrder)o);
        }
        if ((o = this.context.get("ucar.checksummode")) != null) {
            this.setChecksumMode(ChecksumMode.modeFor(o.toString()));
        }
    }

    public void setDMR(DapDataset dmr) {
        this.dmr = dmr;
        if (this.getDMR() != null) {
            this.getDMR().setDataset(this.getDMR());
            this.getDMR().setDapVersion(DAPVERSION);
            this.getDMR().setDMRVersion(DMRVERSION);
            this.getDMR().setNS(DMRNS);
        }
    }

    protected void setDataset(DapDataset dataset) throws DapException {
        this.dmr = dataset;
    }

    @Override
    public ByteOrder getOrder() {
        return this.order;
    }

    public AbstractDSP setOrder(ByteOrder order) {
        this.order = order;
        return this;
    }

    @Override
    public ChecksumMode getChecksumMode() {
        return this.checksummode;
    }

    public AbstractDSP setChecksumMode(ChecksumMode mode) {
        if (mode != null) {
            this.checksummode = mode;
        }
        return this;
    }

    public void addVariableData(DapVariable var, DataCursor cursor) {
        this.variables.put(var, cursor);
    }

    protected DapDataset parseDMR(String document) throws DapException {
        Dap4ParserImpl parser = new Dap4ParserImpl(null);
        try {
            if (!parser.parse(document)) {
                throw new DapException("DMR Parse failed");
            }
        }
        catch (SAXException se) {
            throw new DapException(se);
        }
        if (parser.getErrorResponse() != null) {
            throw new DapException("Error Response Document not supported");
        }
        DapDataset result = parser.getDMR();
        this.processAttributes(result);
        return result;
    }

    protected void processAttributes(DapDataset dataset) throws DapException {
        List<DapNode> nodes = dataset.getNodeList();
        block3: for (DapNode node : nodes) {
            switch (node.getSort()) {
                case GROUP: 
                case DATASET: 
                case VARIABLE: {
                    Map<String, DapAttribute> attrs = node.getAttributes();
                    if (attrs.size() <= 0) break;
                    ArrayList<DapAttribute> suppressed = new ArrayList<DapAttribute>();
                    for (DapAttribute dattr : attrs.values()) {
                        if (!this.suppress(dattr.getShortName())) continue;
                        suppressed.add(dattr);
                    }
                    for (DapAttribute dattr : suppressed) {
                        node.removeAttribute(dattr);
                    }
                    continue block3;
                }
            }
        }
        this.getEndianAttribute(dataset);
    }

    protected boolean suppress(String attrname) {
        if (attrname.startsWith("_Coord")) {
            return true;
        }
        return attrname.equals("_Unsigned");
    }

    void getEndianAttribute(DapDataset dataset) {
        DapAttribute a = dataset.findAttribute("_DAP4_Little_Endian");
        if (a == null) {
            this.order = ByteOrder.LITTLE_ENDIAN;
        } else {
            String[] v = a.getValues();
            int len = Array.getLength(v);
            if (len == 0) {
                this.order = ByteOrder.nativeOrder();
            } else {
                String onezero = Array.get(v, 0).toString();
                int islittle = 1;
                try {
                    islittle = Integer.parseInt(onezero);
                }
                catch (NumberFormatException e) {
                    islittle = 1;
                }
                this.order = islittle == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            }
        }
    }

    public static String printDMR(DapDataset dmr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrinter printer = new DMRPrinter(dmr, pw);
        try {
            printer.print();
            pw.close();
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

