/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Index;
import dap4.core.util.Slice;
import java.util.List;

public abstract class AbstractCursor
implements DataCursor {
    protected DataCursor.Scheme scheme;
    protected DSP dsp;
    protected DapNode template;
    protected Index arrayindex = null;
    protected long recordindex = -1L;
    protected AbstractCursor container = null;
    protected long recordcount = -1L;

    public AbstractCursor(DataCursor.Scheme scheme, DSP dsp, DapNode template, AbstractCursor container) {
        this.setScheme(scheme);
        this.setDSP(dsp);
        this.setTemplate(template);
        this.setContainer(container);
    }

    public AbstractCursor(AbstractCursor orig) {
        this(orig.getScheme(), orig.getDSP(), orig.getTemplate(), orig.getContainer());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getScheme().toString());
        if (this.getScheme() == DataCursor.Scheme.STRUCTARRAY || this.getScheme() == DataCursor.Scheme.SEQARRAY) {
            buf.append("[]");
        }
        buf.append(":");
        buf.append(this.getTemplate().toString());
        if (this.arrayindex != null) {
            buf.append("::");
            buf.append(this.arrayindex.toString());
        }
        if (this.recordindex >= 0L) {
            buf.append("*");
            buf.append(this.recordindex);
        }
        return buf.toString();
    }

    @Override
    public abstract Object read(List<Slice> var1) throws DapException;

    @Override
    public abstract Object read(Index var1) throws DapException;

    @Override
    public abstract AbstractCursor readRecord(long var1) throws DapException;

    @Override
    public abstract AbstractCursor readField(int var1) throws DapException;

    @Override
    public int fieldIndex(String name) throws DapException {
        DapStructure ds;
        if (this.getTemplate().getSort().isCompound()) {
            ds = (DapStructure)this.getTemplate();
        } else if (this.getTemplate().getSort().isVar() && ((DapVariable)this.getTemplate()).getBaseType().getSort().isCompound()) {
            ds = (DapStructure)((DapVariable)this.getTemplate()).getBaseType();
        } else {
            throw new DapException("Attempt to get field name on non-compound object");
        }
        int i = ds.indexByName(name);
        if (i < 0) {
            throw new DapException("Unknown field name: " + name);
        }
        return i;
    }

    @Override
    public DataCursor.Scheme getScheme() {
        return this.scheme;
    }

    @Override
    public DSP getDSP() {
        return this.dsp;
    }

    @Override
    public DapNode getTemplate() {
        return this.template;
    }

    @Override
    public Index getIndex() throws DapException {
        if (this.scheme != DataCursor.Scheme.STRUCTURE && this.scheme != DataCursor.Scheme.SEQUENCE) {
            throw new DapException("Not a Sequence|Structure instance");
        }
        return this.arrayindex;
    }

    @Override
    public long getRecordIndex() throws DapException {
        if (this.scheme != DataCursor.Scheme.RECORD) {
            throw new DapException("Not a Record instance");
        }
        return this.recordindex;
    }

    @Override
    public long getRecordCount() throws DapException {
        if (this.scheme != DataCursor.Scheme.SEQUENCE) {
            throw new DapException("Not a SEQUENCE instance");
        }
        return this.recordcount;
    }

    @Override
    public AbstractCursor getContainer() {
        return this.container;
    }

    @Override
    public boolean isScalar() {
        if (this.getTemplate().getSort().isVar()) {
            return ((DapVariable)this.getTemplate()).getRank() == 0;
        }
        return false;
    }

    @Override
    public boolean isField() {
        return this.getTemplate().getContainer() != null;
    }

    public boolean isAtomic() {
        boolean is;
        boolean bl = is = this.scheme == DataCursor.Scheme.ATOMIC;
        assert (!is || this.getTemplate().getSort() == DapSort.ATOMICTYPE || this.getTemplate().getSort() == DapSort.VARIABLE && ((DapVariable)this.getTemplate()).getBaseType().getTypeSort().isAtomic());
        return is;
    }

    public boolean isCompound() {
        boolean is;
        boolean bl = is = this.scheme == DataCursor.Scheme.SEQUENCE || this.scheme == DataCursor.Scheme.STRUCTURE;
        assert (!is || this.getTemplate().getSort() == DapSort.SEQUENCE || this.getTemplate().getSort() == DapSort.STRUCTURE || this.getTemplate().getSort() == DapSort.VARIABLE && ((DapVariable)this.getTemplate()).getBaseType().getTypeSort().isCompoundType());
        return is;
    }

    public boolean isCompoundArray() {
        boolean is;
        boolean bl = is = this.scheme == DataCursor.Scheme.SEQARRAY || this.scheme == DataCursor.Scheme.STRUCTARRAY;
        assert (!is || this.getTemplate().getSort() == DapSort.SEQUENCE || this.getTemplate().getSort() == DapSort.STRUCTURE || this.getTemplate().getSort() == DapSort.VARIABLE && ((DapVariable)this.getTemplate()).getBaseType().getTypeSort().isCompoundType());
        return is;
    }

    public AbstractCursor setIndex(Index index) {
        this.arrayindex = index;
        return this;
    }

    public AbstractCursor setRecordIndex(long index) {
        this.recordindex = index;
        return this;
    }

    public AbstractCursor setRecordCount(long count) {
        this.recordcount = count;
        return this;
    }

    public AbstractCursor setContainer(AbstractCursor container) {
        this.container = container;
        return this;
    }

    public AbstractCursor setScheme(DataCursor.Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public AbstractCursor setDSP(DSP dsp) {
        this.dsp = dsp;
        return this;
    }

    public AbstractCursor setTemplate(DapNode template) {
        this.template = template;
        return this;
    }

    public static DataCursor.Scheme schemeFor(DapVariable field) {
        boolean isscalar;
        DapType ftype = field.getBaseType();
        DataCursor.Scheme scheme = null;
        boolean bl = isscalar = field.getRank() == 0;
        if (ftype.getTypeSort().isAtomic()) {
            scheme = DataCursor.Scheme.ATOMIC;
        } else if (ftype.getTypeSort().isStructType()) {
            scheme = DataCursor.Scheme.STRUCTARRAY;
        } else if (ftype.getTypeSort().isSeqType()) {
            scheme = DataCursor.Scheme.SEQARRAY;
        }
        return scheme;
    }
}

