/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapDecl;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapType;
import dap4.core.dmr.TypeSort;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import java.util.ArrayList;
import java.util.List;

public class DapVariable
extends DapNode
implements DapDecl {
    protected DapType basetype = null;
    protected List<DapDimension> dimensions = new ArrayList<DapDimension>();
    protected List<DapMap> maps = new ArrayList<DapMap>();
    protected int checksum = 0;
    protected int fieldindex = -1;

    public DapVariable() {
    }

    public DapVariable(String name) {
        super(name);
    }

    public DapVariable(String name, DapType basetype) {
        super(name);
        this.setBaseType(basetype);
    }

    public DapType getBaseType() {
        return this.basetype;
    }

    public DapVariable setBaseType(DapType t) {
        this.basetype = t;
        return this;
    }

    public int getRank() {
        return this.dimensions.size();
    }

    public long getCount() {
        return DapUtil.dimProduct(this.getDimensions());
    }

    public List<DapDimension> getDimensions() {
        return this.dimensions;
    }

    public DapDimension getDimension(int i) {
        if (this.dimensions == null || i < 0 || i >= this.dimensions.size()) {
            throw new IllegalArgumentException("Illegal index: " + i);
        }
        return this.dimensions.get(i);
    }

    public void addDimension(DapDimension node) throws DapException {
        this.dimensions.add(node);
    }

    public List<DapMap> getMaps() {
        return this.maps;
    }

    public void addMap(DapMap map) throws DapException {
        if (this.maps.contains(map)) {
            throw new DapException("Duplicate map variables: " + map.getFQN());
        }
        this.maps.add(map);
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int csum) {
        this.checksum = csum;
    }

    public int getFieldIndex() {
        return this.fieldindex;
    }

    public void setFieldIndex(int index) {
        this.fieldindex = index;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        if (this.getBaseType() != null) {
            s2.append(this.getBaseType().toString());
            s2.append("|");
        }
        s2.append(super.toString());
        for (int i = 0; i < this.getRank(); ++i) {
            DapDimension dim = this.dimensions.get(i);
            if (dim == null) {
                s2.append("(null)");
                continue;
            }
            s2.append(String.format("(%d)", dim.getSize()));
        }
        return s2.toString();
    }

    public DapType getTrueBaseType() {
        DapType bt = this.getBaseType();
        if (bt.getTypeSort() == TypeSort.Enum) {
            return ((DapEnumeration)bt).getBaseType();
        }
        return bt;
    }

    public boolean isLeaf() {
        return this.isAtomic();
    }

    public boolean isAtomic() {
        return this.getBaseType() == null ? false : this.getBaseType().getTypeSort().isAtomic();
    }

    public boolean isEnum() {
        return this.getBaseType() == null ? false : this.getBaseType().getTypeSort().isEnumType();
    }

    public boolean isSequence() {
        return this.getBaseType() == null ? false : this.getBaseType().getTypeSort().isSeqType();
    }

    public boolean isStructure() {
        return this.getBaseType() == null ? false : this.getBaseType().getTypeSort().isStructType();
    }

    public boolean isCompound() {
        return this.isStructure() || this.isSequence();
    }
}

