/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDecl;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import java.util.ArrayList;
import java.util.List;

public class DapGroup
extends DapNode
implements DapDecl {
    protected List<DapNode> decls = new ArrayList<DapNode>();
    protected List<DapGroup> groups = new ArrayList<DapGroup>();
    protected List<DapEnumeration> enums = new ArrayList<DapEnumeration>();
    protected List<DapDimension> dimensions = new ArrayList<DapDimension>();
    protected List<DapVariable> variables = new ArrayList<DapVariable>();
    protected List<DapStructure> compounds = new ArrayList<DapStructure>();

    public DapGroup() {
    }

    public DapGroup(String name) {
        super(name);
    }

    public List<DapNode> getDecls() {
        return this.decls;
    }

    public void setDecls(List<? extends DapNode> decls) throws DapException {
        decls.clear();
        this.groups.clear();
        this.enums.clear();
        this.dimensions.clear();
        this.variables.clear();
        this.compounds.clear();
        for (DapNode dapNode : decls) {
            this.addDecl(dapNode);
        }
    }

    public void addDecl(DapNode newdecl) throws DapException {
        DapSort newsort = newdecl.getSort();
        String newname = newdecl.getShortName();
        boolean suppress = false;
        if (newsort != DapSort.DIMENSION || newname != null) {
            for (DapNode decl : this.decls) {
                if (newsort != decl.getSort() || !newname.equals(decl.getShortName())) continue;
                throw new DapException("DapGroup: attempt to add duplicate decl: " + newname);
            }
        } else {
            DapDimension anon = (DapDimension)newdecl;
            assert (newsort == DapSort.DIMENSION && newname == null);
            boolean found = false;
            for (DapDimension dim : this.dimensions) {
                if (dim.isShared() || dim.getSize() != anon.getSize()) continue;
                found = true;
                break;
            }
            if (!found && !this.isTopLevel()) {
                this.getDataset().addDecl(anon);
            }
            boolean bl = suppress = found || !this.isTopLevel();
        }
        if (!suppress) {
            this.decls.add(newdecl);
            newdecl.setParent(this);
        }
        switch (newdecl.getSort()) {
            case ATTRIBUTE: 
            case ATTRIBUTESET: 
            case OTHERXML: {
                super.addAttribute((DapAttribute)newdecl);
                break;
            }
            case DIMENSION: {
                if (suppress) break;
                this.dimensions.add((DapDimension)newdecl);
                break;
            }
            case ENUMERATION: {
                this.enums.add((DapEnumeration)newdecl);
                break;
            }
            case ATOMICTYPE: {
                break;
            }
            case STRUCTURE: 
            case SEQUENCE: {
                this.compounds.add((DapStructure)newdecl);
                break;
            }
            case VARIABLE: {
                this.variables.add((DapVariable)newdecl);
                break;
            }
            case GROUP: 
            case DATASET: {
                if (this == (DapGroup)newdecl) break;
                this.groups.add((DapGroup)newdecl);
                break;
            }
            default: {
                throw new ClassCastException(newdecl.getShortName());
            }
        }
    }

    void updateGroups(List<DapGroup> groups) {
        assert (groups.size() == this.groups.size()) : "Update groups: not same size";
        for (DapGroup g : groups) {
            if (!this.groups.contains(g)) assert (false) : "Update groups: attempt to add new group";
        }
    }

    public List<DapGroup> getGroups() {
        return this.groups;
    }

    public List<DapEnumeration> getEnums() {
        return this.enums;
    }

    public List<DapStructure> getCompounds() {
        return this.compounds;
    }

    public List<DapDimension> getDimensions() {
        return this.dimensions;
    }

    public List<DapVariable> getVariables() {
        return this.variables;
    }

    public DapNode findByName(String name, DapSort ... sortset) {
        return this.findInGroup(name, sortset);
    }

    public DapNode findInGroup(String name, DapSort ... sortset) {
        block9: for (DapSort sort : sortset) {
            switch (sort) {
                case ATTRIBUTE: 
                case ATTRIBUTESET: 
                case OTHERXML: {
                    DapAttribute attr = super.getAttributes().get(name);
                    return attr;
                }
                case DIMENSION: {
                    for (DapDimension dapDimension : this.dimensions) {
                        if (!dapDimension.getShortName().equals(name)) continue;
                        return dapDimension;
                    }
                    continue block9;
                }
                case ENUMERATION: {
                    for (DapEnumeration dapEnumeration : this.enums) {
                        if (!dapEnumeration.getShortName().equals(name)) continue;
                        return dapEnumeration;
                    }
                    continue block9;
                }
                case STRUCTURE: {
                    for (DapStructure dapStructure : this.compounds) {
                        if (dapStructure.getSort() != DapSort.STRUCTURE || !dapStructure.getShortName().equals(name)) continue;
                        return dapStructure;
                    }
                    continue block9;
                }
                case SEQUENCE: {
                    for (DapStructure dapStructure : this.compounds) {
                        if (dapStructure.getSort() != DapSort.SEQUENCE || !dapStructure.getShortName().equals(name)) continue;
                        return dapStructure;
                    }
                    continue block9;
                }
                case VARIABLE: {
                    for (DapVariable dapVariable : this.variables) {
                        if (!dapVariable.getShortName().equals(name)) continue;
                        return dapVariable;
                    }
                    continue block9;
                }
                case GROUP: {
                    for (DapGroup dapGroup : this.groups) {
                        if (!dapGroup.getShortName().equals(name)) continue;
                        return dapGroup;
                    }
                    continue block9;
                }
            }
        }
        return null;
    }

    public DapNode findByFQN(String fqn, DapSort ... sortset) throws DapException {
        if ((fqn = fqn.trim()) == null) {
            return null;
        }
        if (fqn.charAt(0) != '/') {
            String prefix = this.getFQN();
            fqn = prefix + '/' + fqn;
        }
        return this.getDataset().lookup(fqn, sortset);
    }

    public DapVariable findVariable(String name) {
        DapNode var = this.findInGroup(name, DapSort.VARIABLE);
        return (DapVariable)var;
    }
}

