/*
 * Decompiled with CFR 0.152.
 */
package opendap.dts;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.parsers.ParseException;
import opendap.dts.testDataset;
import opendap.dts.testEngine;
import opendap.dts.test_SDArray;
import opendap.servers.CEEvaluator;
import opendap.servers.ClauseFactory;
import opendap.servers.FunctionLibrary;
import opendap.servers.ServerDDS;
import opendap.servlet.AbstractServlet;
import opendap.servlet.AsciiWriter;
import opendap.servlet.DTSLog;
import opendap.servlet.GetDirHandler;
import opendap.servlet.GetHTMLInterfaceHandler;
import opendap.servlet.GetInfoHandler;
import opendap.servlet.GuardedDataset;
import opendap.servlet.ReqState;
import opendap.util.Debug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.net.EscapeStrings;

public class DTSServlet
extends AbstractServlet {
    public static Logger log = LoggerFactory.getLogger(DTSServlet.class);
    static final String DEFAULTCONTEXTPATH = "/dts";
    private static FunctionLibrary functionLibrary = new FunctionLibrary("opendap.servers.SSF");
    private String ServerVersion = "DODS/3.2";
    protected boolean allowDeflate = true;
    private boolean track = false;
    private Object syncLock = new Object();
    private int HitCounter = 0;
    private ServletConfig servletConfig = null;
    private ServletContext servletContext = null;
    private String rootpath = null;
    private ArrayList prArr = null;

    public String getDefaultContextPath() {
        return DEFAULTCONTEXTPATH;
    }

    public String getRootPath() {
        return this.rootpath;
    }

    public String getServerVersion() {
        return this.ServerVersion;
    }

    protected GuardedDataset getDataset(ReqState rs) throws DAP2Exception, IOException, ParseException {
        return new testDataset(rs);
    }

    private void cacheArrayShapes(ServerDDS sdds) {
        Enumeration e = sdds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            this.cAS(bt);
        }
    }

    private void cAS(BaseType bt) {
        if (bt instanceof DConstructor) {
            Enumeration e = ((DConstructor)bt).getVariables();
            while (e.hasMoreElements()) {
                BaseType tbt = (BaseType)e.nextElement();
                this.cAS(tbt);
            }
        } else if (bt instanceof test_SDArray) {
            ((test_SDArray)bt).cacheShape();
        }
    }

    public void init() throws ServletException {
        super.init();
        DTSServlet.setLog(DTSLog.class);
        log.debug("**************** DTS INIT ***********************");
        String debugOn = this.getInitParameter("DebugOn");
        if (debugOn != null) {
            StringTokenizer toker = new StringTokenizer(debugOn);
            while (toker.hasMoreTokens()) {
                Debug.set((String)toker.nextToken(), (boolean)true);
            }
        }
        this.servletConfig = this.getServletConfig();
        this.servletContext = this.servletConfig.getServletContext();
        this.rootpath = this.servletContext.getRealPath("/");
        log.debug("rootpath=" + this.rootpath);
    }

    public void parseExceptionHandler(ParseException pe, HttpServletResponse response) {
        if (Debug.isSet((String)"showException")) {
            log.error(pe.toString());
            pe.printStackTrace();
            DTSServlet.printThrowable((Throwable)pe);
        }
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            String msg = pe.getMessage().replace('\"', '\'');
            DAP2Exception de2 = new DAP2Exception(5, msg);
            de2.print((OutputStream)eOut);
        }
        catch (IOException ioe) {
            log.error("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void dap2ExceptionHandler(DAP2Exception de, HttpServletResponse response) {
        if (Debug.isSet((String)"showException")) {
            log.error(de.toString());
            de.printStackTrace();
            DTSServlet.printDODSException((DAP2Exception)de);
        }
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            de.print((OutputStream)eOut);
        }
        catch (IOException ioe) {
            log.error("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void IOExceptionHandler(IOException e, ReqState rs) {
        HttpServletResponse response = rs.getResponse();
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            String msg = e.getMessage();
            if (msg != null) {
                msg = msg.replace('\"', '\'');
            }
            DAP2Exception de2 = new DAP2Exception(5, msg);
            de2.print((OutputStream)eOut);
            if (Debug.isSet((String)"showException")) {
                log.error("DODServlet ERROR (IOExceptionHandler): " + e);
                log.error(rs.toString());
                if (this.track) {
                    RequestDebug reqD = (RequestDebug)rs.getUserObject();
                    log.error("  request number: " + reqD.reqno + " thread: " + reqD.threadDesc);
                }
                e.printStackTrace();
                DTSServlet.printThrowable((Throwable)e);
            }
        }
        catch (IOException ioe) {
            log.error("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void anyExceptionHandler(Throwable e, ReqState rs) {
        try {
            log.error("DODServlet ERROR (anyExceptionHandler): " + e);
            e.printStackTrace();
            DTSServlet.printThrowable((Throwable)e);
            String msg = e.getMessage();
            if (msg != null) {
                msg = msg.replace('\"', '\'');
            }
            if (rs != null) {
                HttpServletResponse response = rs.getResponse();
                log.error(rs + "");
                if (this.track) {
                    RequestDebug reqD = (RequestDebug)rs.getUserObject();
                    log.error("  request number: " + reqD.reqno + " thread: " + reqD.threadDesc);
                }
                BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
                response.setHeader("Content-Description", "dods-error");
                response.setHeader("Content-Encoding", "");
                DAP2Exception de2 = new DAP2Exception(-1, msg);
                de2.print((OutputStream)eOut);
            }
        }
        catch (IOException ioe) {
            log.error("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void sendDODSError(ReqState rs, String clientMsg, String serverMsg) throws Exception {
        rs.getResponse().setContentType("text/plain");
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setHeader("Content-Description", "dods-error");
        ServletOutputStream Out = rs.getResponse().getOutputStream();
        DAP2Exception de = new DAP2Exception(0, clientMsg);
        de.print((OutputStream)Out);
        rs.getResponse().setStatus(200);
        log.error(serverMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAS(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.error("doGetDAS for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            rs.getResponse().setContentType("text/plain");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-das");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)rs.getResponse().getOutputStream());
            DAS myDAS = ds.getDAS();
            myDAS.print((OutputStream)Out);
            rs.getResponse().setStatus(200);
            if (Debug.isSet((String)"showResponse")) {
                log.debug("DAS=\n");
                myDAS.print(System.out);
            }
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDS(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("doGetDDS for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            rs.getResponse().setContentType("text/plain");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-dds");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)rs.getResponse().getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.print((OutputStream)Out);
                ((OutputStream)Out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(Out));
                myDDS.printConstrained(pw);
                pw.flush();
            }
            rs.getResponse().setStatus(200);
            if (Debug.isSet((String)"showResponse")) {
                if (rs.getConstraintExpression().equals("")) {
                    log.debug("Unconstrained DDS=\n");
                } else {
                    log.debug("Constrained DDS=\n");
                }
            }
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDX(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("doGetDDX for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            rs.getResponse().setContentType("text/plain");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-ddx");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)rs.getResponse().getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.printXML((OutputStream)Out);
                ((OutputStream)Out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(Out));
                myDDS.printConstrainedXML(pw);
                pw.flush();
            }
            rs.getResponse().setStatus(200);
            if (Debug.isSet((String)"showResponse")) {
                if (rs.getConstraintExpression().equals("")) {
                    log.debug("Unconstrained DDX=\n");
                    myDDS.printXML((OutputStream)System.out);
                } else {
                    log.debug("Constrained DDX=\n");
                    myDDS.printConstrainedXML((OutputStream)System.out);
                }
            }
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetBLOB(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("doGetBLOB For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            BufferedOutputStream bOut;
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            rs.getResponse().setContentType("application/octet-stream");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-blob");
            ServletOutputStream sOut = rs.getResponse().getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                rs.getResponse().setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            this.cacheArrayShapes(myDDS);
            CEEvaluator ce = new CEEvaluator(myDDS, new ClauseFactory(functionLibrary));
            ce.parseConstraint(rs.getConstraintExpression(), rs.getRequestURL().toString());
            DataOutputStream sink = new DataOutputStream(bOut);
            int seqLength = 5;
            String sls = rs.getInitParameter("SequenceLength");
            if (sls != null) {
                seqLength = Integer.valueOf(sls);
            }
            testEngine te = new testEngine(seqLength);
            ce.send(myDDS.getEncodedName(), (OutputStream)sink, (Object)te);
            sink.flush();
            if (rs.getAcceptsCompressed()) {
                ((DeflaterOutputStream)((Object)bOut)).finish();
            }
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException ioe) {
            this.IOExceptionHandler(ioe, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAP2Data(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("doGetDAP2Data For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            BufferedOutputStream bOut;
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            rs.getResponse().setContentType("application/octet-stream");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-data");
            rs.getResponse().setStatus(200);
            ServletOutputStream sOut = rs.getResponse().getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                rs.getResponse().setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            this.cacheArrayShapes(myDDS);
            CEEvaluator ce = new CEEvaluator(myDDS, new ClauseFactory(functionLibrary));
            ce.parseConstraint(rs);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(bOut));
            myDDS.printConstrained(pw);
            pw.flush();
            ((OutputStream)bOut).write("\nData:\r\n".getBytes());
            ((OutputStream)bOut).flush();
            int seqLength = 5;
            String sls = rs.getInitParameter("SequenceLength");
            if (sls != null) {
                seqLength = Integer.valueOf(sls);
            }
            DataOutputStream sink = new DataOutputStream(bOut);
            testEngine te = new testEngine(seqLength);
            ce.send(myDDS.getEncodedName(), (OutputStream)sink, (Object)te);
            sink.flush();
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                ((DeflaterOutputStream)((Object)bOut)).finish();
            }
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException ioe) {
            this.IOExceptionHandler(ioe, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetDIR(ReqState rs) throws Exception {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("Content-Description", "dods-directory");
        try {
            GetDirHandler di = new GetDirHandler();
            di.sendDIR(rs);
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
    }

    public void doGetVER(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("Sending Version Tag.");
        }
        rs.getResponse().setContentType("text/plain");
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setHeader("Content-Description", "dods-version");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)rs.getResponse().getOutputStream()));
        pw.println("Server Version: " + this.getServerVersion());
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    public void doGetHELP(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("Sending Help Page.");
        }
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setHeader("Content-Description", "dods-help");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)rs.getResponse().getOutputStream()));
        this.printHelpPage(pw);
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    public void badURL(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("Sending Bad URL Page.");
        }
        response.setContentType("text/html");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-error");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        this.printBadURLPage(pw);
        this.printHelpPage(pw);
        pw.flush();
        response.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetASC(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("doGetASC For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setContentType("text/plain");
            rs.getResponse().setHeader("Content-Description", "dods-ascii");
            rs.getResponse().setStatus(200);
            boolean debug = false;
            if (debug) {
                log.debug("Sending OPeNDAP ASCII Data For: " + rs + "  CE: '" + rs.getConstraintExpression() + "'");
            }
            ServerDDS dds = ds.getDDS();
            this.cacheArrayShapes(dds);
            CEEvaluator ce = new CEEvaluator(dds, new ClauseFactory(functionLibrary));
            ce.parseConstraint(rs);
            int seqLength = 5;
            String sls = rs.getInitParameter("SequenceLength");
            if (sls != null) {
                seqLength = Integer.valueOf(sls);
            }
            log.debug("Sequence Length: " + seqLength);
            testEngine te = new testEngine(seqLength);
            PrintWriter pw = new PrintWriter((OutputStream)rs.getResponse().getOutputStream());
            dds.printConstrained(pw);
            pw.println("---------------------------------------------");
            AsciiWriter writer = new AsciiWriter();
            writer.toASCII(pw, (DDS)dds, (Object)te);
            pw.flush();
            log.debug("ASCII Response Sent");
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetINFO(ReqState rs) throws Exception {
        if (Debug.isSet((String)"showResponse")) {
            log.debug("doGetINFO For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            PrintStream pw = new PrintStream((OutputStream)rs.getResponse().getOutputStream());
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setContentType("text/html");
            rs.getResponse().setHeader("Content-Description", "dods-description");
            GetInfoHandler di = new GetInfoHandler();
            di.sendINFO(pw, ds, rs);
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetHTML(ReqState rs) throws Exception {
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setContentType("text/html");
            rs.getResponse().setHeader("Content-Description", "dods-form");
            ServerDDS myDDS = ds.getDDS();
            DAS das = ds.getDAS();
            GetHTMLInterfaceHandler di = new GetHTMLInterfaceHandler();
            di.sendDataRequestForm(rs, rs.getDataSet(), myDDS, das);
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetCatalog(ReqState rs) throws Exception {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/xml");
        rs.getResponse().setHeader("Content-Description", "dods-catalog");
        PrintWriter pw = new PrintWriter((OutputStream)rs.getResponse().getOutputStream());
        this.printCatalog(rs, pw);
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    protected void printCatalog(ReqState rs, PrintWriter os) throws IOException {
        os.println("Catalog not available for this server");
        os.println("Server version = " + this.getServerVersion());
    }

    public void doDebug(ReqState rs) {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("Content-Description", "dods_debug");
        PrintStream pw = null;
        try {
            pw = new PrintStream((OutputStream)rs.getResponse().getOutputStream());
        }
        catch (IOException e) {
            return;
        }
        pw.println("<title>Debugging</title>");
        pw.println("<body><pre>");
        StringTokenizer tz = new StringTokenizer(rs.getConstraintExpression(), "=;");
        while (tz.hasMoreTokens()) {
            String cmd = tz.nextToken();
            pw.println("Cmd= " + cmd);
            if (cmd.equals("help")) {
                pw.println(" help;log;logEnd;logShow");
                pw.println(" showFlags;showInitParameters;showRequest");
                pw.println(" on|off=(flagName)");
                this.doDebugCmd(cmd, tz, pw);
                continue;
            }
            if (cmd.equals("on")) {
                Debug.set((String)tz.nextToken(), (boolean)true);
                continue;
            }
            if (cmd.equals("off")) {
                Debug.set((String)tz.nextToken(), (boolean)false);
                continue;
            }
            if (cmd.equals("showFlags")) {
                for (String key : Debug.keySet()) {
                    pw.println("  " + key + " " + Debug.isSet((String)key));
                }
                continue;
            }
            if (cmd.equals("showInitParameters")) {
                pw.println(rs.toString());
                continue;
            }
            if (cmd.equals("showRequest")) {
                this.probeRequest(pw, rs);
                continue;
            }
            if (this.doDebugCmd(cmd, tz, pw)) continue;
            pw.println("  unrecognized command");
        }
        pw.println("--------------------------------------");
        pw.println("Logging is on");
        for (String key : Debug.keySet()) {
            boolean val = Debug.isSet((String)key);
            if (!val) continue;
            pw.println("  " + key + " " + Debug.isSet((String)key));
        }
        pw.println("</pre></body>");
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    protected boolean doDebugCmd(String cmd, StringTokenizer tz, PrintStream pw) {
        return false;
    }

    public void doGetSystemProps(ReqState rs) throws Exception {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("Content-Description", "dods-status");
        PrintWriter pw = new PrintWriter((OutputStream)rs.getResponse().getOutputStream());
        pw.println("<html>");
        pw.println("<title>System Properties</title>");
        pw.println("<hr>");
        pw.println("<body><h2>System Properties</h2>");
        pw.println("<h3>Date: " + new Date() + "</h3>");
        Properties sysp = System.getProperties();
        Enumeration<?> e = sysp.propertyNames();
        pw.println("<ul>");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = System.getProperty(name);
            pw.println("<li>" + name + ": " + value + "</li>");
        }
        pw.println("</ul>");
        pw.println("<h3>Runtime Info:</h3>");
        Runtime rt = Runtime.getRuntime();
        pw.println("JVM Max Memory:   " + (double)(rt.maxMemory() / 1024L) / 1000.0 + " MB (JVM Maximum Allowable Heap)<br>");
        pw.println("JVM Total Memory: " + (double)(rt.totalMemory() / 1024L) / 1000.0 + " MB (JVM Heap size)<br>");
        pw.println("JVM Free Memory:  " + (double)(rt.freeMemory() / 1024L) / 1000.0 + " MB (Unused part of heap)<br>");
        pw.println("JVM Used Memory:  " + (double)((rt.totalMemory() - rt.freeMemory()) / 1024L) / 1000.0 + " MB (Currently active memory)<br>");
        pw.println("<hr>");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    public void doGetStatus(ReqState rs) throws Exception {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("Content-Description", "dods-status");
        PrintWriter pw = new PrintWriter((OutputStream)rs.getResponse().getOutputStream());
        pw.println("<title>Server Status</title>");
        pw.println("<body><ul>");
        this.printStatus(pw);
        pw.println("</ul></body>");
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    protected void printStatus(PrintWriter os) {
        os.println("<h2>Server version = " + this.getServerVersion() + "</h2>");
        os.println("<h2>Number of Requests Received = " + this.HitCounter + "</h2>");
        if (this.track) {
            int n = this.prArr.size();
            int pending = 0;
            String preqs = "";
            for (int i = 0; i < n; ++i) {
                ReqState rs = (ReqState)this.prArr.get(i);
                RequestDebug reqD = (RequestDebug)rs.getUserObject();
                if (rs == null || reqD.done) continue;
                preqs = preqs + "<pre>-----------------------\n";
                preqs = preqs + "Request[" + reqD.reqno + "](" + reqD.threadDesc + ") is pending.\n";
                preqs = preqs + rs.toString();
                preqs = preqs + "</pre>";
                ++pending;
            }
            os.println("<h2>" + pending + " Pending Request(s)</h2>");
            os.println(preqs);
        }
    }

    public void probeRequest(PrintStream ps, ReqState rs) {
        String s;
        HttpServletRequest request = rs.getRequest();
        ps.println("####################### PROBE ##################################");
        ps.println("The HttpServletRequest object is actually a: " + request.getClass().getName());
        ps.println("");
        ps.println("HttpServletRequest Interface:");
        ps.println("    getAuthType:           " + request.getAuthType());
        ps.println("    getMethod:             " + request.getMethod());
        ps.println("    getPathInfo:           " + request.getPathInfo());
        ps.println("    getPathTranslated:     " + request.getPathTranslated());
        ps.println("    getRequestURL:         " + request.getRequestURL());
        ps.println("    getQueryString:        " + request.getQueryString());
        ps.println("    getRemoteUser:         " + request.getRemoteUser());
        ps.println("    getRequestedSessionId: " + request.getRequestedSessionId());
        ps.println("    getRequestURI:         " + request.getRequestURI());
        ps.println("    getServletPath:        " + request.getServletPath());
        ps.println("    isRequestedSessionIdFromCookie: " + request.isRequestedSessionIdFromCookie());
        ps.println("    isRequestedSessionIdValid:      " + request.isRequestedSessionIdValid());
        ps.println("    isRequestedSessionIdFromURL:    " + request.isRequestedSessionIdFromURL());
        ps.println("");
        int i = 0;
        Enumeration e = request.getHeaderNames();
        ps.println("    Header Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Header[" + ++i + "]: " + s);
            ps.println(": " + request.getHeader(s));
        }
        ps.println("");
        ps.println("ServletRequest Interface:");
        ps.println("    getCharacterEncoding:  " + request.getCharacterEncoding());
        ps.println("    getContentType:        " + request.getContentType());
        ps.println("    getContentLength:      " + request.getContentLength());
        ps.println("    getProtocol:           " + request.getProtocol());
        ps.println("    getScheme:             " + request.getScheme());
        ps.println("    getServerName:         " + request.getServerName());
        ps.println("    getServerPort:         " + request.getServerPort());
        ps.println("    getRemoteAddr:         " + request.getRemoteAddr());
        ps.println("    getRemoteHost:         " + request.getRemoteHost());
        ps.println(".............................");
        ps.println("");
        i = 0;
        e = request.getAttributeNames();
        ps.println("    Attribute Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Attribute[" + ++i + "]: " + s);
            ps.println(" Type: " + request.getAttribute(s));
        }
        ps.println(".............................");
        ps.println("");
        i = 0;
        e = request.getParameterNames();
        ps.println("    Parameter Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Parameter[" + ++i + "]: " + s);
            ps.println(" Value: " + request.getParameter(s));
        }
        ps.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        ps.println(" . . . . . . . . . Servlet Infomation API  . . . . . . . . . . . . . .");
        ps.println("");
        ps.println("Servlet Context:");
        ps.println("");
        i = 0;
        e = this.servletContext.getAttributeNames();
        ps.println("    Attribute Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Attribute[" + ++i + "]: " + s);
            ps.println(" Type: " + this.servletContext.getAttribute(s));
        }
        ps.println("    ServletContext.getRealPath(\".\"): " + this.servletContext.getRealPath("."));
        ps.println("    ServletContext.getMajorVersion(): " + this.servletContext.getMajorVersion());
        ps.println("    ServletContext.getMinorVersion(): " + this.servletContext.getMinorVersion());
        ps.println(".............................");
        ps.println("Servlet Config:");
        ps.println("");
        ServletConfig scnfg = this.getServletConfig();
        i = 0;
        e = scnfg.getInitParameterNames();
        ps.println("    InitParameters:");
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            ps.print("        InitParameter[" + i + "]: " + p);
            ps.println(" Value: " + scnfg.getInitParameter(p));
            ++i;
        }
        ps.println("");
        ps.println("######################## END PROBE ###############################");
        ps.println("");
    }

    public String getServerName() {
        String servletName = ((Object)((Object)this)).getClass().getName();
        return servletName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        log.debug("DTS doGet()");
        long tid = Thread.currentThread().getId();
        log.debug("thread=" + tid);
        boolean isDebug = false;
        ReqState rs = null;
        RequestDebug reqD = null;
        try {
            Object ds;
            if (Debug.isSet((String)"probeRequest")) {
                this.probeRequest(System.out, rs);
            }
            rs = this.getRequestState(request, response);
            assert (rs != null);
            if (rs != null) {
                ds = rs.getDataSet();
                String suff = rs.getRequestSuffix();
                isDebug = ds != null && ((String)ds).equals("debug") && suff != null && suff.equals("");
            }
            ds = this.syncLock;
            synchronized (ds) {
                if (!isDebug) {
                    long reqno = this.HitCounter++;
                    if (this.track) {
                        reqD = new RequestDebug(reqno, Thread.currentThread().toString());
                        rs.setUserObject((Object)reqD);
                        if (this.prArr == null) {
                            this.prArr = new ArrayList(10000);
                        }
                        this.prArr.add((int)reqno, rs);
                    }
                    if (Debug.isSet((String)"showRequest")) {
                        log.debug("-------------------------------------------");
                        log.debug("Server: " + this.getServerName() + "   Request #" + reqno);
                        log.debug("Client: " + request.getRemoteHost());
                        log.debug(rs.toString());
                        log.debug("Request dataset: '" + rs.getDataSet() + "' suffix: '" + rs.getRequestSuffix() + "' CE: '" + rs.getConstraintExpression() + "'");
                    }
                }
            }
            if (rs != null) {
                String dataSet = rs.getDataSet();
                String requestSuffix = rs.getRequestSuffix();
                if (dataSet == null || dataSet.equals("/") || dataSet.equals("")) {
                    this.doGetDIR(rs);
                } else if (dataSet.equalsIgnoreCase("/version") || dataSet.equalsIgnoreCase("/version/")) {
                    this.doGetVER(rs);
                } else if (dataSet.equalsIgnoreCase("/help") || dataSet.equalsIgnoreCase("/help/")) {
                    this.doGetHELP(rs);
                } else if (dataSet.equalsIgnoreCase("/" + requestSuffix)) {
                    this.doGetHELP(rs);
                } else if (requestSuffix.equalsIgnoreCase("dds")) {
                    this.doGetDDS(rs);
                } else if (requestSuffix.equalsIgnoreCase("das")) {
                    this.doGetDAS(rs);
                } else if (requestSuffix.equalsIgnoreCase("ddx")) {
                    this.doGetDDX(rs);
                } else if (requestSuffix.equalsIgnoreCase("blob")) {
                    this.doGetBLOB(rs);
                } else if (requestSuffix.equalsIgnoreCase("dods")) {
                    this.doGetDAP2Data(rs);
                } else if (requestSuffix.equalsIgnoreCase("asc") || requestSuffix.equalsIgnoreCase("ascii")) {
                    this.doGetASC(rs);
                } else if (requestSuffix.equalsIgnoreCase("info")) {
                    this.doGetINFO(rs);
                } else if (requestSuffix.equalsIgnoreCase("html") || requestSuffix.equalsIgnoreCase("htm")) {
                    this.doGetHTML(rs);
                } else if (requestSuffix.equalsIgnoreCase("ver") || requestSuffix.equalsIgnoreCase("version")) {
                    this.doGetVER(rs);
                } else if (requestSuffix.equalsIgnoreCase("help")) {
                    this.doGetHELP(rs);
                } else if (requestSuffix.equals("") || requestSuffix == null) {
                    this.badURL(request, response);
                } else {
                    this.badURL(request, response);
                }
            } else {
                this.badURL(request, response);
            }
            if (reqD != null) {
                reqD.done = true;
            }
        }
        catch (Throwable e) {
            this.anyExceptionHandler(e, rs);
        }
    }

    protected ReqState getRequestState(HttpServletRequest request, HttpServletResponse response) {
        ReqState rs = null;
        String baseurl = request.getRequestURL().toString();
        baseurl = EscapeStrings.unescapeURL((String)baseurl);
        String query = request.getQueryString();
        query = EscapeStrings.unescapeURLQuery((String)query);
        rs = new ReqState(request, response, (AbstractServlet)this, this.getServerName(), baseurl, query);
        return rs;
    }

    void showMemUsed(String from) {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        log.debug("****showMemUsed " + from);
        log.debug(" totalMemory " + totalMemory);
        log.debug(" freeMemory " + freeMemory);
        log.debug(" usedMemory " + usedMemory);
    }

    private void printHelpPage(PrintWriter pw) {
        pw.println("<h3>OPeNDAP Server Help</h3>");
        pw.println("To access most of the features of this OPeNDAP server, append");
        pw.println("one of the following a eight suffixes to a URL: .das, .dds, .dods, .ddx, .blob, .info,");
        pw.println(".ver or .help. Using these suffixes, you can ask this server for:");
        pw.println("<dl>");
        pw.println("<dt> das  </dt> <dd> Dataset Attribute Structure (DAS)</dd>");
        pw.println("<dt> dds  </dt> <dd> Dataset Descriptor Structure (DDS)</dd>");
        pw.println("<dt> dods </dt> <dd> DataDDS object (A constrained DDS populated with data)</dd>");
        pw.println("<dt> ddx  </dt> <dd> XML version of the DDS/DAS</dd>");
        pw.println("<dt> blob </dt> <dd> Serialized binary data content for requested data set, with the constraint expression applied.</dd>");
        pw.println("<dt> info </dt> <dd> info object (attributes, types and other information)</dd>");
        pw.println("<dt> html </dt> <dd> html form for this dataset</dd>");
        pw.println("<dt> ver  </dt> <dd> return the version number of the server</dd>");
        pw.println("<dt> help </dt> <dd> help information (this text)</dd>");
        pw.println("</dl>");
        pw.println("For example, to request the DAS object from the FNOC1 dataset at URI/GSO (a");
        pw.println("test dataset) you would appand `.das' to the URL:");
        pw.println("http://opendap.gso.uri.edu/cgi-bin/nph-nc/data/fnoc1.nc.das.");
        pw.println("<p><b>Note</b>: Many OPeNDAP clients supply these extensions for you so you don't");
        pw.println("need to append them (for example when using interfaces supplied by us or");
        pw.println("software re-linked with a OPeNDAP client-library). Generally, you only need to");
        pw.println("add these if you are typing a URL directly into a WWW browser.");
        pw.println("<p><b>Note</b>: If you would like version information for this server but");
        pw.println("don't know a specific data file or data set name, use `/version' for the");
        pw.println("filename. For example: http://opendap.gso.uri.edu/cgi-bin/nph-nc/version will");
        pw.println("return the version number for the netCDF server used in the first example. ");
        pw.println("<p><b>Suggestion</b>: If you're typing this URL into a WWW browser and");
        pw.println("would like information about the dataset, use the `.info' extension.");
        pw.println("<p>If you'd like to see a data values, use the `.html' extension and submit a");
        pw.println("query using the customized form.");
    }

    private void printBadURLPage(PrintWriter pw) {
        pw.println("<h3>Error in URL</h3>");
        pw.println("The URL extension did not match any that are known by this");
        pw.println("server. Below is a list of the five extensions that are be recognized by");
        pw.println("all OPeNDAP servers. If you think that the server is broken (that the URL you");
        pw.println("submitted should have worked), then please contact the");
        pw.println("OPeNDAP user support coordinator at: ");
        pw.println("<a href=\"mailto:support@unidata.ucar.edu\">support@unidata.ucar.edu</a><p>");
    }

    private class RequestDebug {
        long reqno;
        String threadDesc;
        boolean done = false;

        RequestDebug(long reqno, String threadDesc) {
            this.reqno = reqno;
            this.threadDesc = threadDesc;
        }
    }
}

