/*
 * Decompiled with CFR 0.152.
 */
package opendap.dts;

import java.io.EOFException;
import java.io.IOException;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.BooleanPrimitiveVector;
import opendap.dap.BytePrimitiveVector;
import opendap.dap.DAP2Exception;
import opendap.dap.DArrayDimension;
import opendap.dap.DSequence;
import opendap.dap.Float32PrimitiveVector;
import opendap.dap.Float64PrimitiveVector;
import opendap.dap.Int16PrimitiveVector;
import opendap.dap.Int32PrimitiveVector;
import opendap.dap.InvalidDimensionException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.PrimitiveVector;
import opendap.dap.UInt16PrimitiveVector;
import opendap.dap.UInt32PrimitiveVector;
import opendap.dts.DTSServlet;
import opendap.dts.test_SDArray;
import opendap.dts.test_SDGrid;
import opendap.servers.SDArray;
import opendap.servers.ServerMethods;

public class testEngine {
    private static boolean _Debug = false;
    private int sequenceLength;
    private boolean tBool;
    private byte tByte;
    private float tFloat32;
    private double tFloat64;
    private short tUint16;
    private short tInt16;
    private int tUint32;
    private int tInt32_1;
    private int tInt32_2;
    private String tURL;
    private int tStringCount;

    public testEngine(int sLength) {
        this.sequenceLength = sLength;
        this.tBool = false;
        this.tByte = 0;
        this.tFloat32 = 0.0f;
        this.tFloat64 = 0.0;
        this.tUint16 = 0;
        this.tInt16 = 0;
        this.tUint32 = 0;
        this.tInt32_1 = 0;
        this.tInt32_2 = 1;
        this.tURL = "http://www.dods.org";
        this.tStringCount = 0;
    }

    public int getMaxSequenceLength() {
        return this.sequenceLength;
    }

    public boolean nextBool() {
        this.tBool = !this.tBool;
        return this.tBool;
    }

    public byte nextByte() {
        byte by = this.tByte;
        this.tByte = (byte)(by + 1);
        return by;
    }

    public float nextFloat32() {
        float b = (float)(100.0 * Math.sin(this.tFloat32));
        this.tFloat32 = (float)((double)this.tFloat32 + 0.01);
        return b;
    }

    public double nextFloat64() {
        double b = 1000.0 * Math.cos(this.tFloat64);
        this.tFloat64 += 0.01;
        return b;
    }

    public short nextUint16() {
        short b = (short)(-16 * this.tUint16);
        this.tUint16 = (short)(this.tUint16 + 1);
        return b;
    }

    public short nextInt16() {
        short b = (short)(16 * this.tInt16);
        this.tInt16 = (short)(this.tInt16 + 1);
        return b;
    }

    public int nextUint32() {
        int b = this.tUint32++ * this.tUint32;
        return b;
    }

    public int nextInt32() {
        int b = this.tInt32_1 + this.tInt32_2;
        this.tInt32_1 = this.tInt32_2;
        this.tInt32_2 = b;
        return b;
    }

    public String nextURL() {
        return this.tURL;
    }

    public String nextString() {
        String b = "This is a data test string (pass " + this.tStringCount + ").";
        ++this.tStringCount;
        return b;
    }

    public void newLoadTestArray(String datasetName, test_SDArray ta) throws IOException {
        if (_Debug) {
            DTSServlet.log.debug("testEngine.newLoadTestArray(" + datasetName + "): ");
        }
        try {
            if (_Debug) {
                DTSServlet.log.debug("Loading: " + ta.getEncodedName() + " an SDArray of " + ta.numDimensions() + " dimension(s).");
            }
            PrimitiveVector pv = ta.getPrimitiveVector();
            if (_Debug) {
                Class<?> cl = pv.getClass();
                DTSServlet.log.debug("PrimitiveVector is a: " + cl.getName());
            }
            pv.setLength(this.getLength(ta, 0, true));
            if (_Debug) {
                DTSServlet.log.debug("Length: " + pv.getLength());
            }
            this.newLoadArray(datasetName, ta);
        }
        catch (DAP2Exception dAP2Exception) {
            // empty catch block
        }
        if (_Debug) {
            DTSServlet.log.debug("---------------------------------------------------");
        }
    }

    private int getLength(test_SDArray ta, int dim, boolean constrained) throws InvalidDimensionException {
        int sizeofThisDim;
        int sizeofOtherDims = 1;
        if (dim + 1 < ta.numDimensions()) {
            sizeofOtherDims = this.getLength(ta, dim + 1, constrained);
        }
        DArrayDimension dad = ta.getDimension(dim);
        if (constrained) {
            if (_Debug) {
                DTSServlet.log.debug("Scanning Dimension " + dim + "  start: " + dad.getStart() + "  stop: " + dad.getStop() + "  stride: " + dad.getStride());
            }
            sizeofThisDim = 1 + (dad.getStop() - dad.getStart()) / dad.getStride();
        } else {
            sizeofThisDim = dad.getSize();
        }
        int eCount = sizeofThisDim * sizeofOtherDims;
        if (_Debug) {
            DTSServlet.log.debug("  length: " + sizeofThisDim);
        }
        return eCount;
    }

    private int nuAI(int constrainedIndex, test_SDArray ta) throws InvalidDimensionException {
        DArrayDimension dad;
        int[] cIndices = new int[ta.numDimensions()];
        int[] uIndices = new int[ta.numDimensions()];
        int[] cDimSteps = new int[ta.numDimensions()];
        int[] uDimSteps = new int[ta.numDimensions()];
        if (_Debug) {
            DTSServlet.log.debug("ConstrainedIndex: " + constrainedIndex);
        }
        int dim = ta.numDimensions() - 1;
        cDimSteps[dim] = 1;
        uDimSteps[dim] = 1;
        for (dim = ta.numDimensions() - 2; dim >= 0; --dim) {
            dad = ta.getDimension(dim + 1);
            cDimSteps[dim] = cDimSteps[dim + 1] * dad.getSize();
            uDimSteps[dim] = uDimSteps[dim + 1] * ta.getCachedShape(dim + 1);
        }
        if (_Debug) {
            DTSServlet.log.debug("DimSteps: ");
            for (dim = 0; dim < ta.numDimensions(); ++dim) {
                DTSServlet.log.debug("    cDimSteps[" + dim + "]: " + cDimSteps[dim]);
            }
            DTSServlet.log.debug("");
            for (dim = 0; dim < ta.numDimensions(); ++dim) {
                DTSServlet.log.debug("    uDimSteps[" + dim + "]: " + uDimSteps[dim]);
            }
        }
        if (_Debug) {
            DTSServlet.log.debug("cIndices: ");
        }
        int k = 0;
        for (dim = 0; dim < ta.numDimensions() - 1; ++dim) {
            cIndices[dim] = (constrainedIndex - k) / cDimSteps[dim];
            if (_Debug) {
                DTSServlet.log.debug("cIndices[" + dim + "]: " + cIndices[dim] + "  k: " + k);
            }
            k += cIndices[dim] * cDimSteps[dim];
        }
        cIndices[dim] = constrainedIndex - k;
        if (_Debug) {
            DTSServlet.log.debug("cIndices[" + dim + "]: " + cIndices[dim] + "  k: " + k);
        }
        if (_Debug) {
            DTSServlet.log.debug("uIndices: (");
        }
        for (dim = 0; dim < ta.numDimensions(); ++dim) {
            dad = ta.getDimension(dim);
            uIndices[dim] = dad.getStart() + cIndices[dim] * dad.getStride();
            if (!_Debug) continue;
            DTSServlet.log.debug(uIndices[dim] + ", ");
        }
        if (_Debug) {
            DTSServlet.log.debug(")");
        }
        int uI = 0;
        for (dim = 0; dim < ta.numDimensions(); ++dim) {
            uI += uIndices[dim] * uDimSteps[dim];
        }
        return uI;
    }

    private void newLoadArray(String dataset, test_SDArray ta) throws InvalidDimensionException, NoSuchVariableException, EOFException, IOException {
        PrimitiveVector pv = ta.getPrimitiveVector();
        if (_Debug) {
            DTSServlet.log.debug("Loading Array... ");
        }
        for (int j = 0; j < pv.getLength(); ++j) {
            if (_Debug) {
                DTSServlet.log.debug("..\n");
            }
            int i = this.nuAI(j, ta);
            if (_Debug) {
                DTSServlet.log.debug("ConstrainedIndex: " + j + "   UnconstrainedIndex: " + i);
            }
            if (pv instanceof BaseTypePrimitiveVector) {
                boolean MoreToRead;
                BaseType bt = ((BaseTypePrimitiveVector)pv).getTemplate();
                BaseType newBT = (BaseType)bt.clone();
                newBT.setEncodedName(newBT.getEncodedName() + "[" + j + "]");
                ((BaseTypePrimitiveVector)pv).setValue(j, newBT);
                ServerMethods sm = (ServerMethods)((BaseTypePrimitiveVector)pv).getValue(j);
                boolean bl = MoreToRead = !(bt instanceof DSequence);
                while (MoreToRead) {
                    MoreToRead = sm.read(dataset, (Object)this);
                }
            }
            if (pv instanceof BooleanPrimitiveVector) {
                if (i % 2 != 0) {
                    ((BooleanPrimitiveVector)pv).setValue(j, true);
                } else {
                    ((BooleanPrimitiveVector)pv).setValue(j, false);
                }
            }
            if (pv instanceof BytePrimitiveVector) {
                ((BytePrimitiveVector)pv).setValue(j, (byte)i);
            }
            if (pv instanceof Float32PrimitiveVector) {
                ((Float32PrimitiveVector)pv).setValue(j, (float)Math.sin((double)i / 100.0));
            }
            if (pv instanceof Float64PrimitiveVector) {
                ((Float64PrimitiveVector)pv).setValue(j, Math.cos((double)i / 100.0));
            }
            if (pv instanceof Int16PrimitiveVector) {
                ((Int16PrimitiveVector)pv).setValue(j, (short)(i * 256));
            }
            if (pv instanceof UInt16PrimitiveVector) {
                ((UInt16PrimitiveVector)pv).setValue(j, (short)(i * 1024));
            }
            if (pv instanceof Int32PrimitiveVector) {
                ((Int32PrimitiveVector)pv).setValue(j, i * 2048);
            }
            if (!(pv instanceof UInt32PrimitiveVector)) continue;
            ((UInt32PrimitiveVector)pv).setValue(j, i * 4096);
        }
    }

    public void loadTestGrid(String datasetName, test_SDGrid tg) throws NoSuchVariableException, IOException, EOFException {
        SDArray da = (SDArray)tg.getVar(0);
        if (da.isProject()) {
            da.read(datasetName, (Object)this);
        }
        for (int i = 0; i < da.numDimensions(); ++i) {
            try {
                DArrayDimension dad = da.getDimension(i);
            }
            catch (InvalidDimensionException e) {
                throw new NoSuchVariableException(e.getMessage());
            }
            SDArray sam = (SDArray)tg.getVar(i + 1);
            if (!sam.isProject()) continue;
            sam.read(datasetName, (Object)this);
        }
    }
}

