/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.gcdm.GcdmConverter;
import ucar.gcdm.GcdmGridProto;
import ucar.gcdm.client.GcdmGrid;
import ucar.gcdm.client.GcdmGridDataset;
import ucar.nc2.AttributeContainer;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridAxis1DTime;
import ucar.nc2.grid.GridAxis2D;
import ucar.nc2.grid.GridAxisOffsetTimeRegular;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridHorizCoordinateSystem;
import ucar.nc2.grid.GridReferencedArray;
import ucar.nc2.internal.dataset.transform.horiz.ProjectionFactory;
import ucar.nc2.internal.grid.GridCS;
import ucar.unidata.geoloc.Projection;

public class GcdmGridConverter {
    public static FeatureType convertFeatureType(GcdmGridProto.CdmFeatureType proto) {
        switch (proto) {
            case CDM_FEATURE_TYPE_GRIDDED: {
                return FeatureType.GRID;
            }
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static AxisType convertAxisType(GcdmGridProto.CdmAxisType proto) {
        AxisType axisType = null;
        if (proto != null) {
            switch (proto) {
                case CDM_AXIS_TYPE_RUN_TIME: {
                    axisType = AxisType.RunTime;
                    break;
                }
                case CDM_AXIS_TYPE_ENSEMBLE: {
                    axisType = AxisType.Ensemble;
                    break;
                }
                case CDM_AXIS_TYPE_TIME: {
                    axisType = AxisType.Time;
                    break;
                }
                case CDM_AXIS_TYPE_GEO_X: {
                    axisType = AxisType.GeoX;
                    break;
                }
                case CDM_AXIS_TYPE_GEO_Y: {
                    axisType = AxisType.GeoY;
                    break;
                }
                case CDM_AXIS_TYPE_GEO_Z: {
                    axisType = AxisType.GeoZ;
                    break;
                }
                case CDM_AXIS_TYPE_LAT: {
                    axisType = AxisType.Lat;
                    break;
                }
                case CDM_AXIS_TYPE_LON: {
                    axisType = AxisType.Lon;
                    break;
                }
                case CDM_AXIS_TYPE_HEIGHT: {
                    axisType = AxisType.Height;
                    break;
                }
                case CDM_AXIS_TYPE_PRESSURE: {
                    axisType = AxisType.Pressure;
                    break;
                }
                case CDM_AXIS_TYPE_TIME_OFFSET: {
                    axisType = AxisType.TimeOffset;
                    break;
                }
                case CDM_AXIS_TYPE_UNSPECIFIED: {
                    throw new UnsupportedOperationException("CDM Axis Type is UNSPECIFIED. Cannot convert to AxisType.");
                }
                default: {
                    throw new UnsupportedOperationException("CdmAxisType not understood.");
                }
            }
        }
        return axisType;
    }

    public static GcdmGridProto.CdmAxisType convertAxisType(AxisType axis) {
        GcdmGridProto.CdmAxisType cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_UNSPECIFIED;
        if (axis != null) {
            switch (axis) {
                case RunTime: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_RUN_TIME;
                    break;
                }
                case Ensemble: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_ENSEMBLE;
                    break;
                }
                case Time: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_TIME;
                    break;
                }
                case GeoX: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_GEO_X;
                    break;
                }
                case GeoY: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_GEO_Y;
                    break;
                }
                case GeoZ: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_GEO_Z;
                    break;
                }
                case Lat: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_LAT;
                    break;
                }
                case Lon: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_LON;
                    break;
                }
                case Height: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_HEIGHT;
                    break;
                }
                case Pressure: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_PRESSURE;
                    break;
                }
                case TimeOffset: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_TIME_OFFSET;
                    break;
                }
                case RadialAzimuth: 
                case RadialDistance: 
                case RadialElevation: 
                case Spectral: 
                case Dimension: 
                case SimpleGeometryX: 
                case SimpleGeometryY: 
                case SimpleGeometryZ: 
                case SimpleGeometryID: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_UNSPECIFIED;
                    break;
                }
                default: {
                    cdmAxisType = GcdmGridProto.CdmAxisType.CDM_AXIS_TYPE_UNSPECIFIED;
                }
            }
        }
        return cdmAxisType;
    }

    @Nullable
    public static GridAxis.Spacing convertAxisSpacing(GcdmGridProto.GridAxisSpacing proto) {
        GridAxis.Spacing gridAxisSpacing = null;
        if (proto != null) {
            switch (proto) {
                case GRID_AXIS_SPACING_REGULAR_POINT: {
                    gridAxisSpacing = GridAxis.Spacing.regularPoint;
                    break;
                }
                case GRID_AXIS_SPACING_IRREGULAR_POINT: {
                    gridAxisSpacing = GridAxis.Spacing.irregularPoint;
                    break;
                }
                case GRID_AXIS_SPACING_REGULAR_INTERVAL: {
                    gridAxisSpacing = GridAxis.Spacing.regularInterval;
                    break;
                }
                case GRID_AXIS_SPACING_CONTIGUOUS_INTERVAL: {
                    gridAxisSpacing = GridAxis.Spacing.contiguousInterval;
                    break;
                }
                case GRID_AXIS_SPACING_DISCONTIGUOUS_INTERVAL: {
                    gridAxisSpacing = GridAxis.Spacing.discontiguousInterval;
                    break;
                }
                case GRID_AXIS_SPACING_UNSPECIFIED: {
                    throw new UnsupportedOperationException("CDM Axis Spacing is UNSPECIFIED. Cannot convert to GridAxis.Spacing.");
                }
            }
        }
        return gridAxisSpacing;
    }

    public static GcdmGridProto.GridAxisSpacing convertAxisSpacing(GridAxis.Spacing spacing) {
        GcdmGridProto.GridAxisSpacing gridAxisSpacing = GcdmGridProto.GridAxisSpacing.GRID_AXIS_SPACING_UNSPECIFIED;
        if (spacing != null) {
            switch (spacing) {
                case regularPoint: {
                    gridAxisSpacing = GcdmGridProto.GridAxisSpacing.GRID_AXIS_SPACING_REGULAR_POINT;
                    break;
                }
                case irregularPoint: {
                    gridAxisSpacing = GcdmGridProto.GridAxisSpacing.GRID_AXIS_SPACING_IRREGULAR_POINT;
                    break;
                }
                case regularInterval: {
                    gridAxisSpacing = GcdmGridProto.GridAxisSpacing.GRID_AXIS_SPACING_REGULAR_INTERVAL;
                    break;
                }
                case contiguousInterval: {
                    gridAxisSpacing = GcdmGridProto.GridAxisSpacing.GRID_AXIS_SPACING_CONTIGUOUS_INTERVAL;
                    break;
                }
                case discontiguousInterval: {
                    gridAxisSpacing = GcdmGridProto.GridAxisSpacing.GRID_AXIS_SPACING_DISCONTIGUOUS_INTERVAL;
                    break;
                }
                default: {
                    gridAxisSpacing = GcdmGridProto.GridAxisSpacing.GRID_AXIS_SPACING_UNSPECIFIED;
                }
            }
        }
        return gridAxisSpacing;
    }

    @Nullable
    public static GridAxis.DependenceType convertAxisDependenceType(GcdmGridProto.GridAxisDependenceType proto) {
        GridAxis.DependenceType dependenceType = null;
        if (proto != null) {
            switch (proto) {
                case GRID_AXIS_DEPENDENCE_TYPE_INDEPENDENT: {
                    dependenceType = GridAxis.DependenceType.independent;
                    break;
                }
                case GRID_AXIS_DEPENDENCE_TYPE_DEPENDENT: {
                    dependenceType = GridAxis.DependenceType.dependent;
                    break;
                }
                case GRID_AXIS_DEPENDENCE_TYPE_SCALAR: {
                    dependenceType = GridAxis.DependenceType.scalar;
                    break;
                }
                case GRID_AXIS_DEPENDENCE_TYPE_TWO_D: {
                    dependenceType = GridAxis.DependenceType.twoD;
                    break;
                }
                case GRID_AXIS_DEPENDENCE_TYPE_FMRC_REG: {
                    dependenceType = GridAxis.DependenceType.fmrcReg;
                    break;
                }
                case GRID_AXIS_DEPENDENCE_TYPE_DIMENSION: {
                    dependenceType = GridAxis.DependenceType.dimension;
                    break;
                }
                case GRID_AXIS_DEPENDENCE_TYPE_UNSPECIFIED: {
                    throw new UnsupportedOperationException("Grid Axis Dependence Type is UNSPECIFIED. Cannot convert to GridAxis.DependenceType");
                }
            }
        }
        return dependenceType;
    }

    public static GcdmGridProto.GridAxisDependenceType convertAxisDependenceType(GridAxis.DependenceType dtype) {
        GcdmGridProto.GridAxisDependenceType gridAxisDependenceType = GcdmGridProto.GridAxisDependenceType.GRID_AXIS_DEPENDENCE_TYPE_UNSPECIFIED;
        if (dtype != null) {
            switch (dtype) {
                case independent: {
                    gridAxisDependenceType = GcdmGridProto.GridAxisDependenceType.GRID_AXIS_DEPENDENCE_TYPE_INDEPENDENT;
                    break;
                }
                case dependent: {
                    gridAxisDependenceType = GcdmGridProto.GridAxisDependenceType.GRID_AXIS_DEPENDENCE_TYPE_DEPENDENT;
                    break;
                }
                case scalar: {
                    gridAxisDependenceType = GcdmGridProto.GridAxisDependenceType.GRID_AXIS_DEPENDENCE_TYPE_SCALAR;
                    break;
                }
                case twoD: {
                    gridAxisDependenceType = GcdmGridProto.GridAxisDependenceType.GRID_AXIS_DEPENDENCE_TYPE_TWO_D;
                    break;
                }
                case fmrcReg: {
                    gridAxisDependenceType = GcdmGridProto.GridAxisDependenceType.GRID_AXIS_DEPENDENCE_TYPE_FMRC_REG;
                    break;
                }
                case dimension: {
                    gridAxisDependenceType = GcdmGridProto.GridAxisDependenceType.GRID_AXIS_DEPENDENCE_TYPE_DIMENSION;
                    break;
                }
                default: {
                    gridAxisDependenceType = GcdmGridProto.GridAxisDependenceType.GRID_AXIS_DEPENDENCE_TYPE_UNSPECIFIED;
                }
            }
        }
        return gridAxisDependenceType;
    }

    public static void decodeDataset(GcdmGridProto.GridDataset proto, GcdmGridDataset.Builder builder, Formatter errlog) {
        for (GcdmGridProto.GridAxis axis : proto.getGridAxesList()) {
            builder.addGridAxis(GcdmGridConverter.decodeGridAxis(axis));
        }
        for (GcdmGridProto.GridCoordinateSystem coordsys : proto.getCoordSystemsList()) {
            builder.addCoordSys(GcdmGridConverter.decodeCoordSys(coordsys, errlog));
        }
        for (GcdmGridProto.Grid grid : proto.getGridsList()) {
            builder.addGrid(GcdmGridConverter.decodeGrid(grid));
        }
    }

    public static GridAxis.Builder<?> decodeGridAxis(GcdmGridProto.GridAxis proto) {
        GridAxis1D.Builder axis1b;
        GridAxis1D.Builder axisb;
        GcdmGridProto.GridAxisType gridAxisType = proto.getGridAxisType();
        switch (gridAxisType) {
            case GRID_AXIS_TYPE_AXIS_1D: {
                axisb = GridAxis1D.builder();
                break;
            }
            case GRID_AXIS_TYPE_AXIS_1D_TIME: {
                axisb = GridAxis1DTime.builder();
                break;
            }
            case GRID_AXIS_TYPE_TIME_OFFSET_REGULAR: {
                axisb = GridAxisOffsetTimeRegular.builder();
                break;
            }
            case GRID_AXIS_TYPE_UNSPECIFIED: {
                throw new UnsupportedOperationException("Grid Axis Type is UNSPECIFIED. Cannot decode.");
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        axisb.setName(proto.getName());
        axisb.setDescription(proto.getDescription());
        axisb.setUnits(proto.getUnit());
        axisb.setAxisType(GcdmGridConverter.convertAxisType(proto.getCdmAxisType()));
        axisb.setAttributes(GcdmConverter.decodeAttributes(proto.getName(), proto.getAttributesList()));
        axisb.setSpacing(GcdmGridConverter.convertAxisSpacing(proto.getSpacing()));
        axisb.setDependenceType(GcdmGridConverter.convertAxisDependenceType(proto.getDependenceType()));
        axisb.setDependsOn((List)proto.getDependsOnList());
        if (axisb instanceof GridAxis1D.Builder) {
            axis1b = axisb;
            axis1b.setRegular(proto.getNcoord(), proto.getStartValue(), proto.getEndValue(), proto.getResolution());
            if (proto.getValuesCount() > 0) {
                axis1b.setValues(proto.getValuesList());
            }
        }
        if (axisb instanceof GridAxis1DTime.Builder) {
            axis1b = (GridAxis1DTime.Builder)axisb;
            axis1b.setDateUnits(proto.getDateUnit());
        }
        if (axisb instanceof GridAxisOffsetTimeRegular.Builder) {
            GridAxisOffsetTimeRegular.Builder axisReg = (GridAxisOffsetTimeRegular.Builder)axisb;
            axisReg.setRuntimeAxisName(proto.getRuntimeAxisName());
            axisReg.setHourOffsets(proto.getHourOffsetsList());
            axisReg.setMidpointsBounds(proto.getShapesList(), proto.getMidpointsList(), proto.getBoundsList());
        }
        return axisb;
    }

    public static GridCS.Builder<?> decodeCoordSys(GcdmGridProto.GridCoordinateSystem proto, Formatter errlog) {
        GridCS.Builder builder = GridCS.builder();
        builder.setName(proto.getName());
        builder.setFeatureType(FeatureType.GRID);
        builder.setAxisNames((List)proto.getAxisNamesList());
        builder.setProjection(GcdmGridConverter.decodeProjection(proto.getProjection(), errlog));
        return builder;
    }

    public static GcdmGrid.Builder decodeGrid(GcdmGridProto.Grid proto) {
        return GcdmGrid.builder().setProto(proto);
    }

    public static Projection decodeProjection(GcdmGridProto.Projection proto, Formatter errlog) {
        AttributeContainer ctv = GcdmConverter.decodeAttributes(proto.getName(), proto.getAttributesList());
        return ProjectionFactory.makeProjection((AttributeContainer)ctv, (String)proto.getGeoUnit(), (Formatter)errlog);
    }

    public static GridReferencedArray decodeGridReferencedArray(GcdmGridProto.GridReferencedArray proto, ImmutableList<GridAxis> axes) {
        Formatter errlog = new Formatter();
        GridCS.Builder<?> cs = GcdmGridConverter.decodeCoordSys(proto.getCsSubset(), errlog);
        Array data = GcdmConverter.decodeData(proto.getData());
        return GridReferencedArray.create((String)proto.getGridName(), (ArrayType)data.getArrayType(), data, (GridCoordinateSystem)cs.build(axes));
    }

    public static GcdmGridProto.GridDataset encodeDataset(GridDataset org) {
        GcdmGridProto.GridDataset.Builder builder = GcdmGridProto.GridDataset.newBuilder();
        builder.setName(org.getName());
        builder.setLocation(org.getLocation());
        builder.setFeatureType(GcdmGridProto.CdmFeatureType.CDM_FEATURE_TYPE_GRIDDED);
        builder.addAllAttributes(GcdmConverter.encodeAttributes(org.attributes()));
        for (GridAxis axis : org.getGridAxes()) {
            builder.addGridAxes(GcdmGridConverter.encodeGridAxis(axis));
        }
        for (GridCoordinateSystem coordsys : org.getGridCoordinateSystems()) {
            builder.addCoordSystems(GcdmGridConverter.encodeCoordSys(coordsys));
        }
        for (Grid grid : org.getGrids()) {
            builder.addGrids(GcdmGridConverter.encodeGrid(grid));
        }
        return builder.build();
    }

    public static GcdmGridProto.GridCoordinateSystem encodeCoordSys(GridCoordinateSystem csys) {
        GcdmGridProto.GridCoordinateSystem.Builder builder = GcdmGridProto.GridCoordinateSystem.newBuilder();
        builder.setName(csys.getName());
        for (GridAxis axis : csys.getGridAxes()) {
            builder.addAxisNames(axis.getName());
        }
        GridHorizCoordinateSystem horizCS = csys.getHorizCoordSystem();
        builder.setProjection(GcdmGridConverter.encodeProjection(horizCS.getProjection(), horizCS.getGeoUnits()));
        return builder.build();
    }

    public static GcdmGridProto.Projection encodeProjection(Projection projection, String geoUnits) {
        GcdmGridProto.Projection.Builder builder = GcdmGridProto.Projection.newBuilder();
        builder.setName(projection.getName());
        if (geoUnits != null) {
            builder.setGeoUnit(geoUnits);
        }
        builder.addAllAttributes(GcdmConverter.encodeAttributes(projection.getProjectionAttributes()));
        return builder.build();
    }

    public static GcdmGridProto.GridAxis encodeGridAxis(GridAxis axis) {
        GcdmGridProto.GridAxis.Builder builder = GcdmGridProto.GridAxis.newBuilder();
        if (axis instanceof GridAxis1DTime) {
            builder.setGridAxisType(GcdmGridProto.GridAxisType.GRID_AXIS_TYPE_AXIS_1D_TIME);
        } else if (axis instanceof GridAxisOffsetTimeRegular) {
            builder.setGridAxisType(GcdmGridProto.GridAxisType.GRID_AXIS_TYPE_TIME_OFFSET_REGULAR);
        } else if (axis instanceof GridAxis2D) {
            builder.setGridAxisType(GcdmGridProto.GridAxisType.GRID_AXIS_TYPE_AXIS_2D);
        } else {
            builder.setGridAxisType(GcdmGridProto.GridAxisType.GRID_AXIS_TYPE_AXIS_1D);
        }
        builder.setName(axis.getName());
        builder.setDescription(axis.getDescription());
        builder.setUnit(axis.getUnits());
        builder.setCdmAxisType(GcdmGridConverter.convertAxisType(axis.getAxisType()));
        builder.addAllAttributes(GcdmConverter.encodeAttributes(axis.attributes()));
        builder.setSpacing(GcdmGridConverter.convertAxisSpacing(axis.getSpacing()));
        builder.setDependenceType(GcdmGridConverter.convertAxisDependenceType(axis.getDependenceType()));
        builder.addAllDependsOn((Iterable<String>)axis.getDependsOn());
        if (axis instanceof GridAxis1D) {
            GridAxis1D axis1 = (GridAxis1D)axis;
            builder.setNcoord(axis1.getNcoords());
            builder.setStartValue(axis1.getStartValue());
            builder.setEndValue(axis1.getEndValue());
            builder.setResolution(axis1.getResolution());
            double[] object = axis1.getValues();
            if (object != null) {
                double[] dArray = object;
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    double value = dArray[i];
                    builder.addValues(value);
                }
            }
        }
        if (axis instanceof GridAxis1DTime) {
            GridAxis1DTime axis1t = (GridAxis1DTime)axis;
            builder.setDateUnit(axis1t.getTimeHelper().getUdUnit());
        }
        if (axis instanceof GridAxisOffsetTimeRegular) {
            GridAxisOffsetTimeRegular axisReg = (GridAxisOffsetTimeRegular)axis;
            builder.setRuntimeAxisName(axisReg.getRunTimeAxis().getName());
            UnmodifiableIterator unmodifiableIterator = axisReg.getHourOffsets().iterator();
            while (unmodifiableIterator.hasNext()) {
                int hour = (Integer)unmodifiableIterator.next();
                builder.addHourOffsets(hour);
            }
            Iterator iterator = axisReg.getCoordsAsArray().iterator();
            while (iterator.hasNext()) {
                double mid = (Double)iterator.next();
                builder.addMidpoints(mid);
            }
            Iterator iterator2 = axisReg.getCoordBoundsAsArray().iterator();
            while (iterator2.hasNext()) {
                double bound = (Double)iterator2.next();
                builder.addBounds(bound);
            }
            for (int shape : axisReg.getCoordsAsArray().getShape()) {
                builder.addShapes(shape);
            }
        }
        return builder.build();
    }

    public static GcdmGridProto.Grid encodeGrid(Grid grid) {
        GcdmGridProto.Grid.Builder builder = GcdmGridProto.Grid.newBuilder();
        builder.setName(grid.getName());
        builder.setDescription(grid.getDescription());
        builder.setUnit(grid.getUnits());
        builder.setDataType(GcdmConverter.convertDataType(grid.getArrayType()));
        builder.addAllAttributes(GcdmConverter.encodeAttributes(grid.attributes()));
        builder.setCoordSystem(grid.getCoordinateSystem().getName());
        builder.setHasMissing(grid.hasMissing());
        return builder.build();
    }

    public static GcdmGridProto.GridReferencedArray encodeGridReferencedArray(GridReferencedArray geoArray) {
        GcdmGridProto.GridReferencedArray.Builder builder = GcdmGridProto.GridReferencedArray.newBuilder();
        builder.setGridName(geoArray.gridName());
        builder.setCsSubset(GcdmGridConverter.encodeCoordSys(geoArray.csSubset()));
        builder.setData(GcdmConverter.encodeData(geoArray.arrayType(), geoArray.data()));
        return builder.build();
    }
}

