/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.gcdm.GcdmConverter;
import ucar.gcdm.GcdmGrpc;
import ucar.gcdm.GcdmNetcdfProto;
import ucar.ma2.Array;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedArraySectionSpec;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.DebugFlags;

public class GcdmNetcdfFile
extends NetcdfFile {
    private static final Logger log = LoggerFactory.getLogger(GcdmNetcdfFile.class);
    private static final int MAX_DATA_WAIT_SECONDS = 30;
    private static final int MAX_MESSAGE = 51000000;
    private static boolean showRequest = true;
    public static final String PROTOCOL = "gcdm";
    public static final String SCHEME = "gcdm:";
    private final String remoteURI;
    private final String path;
    private final ManagedChannel channel;
    private final GcdmGrpc.GcdmBlockingStub blockingStub;

    public static void setDebugFlags(DebugFlags debugFlag) {
        showRequest = debugFlag.isSet("Gcdm/showRequest");
    }

    protected Array readData(Variable v, Section sectionWanted) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected StructureDataIterator getStructureIterator(Structure s, int bufferSize) {
        throw new UnsupportedOperationException();
    }

    public Iterator<StructureData> getStructureDataArrayIterator(Sequence s, int bufferSize) throws IOException {
        ucar.array.Array<?> data = this.readArrayData((Variable)s, s.getSection());
        Preconditions.checkNotNull(data);
        Preconditions.checkArgument((boolean)(data instanceof StructureDataArray));
        StructureDataArray sdata = (StructureDataArray)data;
        return sdata.iterator();
    }

    @Nullable
    protected ucar.array.Array<?> readArrayData(Variable v, ucar.array.Section sectionWanted) throws IOException {
        String spec = ParsedArraySectionSpec.makeSectionSpecString((Variable)v, (ucar.array.Section)sectionWanted);
        if (showRequest) {
            System.out.printf("GcdmNetcdfFile data request forspec=(%s)%n url='%s'%n path='%s'%n", spec, this.remoteURI, this.path);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList results = new ArrayList();
        long size = 0L;
        GcdmNetcdfProto.DataRequest request = GcdmNetcdfProto.DataRequest.newBuilder().setLocation(this.path).setVariableSpec(spec).build();
        try {
            Iterator<GcdmNetcdfProto.DataResponse> responses = ((GcdmGrpc.GcdmBlockingStub)this.blockingStub.withDeadlineAfter(30L, TimeUnit.SECONDS)).getNetcdfData(request);
            while (responses.hasNext()) {
                GcdmNetcdfProto.DataResponse response = responses.next();
                if (response.hasError()) {
                    throw new IOException(response.getError().getMessage());
                }
                ucar.array.Array result = GcdmConverter.decodeData(response.getData());
                results.add(result);
                size += result.length();
            }
        }
        catch (StatusRuntimeException e) {
            log.warn("readSection requestData failed failed: ", (Throwable)e);
            throw new IOException(e);
        }
        catch (Throwable t) {
            System.out.printf(" ** failed after %s%n", stopwatch);
            log.warn("readSection requestData failed failed: ", t);
            throw new IOException(t);
        }
        System.out.printf(" ** size=%d took=%s%n", size, stopwatch.stop());
        if (results.size() == 1) {
            return (ucar.array.Array)results.get(0);
        }
        return Arrays.factoryCopy((ArrayType)v.getArrayType(), (int[])sectionWanted.getShape(), results);
    }

    public String getFileTypeId() {
        return PROTOCOL;
    }

    public String getFileTypeDescription() {
        return PROTOCOL;
    }

    public synchronized void close() {
        try {
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            log.warn("GcdmNetcdfFile shutdown interrupted");
        }
    }

    private GcdmNetcdfFile(Builder<?> builder) {
        super(builder);
        this.remoteURI = ((Builder)builder).remoteURI;
        this.path = ((Builder)builder).path;
        this.channel = ((Builder)builder).channel;
        this.blockingStub = ((Builder)builder).blockingStub;
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(GcdmNetcdfFile.builder());
    }

    private Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        b.setRemoteURI(this.remoteURI);
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends NetcdfFile.Builder<T> {
        private String remoteURI;
        private ManagedChannel channel;
        private GcdmGrpc.GcdmBlockingStub blockingStub;
        private String path;
        private boolean built;

        protected abstract T self();

        public T setRemoteURI(String remoteURI) {
            this.remoteURI = remoteURI;
            return (T)this.self();
        }

        public GcdmNetcdfFile build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.openChannel();
            return new GcdmNetcdfFile(this);
        }

        private void openChannel() {
            URI uri = URI.create(this.remoteURI);
            String target = uri.getAuthority();
            this.path = uri.getPath();
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
            this.channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().enableFullStreamDecompression().maxInboundMessageSize(51000000).build();
            try {
                this.blockingStub = GcdmGrpc.newBlockingStub((Channel)this.channel);
                this.readHeader(this.path);
            }
            catch (Exception e) {
                try {
                    this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    log.warn("Shutdown interrupted ", (Throwable)e);
                }
                e.printStackTrace();
                throw new RuntimeException("Cant open Gcdm url " + this.remoteURI, e);
            }
        }

        private void readHeader(String location) {
            log.info("GcdmNetcdfFile request header for " + location);
            GcdmNetcdfProto.HeaderRequest request = GcdmNetcdfProto.HeaderRequest.newBuilder().setLocation(location).build();
            GcdmNetcdfProto.HeaderResponse response = this.blockingStub.getNetcdfHeader(request);
            if (response.hasError()) {
                throw new RuntimeException(response.getError().getMessage());
            }
            GcdmNetcdfProto.Header header = response.getHeader();
            this.setId(header.getId());
            this.setTitle(header.getTitle());
            this.setLocation(GcdmNetcdfFile.SCHEME + header.getLocation());
            this.rootGroup = Group.builder().setName("");
            GcdmConverter.decodeGroup(header.getRoot(), this.rootGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

