/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ThreddsMetadata;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.TimePartitionCollection;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.grib1.Grib1Iosp;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Iosp;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class InvDatasetFcGrib
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcGrib.class);
    private static final String COLLECTION = "collection";
    private static final String VARIABLES = "?metadata=variableMap";
    private final FeatureCollectionConfig.GribConfig gribConfig;
    private final AtomicBoolean needsUpdate = new AtomicBoolean();
    private final AtomicBoolean needsProto = new AtomicBoolean();
    private boolean first = true;
    private DataFormatType format;
    private Map<Integer, ThreddsMetadata.Variable> map = null;
    private Grib1Customizer cust1 = null;
    private Grib2Customizer cust2 = null;

    public InvDatasetFcGrib(InvDatasetImpl parent, String name, String path, FeatureType featureType, FeatureCollectionConfig config) {
        super(parent, name, path, featureType, config);
        String errs;
        this.gribConfig = config.gribConfig;
        Formatter errlog = new Formatter();
        if (config.useIndexOnly) {
            this.dcm = TimePartitionCollection.fromExistingIndices((FeatureCollectionConfig)config, (Formatter)errlog);
        } else if (config.timePartition != null) {
            this.dcm = TimePartitionCollection.factory((FeatureCollectionConfig)config, (Formatter)errlog);
            this.dcm.setChangeChecker(GribIndex.getChangeChecker());
        } else {
            this.dcm = new MFileCollectionManager(config, errlog);
            this.dcm.setChangeChecker(GribIndex.getChangeChecker());
        }
        if (config.gribConfig != null) {
            this.dcm.putAuxInfo("gribConfig", (Object)config.gribConfig);
        }
        if ((errs = errlog.toString()).length() > 0) {
            logger.warn("{}: CollectionManager parse error = {} ", (Object)name, (Object)errs);
        }
        this.tmi.setDataType(FeatureType.GRID);
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CollectionManager.Force force) {
        if (this.first) {
            Object object = this.lock;
            synchronized (object) {
                this.format = this.getDataFormatType();
                this.firstInit();
                this.first = false;
            }
        }
        if (force == CollectionManager.Force.nocheck) {
            try {
                this.dcm.scan(false);
            }
            catch (IOException e) {
                logger.error("Error on scan " + this.dcm, (Throwable)e);
            }
        }
        StateGrib localState = new StateGrib((StateGrib)this.state);
        try {
            this.updateCollection(localState, force);
        }
        catch (Throwable e) {
            logger.error("Fail to create/update collection", e);
            return;
        }
        this.makeTopDatasets(localState);
        localState.lastInvChange = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.needsUpdate.set(false);
            this.needsProto.set(false);
            this.state = localState;
        }
    }

    public void updateProto() {
        this.needsProto.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateGrib checkState() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.first) {
                this.format = this.getDataFormatType();
                this.firstInit();
                this.dcm.scanIfNeeded();
                this.first = false;
            } else if (!this.dcm.scanIfNeeded()) {
                return (StateGrib)this.state;
            }
            boolean tdsUsingTdm = !CollectionUpdater.INSTANCE.isTdm() && this.config.tdmConfig != null;
            StateGrib localState = new StateGrib((StateGrib)this.state);
            this.updateCollection(localState, tdsUsingTdm ? CollectionManager.Force.nocheck : CollectionManager.Force.test);
            this.makeTopDatasets(localState);
            localState.lastInvChange = System.currentTimeMillis();
            this.needsUpdate.set(false);
            this.needsProto.set(false);
            this.state = localState;
            return localState;
        }
    }

    private void updateCollection(StateGrib localState, CollectionManager.Force force) throws IOException {
        if (this.config.timePartition != null) {
            TimePartition previous = localState.timePartition;
            localState.timePartition = TimePartition.factory(this.format == DataFormatType.GRIB1, (TimePartitionCollection)this.dcm, force, new Formatter());
            localState.gribCollection = null;
            if (previous != null) {
                previous.close();
            }
        } else {
            GribCollection previous = localState.gribCollection;
            localState.gribCollection = GribCollection.factory(this.format == DataFormatType.GRIB1, this.dcm, force, new Formatter());
            localState.timePartition = null;
            if (previous != null) {
                previous.close();
            }
        }
        logger.debug("{}: Collection was recreated", (Object)this.getName());
    }

    public InvCatalogImpl makeCatalog(String match, String orgPath, URI baseURI) {
        StateGrib localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                InvCatalogImpl main = this.makeCatalogTop(baseURI, localState);
                main.addService(this.virtualService);
                main.getDataset().getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
                main.finish();
                return main;
            }
            if (localState.timePartition == null) {
                String[] path = match.split("/");
                if (path.length < 2) {
                    return null;
                }
                GribCollection.GroupHcs group = localState.gribCollection.findGroupById(path[0]);
                if (group != null) {
                    return this.makeFilesCatalog(localState.gribCollection, group, baseURI, localState);
                }
            } else {
                if (match.equals(COLLECTION)) {
                    return this.makeGribCollectionCatalog(localState.timePartition, baseURI, localState);
                }
                TimePartition.Partition tpp = localState.timePartition.getPartitionByName(match);
                if (tpp != null) {
                    GribCollection gc = tpp.getGribCollection();
                    InvCatalogImpl result = this.makeGribCollectionCatalog(gc, baseURI, localState);
                    gc.close();
                    return result;
                }
                String[] path = match.split("/");
                if (path.length < 2) {
                    return null;
                }
                tpp = localState.timePartition.getPartitionByName(path[0]);
                if (tpp != null) {
                    GribCollection gc = tpp.getGribCollection();
                    GribCollection.GroupHcs group = gc.findGroupById(path[1]);
                    if (group == null) {
                        return null;
                    }
                    InvCatalogImpl result = this.makeFilesCatalog(gc, group, baseURI, localState);
                    gc.close();
                    return result;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, (Throwable)e);
        }
        return null;
    }

    private void makeTopDatasets(StateGrib localState) {
        ArrayList<Object> datasets = new ArrayList<Object>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        if (localState.timePartition == null) {
            ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(localState.gribCollection.getGroups());
            Collections.sort(groups);
            for (GribCollection.GroupHcs group : groups) {
                String groupId = group.getId();
                InvDatasetImpl ds = new InvDatasetImpl((InvDataset)this, group.getDescription());
                ds.setUrlPath(this.path + "/" + groupId);
                ds.setID(id + "/" + groupId);
                this.addFileDatasets(ds, groupId);
                ds.tmi.addVariableMapLink(this.makeMetadataLink(this.path, groupId, VARIABLES));
                ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
                CalendarDateRange cdr = this.extractCalendarDateRange(group);
                if (cdr != null) {
                    ds.tmi.setTimeCoverage(cdr);
                }
                ds.finish();
                datasets.add(ds);
            }
        } else {
            InvCatalogRef ds = new InvCatalogRef((InvDatasetImpl)this, COLLECTION, this.getCatalogHref(COLLECTION));
            ds.setUrlPath(this.path + "/" + COLLECTION);
            ds.setID(id + "/" + COLLECTION);
            ds.finish();
            datasets.add(ds);
            for (TimePartition.Partition dc : localState.timePartition.getPartitions()) {
                String dname = dc.getName();
                ds = new InvCatalogRef((InvDatasetImpl)this, dname, this.getCatalogHref(dname));
                dname = StringUtil2.replace((String)dname, (char)' ', (String)"_");
                ds.setUrlPath(this.path + "/" + dname);
                ds.setID(id + "/" + dname);
                ds.tmi.addVariableMapLink(this.makeMetadataLink(this.path, dname, VARIABLES));
                ds.finish();
                datasets.add(ds);
            }
        }
        localState.datasets = datasets;
        this.datasets = datasets;
        this.finish();
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(GribCollection.GroupHcs group) {
        GdsHorizCoordSys gdsCoordSys = group.hcs;
        LatLonRect llbb = GridCoordSys.getLatLonBoundingBox((Projection)gdsCoordSys.proj, (double)gdsCoordSys.getStartX(), (double)gdsCoordSys.getStartY(), (double)gdsCoordSys.getEndX(), (double)gdsCoordSys.getEndY());
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
        if (llbb != null) {
            gc.setBoundingBox(llbb);
        }
        if (group.hcs.isLatLon()) {
            gc.setLonResolution(gdsCoordSys.dx);
            gc.setLatResolution(gdsCoordSys.dy);
        }
        return gc;
    }

    private CalendarDateRange extractCalendarDateRange(GribCollection.GroupHcs group) {
        TimeCoord max = null;
        for (TimeCoord tc : group.timeCoords) {
            if (tc.isInterval() || max != null && max.getSize() >= tc.getSize()) continue;
            max = tc;
        }
        if (max == null) {
            for (TimeCoord tc : group.timeCoords) {
                if (!tc.isInterval() || max != null && max.getSize() >= tc.getSize()) continue;
                max = tc;
            }
        }
        return max == null ? null : max.getCalendarRange();
    }

    private InvCatalogImpl makeGribCollectionCatalog(GribCollection gribCollection, URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        String collectionName = gribCollection.getName();
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(collectionName));
        InvCatalogImpl partCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl((InvDatasetImpl)this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(collectionName);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        partCatalog.addDataset(top);
        partCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(gribCollection.getGroups());
        Collections.sort(groups);
        for (GribCollection.GroupHcs group : groups) {
            String groupId = group.getId();
            InvDatasetImpl ds = new InvDatasetImpl((InvDataset)this, groupId + "_" + COLLECTION);
            ds.setUrlPath(this.path + "/" + collectionName + "/" + groupId);
            ds.setID(id + "/" + collectionName + "/" + groupId);
            ds.tmi.addVariableMapLink(this.makeMetadataLink(this.path + "/" + collectionName, groupId, VARIABLES));
            ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
            CalendarDateRange cdr = this.extractCalendarDateRange(group);
            if (cdr != null) {
                ds.tmi.setTimeCoverage(cdr);
            }
            if (!(gribCollection instanceof TimePartition)) {
                this.addFileDatasets(ds, collectionName + "/" + groupId);
            }
            ds.finish();
            top.addDataset(ds);
        }
        partCatalog.finish();
        return partCatalog;
    }

    private void addFileDatasets(InvDatasetImpl parent, String prefix) {
        String name = prefix + "/" + "files";
        InvCatalogRef ds = new InvCatalogRef((InvDatasetImpl)this, "files", this.getCatalogHref(name));
        ds.finish();
        parent.addDataset((InvDatasetImpl)ds);
    }

    private InvCatalogImpl makeFilesCatalog(GribCollection gc, GribCollection.GroupHcs group, URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        String collectionName = gc.getName();
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(collectionName));
        InvCatalogImpl result = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl((InvDatasetImpl)this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName("files");
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        result.addDataset(top);
        result.addService(this.orgService);
        top.getLocalMetadataInheritable().setServiceName(this.orgService.getName());
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (String f : group.getFilenames()) {
            if (!f.startsWith(this.topDirectory)) {
                System.out.println("HEY");
            }
            String fname = f.substring(this.topDirectory.length() + 1);
            String path = "files/" + fname;
            InvDatasetImpl ds = new InvDatasetImpl((InvDataset)this, fname);
            ds.setUrlPath(this.path + "/" + path);
            ds.setID(id + "/" + path);
            ds.tmi.addVariableMapLink(this.makeMetadataLink(this.path, fname, VARIABLES));
            File file = new File(f);
            ds.tm.setDataSize((double)file.length());
            ds.finish();
            top.addDataset(ds);
        }
        result.finish();
        return result;
    }

    private String makeMetadataLink(String path, String dataset, String metadata) {
        return dataset + metadata;
    }

    public GridDataset getGridDataset(String matchPath) throws IOException {
        String filename;
        GridDataset result = super.getGridDataset(matchPath);
        if (result != null) {
            return result;
        }
        StateGrib localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        if (matchPath == null || matchPath.length() == 0) {
            return null;
        }
        String[] paths = matchPath.split("/");
        if (paths.length < 1) {
            return null;
        }
        String string = filename = paths.length == 2 ? paths[1] : null;
        if (localState.timePartition == null) {
            return localState.gribCollection.getGridDataset(paths[0], filename, this.gribConfig);
        }
        if (paths.length < 2) {
            return null;
        }
        if (paths[0].equals(localState.timePartition.getName())) {
            return localState.timePartition.getGridDataset(paths[1], null, this.gribConfig);
        }
        TimePartition.Partition tpp = localState.timePartition.getPartitionByName(paths[0]);
        if (tpp != null) {
            GribCollection gc = tpp.getGribCollection();
            result = gc.getGridDataset(paths[1], filename, this.gribConfig);
            return result;
        }
        return null;
    }

    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        NetcdfDataset result = super.getNetcdfDataset(matchPath);
        if (result != null) {
            return result;
        }
        StateGrib localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        if (matchPath == null || matchPath.length() == 0) {
            return null;
        }
        String[] paths = matchPath.split("/");
        if (paths.length < 1) {
            return null;
        }
        if (localState.timePartition == null) {
            int n = paths.length;
            if (n >= 2) {
                String group = paths[n - 2];
                String filename = paths[n - 1];
                return localState.gribCollection.getNetcdfDataset(group, filename, this.gribConfig);
            }
            return localState.gribCollection.getNetcdfDataset(paths[0], null, this.gribConfig);
        }
        if (paths.length < 2) {
            return null;
        }
        if (paths[0].equals(localState.timePartition.getName())) {
            return localState.timePartition.getNetcdfDataset(paths[1], null, this.gribConfig);
        }
        TimePartition.Partition dcm = localState.timePartition.getPartitionByName(paths[0]);
        if (dcm != null) {
            String filename = paths.length > 2 ? paths[2] : null;
            return dcm.getGribCollection().getNetcdfDataset(paths[1], filename, this.gribConfig);
        }
        return null;
    }

    private ThreddsMetadata.Variables extractThreddsVariables(GribCollection gribCollection, GribCollection.GroupHcs group) {
        ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables(this.format.toString());
        for (GribCollection.VariableIndex vindex : group.varIndex) {
            vars.addVariable(this.extractThreddsVariables(gribCollection, vindex));
        }
        vars.sort();
        return vars;
    }

    public ThreddsMetadata.Variable extractThreddsVariables(GribCollection gc, GribCollection.VariableIndex vindex) {
        String paramCategory;
        ThreddsMetadata.Variable tv;
        if (this.map == null) {
            this.map = new HashMap<Integer, ThreddsMetadata.Variable>(100);
        }
        if ((tv = this.map.get(vindex.cdmHash)) != null) {
            return tv;
        }
        tv = new ThreddsMetadata.Variable();
        if (gc.isGrib1()) {
            if (this.cust1 == null) {
                this.cust1 = Grib1Customizer.factory(gc.getCenter(), gc.getSubcenter(), gc.getLocal(), null);
            }
            tv.setName(this.cust1.makeVariableName(gc, vindex));
            tv.setDescription(Grib1Iosp.makeVariableLongName(this.cust1, gc, vindex));
            tv.setUnits(Grib1Iosp.makeVariableUnits(this.cust1, gc, vindex));
            tv.setVocabularyId("1-" + vindex.discipline + "-" + vindex.category + "-" + vindex.parameter);
            this.map.put(vindex.cdmHash, tv);
            return tv;
        }
        if (this.cust2 == null) {
            this.cust2 = Grib2Customizer.factory(gc.getCenter(), gc.getSubcenter(), gc.getMaster(), gc.getLocal());
        }
        tv.setName(Grib2Iosp.makeVariableName(this.cust2, gc, vindex));
        tv.setDescription(Grib2Iosp.makeVariableLongName(this.cust2, vindex));
        tv.setUnits(Grib2Iosp.makeVariableUnits(this.cust2, vindex));
        tv.setVocabularyId("2-" + vindex.discipline + "-" + vindex.category + "-" + vindex.parameter);
        String paramDisc = this.cust2.getTableValue("0.0", vindex.discipline);
        if (paramDisc == null) {
            paramDisc = "Unknown";
        }
        if ((paramCategory = this.cust2.getTableValue("4.1." + vindex.discipline, vindex.category)) == null) {
            paramCategory = "Unknown";
        }
        String paramName = this.cust2.getVariableName(vindex.discipline, vindex.category, vindex.parameter);
        tv.setVocabularyName(paramDisc + " / " + paramCategory + " / " + paramName);
        this.map.put(vindex.cdmHash, tv);
        return tv;
    }

    private class Vhash {
        int center;
        int subcenter;
        int local;
        int master;
        int discipline;
        int category;
        int param;

        private Vhash() {
        }
    }

    protected class StateGrib
    extends InvDatasetFeatureCollection.State {
        TimePartition timePartition;
        GribCollection gribCollection;

        protected StateGrib(StateGrib from) {
            super((InvDatasetFeatureCollection)InvDatasetFcGrib.this, (InvDatasetFeatureCollection.State)from);
            if (from != null) {
                this.timePartition = from.timePartition;
                this.gribCollection = from.gribCollection;
            }
        }
    }
}

