/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.util.Date;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;

public final class Grib2Product {
    private final String header;
    private final int discipline;
    private final Date baseTime;
    private final long refTime;
    private Grib2IdentificationSection id = null;
    private final String gdsKey;
    private final int gdskey;
    private Grib2ProductDefinitionSection pds = null;
    private long GdsOffset = -1L;
    private long PdsOffset = -1L;

    public Grib2Product(String header, Grib2IndicatorSection is, Grib2IdentificationSection id, String gdsKey, Grib2ProductDefinitionSection pds, long GdsOffset, long PdsOffset) {
        this.header = header;
        this.discipline = is.getDiscipline();
        this.id = id;
        this.baseTime = id.getBaseTime();
        this.refTime = id.getRefTime();
        this.gdsKey = gdsKey;
        this.gdskey = Integer.parseInt(gdsKey);
        this.pds = pds;
        this.GdsOffset = GdsOffset;
        this.PdsOffset = PdsOffset;
    }

    public Grib2Product(String header, Grib2IndicatorSection is, Grib2IdentificationSection id, String gdsKey, int gdskey, Grib2ProductDefinitionSection pds, long GdsOffset, long PdsOffset) {
        this.header = header;
        this.discipline = is.getDiscipline();
        this.id = id;
        this.baseTime = id.getBaseTime();
        this.refTime = id.getRefTime();
        this.gdsKey = gdsKey;
        this.gdskey = gdskey;
        this.pds = pds;
        this.GdsOffset = GdsOffset;
        this.PdsOffset = PdsOffset;
    }

    public final int getDiscipline() {
        return this.discipline;
    }

    public final Date getBaseTime() {
        return this.baseTime;
    }

    public final long getRefTime() {
        return this.refTime;
    }

    public final String getGDSkey() {
        return this.gdsKey;
    }

    public final int getGDSkeyInt() {
        return this.gdskey;
    }

    public final Grib2ProductDefinitionSection getPDS() {
        return this.pds;
    }

    public final Grib2IdentificationSection getID() {
        return this.id;
    }

    public final long getGdsOffset() {
        return this.GdsOffset;
    }

    public final long getPdsOffset() {
        return this.PdsOffset;
    }
}

