/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.zip.CRC32;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionGridDefinition {
    private final byte[] rawData;
    private final long startingPosition;
    private final int templateNumber;
    private long crc = 0L;
    private Grib2Gds gds = null;

    public Grib2SectionGridDefinition(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        int length = GribNumbers.int4(raf);
        int section = raf.read();
        if (section != 3) {
            throw new IllegalArgumentException("Not a GRIB-2 GDS section");
        }
        raf.skipBytes(7);
        this.templateNumber = GribNumbers.int2(raf);
        this.rawData = new byte[length];
        raf.seek(this.startingPosition);
        raf.readFully(this.rawData);
    }

    public Grib2SectionGridDefinition(byte[] rawData) {
        this.rawData = rawData;
        this.templateNumber = GribNumbers.int2(this.getInt(13), this.getInt(14));
        this.startingPosition = -1L;
    }

    public byte[] getRawBytes() {
        return this.rawData;
    }

    public long calcCRC() {
        if (this.crc == 0L) {
            CRC32 crc32 = new CRC32();
            crc32.update(this.rawData);
            this.crc = crc32.getValue();
        }
        return this.crc;
    }

    public int getLength() {
        return this.rawData.length;
    }

    public long getOffset() {
        return this.startingPosition;
    }

    public int getSource() {
        return this.getInt(6);
    }

    public int getNumberPoints() {
        return GribNumbers.int4(this.getInt(7), this.getInt(8), this.getInt(9), this.getInt(10));
    }

    public int getGDSTemplateNumber() {
        return this.templateNumber;
    }

    private int getInt(int index) {
        return this.rawData[index - 1] & 0xFF;
    }

    public Grib2Gds getGDS() {
        if (this.gds == null) {
            this.gds = Grib2Gds.factory(this.templateNumber, this.rawData);
        }
        return this.gds;
    }
}

