/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.TimePartitionCollection;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.grib1.Grib1TimePartitionBuilder;
import ucar.nc2.grib.grib2.Grib2TimePartitionBuilder;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;

public abstract class TimePartition
extends GribCollection {
    private static final Logger logger = LoggerFactory.getLogger(TimePartition.class);
    public static final byte VERT_COORDS_DIFFER = 1;
    public static final byte ENS_COORDS_DIFFER = 2;
    private static FileCache partitionCache;
    private static final FileFactory collectionFactory;
    protected Map<String, Partition> partitionMap;
    protected List<Partition> partitions;

    public static void initPartitionCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        partitionCache = new FileCache("GribCollectionPartitionCache ", minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static FileCache getPartitionCache() {
        return partitionCache;
    }

    public static void disableNetcdfFileCache() {
        if (null != partitionCache) {
            partitionCache.disable();
        }
        partitionCache = null;
    }

    public static boolean update(boolean isGrib1, TimePartitionCollection tpc, Formatter f) throws IOException {
        if (isGrib1) {
            return Grib1TimePartitionBuilder.update(tpc, f);
        }
        return Grib2TimePartitionBuilder.update(tpc, f);
    }

    public static TimePartition factory(boolean isGrib1, TimePartitionCollection tpc, CollectionManager.Force force, Formatter f) throws IOException {
        if (isGrib1) {
            return Grib1TimePartitionBuilder.factory(tpc, force, f);
        }
        return Grib2TimePartitionBuilder.factory(tpc, force, f);
    }

    protected TimePartition(String name, File directory, FeatureCollectionConfig.GribConfig dcm, boolean isGrib1) {
        super(name, directory, dcm, isGrib1);
    }

    @Override
    public List<String> getFilenames() {
        if (this.filenames == null || this.filenames.size() == 0) {
            List<Partition> parts = this.getPartitions();
            this.filenames = new ArrayList(parts.size());
            for (Partition p : parts) {
                this.filenames.add(p.indexFilename);
            }
            this.filenames = Collections.unmodifiableList(this.filenames);
        }
        return this.filenames;
    }

    public void addPartition(String name, String filename) {
        if (this.partitionMap == null) {
            this.partitionMap = new TreeMap<String, Partition>();
        }
        this.partitionMap.put(name, new Partition(name, filename));
    }

    public void addPartition(CollectionManager dcm) {
        if (this.partitionMap == null) {
            this.partitionMap = new TreeMap<String, Partition>();
        }
        this.partitionMap.put(dcm.getCollectionName(), new Partition(dcm));
    }

    public Partition getPartitionByName(String name) {
        return this.partitionMap.get(name);
    }

    public void cleanup() throws IOException {
        if (this.partitions == null) {
            return;
        }
        for (Partition p : this.partitions) {
            if (p.gribCollection == null) continue;
            p.gribCollection.close();
        }
    }

    @Override
    public GribCollection.VariableIndex makeVariableIndex(GribCollection.GroupHcs group, int tableVersion, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, String intvName, int ensDerivedType, int probType, String probabilityName, int genProcessType, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
        throw new UnsupportedOperationException();
    }

    public GribCollection.VariableIndex makeVariableIndex(GribCollection.GroupHcs group, int tableVersion, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, String intvName, int ensDerivedType, int probType, String probabilityName, int genProcessType, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen, List<Integer> groupnoList, List<Integer> varnoList, List<Integer> flagList) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(group, discipline, category, parameter, levelType, isLayer, intvType, intvName, ensDerivedType, probType, probabilityName, genProcessType, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
        int nparts = varnoList.size();
        vip.groupno = new int[nparts];
        vip.varno = new int[nparts];
        vip.flag = new int[nparts];
        for (int i = 0; i < nparts; ++i) {
            vip.groupno[i] = groupnoList.get(i);
            vip.varno[i] = varnoList.get(i);
            vip.flag[i] = flagList.get(i);
        }
        return vip;
    }

    public VariableIndexPartitioned makeVariableIndexPartitioned(GribCollection.VariableIndex vi, int nparts) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(vi.group, vi.discipline, vi.category, vi.parameter, vi.levelType, vi.isLayer, vi.intvType, vi.intvName, vi.ensDerivedType, vi.probType, vi.probabilityName, vi.genProcessType, vi.cdmHash, vi.timeIdx, vi.vertIdx, vi.ensIdx, vi.recordsPos, vi.recordsLen);
        vip.groupno = new int[nparts];
        vip.varno = new int[nparts];
        vip.flag = new int[nparts];
        for (int i = 0; i < nparts; ++i) {
            vip.groupno[i] = -1;
            vip.varno[i] = -1;
        }
        return vip;
    }

    public List<Partition> getPartitions() {
        if (this.partitions == null) {
            ArrayList<Partition> c = new ArrayList<Partition>(this.partitionMap.values());
            Collections.sort(c);
            this.partitions = c;
        }
        return this.partitions;
    }

    public void removePartition(Partition p) {
        this.partitions.remove(p);
        if (null != p.getDcm()) {
            this.partitionMap.remove(p.getDcm().getCollectionName());
        }
    }

    @Override
    public void showIndex(Formatter f) {
        List<Partition> plist = this.getPartitions();
        f.format("Partitions (%d)%n", plist.size());
        for (Partition p : plist) {
            f.format("  %s%n", p);
        }
        f.format("%n", new Object[0]);
        for (GribCollection.GroupHcs g : this.groups) {
            for (GribCollection.VariableIndex v : g.varIndex) {
                VariableIndexPartitioned vp = (VariableIndexPartitioned)v;
                for (int i = 0; i < vp.flag.length; ++i) {
                    if (vp.flag[i] == 0) continue;
                    f.format("  %s has missing (%d) on partition %d%n", v.id(), vp.flag[i], i);
                }
            }
        }
        super.showIndex(f);
    }

    public RandomAccessFile getRaf(int partno, int fileno) throws IOException {
        Partition part = this.getPartitions().get(partno);
        GribCollection gc = part.getGribCollection();
        return gc.getDataRaf(fileno);
    }

    @Override
    public void close() throws IOException {
        if (this.fileCache != null) {
            this.fileCache.release((FileCacheable)this);
        } else if (this.indexRaf != null) {
            this.cleanup();
            super.close();
        }
    }

    static {
        collectionFactory = new FileFactory(){

            public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                File f = new File(location);
                RandomAccessFile raf = new RandomAccessFile(location, "r");
                Partition p = (Partition)iospMessage;
                return GribCollection.createFromIndex(false, p.getName(), f.getParentFile(), raf, p.getConfig());
            }
        };
    }

    public class VariableIndexPartitioned
    extends GribCollection.VariableIndex {
        public int[] groupno;
        public int[] varno;
        public int[] flag;

        public VariableIndexPartitioned(GribCollection.GroupHcs g, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, String intvName, int ensDerivedType, int probType, String probabilityName, int genProcessType, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
            super(g, 0, discipline, category, parameter, levelType, isLayer, intvType, intvName, ensDerivedType, probType, probabilityName, genProcessType, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
        }

        public void setPartitionIndex(int partno, int groupIdx, int varIdx, int flag) {
            this.groupno[partno] = groupIdx;
            this.varno[partno] = varIdx;
            this.flag[partno] = flag;
        }

        public GribCollection.VariableIndex getVindex(int partno) throws IOException {
            Partition p = TimePartition.this.getPartitions().get(partno);
            GribCollection gc = p.getGribCollection();
            GribCollection.GroupHcs g = gc.groups.get(this.groupno[partno]);
            GribCollection.VariableIndex vindex = g.varIndex.get(this.varno[partno]);
            vindex.readRecords();
            return vindex;
        }

        @Override
        public String toStringComplete() {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("VariableIndexPartitioned");
            sb.append("{\ngroupno=").append(this.groupno == null ? "null" : "");
            for (i = 0; this.groupno != null && i < this.groupno.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.groupno[i]);
            }
            sb.append("\n varno=").append(this.varno == null ? "null" : "");
            for (i = 0; this.varno != null && i < this.varno.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.varno[i]);
            }
            sb.append("\n flags=").append(this.flag == null ? "null" : "");
            for (i = 0; this.flag != null && i < this.flag.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.flag[i]);
            }
            sb.append("}\n");
            sb.append(super.toStringComplete());
            return sb.toString();
        }

        public void cleanup() throws IOException {
        }
    }

    public class Partition
    implements Comparable<Partition> {
        private GribCollection gribCollection;
        private String name;
        private String indexFilename;
        private CollectionManager dcm;

        public Partition(String name, String indexFilename) {
            this.name = name;
            this.indexFilename = indexFilename;
        }

        public String getName() {
            return this.name;
        }

        public String getIndexFilename() {
            return this.indexFilename;
        }

        public FeatureCollectionConfig.GribConfig getConfig() {
            return TimePartition.this.gribConfig;
        }

        public CollectionManager getDcm() {
            return this.dcm;
        }

        public GribCollection getGribCollection() throws IOException {
            if (this.gribCollection == null) {
                this.gribCollection = partitionCache != null ? (GribCollection)partitionCache.acquire(collectionFactory, (Object)this.indexFilename, this.indexFilename, -1, null, (Object)this) : (GribCollection)collectionFactory.open(this.indexFilename, -1, null, (Object)this);
            }
            return this.gribCollection;
        }

        @Override
        public int compareTo(Partition o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "Partition{dcm=" + this.dcm + ", name='" + this.name + '\'' + ", filename='" + this.indexFilename + '\'' + '}';
        }

        public Partition(CollectionManager dcm) {
            this.dcm = dcm;
            this.name = dcm.getCollectionName();
        }

        public GribCollection makeGribCollection(Formatter f) throws IOException {
            if (this.gribCollection == null) {
                this.gribCollection = GribCollection.factory(TimePartition.this.isGrib1, this.dcm, CollectionManager.Force.test, f);
                this.indexFilename = this.gribCollection.getIndexFile().getPath();
            }
            return this.gribCollection;
        }
    }
}

