/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribResourceReader;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.wmo.Util;

public class GribPDSParamTable {
    private static final Logger logger = LoggerFactory.getLogger(GribPDSParamTable.class);
    private static Object lock = new Object();
    private static int standardTablesStart = 0;
    private static boolean debug = false;
    private static GribPDSParamTable defaultTable;
    private static Map<Integer, GribPDSParamTable> tableMap;
    private static List<GribPDSParamTable> paramTables;
    private static boolean strict;
    private int center_id;
    private int subcenter_id;
    private int version;
    private String name;
    private String path;
    private Map<Integer, GridParameter> parameters;

    public static boolean isStrict() {
        return strict;
    }

    public static void setStrict(boolean strict) {
        GribPDSParamTable.strict = strict;
    }

    public static GribPDSParamTable getDefaultTable() {
        return defaultTable;
    }

    public static List<GribPDSParamTable> getParameterTables() {
        return paramTables;
    }

    public static GridParameter getParameter(int center, int subcenter, int tableVersion, int param_number) {
        GribPDSParamTable pt = GribPDSParamTable.getParameterTable(center, subcenter, tableVersion);
        return pt == null ? null : pt.getParameter(param_number);
    }

    public static GribPDSParamTable getParameterTable(int center, int subcenter, int tableVersion) {
        int key = GribPDSParamTable.makeKey(center, subcenter, tableVersion);
        GribPDSParamTable table = tableMap.get(key);
        if (table != null) {
            return table;
        }
        table = GribPDSParamTable.findParameterTable(center, subcenter, tableVersion);
        if (table == null) {
            if (strict) {
                logger.warn("GRIBOLD: Could not find a table for GRIB file with center: " + center + " subCenter: " + subcenter + " version: " + tableVersion);
            }
            return strict ? null : defaultTable;
        }
        tableMap.put(key, table);
        return table;
    }

    private static GribPDSParamTable findParameterTable(int center, int subcenter, int version) {
        List<GribPDSParamTable> localCopy = paramTables;
        for (GribPDSParamTable table : localCopy) {
            if (center != table.center_id || table.subcenter_id != -1 && subcenter != table.subcenter_id || table.version != -1 && version != table.version) continue;
            if (table.parameters == null) {
                table.readParameterTable();
                if (table.parameters == null) continue;
                for (GribPDSParamTable table2 : localCopy) {
                    if (!table2.path.equals(table.path)) continue;
                    table2.parameters = table.parameters;
                }
            }
            return table;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addParameterUserLookup(String userGribTabList) throws IOException {
        LookupTable lookup = new LookupTable();
        ArrayList tables = new ArrayList();
        if (!lookup.readLookupTable(userGribTabList, tables)) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            paramTables.addAll(standardTablesStart, tables);
            standardTablesStart += tables.size();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParameterTable(int center, int subcenter, int tableVersion, String path) {
        GribPDSParamTable table = new GribPDSParamTable(center, subcenter, tableVersion, path);
        Object object = lock;
        synchronized (object) {
            paramTables.add(standardTablesStart, table);
            ++standardTablesStart;
        }
    }

    private static int makeKey(int center, int subcenter, int version) {
        if (center < 0) {
            center = 255;
        }
        if (subcenter < 0) {
            subcenter = 255;
        }
        if (version < 0) {
            version = 255;
        }
        return center * 1000 * 1000 + subcenter * 1000 + version;
    }

    public GribPDSParamTable(String path) throws IOException {
        this.path = path;
        this.name = GribResourceReader.getFilename(path);
        this.parameters = this.readParameterTable();
    }

    public GribPDSParamTable(int center_id, int subcenter_id, int version, String path) {
        this.center_id = center_id;
        this.subcenter_id = subcenter_id;
        this.version = version;
        this.path = path;
        this.name = GribResourceReader.getFilename(path);
    }

    public int getCenter_id() {
        return this.center_id;
    }

    public int getSubcenter_id() {
        return this.subcenter_id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public int getKey() {
        return GribPDSParamTable.makeKey(this.center_id, this.subcenter_id, this.version);
    }

    public String getPath() {
        return this.path;
    }

    public Map<Integer, GridParameter> getParameters() {
        if (this.parameters == null) {
            this.readParameterTable();
        }
        return this.parameters;
    }

    public GridParameter getParameter(int id) {
        GridParameter p;
        if (this.parameters == null) {
            this.readParameterTable();
        }
        if ((p = this.parameters.get(id)) != null) {
            return p;
        }
        p = GribPDSParamTable.defaultTable.parameters.get(id);
        return p;
    }

    public GridParameter getLocalParameter(int id) {
        if (this.parameters == null) {
            this.readParameterTable();
        }
        return this.parameters.get(id);
    }

    public String toString() {
        return "GribPDSParamTable{center_id=" + this.center_id + ", subcenter_id=" + this.subcenter_id + ", version=" + this.version + ", name='" + this.name + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private Map<Integer, GridParameter> readParameterTable() {
        if (this.name.endsWith(".tab")) {
            this.readParameterTableTab();
        } else if (this.name.endsWith(".wrf")) {
            this.readParameterTableSplit("\\|", new int[]{0, 3, 1, 2});
        } else if (this.name.endsWith(".dss")) {
            this.readParameterTableSplit("\t", new int[]{0, -1, 1, 2});
        } else if (this.name.endsWith(".xml")) {
            this.readParameterTableXml();
        } else if (this.name.endsWith(".htm")) {
            this.readParameterTableNcepScrape();
        } else if (this.name.startsWith("table_2_") || this.name.startsWith("local_table_2_")) {
            this.readParameterTableEcmwf();
        } else {
            logger.warn("Dont know how to read " + this.name + " file=" + this.path);
        }
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableEcmwf() {
        boolean num2;
        HashMap<Integer, GridParameter> result = new HashMap<Integer, GridParameter>();
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                boolean bl = false;
                return bl;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            if (!line.startsWith("...")) {
                this.name = line;
            }
            while (!line.startsWith("...")) {
                line = br.readLine();
            }
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("...") && (line = br.readLine()) == null) break;
                String num2 = line.trim();
                line = br.readLine();
                String name = line != null ? line.trim() : null;
                line = br.readLine();
                String desc = line != null ? line.trim() : null;
                line = br.readLine();
                String units1 = line != null ? line.trim() : null;
                line = br.readLine();
                String notes = line == null || line.startsWith("...") ? null : line.trim();
                GridParameter parameter = new GridParameter();
                try {
                    int p1 = Integer.parseInt(num2);
                    parameter.setNumber(p1);
                }
                catch (Exception e) {
                    logger.warn("Cant parse " + num2 + " in file " + this.path);
                }
                parameter.setName(name);
                parameter.setDescription(Util.cleanName((String)desc));
                parameter.setUnit(units1);
                result.put(parameter.getNumber(), parameter);
                if (!debug) continue;
                System.out.printf(" %s%n", parameter);
            }
            this.parameters = result;
            num2 = true;
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in GribPDSParamTable while trying to open the parameter table " + this.path + " : " + ioError);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return num2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableNcepScrape() {
        boolean bl;
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                boolean bl2 = false;
                return bl2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, GridParameter> result = new HashMap<Integer, GridParameter>();
            List params = root.getChildren("tr");
            for (Element elem1 : params) {
                List elems = elem1.getChildren("td");
                Element e1 = (Element)elems.get(0);
                String codeS = e1.getChildText("center");
                int code = Integer.parseInt(codeS);
                String desc = ((Element)elems.get(1)).getText();
                String units = ((Element)elems.get(2)).getText();
                String name = ((Element)elems.get(3)).getText();
                GridParameter parameter = new GridParameter(code, name, desc, units);
                result.put(parameter.getNumber(), parameter);
                if (!debug) continue;
                System.out.printf(" %s%n", parameter);
            }
            this.parameters = result;
            bl = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableXml() {
        boolean bl;
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                boolean bl2 = false;
                return bl2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, GridParameter> result = new HashMap<Integer, GridParameter>();
            List params = root.getChildren("parameter");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description");
                if (desc == null) continue;
                String units = elem1.getChildText("units");
                if (units == null) {
                    units = "";
                }
                String name = elem1.getChildText("shortName");
                String cf = elem1.getChildText("CF");
                GridParameter parameter = new GridParameter(code, name, desc, units, cf);
                result.put(parameter.getNumber(), parameter);
                if (!debug) continue;
                System.out.printf(" %s%n", parameter);
            }
            this.parameters = result;
            bl = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableSplit(String regexp, int[] order) {
        boolean bl;
        HashMap<Integer, GridParameter> result = new HashMap<Integer, GridParameter>();
        InputStream is = null;
        try {
            String line;
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                boolean bl2 = false;
                return bl2;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] flds = line.split(regexp);
                GridParameter parameter = new GridParameter();
                parameter.setNumber(Integer.parseInt(flds[order[0]].trim()));
                if (order[1] >= 0) {
                    parameter.setName(flds[order[1]].trim());
                }
                parameter.setDescription(Util.cleanName((String)flds[order[2]].trim()));
                if (flds.length > order[3]) {
                    parameter.setUnit(flds[order[3]].trim());
                }
                result.put(parameter.getNumber(), parameter);
                if (!debug) continue;
                System.out.printf(" %s%n", parameter);
            }
            this.parameters = result;
            bl = true;
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in GribPDSParamTable while trying to open the parameter table " + this.path + " : " + ioError);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableTab() {
        boolean line22;
        if (this.path == null) {
            logger.error("GribPDSParamTable: unknown path for " + this);
            return false;
        }
        InputStream is = null;
        try {
            String line22;
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                logger.error("GribPDSParamTable: error getInputStream on " + this);
                boolean bl = false;
                return bl;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            br.readLine();
            HashMap<Integer, GridParameter> params = new HashMap<Integer, GridParameter>();
            while ((line22 = br.readLine()) != null) {
                if (line22.length() == 0 || line22.startsWith("#")) continue;
                String[] tableDefArr = line22.split(":");
                GridParameter parameter = new GridParameter();
                parameter.setNumber(Integer.parseInt(tableDefArr[0].trim()));
                parameter.setName(tableDefArr[1].trim());
                if (tableDefArr[2].indexOf(91) == -1) {
                    parameter.setDescription(tableDefArr[2].trim());
                    parameter.setUnit(tableDefArr[2].trim());
                } else {
                    String[] arr2 = tableDefArr[2].split("\\[");
                    parameter.setDescription(arr2[0].trim());
                    parameter.setUnit(arr2[1].substring(0, arr2[1].lastIndexOf(93)).trim());
                }
                if (!parameter.getDescription().equalsIgnoreCase("undefined")) {
                    params.put(parameter.getNumber(), parameter);
                }
                if (!debug) continue;
                System.out.println(parameter.getNumber() + " " + parameter.getDescription() + " " + parameter.getUnit());
            }
            this.parameters = params;
            line22 = true;
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in GribPDSParamTable while trying to open the parameter table " + this.path + " : " + ioError);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return line22;
    }

    public static void main(String[] args) throws IOException {
        debug = true;
        GribPDSParamTable.addParameterUserLookup("C:/dev/tds4.2/thredds/grib/resources/resources/grib1/tablesOld/zagreb_221_1.tab");
    }

    static {
        tableMap = new ConcurrentHashMap<Integer, GribPDSParamTable>();
        try {
            CopyOnWriteArrayList tables = new CopyOnWriteArrayList();
            LookupTable lookup = new LookupTable();
            lookup.readLookupTable("resources/grib1/lookupTables.txt", tables);
            lookup.readLookupTable("resources/grib1/dss/lookupTables.txt", tables);
            lookup.readLookupTable("resources/grib1/ecmwf/lookupTables.txt", tables);
            lookup.readLookupTable("resources/grib1/ncep/lookupTables.txt", tables);
            paramTables = new CopyOnWriteArrayList<GribPDSParamTable>(tables);
            defaultTable = GribPDSParamTable.getParameterTable(0, -1, -1);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        strict = true;
    }

    private static class LookupTable {
        private LookupTable() {
        }

        private boolean readLookupTable(String resourceName, List<GribPDSParamTable> result) throws IOException {
            InputStream inputStream = GribResourceReader.getInputStream(resourceName);
            if (inputStream == null) {
                logger.debug("Could not open table file:" + resourceName);
                return false;
            }
            return this.readLookupTable(inputStream, resourceName, result);
        }

        private boolean readLookupTable(InputStream is, String lookupFile, List<GribPDSParamTable> result) throws IOException {
            String line;
            if (is == null) {
                return false;
            }
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String[] tableDefArr = line.split(":");
                int center = Integer.parseInt(tableDefArr[0].trim());
                int subcenter = Integer.parseInt(tableDefArr[1].trim());
                int version = Integer.parseInt(tableDefArr[2].trim());
                String filename = tableDefArr[3].trim();
                String path = filename.startsWith("/") || filename.startsWith("\\") || filename.startsWith("file:") || filename.startsWith("http://") ? filename : GribResourceReader.getFileRoot(lookupFile) + "/" + filename;
                GribPDSParamTable table = new GribPDSParamTable(center, subcenter, version, path);
                result.add(table);
            }
            is.close();
            return true;
        }
    }
}

