/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.lut;

import ucar.jpeg.colorspace.ColorSpace;
import ucar.jpeg.icc.RestrictedICCProfile;
import ucar.jpeg.icc.lut.LookUpTable32LinearSRGBtoSRGB;
import ucar.jpeg.icc.lut.LookUpTableFP;
import ucar.jpeg.icc.lut.MatrixBasedTransformException;
import ucar.jpeg.icc.tags.ICCXYZType;
import ucar.jpeg.jj2000.j2k.image.DataBlkFloat;
import ucar.jpeg.jj2000.j2k.image.DataBlkInt;

public class MatrixBasedTransformTosRGB {
    private static final String eol = System.getProperty("line.separator");
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final double SRGB00 = 3.1337;
    private static final double SRGB01 = -1.6173;
    private static final double SRGB02 = -0.4907;
    private static final double SRGB10 = -0.9785;
    private static final double SRGB11 = 1.9162;
    private static final double SRGB12 = 0.0334;
    private static final double SRGB20 = 0.072;
    private static final double SRGB21 = -0.229;
    private static final double SRGB22 = 1.4056;
    private static final int M00 = 0;
    private static final int M01 = 1;
    private static final int M02 = 2;
    private static final int M10 = 3;
    private static final int M11 = 4;
    private static final int M12 = 5;
    private static final int M20 = 6;
    private static final int M21 = 7;
    private static final int M22 = 8;
    private static final double ksRGBExponent = 0.4166666666666667;
    private static final double ksRGBScaleAfterExp = 1.055;
    private static final double ksRGBReduceAfterExp = 0.055;
    private static final double ksRGBShadowCutoff = 0.0031308;
    private static final double ksRGBShadowSlope = 12.92;
    private final double[] matrix;
    private LookUpTableFP[] fLut = new LookUpTableFP[3];
    private LookUpTable32LinearSRGBtoSRGB lut;
    private final int[] dwMaxValue;
    private final int[] dwShiftValue;
    private int dwMaxCols = 0;
    private int dwMaxRows = 0;
    private float[][] fBuf = null;

    public String toString() {
        StringBuffer rep = new StringBuffer("[MatrixBasedTransformTosRGB: ");
        StringBuffer body = new StringBuffer("  ");
        body.append(eol).append("ksRGBExponent= ").append(String.valueOf(0.4166666666666667));
        body.append(eol).append("ksRGBScaleAfterExp= ").append(String.valueOf(1.055));
        body.append(eol).append("ksRGBReduceAfterExp= ").append(String.valueOf(0.055));
        body.append(eol).append("dwMaxValues= ").append(String.valueOf(this.dwMaxValue[0])).append(", ").append(String.valueOf(this.dwMaxValue[1])).append(", ").append(String.valueOf(this.dwMaxValue[2]));
        body.append(eol).append("dwShiftValues= ").append(String.valueOf(this.dwShiftValue[0])).append(", ").append(String.valueOf(this.dwShiftValue[1])).append(", ").append(String.valueOf(this.dwShiftValue[2]));
        body.append(eol).append(eol).append("fLut= ").append(eol).append(ColorSpace.indent("  ", "fLut[RED]=  " + this.fLut[0].toString())).append(eol).append(ColorSpace.indent("  ", "fLut[GRN]=  " + this.fLut[1].toString())).append(eol).append(ColorSpace.indent("  ", "fLut[BLU]=  " + this.fLut[2].toString()));
        body.append(eol).append(eol).append("[matrix ");
        for (int i = 0; i < 3; ++i) {
            body.append(eol).append("  ");
            for (int j = 0; j < 3; ++j) {
                body.append(this.matrix[3 * i + j] + "   ");
            }
        }
        body.append("]");
        body.append(eol).append(eol).append(this.lut.toString());
        rep.append(ColorSpace.indent("  ", body)).append("]");
        return rep.append("]").toString();
    }

    public MatrixBasedTransformTosRGB(RestrictedICCProfile ricc, int[] dwMaxValue, int[] dwShiftValue) {
        if (ricc.getType() != 1) {
            throw new IllegalArgumentException("MatrixBasedTransformTosRGB: wrong type ICCProfile supplied");
        }
        this.dwMaxValue = dwMaxValue;
        this.dwShiftValue = dwShiftValue;
        for (int c = 0; c < 3; ++c) {
            this.fLut[c] = LookUpTableFP.createInstance(ricc.trc[c], dwMaxValue[c] + 1);
        }
        this.matrix = this.createMatrix(ricc, dwMaxValue);
        this.lut = LookUpTable32LinearSRGBtoSRGB.createInstance(dwMaxValue[0], dwMaxValue[0], 0.0031308, 12.92, 1.055, 0.4166666666666667, 0.055);
    }

    private double[] createMatrix(RestrictedICCProfile ricc, int[] maxValues) {
        double dfPCS00 = ICCXYZType.XYZToDouble(ricc.colorant[0].x);
        double dfPCS01 = ICCXYZType.XYZToDouble(ricc.colorant[1].x);
        double dfPCS02 = ICCXYZType.XYZToDouble(ricc.colorant[2].x);
        double dfPCS10 = ICCXYZType.XYZToDouble(ricc.colorant[0].y);
        double dfPCS11 = ICCXYZType.XYZToDouble(ricc.colorant[1].y);
        double dfPCS12 = ICCXYZType.XYZToDouble(ricc.colorant[2].y);
        double dfPCS20 = ICCXYZType.XYZToDouble(ricc.colorant[0].z);
        double dfPCS21 = ICCXYZType.XYZToDouble(ricc.colorant[1].z);
        double dfPCS22 = ICCXYZType.XYZToDouble(ricc.colorant[2].z);
        double[] matrix = new double[]{(double)maxValues[0] * (3.1337 * dfPCS00 + -1.6173 * dfPCS10 + -0.4907 * dfPCS20), (double)maxValues[0] * (3.1337 * dfPCS01 + -1.6173 * dfPCS11 + -0.4907 * dfPCS21), (double)maxValues[0] * (3.1337 * dfPCS02 + -1.6173 * dfPCS12 + -0.4907 * dfPCS22), (double)maxValues[1] * (-0.9785 * dfPCS00 + 1.9162 * dfPCS10 + 0.0334 * dfPCS20), (double)maxValues[1] * (-0.9785 * dfPCS01 + 1.9162 * dfPCS11 + 0.0334 * dfPCS21), (double)maxValues[1] * (-0.9785 * dfPCS02 + 1.9162 * dfPCS12 + 0.0334 * dfPCS22), (double)maxValues[2] * (0.072 * dfPCS00 + -0.229 * dfPCS10 + 1.4056 * dfPCS20), (double)maxValues[2] * (0.072 * dfPCS01 + -0.229 * dfPCS11 + 1.4056 * dfPCS21), (double)maxValues[2] * (0.072 * dfPCS02 + -0.229 * dfPCS12 + 1.4056 * dfPCS22)};
        return matrix;
    }

    public void apply(DataBlkInt[] inb, DataBlkInt[] outb) throws MatrixBasedTransformException {
        int[][] in = new int[3][];
        int[][] out = new int[3][];
        int nrows = inb[0].h;
        int ncols = inb[0].w;
        if (this.fBuf == null || this.fBuf[0].length < ncols * nrows) {
            this.fBuf = new float[3][ncols * nrows];
        }
        for (int c = 0; c < 3; ++c) {
            in[c] = (int[])inb[c].getData();
            out[c] = (int[])outb[c].getData();
            if (out[c] == null || out[c].length < in[c].length) {
                out[c] = new int[in[c].length];
                outb[c].setData(out[c]);
            }
            MatrixBasedTransformTosRGB.standardizeMatrixLineThroughLut(inb[c], this.fBuf[c], this.dwMaxValue[c], this.fLut[c]);
        }
        float[] ra = this.fBuf[0];
        float[] ga = this.fBuf[1];
        float[] ba = this.fBuf[2];
        int[] ro = out[0];
        int[] go = out[1];
        int[] bo = out[2];
        int[] lut32 = this.lut.lut;
        int index = 0;
        for (int y = 0; y < inb[0].h; ++y) {
            int end = index + inb[0].w;
            while (index < end) {
                double r = ra[index];
                double g = ga[index];
                double b = ba[index];
                int val = (int)(this.matrix[0] * r + this.matrix[1] * g + this.matrix[2] * b + 0.5);
                ro[index] = val < 0 ? lut32[0] : (val >= lut32.length ? lut32[lut32.length - 1] : lut32[val]);
                val = (int)(this.matrix[3] * r + this.matrix[4] * g + this.matrix[5] * b + 0.5);
                go[index] = val < 0 ? lut32[0] : (val >= lut32.length ? lut32[lut32.length - 1] : lut32[val]);
                val = (int)(this.matrix[6] * r + this.matrix[7] * g + this.matrix[8] * b + 0.5);
                bo[index] = val < 0 ? lut32[0] : (val >= lut32.length ? lut32[lut32.length - 1] : lut32[val]);
                ++index;
            }
        }
    }

    public void apply(DataBlkFloat[] inb, DataBlkFloat[] outb) throws MatrixBasedTransformException {
        float[][] in = new float[3][];
        float[][] out = new float[3][];
        int nrows = inb[0].h;
        int ncols = inb[0].w;
        if (this.fBuf == null || this.fBuf[0].length < ncols * nrows) {
            this.fBuf = new float[3][ncols * nrows];
        }
        for (int c = 0; c < 3; ++c) {
            in[c] = (float[])inb[c].getData();
            out[c] = (float[])outb[c].getData();
            if (out[c] == null || out[c].length < in[c].length) {
                out[c] = new float[in[c].length];
                outb[c].setData(out[c]);
            }
            MatrixBasedTransformTosRGB.standardizeMatrixLineThroughLut(inb[c], this.fBuf[c], (float)this.dwMaxValue[c], this.fLut[c]);
        }
        int[] lut32 = this.lut.lut;
        int index = 0;
        for (int y = 0; y < inb[0].h; ++y) {
            int end = index + inb[0].w;
            while (index < end) {
                int val = (int)(this.matrix[0] * (double)this.fBuf[0][index] + this.matrix[1] * (double)this.fBuf[1][index] + this.matrix[2] * (double)this.fBuf[2][index] + 0.5);
                out[0][index] = val < 0 ? (float)lut32[0] : (val >= lut32.length ? (float)lut32[lut32.length - 1] : (float)lut32[val]);
                val = (int)(this.matrix[3] * (double)this.fBuf[0][index] + this.matrix[4] * (double)this.fBuf[1][index] + this.matrix[5] * (double)this.fBuf[2][index] + 0.5);
                out[1][index] = val < 0 ? (float)lut32[0] : (val >= lut32.length ? (float)lut32[lut32.length - 1] : (float)lut32[val]);
                val = (int)(this.matrix[6] * (double)this.fBuf[0][index] + this.matrix[7] * (double)this.fBuf[1][index] + this.matrix[8] * (double)this.fBuf[2][index] + 0.5);
                out[2][index] = val < 0 ? (float)lut32[0] : (val >= lut32.length ? (float)lut32[lut32.length - 1] : (float)lut32[val]);
                ++index;
            }
        }
    }

    private static void standardizeMatrixLineThroughLut(DataBlkInt inb, float[] out, int dwInputMaxValue, LookUpTableFP lut) {
        int j = 0;
        int[] in = (int[])inb.getData();
        float[] lutFP = lut.lut;
        for (int y = inb.uly; y < inb.uly + inb.h; ++y) {
            for (int x = inb.ulx; x < inb.ulx + inb.w; ++x) {
                int i = inb.offset + (y - inb.uly) * inb.scanw + (x - inb.ulx);
                int wTemp = in[i] > dwInputMaxValue ? dwInputMaxValue : (in[i] < 0 ? 0 : in[i]);
                out[j++] = lutFP[wTemp];
            }
        }
    }

    private static void standardizeMatrixLineThroughLut(DataBlkFloat inb, float[] out, float dwInputMaxValue, LookUpTableFP lut) {
        int j = 0;
        float[] in = (float[])inb.getData();
        float[] lutFP = lut.lut;
        for (int y = inb.uly; y < inb.uly + inb.h; ++y) {
            for (int x = inb.ulx; x < inb.ulx + inb.w; ++x) {
                int i = inb.offset + (y - inb.uly) * inb.scanw + (x - inb.ulx);
                float wTemp = in[i] > dwInputMaxValue ? dwInputMaxValue : (in[i] < 0.0f ? 0.0f : in[i]);
                out[j++] = lutFP[(int)wTemp];
            }
        }
    }
}

