/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionManagerSingleFile;
import thredds.inventory.MFile;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribCollectionBuilder;
import ucar.nc2.grib.GribCollectionProto;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1Collection;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1GdsPredefined;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1Rectilyser;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1TimePartitionBuilder;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public class Grib1CollectionBuilder
extends GribCollectionBuilder {
    protected static final int minVersionSingle = 9;
    protected static final int version = 10;
    public static final String MAGIC_START = "Grib1CollectionIndex";
    protected GribCollection gc;
    protected Grib1Customizer cust;

    public static GribCollection readOrCreateIndexFromSingleFile(MFile file, CollectionManager.Force force, FeatureCollectionConfig.GribConfig config, Logger logger) throws IOException {
        Grib1CollectionBuilder builder = new Grib1CollectionBuilder(file, config, logger);
        builder.readOrCreateIndex(force);
        return builder.gc;
    }

    public static boolean update(CollectionManager dcm, Logger logger) throws IOException {
        Grib1CollectionBuilder builder = new Grib1CollectionBuilder(dcm, logger);
        if (!builder.needsUpdate()) {
            return false;
        }
        builder.readOrCreateIndex(CollectionManager.Force.always);
        builder.gc.close();
        return true;
    }

    public static GribCollection factory(CollectionManager dcm, CollectionManager.Force force, Logger logger) throws IOException {
        Grib1CollectionBuilder builder = new Grib1CollectionBuilder(dcm, logger);
        builder.readOrCreateIndex(force);
        return builder.gc;
    }

    public static GribCollection createFromIndex(String name, File directory, RandomAccessFile indexRaf, FeatureCollectionConfig.GribConfig config, Logger logger) throws IOException {
        Grib1CollectionBuilder builder = new Grib1CollectionBuilder(name, directory, config, logger);
        if (builder.readIndex(indexRaf)) {
            return builder.gc;
        }
        throw new IOException("Reading index failed");
    }

    public static boolean writeIndexFile(File indexFile, CollectionManager dcm, Logger logger) throws IOException {
        Grib1CollectionBuilder builder = new Grib1CollectionBuilder(dcm, logger);
        return builder.createIndex(indexFile);
    }

    private Grib1CollectionBuilder(MFile file, FeatureCollectionConfig.GribConfig config, Logger logger) throws IOException {
        super((CollectionManager)new CollectionManagerSingleFile(file, logger), true, logger);
        try {
            if (config != null) {
                this.dcm.putAuxInfo("gribConfig", (Object)config);
            }
            this.gc = new Grib1Collection(file.getName(), new File(this.dcm.getRoot()), config);
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            e.printStackTrace(new PrintStream(bos));
            logger.error("Failed to create index for single file", (Throwable)e);
            throw new IOException(e);
        }
    }

    private Grib1CollectionBuilder(CollectionManager dcm, Logger logger) {
        super(dcm, false, logger);
        FeatureCollectionConfig.GribConfig config = (FeatureCollectionConfig.GribConfig)dcm.getAuxInfo("gribConfig");
        this.gc = new Grib1Collection(dcm.getCollectionName(), new File(dcm.getRoot()), config);
    }

    private Grib1CollectionBuilder(String name, File directory, FeatureCollectionConfig.GribConfig config, Logger logger) {
        super(null, false, logger);
        this.gc = new Grib1Collection(name, directory, config);
    }

    protected Grib1CollectionBuilder(CollectionManager dcm, boolean isSingleFile, Logger logger) {
        super(dcm, isSingleFile, logger);
    }

    private void readOrCreateIndex(CollectionManager.Force ff) throws IOException {
        boolean force = ff == CollectionManager.Force.always || ff == CollectionManager.Force.test && this.needsUpdate();
        File idx = this.gc.getIndexFile();
        if (force || !idx.exists() || !this.readIndex(idx.getPath())) {
            idx = this.gc.makeNewIndexFile(this.logger);
            this.logger.info("{}: createIndex {}", (Object)this.gc.getName(), (Object)idx.getPath());
            this.createIndex(idx);
            RandomAccessFile indexRaf = new RandomAccessFile(idx.getPath(), "r");
            this.gc.setIndexRaf(indexRaf);
            this.readIndex(indexRaf);
        }
    }

    public boolean needsUpdate() {
        if (this.dcm == null) {
            return false;
        }
        File idx = this.gc.getIndexFile();
        return !idx.exists() || this.needsUpdate(idx.lastModified());
    }

    private boolean needsUpdate(long idxLastModified) {
        CollectionManager.ChangeChecker cc = GribIndex.getChangeChecker();
        for (MFile mfile : this.dcm.getFiles()) {
            if (!cc.hasChangedSince(mfile, idxLastModified)) continue;
            return true;
        }
        return false;
    }

    public boolean readIndex(String filename) throws IOException {
        return this.readIndex(new RandomAccessFile(filename, "r"));
    }

    protected boolean readIndex(RandomAccessFile raf) {
        this.gc.setIndexRaf(raf);
        try {
            int i;
            boolean versionOk;
            raf.order(0);
            raf.seek(0L);
            if (!NcStream.readAndTest((RandomAccessFile)raf, (byte[])this.getMagicStart().getBytes())) {
                this.logger.error("GribCollection {}: invalid index", (Object)this.gc.getName());
                return false;
            }
            this.gc.version = raf.readInt();
            boolean bl = this.isSingleFile ? this.gc.version >= 9 : (versionOk = this.gc.version == 10);
            if (!versionOk) {
                this.logger.warn("Grib1Collection {}: index found version={}, want version= {} on file {}", new Object[]{this.gc.getName(), this.gc.version, 10, raf.getLocation()});
                return false;
            }
            long skip = raf.readLong();
            raf.skipBytes(skip);
            int size = NcStream.readVInt((RandomAccessFile)raf);
            if (size < 0 || size > 100000000) {
                this.logger.warn("Grib1Collection {}: invalid or empty index ", (Object)this.gc.getName());
                return false;
            }
            byte[] m = new byte[size];
            raf.readFully(m);
            GribCollectionProto.GribCollectionIndex proto = GribCollectionProto.GribCollectionIndex.parseFrom(m);
            this.gc.center = proto.getCenter();
            this.gc.subcenter = proto.getSubcenter();
            this.gc.master = proto.getMaster();
            this.gc.local = proto.getLocal();
            this.gc.genProcessType = proto.getGenProcessType();
            this.gc.genProcessId = proto.getGenProcessId();
            this.gc.backProcessId = proto.getBackProcessId();
            this.gc.local = proto.getLocal();
            if (this.cust == null) {
                this.cust = Grib1Customizer.factory(this.gc.center, this.gc.subcenter, this.gc.local, null);
            }
            File dir = this.gc.getDirectory();
            String dirname = proto.getDirName();
            if (dir != null && !dir.getPath().equals(dirname)) {
                this.logger.debug("Grib1Collection {}: has different directory= {} than index= {} ", new Object[]{this.gc.getName(), dir.getPath(), dirname});
            }
            if (!(this instanceof Grib1TimePartitionBuilder)) {
                int i2;
                ArrayList<MFile> files;
                int n;
                if (this.gc.version < 10) {
                    n = proto.getFilesCount();
                    if (n == 0) {
                        this.logger.warn("Grib1Collection {}: has no files, force recreate ", (Object)this.gc.getName());
                        return false;
                    }
                    files = new ArrayList(proto.getFilesCount());
                    for (i2 = 0; i2 < n; ++i2) {
                        files.add(new GribCollectionBuilder.GcMFile(dir, proto.getFiles(i2), -1L));
                    }
                    this.gc.setFiles(files);
                    if (this.dcm != null) {
                        this.dcm.setFiles(files);
                    }
                } else {
                    n = proto.getMfilesCount();
                    if (n == 0) {
                        this.logger.warn("Grib1Collection {}: has no files, force recreate ", (Object)this.gc.getName());
                        return false;
                    }
                    files = new ArrayList<MFile>(n);
                    for (i2 = 0; i2 < n; ++i2) {
                        files.add(new GribCollectionBuilder.GcMFile(dir, proto.getMfiles(i2)));
                    }
                    this.gc.setFiles(files);
                    if (this.dcm != null) {
                        this.dcm.setFiles(files);
                    }
                }
            }
            this.gc.groups = new ArrayList<GribCollection.GroupHcs>(proto.getGroupsCount());
            for (i = 0; i < proto.getGroupsCount(); ++i) {
                this.gc.groups.add(this.readGroup(proto.getGroups(i), this.gc.makeGroup(), this.gc.center));
            }
            this.gc.groups = Collections.unmodifiableList(this.gc.groups);
            this.gc.params = new ArrayList<Parameter>(proto.getParamsCount());
            for (i = 0; i < proto.getParamsCount(); ++i) {
                this.gc.params.add(this.readParam(proto.getParams(i)));
            }
            if (!this.readPartitions(proto, dirname)) {
                this.logger.warn("Time1Partition {}: has no partitions, force recreate ", (Object)this.gc.getName());
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            this.logger.error("Error reading index " + raf.getLocation(), t);
            return false;
        }
    }

    protected boolean readPartitions(GribCollectionProto.GribCollectionIndex proto, String directory) {
        return true;
    }

    protected void readTimePartitions(GribCollection.GroupHcs group, GribCollectionProto.Group proto) {
    }

    GribCollection.GroupHcs readGroup(GribCollectionProto.Group p, GribCollection.GroupHcs group, int center) throws IOException {
        int i;
        Grib1Gds gds;
        byte[] rawGds = null;
        if (p.hasPredefinedGds()) {
            gds = Grib1GdsPredefined.factory(center, p.getPredefinedGds());
        } else {
            rawGds = p.getGds().toByteArray();
            Grib1SectionGridDefinition gdss = new Grib1SectionGridDefinition(rawGds);
            gds = gdss.getGDS();
        }
        int gdsHash = p.getGdsHash() != 0 ? p.getGdsHash() : gds.hashCode();
        group.setHorizCoordSystem(gds.makeHorizCoordSys(), rawGds, gdsHash);
        group.varIndex = new ArrayList<GribCollection.VariableIndex>();
        for (i = 0; i < p.getVariablesCount(); ++i) {
            group.varIndex.add(this.readVariable(p.getVariables(i), group));
        }
        Collections.sort(group.varIndex);
        group.timeCoords = new ArrayList<TimeCoord>(p.getTimeCoordsCount());
        for (i = 0; i < p.getTimeCoordsCount(); ++i) {
            group.timeCoords.add(this.readTimeCoord(p.getTimeCoords(i)));
        }
        group.vertCoords = new ArrayList<VertCoord>(p.getVertCoordsCount());
        for (i = 0; i < p.getVertCoordsCount(); ++i) {
            group.vertCoords.add(this.readVertCoord(p.getVertCoords(i)));
        }
        group.ensCoords = new ArrayList<EnsCoord>(p.getEnsCoordsCount());
        for (i = 0; i < p.getEnsCoordsCount(); ++i) {
            group.ensCoords.add(this.readEnsCoord(p.getEnsCoords(i)));
        }
        group.filenose = new int[p.getFilenoCount()];
        for (i = 0; i < p.getFilenoCount(); ++i) {
            group.filenose[i] = p.getFileno(i);
        }
        this.readTimePartitions(group, p);
        for (GribCollection.VariableIndex vi : group.varIndex) {
            TimeCoord tc = group.timeCoords.get(vi.timeIdx);
            vi.ntimes = tc.getSize();
            VertCoord vc = vi.vertIdx < 0 ? null : group.vertCoords.get(vi.vertIdx);
            vi.nverts = vc == null ? 0 : vc.getSize();
            EnsCoord ec = vi.ensIdx < 0 ? null : group.ensCoords.get(vi.ensIdx);
            vi.nens = ec == null ? 0 : ec.getSize();
        }
        return group;
    }

    private Parameter readParam(GribCollectionProto.Parameter pp) throws IOException {
        if (pp.hasSdata()) {
            return new Parameter(pp.getName(), pp.getSdata());
        }
        int count = 0;
        double[] vals = new double[pp.getDataCount()];
        for (double val : pp.getDataList()) {
            vals[count++] = val;
        }
        return new Parameter(pp.getName(), vals);
    }

    private TimeCoord readTimeCoord(GribCollectionProto.Coord pc) throws IOException {
        if (pc.getBoundCount() > 0) {
            ArrayList<TimeCoord.Tinv> coords = new ArrayList<TimeCoord.Tinv>(pc.getValuesCount());
            for (int i = 0; i < pc.getValuesCount(); ++i) {
                coords.add(new TimeCoord.Tinv((int)pc.getValues(i), (int)pc.getBound(i)));
            }
            TimeCoord tc = new TimeCoord(pc.getCode(), pc.getUnit(), coords);
            return tc.setIndex(pc.getIndex());
        }
        ArrayList<Integer> coords = new ArrayList<Integer>(pc.getValuesCount());
        for (float value : pc.getValuesList()) {
            coords.add((int)value);
        }
        TimeCoord tc = new TimeCoord(pc.getCode(), pc.getUnit(), coords);
        return tc.setIndex(pc.getIndex());
    }

    private VertCoord readVertCoord(GribCollectionProto.Coord pc) throws IOException {
        boolean isLayer = pc.getBoundCount() > 0;
        ArrayList<VertCoord.Level> coords = new ArrayList<VertCoord.Level>(pc.getValuesCount());
        for (int i = 0; i < pc.getValuesCount(); ++i) {
            coords.add(new VertCoord.Level(pc.getValues(i), isLayer ? (double)pc.getBound(i) : 0.0));
        }
        return new VertCoord(coords, this.cust.getVertUnit(pc.getCode()), isLayer);
    }

    private EnsCoord readEnsCoord(GribCollectionProto.Coord pc) throws IOException {
        ArrayList<EnsCoord.Coord> coords = new ArrayList<EnsCoord.Coord>(pc.getValuesCount());
        for (int i = 0; i < pc.getValuesCount(); i += 2) {
            coords.add(new EnsCoord.Coord((int)pc.getValues(i), (int)pc.getValues(i + 1)));
        }
        return new EnsCoord(coords);
    }

    protected GribCollection.VariableIndex readVariable(GribCollectionProto.Variable pv, GribCollection.GroupHcs group) {
        int discipline = pv.getDiscipline();
        int category = pv.getCategory();
        int param = pv.getParameter();
        int tableVersion = pv.getTableVersion();
        int levelType = pv.getLevelType();
        int intvType = pv.getIntervalType();
        String intvName = pv.getIntvName();
        boolean isLayer = pv.getIsLayer();
        int ensDerivedType = pv.getEnsDerivedType();
        int probType = pv.getProbabilityType();
        String probabilityName = pv.getProbabilityName();
        int cdmHash = pv.getCdmHash();
        long recordsPos = pv.getRecordsPos();
        int recordsLen = pv.getRecordsLen();
        int timeIdx = pv.getTimeIdx();
        int vertIdx = pv.getVertIdx();
        int ensIdx = pv.getEnsIdx();
        return this.gc.makeVariableIndex(group, tableVersion, discipline, category, param, levelType, isLayer, intvType, intvName, ensDerivedType, probType, probabilityName, -1, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
    }

    private boolean createIndex(File indexFile) throws IOException {
        if (this.dcm == null) {
            this.logger.error("Grib1CollectionBuilder " + this.gc.getName() + " : cannot create new index ");
            throw new IllegalStateException();
        }
        long start = System.currentTimeMillis();
        ArrayList<MFile> files = new ArrayList<MFile>();
        List<Group> groups = this.makeAggregatedGroups(files);
        this.createIndex(indexFile, groups, files);
        long took = System.currentTimeMillis() - start;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("That took {} msecs", (Object)took);
        }
        return true;
    }

    public List<Group> makeAggregatedGroups(ArrayList<MFile> files) throws IOException {
        HashMap<Integer, Group> gdsMap = new HashMap<Integer, Group>();
        Map gdsConvert = null;
        Map pdsConvert = null;
        Grib1Rectilyser.Counter stats = new Grib1Rectilyser.Counter();
        this.logger.debug("GribCollection {}: makeAggregatedGroups%n", (Object)this.gc.getName());
        int fileno = 0;
        this.logger.debug(" dcm= {}%n", (Object)this.dcm);
        FeatureCollectionConfig.GribConfig config = (FeatureCollectionConfig.GribConfig)this.dcm.getAuxInfo("gribConfig");
        if (config != null) {
            gdsConvert = config.gdsHash;
        }
        if (config != null) {
            pdsConvert = config.pdsHash;
        }
        FeatureCollectionConfig.GribIntvFilter intvMap = config != null ? config.intvFilter : null;
        for (MFile mfile : this.dcm.getFiles()) {
            Grib1Index index;
            try {
                index = (Grib1Index)GribIndex.readOrCreateIndexFromSingleFile(true, !this.isSingleFile, mfile, config, CollectionManager.Force.test, this.logger);
                files.add(mfile);
            }
            catch (IOException ioe) {
                this.logger.error("Grib1CollectionBuilder " + this.gc.getName() + " : reading/Creating gbx9 index for file " + mfile.getPath() + " failed", (Throwable)ioe);
                continue;
            }
            for (Grib1Record gr : index.getRecords()) {
                gr.setFile(fileno);
                int gdsHash = gr.getGDSsection().getGDS().hashCode();
                if (gdsConvert != null && gdsConvert.get(gdsHash) != null) {
                    gdsHash = (Integer)gdsConvert.get(gdsHash);
                }
                if (this.cust == null) {
                    this.cust = Grib1Customizer.factory(gr, null);
                }
                if (config != null) {
                    this.cust.setTimeUnitConverter(config.getTimeUnitConverter());
                }
                if (intvMap != null && this.filterOut(gr, intvMap)) {
                    ++stats.filter;
                    continue;
                }
                Group g = (Group)gdsMap.get(gdsHash);
                if (g == null) {
                    g = new Group(gr.getGDSsection(), gdsHash);
                    gdsMap.put(gdsHash, g);
                }
                g.records.add(gr);
            }
            ++fileno;
            stats.recordsTotal += index.getRecords().size();
        }
        ArrayList<Group> result = new ArrayList<Group>(gdsMap.values());
        for (Group g : result) {
            g.rect = new Grib1Rectilyser(this.cust, g.records, g.gdsHash, pdsConvert);
            g.rect.make(stats);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(stats.show());
        }
        return result;
    }

    private boolean filterOut(Grib1Record gr, FeatureCollectionConfig.GribIntvFilter intvFilter) {
        Grib1SectionProductDefinition pdss = gr.getPDSsection();
        Grib1ParamTime ptime = pdss.getParamTime(this.cust);
        if (!ptime.isInterval()) {
            return false;
        }
        int[] intv = ptime.getInterval();
        if (intv == null) {
            return false;
        }
        int haveLength = intv[1] - intv[0];
        if (haveLength == 0 && intvFilter.isZeroExcluded()) {
            return intv[0] == 0 && intv[1] == 0;
        }
        if (intvFilter.hasFilter()) {
            int center = pdss.getCenter();
            int subcenter = pdss.getSubCenter();
            int version = pdss.getTableVersion();
            int param = pdss.getParameterNumber();
            int id = (center << 8) + (subcenter << 16) + (version << 24) + param;
            return intvFilter.filterOut(id, haveLength, Integer.MIN_VALUE);
        }
        return false;
    }

    public String getMagicStart() {
        return MAGIC_START;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(File indexFile, List<Group> groups, ArrayList<MFile> files) throws IOException {
        Grib1Record first = null;
        boolean deleteOnClose = false;
        if (indexFile.exists() && !indexFile.delete()) {
            this.logger.warn(" gc1 cant delete index file {}", (Object)indexFile.getPath());
        }
        this.logger.debug(" createIndex for {}", (Object)indexFile.getPath());
        RandomAccessFile raf = new RandomAccessFile(indexFile.getPath(), "rw");
        raf.order(0);
        try {
            raf.write(this.getMagicStart().getBytes("UTF-8"));
            raf.writeInt(10);
            long lenPos = raf.getFilePointer();
            raf.writeLong(0L);
            long countBytes = 0L;
            int countRecords = 0;
            for (Group g : groups) {
                g.fileSet = new HashSet<Integer>();
                for (Grib1Rectilyser.VariableBag vb : g.rect.getGribvars()) {
                    if (first == null) {
                        first = vb.first;
                    }
                    GribCollectionProto.VariableRecords vr = this.writeRecordsProto(vb, g.fileSet);
                    byte[] b = vr.toByteArray();
                    vb.pos = raf.getFilePointer();
                    vb.length = b.length;
                    raf.write(b);
                    countBytes += (long)b.length;
                    countRecords += vb.recordMap.length;
                }
            }
            long bytesPerRecord = countBytes / (long)(countRecords == 0 ? 1 : countRecords);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  write RecordMaps: bytes = {} records = {} bytesPerRecord={}", new Object[]{countBytes, countRecords, bytesPerRecord});
            }
            if (first == null) {
                deleteOnClose = true;
                this.logger.error("GribCollection {}: has no files", (Object)this.gc.getName());
                throw new IOException("GribCollection " + this.gc.getName() + " has no files");
            }
            long pos = raf.getFilePointer();
            raf.seek(lenPos);
            raf.writeLong(countBytes);
            raf.seek(pos);
            GribCollectionProto.GribCollectionIndex.Builder indexBuilder = GribCollectionProto.GribCollectionIndex.newBuilder();
            indexBuilder.setName(this.gc.getName());
            indexBuilder.setDirName(this.gc.getDirectory().getPath());
            List<GribCollectionBuilder.GcMFile> gcmfiles = GribCollectionBuilder.makeFiles(this.gc.getDirectory(), files);
            for (GribCollectionBuilder.GcMFile gcmfile : gcmfiles) {
                indexBuilder.addMfiles(gcmfile.makeProto());
            }
            for (Group g : groups) {
                indexBuilder.addGroups(this.writeGroupProto(g));
            }
            Grib1SectionProductDefinition pds = first.getPDSsection();
            indexBuilder.setCenter(pds.getCenter());
            indexBuilder.setSubcenter(pds.getSubCenter());
            indexBuilder.setLocal(pds.getTableVersion());
            indexBuilder.setMaster(0);
            indexBuilder.setGenProcessId(pds.getGenProcess());
            GribCollectionProto.GribCollectionIndex index = indexBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt((RandomAccessFile)raf, (int)b.length);
            raf.write(b);
            this.logger.debug("  write GribCollectionIndex= {} bytes", (Object)b.length);
        }
        finally {
            this.logger.debug("  file size =  %d bytes", (Object)raf.length());
            raf.close();
            if (deleteOnClose && !indexFile.delete()) {
                this.logger.error(" gc1 cant deleteOnClose index file {}", (Object)indexFile.getPath());
            }
        }
    }

    private GribCollectionProto.VariableRecords writeRecordsProto(Grib1Rectilyser.VariableBag vb, Set<Integer> fileSet) throws IOException {
        GribCollectionProto.VariableRecords.Builder b = GribCollectionProto.VariableRecords.newBuilder();
        b.setCdmHash(vb.cdmHash);
        for (Grib1Rectilyser.Record ar : vb.recordMap) {
            GribCollectionProto.Record.Builder br = GribCollectionProto.Record.newBuilder();
            if (ar == null || ar.gr == null) {
                br.setFileno(0);
                br.setPos(0L);
                br.setMissing(true);
            } else {
                br.setFileno(ar.gr.getFile());
                fileSet.add(ar.gr.getFile());
                Grib1SectionIndicator is = ar.gr.getIs();
                br.setPos(is.getStartPos());
            }
            b.addRecords(br);
        }
        return b.build();
    }

    private GribCollectionProto.Group writeGroupProto(Group g) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        if (g.gdss.getPredefinedGridDefinition() >= 0) {
            b.setPredefinedGds(g.gdss.getPredefinedGridDefinition());
        } else {
            b.setGds(ByteString.copyFrom((byte[])g.gdss.getRawBytes()));
            b.setGdsHash(g.gdsHash);
        }
        for (Grib1Rectilyser.VariableBag vb : g.rect.getGribvars()) {
            b.addVariables(this.writeVariableProto(g.rect, vb));
        }
        List<TimeCoord> timeCoords = g.rect.getTimeCoords();
        for (int i = 0; i < timeCoords.size(); ++i) {
            b.addTimeCoords(this.writeCoordProto(timeCoords.get(i), i));
        }
        List<VertCoord> vertCoords = g.rect.getVertCoords();
        for (int i = 0; i < vertCoords.size(); ++i) {
            b.addVertCoords(this.writeCoordProto(vertCoords.get(i), i));
        }
        List<EnsCoord> ensCoords = g.rect.getEnsCoords();
        for (int i = 0; i < ensCoords.size(); ++i) {
            b.addEnsCoords(this.writeCoordProto(ensCoords.get(i), i));
        }
        for (Integer aFileSet : g.fileSet) {
            b.addFileno(aFileSet);
        }
        if (g.nameOverride != null) {
            b.setName(g.nameOverride);
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(Grib1Rectilyser rect, Grib1Rectilyser.VariableBag vb) throws IOException {
        Grib1ParamTime ptime;
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        Grib1SectionProductDefinition pds = vb.first.getPDSsection();
        b.setDiscipline(0);
        b.setCategory(0);
        b.setParameter(pds.getParameterNumber());
        b.setTableVersion(pds.getTableVersion());
        b.setLevelType(pds.getLevelType());
        b.setIsLayer(this.cust.isLayer(pds.getLevelType()));
        b.setCdmHash(vb.cdmHash);
        b.setRecordsPos(vb.pos);
        b.setRecordsLen(vb.length);
        b.setTimeIdx(vb.timeCoordIndex);
        if (vb.vertCoordIndex >= 0) {
            b.setVertIdx(vb.vertCoordIndex);
        }
        if (vb.ensCoordIndex >= 0) {
            b.setEnsIdx(vb.ensCoordIndex);
        }
        if ((ptime = pds.getParamTime(this.cust)).isInterval()) {
            b.setIntervalType(pds.getTimeRangeIndicator());
            b.setIntvName(rect.getTimeIntervalName(vb.timeCoordIndex));
        }
        return b.build();
    }

    protected GribCollectionProto.Parameter writeParamProto(Parameter param) throws IOException {
        GribCollectionProto.Parameter.Builder b = GribCollectionProto.Parameter.newBuilder();
        b.setName(param.getName());
        if (param.isString()) {
            b.setSdata(param.getStringValue());
        } else {
            for (int i = 0; i < param.getLength(); ++i) {
                b.addData(param.getNumericValue(i));
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(TimeCoord tc, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setIndex(index);
        b.setCode(tc.getCode());
        b.setUnit(tc.getUnits());
        float scale = (float)tc.getTimeUnitScale();
        if (tc.isInterval()) {
            for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                b.addValues((float)tinv.getBounds1() * scale);
                b.addBound((float)tinv.getBounds2() * scale);
            }
        } else {
            for (int value : tc.getCoords()) {
                b.addValues((float)value * scale);
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(VertCoord vc, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setIndex(index);
        b.setCode(vc.getCode());
        String units = vc.getUnits() != null ? vc.getUnits() : "";
        b.setUnit(units);
        for (VertCoord.Level coord : vc.getCoords()) {
            if (vc.isLayer()) {
                b.addValues((float)coord.getValue1());
                b.addBound((float)coord.getValue2());
                continue;
            }
            b.addValues((float)coord.getValue1());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(EnsCoord ec, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setIndex(index);
        b.setCode(0);
        b.setUnit("");
        for (EnsCoord.Coord coord : ec.getCoords()) {
            b.addValues(coord.getCode());
            b.addValues(coord.getEnsMember());
        }
        return b.build();
    }

    private class Group {
        public Grib1SectionGridDefinition gdss;
        public int gdsHash;
        public Grib1Rectilyser rect;
        public List<Grib1Record> records = new ArrayList<Grib1Record>();
        public String nameOverride;
        public Set<Integer> fileSet;

        private Group(Grib1SectionGridDefinition gdss, int gdsHash) {
            this.gdss = gdss;
            this.gdsHash = gdsHash;
        }
    }
}

