/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ucar.grib.GribNumbers;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2Tables;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2ProductDefinitionSection {
    private final int length;
    private final int section;
    private final int coordinates;
    private final int productDefinition;
    private int parameterCategory;
    private int parameterNumber;
    private int typeGenProcess;
    private int backGenProcess;
    private int analysisGenProcess;
    private int hoursAfter;
    private int minutesAfter;
    protected int timeRangeUnit;
    private int forecastTime;
    private int typeFirstFixedSurface;
    private float FirstFixedSurfaceValue;
    private int typeSecondFixedSurface;
    private float SecondFixedSurfaceValue;
    private int typeEnsemble;
    private int perturbNumber;
    private int numberForecasts;
    private int nb;
    private Date endTI;
    private int timeRanges;
    private int[] timeIncrement;
    private float lowerLimit;
    private float upperLimit;
    private final Grib2Pds pdsVars;

    public Grib2ProductDefinitionSection(RandomAccessFile raf, long refTime) throws IOException {
        long sectionEnd = raf.getFilePointer();
        this.length = GribNumbers.int4(raf);
        byte[] pdsData = new byte[this.length];
        raf.skipBytes(-4);
        raf.read(pdsData);
        this.pdsVars = Grib2Pds.factory(pdsData, refTime, Calendar.getInstance());
        raf.seek(sectionEnd + 4L);
        sectionEnd += (long)this.length;
        this.section = raf.read();
        this.coordinates = GribNumbers.int2(raf);
        this.productDefinition = GribNumbers.int2(raf);
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                this.backGenProcess = raf.read();
                this.analysisGenProcess = raf.read();
                this.hoursAfter = GribNumbers.int2(raf);
                this.minutesAfter = raf.read();
                this.timeRangeUnit = raf.read();
                this.forecastTime = GribNumbers.int4(raf) * this.calculateIncrement(this.timeRangeUnit, 1);
                this.typeFirstFixedSurface = raf.read();
                int scaleFirstFixedSurface = raf.read();
                int valueFirstFixedSurface = GribNumbers.int4(raf);
                this.FirstFixedSurfaceValue = (float)(scaleFirstFixedSurface == 0 || valueFirstFixedSurface == 0 ? (double)valueFirstFixedSurface : (double)valueFirstFixedSurface * Math.pow(10.0, -scaleFirstFixedSurface));
                this.typeSecondFixedSurface = raf.read();
                int scaleSecondFixedSurface = raf.read();
                int valueSecondFixedSurface = GribNumbers.int4(raf);
                this.SecondFixedSurfaceValue = (float)(scaleSecondFixedSurface == 0 || valueSecondFixedSurface == 0 ? (double)valueSecondFixedSurface : (double)valueSecondFixedSurface * Math.pow(10.0, -scaleSecondFixedSurface));
                try {
                    if (this.productDefinition == 1 || this.productDefinition == 11) {
                        this.typeEnsemble = raf.read();
                        this.perturbNumber = raf.read();
                        this.numberForecasts = raf.read();
                        if (this.productDefinition != 11) break;
                        raf.seek(sectionEnd);
                        break;
                    }
                    if (this.productDefinition == 2) {
                        this.typeEnsemble = raf.read();
                        this.numberForecasts = raf.read();
                        break;
                    }
                    if (this.productDefinition == 3) {
                        throw new NotSupportedException("PDS productDefinition = 3 not implemented");
                    }
                    if (this.productDefinition == 4) {
                        throw new NotSupportedException("PDS productDefinition = 4 not implemented");
                    }
                    if (this.productDefinition == 5) {
                        int probabilityNumber = raf.read();
                        this.numberForecasts = raf.read();
                        this.typeEnsemble = raf.read();
                        int scaleFactorLL = raf.read();
                        int scaleValueLL = GribNumbers.int4(raf);
                        this.lowerLimit = (float)(scaleFactorLL == 0 || scaleValueLL == 0 ? (double)scaleValueLL : (double)scaleValueLL * Math.pow(10.0, -scaleFactorLL));
                        int scaleFactorUL = raf.read();
                        int scaleValueUL = GribNumbers.int4(raf);
                        this.upperLimit = (float)(scaleFactorUL == 0 || scaleValueUL == 0 ? (double)scaleValueUL : (double)scaleValueUL * Math.pow(10.0, -scaleFactorUL));
                        break;
                    }
                    if (this.productDefinition == 6) {
                        throw new NotSupportedException("PDS productDefinition = 6 not implemented");
                    }
                    if (this.productDefinition == 7) {
                        throw new NotSupportedException("PDS productDefinition = 7 not implemented");
                    }
                    if (this.productDefinition == 8) {
                        int year = GribNumbers.int2(raf);
                        int month = raf.read() - 1;
                        int day = raf.read();
                        int hour = raf.read();
                        int minute = raf.read();
                        int second = raf.read();
                        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                        c.clear();
                        c.set(year, month, day, hour, minute, second);
                        this.endTI = c.getTime();
                        this.timeRanges = raf.read();
                        int missingDataValues = GribNumbers.int4(raf);
                        this.timeIncrement = new int[this.timeRanges * 6];
                        for (int t = 0; t < this.timeRanges; t += 6) {
                            this.timeIncrement[t] = raf.read();
                            this.timeIncrement[t + 1] = raf.read();
                            this.timeIncrement[t + 2] = raf.read();
                            this.timeIncrement[t + 3] = GribNumbers.int4(raf);
                            this.timeIncrement[t + 4] = raf.read();
                            this.timeIncrement[t + 5] = GribNumbers.int4(raf);
                        }
                        if (this.timeRanges == 1) {
                            this.forecastTime += this.calculateIncrement(this.timeIncrement[2], this.timeIncrement[3]);
                            break;
                        }
                        this.forecastTime = -9999;
                        break;
                    }
                    if (this.productDefinition != 9) break;
                    int probabilityNumber = raf.read();
                    this.numberForecasts = raf.read();
                    this.typeEnsemble = raf.read();
                    int scaleFactorLL = raf.read();
                    int scaleValueLL = GribNumbers.int4(raf);
                    this.lowerLimit = (float)(scaleFactorLL == 0 || scaleValueLL == 0 ? (double)scaleValueLL : (double)scaleValueLL * Math.pow(10.0, -scaleFactorLL));
                    int scaleFactorUL = raf.read();
                    int scaleValueUL = GribNumbers.int4(raf);
                    this.upperLimit = (float)(scaleFactorUL == 0 || scaleValueUL == 0 ? (double)scaleValueUL : (double)scaleValueUL * Math.pow(10.0, -scaleFactorUL));
                    int year = GribNumbers.int2(raf);
                    int month = raf.read() - 1;
                    int day = raf.read();
                    int hour = raf.read();
                    int minute = raf.read();
                    int second = raf.read();
                    GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    c.clear();
                    c.set(year, month, day, hour, minute, second);
                    this.endTI = c.getTime();
                    this.timeRanges = raf.read();
                    int missingDataValues = GribNumbers.int4(raf);
                    this.timeIncrement = new int[this.timeRanges * 6];
                    for (int t = 0; t < this.timeRanges; t += 6) {
                        this.timeIncrement[t] = raf.read();
                        this.timeIncrement[t + 1] = raf.read();
                        this.timeIncrement[t + 2] = raf.read();
                        this.timeIncrement[t + 3] = GribNumbers.int4(raf);
                        this.timeIncrement[t + 4] = raf.read();
                        this.timeIncrement[t + 5] = GribNumbers.int4(raf);
                    }
                    if (this.timeRanges == 1) {
                        this.forecastTime += this.calculateIncrement(this.timeIncrement[2], this.timeIncrement[3]);
                        break;
                    }
                    this.forecastTime = -9999;
                    break;
                }
                catch (NotSupportedException nse) {
                    nse.printStackTrace();
                }
            }
            case 20: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                break;
            }
            case 30: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                this.backGenProcess = raf.read();
                this.nb = raf.read();
                for (int j = 0; j < this.nb; ++j) {
                    raf.skipBytes(10);
                }
                break;
            }
            case 254: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                break;
            }
        }
        raf.seek(sectionEnd);
    }

    private int calculateIncrement(int tui, int length) {
        switch (tui) {
            case 1: {
                return length;
            }
            case 10: {
                return 3 * length;
            }
            case 11: {
                return 6 * length;
            }
            case 12: {
                return 12 * length;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                return length;
            }
        }
        return -9999;
    }

    public final int getForecastTime() {
        return this.forecastTime;
    }

    public final int getTypeFirstFixedSurface() {
        return this.typeFirstFixedSurface;
    }

    public final String getTypeFirstFixedSurfaceName() {
        return Grib2Tables.codeTable4_5(this.typeFirstFixedSurface);
    }

    public final float getValueFirstFixedSurface() {
        return this.FirstFixedSurfaceValue;
    }

    public final int getTypeSecondFixedSurface() {
        return this.typeSecondFixedSurface;
    }

    public final String getTypeSecondFixedSurfaceName() {
        return Grib2Tables.codeTable4_5(this.typeSecondFixedSurface);
    }

    public final float getValueSecondFixedSurface() {
        return this.SecondFixedSurfaceValue;
    }

    public final Date getEndTI() {
        return this.endTI;
    }

    public final int getTimeRanges() {
        return this.timeRanges;
    }

    public final int[] getTimeIncrement() {
        return this.timeIncrement;
    }

    public final int getStatProcess(int tr) {
        return this.timeIncrement[tr * 6];
    }

    public final int getTimeType(int tr) {
        return this.timeIncrement[tr * 6 + 1];
    }

    public final int getTimeUnit(int tr) {
        return this.timeIncrement[tr * 6 + 2];
    }

    public final int getLenTimeRange(int tr) {
        return this.timeIncrement[tr * 6 + 3];
    }

    public final int getIndicatorTU(int tr) {
        return this.timeIncrement[tr * 6 + 4];
    }

    public final int getTimeIncrement(int tr) {
        return this.timeIncrement[tr * 6 + 5];
    }

    public final int getNumberForecasts() {
        return this.numberForecasts;
    }

    public int getLength() {
        return this.length;
    }

    public Grib2Pds getPdsVars() {
        return this.pdsVars;
    }

    public static void main(String[] args) throws IOException {
        RandomAccessFile raf = null;
        PrintStream ps = System.out;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        raf.skipBytes(Integer.parseInt(args[1]));
        Grib2ProductDefinitionSection pds = new Grib2ProductDefinitionSection(raf, 0L);
        Grib2Pds gpv = pds.pdsVars;
        ps.println("Section = " + gpv.getSection());
        ps.println("Length = " + gpv.getLength());
        ps.println("ProductDefinition = " + gpv.getProductDefinitionTemplate());
        assert (pds.length == gpv.getLength());
        assert (pds.section == gpv.getSection());
        assert (pds.coordinates == gpv.getNumberCoordinates());
        assert (pds.productDefinition == gpv.getProductDefinitionTemplate());
        assert (pds.parameterCategory == gpv.getParameterCategory());
        assert (pds.parameterNumber == gpv.getParameterNumber());
        if (pds.productDefinition < 20) {
            assert (pds.typeGenProcess == gpv.getGenProcessType());
            assert (pds.timeRangeUnit == gpv.getTimeUnit());
            assert (pds.forecastTime == gpv.getForecastTime());
            assert (pds.typeFirstFixedSurface == gpv.getLevelType1());
            assert ((double)pds.FirstFixedSurfaceValue == gpv.getLevelValue1());
            assert (pds.typeSecondFixedSurface == gpv.getLevelType2());
            assert ((double)pds.SecondFixedSurfaceValue == gpv.getLevelValue2());
        }
        if (pds.productDefinition == 1 || pds.productDefinition == 11) {
            assert (pds.typeEnsemble == gpv.getPerturbationType());
            assert (pds.perturbNumber == gpv.getPerturbationNumber());
            assert (pds.numberForecasts == gpv.getNumberEnsembleForecasts());
        } else if (pds.productDefinition == 2) {
            assert (pds.typeEnsemble == gpv.getPerturbationType());
            assert (pds.numberForecasts == gpv.getNumberEnsembleForecasts());
        } else if (pds.productDefinition == 5) {
            assert (pds.typeEnsemble == gpv.getPerturbationType());
            assert ((double)pds.lowerLimit == gpv.getProbabilityLowerLimit());
            assert ((double)pds.upperLimit == gpv.getProbabilityUpperLimit());
        } else if (pds.productDefinition == 9) {
            assert (pds.typeEnsemble == gpv.getPerturbationType());
            assert (pds.numberForecasts == gpv.getNumberEnsembleForecasts());
            assert ((double)pds.lowerLimit == gpv.getProbabilityLowerLimit());
            assert ((double)pds.upperLimit == gpv.getProbabilityUpperLimit());
        }
    }
}

