/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib1.Grib1Iosp;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Collection
extends GribCollection {
    public Grib1Collection(String name, File directory, FeatureCollectionConfig.GribConfig dcm) {
        super(name, directory, dcm, true);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(String groupName, String filename, FeatureCollectionConfig.GribConfig gribConfig, Logger logger) throws IOException {
        GribCollection.GroupHcs want = this.findGroupById(groupName);
        if (want == null) {
            return null;
        }
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(want);
            iosp.setLookupTablePath(gribConfig.lookupTablePath);
            iosp.setParamTablePath(gribConfig.paramTablePath);
            iosp.setParamTable(gribConfig.paramTable);
            GribCollection.GcNetcdfFile ncfile = new GribCollection.GcNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollection gc = Grib1CollectionBuilder.readOrCreateIndexFromSingleFile(wantFile, CollectionManager.Force.nocheck, gribConfig, logger);
            Grib1Iosp iosp = new Grib1Iosp(gc);
            iosp.setLookupTablePath(gribConfig.lookupTablePath);
            iosp.setParamTablePath(gribConfig.paramTablePath);
            iosp.setParamTable(gribConfig.paramTable);
            GribCollection.GcNetcdfFile ncfile = new GribCollection.GcNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        return null;
    }

    @Override
    public GridDataset getGridDataset(String groupName, String filename, FeatureCollectionConfig.GribConfig gribConfig, Logger logger) throws IOException {
        GribCollection.GroupHcs want = this.findGroupById(groupName);
        if (want == null) {
            return null;
        }
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(want);
            iosp.setLookupTablePath(gribConfig.lookupTablePath);
            iosp.setParamTablePath(gribConfig.paramTablePath);
            iosp.setParamTable(gribConfig.paramTable);
            GribCollection.GcNetcdfFile ncfile = new GribCollection.GcNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollection gc = Grib1CollectionBuilder.readOrCreateIndexFromSingleFile(wantFile, CollectionManager.Force.nocheck, gribConfig, logger);
            Grib1Iosp iosp = new Grib1Iosp(gc);
            iosp.setLookupTablePath(gribConfig.lookupTablePath);
            iosp.setParamTablePath(gribConfig.paramTablePath);
            iosp.setParamTable(gribConfig.paramTable);
            GribCollection.GcNetcdfFile ncfile = new GribCollection.GcNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        return null;
    }

    public static void make(String name, String spec, Logger logger) throws IOException {
        long start = System.currentTimeMillis();
        Formatter f = new Formatter();
        MFileCollectionManager dcm = new MFileCollectionManager(name, spec, f, null);
        File idxFile = new File(dcm.getRoot(), name);
        boolean ok = Grib1CollectionBuilder.writeIndexFile(idxFile, (CollectionManager)dcm, logger);
        System.out.printf("GribCollectionBuilder.writeIndexFile ok = %s%n", ok);
        long took = System.currentTimeMillis() - start;
        System.out.printf("%s%n", f);
        System.out.printf("That took %d msecs%n", took);
    }

    public static void main(String[] args) throws IOException {
        Logger logger = LoggerFactory.getLogger(Grib1Collection.class);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-help")) {
                System.out.printf("usage: ucar.nc2.grib.GribCollection [-make name collSpec] [-read filename]%n", new Object[0]);
                break;
            }
            if (arg.equalsIgnoreCase("-make")) {
                Grib1Collection.make(args[i + 1], args[i + 2], logger);
                break;
            }
            if (!arg.equalsIgnoreCase("-read")) continue;
            File f = new File(args[i + 1]);
            RandomAccessFile raf = new RandomAccessFile(f.getPath(), "r");
            GribCollection gc = Grib1CollectionBuilder.createFromIndex(f.getName(), f.getParentFile(), raf, null, logger);
            gc.showIndex(new Formatter(System.out));
            break;
        }
    }
}

