/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

public class Grib2Rectilyser {
    private static final Logger logger = LoggerFactory.getLogger(Grib2CollectionBuilder.class);
    private final Grib2Customizer cust;
    private final int gdsHash;
    private final boolean intvMerge;
    private final boolean useGenType;
    private final boolean useTableVersion;
    private final List<Grib2Record> records;
    private List<VariableBag> gribvars;
    private final List<TimeCoord> timeCoords = new ArrayList<TimeCoord>();
    private final List<VertCoord> vertCoords = new ArrayList<VertCoord>();
    private final List<EnsCoord> ensCoords = new ArrayList<EnsCoord>();
    List<MFile> files = null;

    public Grib2Rectilyser(Grib2Customizer cust, List<Grib2Record> records, int gdsHash, Map<String, Boolean> pdsHash) {
        this.cust = cust;
        this.records = records;
        this.gdsHash = gdsHash;
        this.intvMerge = this.assignValue(pdsHash, "intvMerge", true);
        this.useTableVersion = this.assignValue(pdsHash, "useTableVersion", true);
        this.useGenType = this.assignValue(pdsHash, "useGenType", false);
    }

    private boolean assignValue(Map<String, Boolean> pdsHash, String key, boolean value) {
        Boolean b;
        if (pdsHash != null && (b = pdsHash.get(key)) != null) {
            value = b;
        }
        return value;
    }

    public List<Grib2Record> getRecords() {
        return this.records;
    }

    public List<VariableBag> getGribvars() {
        return this.gribvars;
    }

    public List<TimeCoord> getTimeCoords() {
        return this.timeCoords;
    }

    public List<VertCoord> getVertCoords() {
        return this.vertCoords;
    }

    public List<EnsCoord> getEnsCoords() {
        return this.ensCoords;
    }

    public void make(Counter counter, List<MFile> files) throws IOException {
        this.files = files;
        HashMap<Integer, VariableBag> vbHash = new HashMap<Integer, VariableBag>(100);
        for (Grib2Record gr : this.records) {
            int cdmHash = this.cdmVariableHash(gr, this.gdsHash);
            VariableBag bag = (VariableBag)vbHash.get(cdmHash);
            if (bag == null) {
                bag = new VariableBag(gr, cdmHash);
                vbHash.put(cdmHash, bag);
            }
            bag.atomList.add(new Record(gr));
        }
        this.gribvars = new ArrayList(vbHash.values());
        Collections.sort(this.gribvars);
        for (VariableBag vb : this.gribvars) {
            this.setTimeUnit(vb);
            TimeCoord use = null;
            if (vb.first.getPDS().isTimeInterval()) {
                use = this.makeTimeCoordsIntv(vb);
            } else {
                boolean isUniform = this.checkTimeCoordsUniform(vb);
                use = this.makeTimeCoords(vb, isUniform);
            }
            vb.timeCoordIndex = TimeCoord.findCoord(this.timeCoords, use);
        }
        for (VariableBag vb : this.gribvars) {
            VertCoord vc = this.makeVertCoord(vb);
            if (!vc.isVertDimensionUsed()) continue;
            vb.vertCoordIndex = VertCoord.findCoord(this.vertCoords, vc);
        }
        for (VariableBag vb : this.gribvars) {
            EnsCoord ec = this.makeEnsCoord(vb);
            if (ec == null) continue;
            vb.ensCoordIndex = EnsCoord.findCoord(this.ensCoords, ec);
        }
        int tot_used = 0;
        int tot_dups = 0;
        for (VariableBag vb : this.gribvars) {
            TimeCoord tc = this.timeCoords.get(vb.timeCoordIndex);
            VertCoord vc = vb.vertCoordIndex < 0 ? null : this.vertCoords.get(vb.vertCoordIndex);
            EnsCoord ec = vb.ensCoordIndex < 0 ? null : this.ensCoords.get(vb.ensCoordIndex);
            int ntimes = tc.getSize();
            int nverts = vc == null ? 1 : vc.getSize();
            int nens = ec == null ? 1 : ec.getSize();
            vb.recordMap = new Record[ntimes * nverts * nens];
            for (Record r : vb.atomList) {
                int ensIdx;
                int vertIdx;
                int timeIdx;
                int n = timeIdx = r.tcIntvCoord != null ? r.tcIntvCoord.index : tc.findIdx(r.tcCoord);
                if (timeIdx < 0) {
                    timeIdx = r.tcIntvCoord != null ? r.tcIntvCoord.index : tc.findIdx(r.tcCoord);
                    throw new IllegalStateException("Cant find time coord " + r.tcCoord);
                }
                int n2 = vertIdx = vb.vertCoordIndex < 0 ? 0 : vc.findIdx(r.vcCoord);
                if (vertIdx < 0) {
                    vertIdx = vc.findIdx(r.vcCoord);
                    throw new IllegalStateException("Cant find vert coord " + r.vcCoord);
                }
                int n3 = ensIdx = vb.ensCoordIndex < 0 ? 0 : ec.findIdx(r.ecCoord);
                if (ensIdx < 0) {
                    ensIdx = ec.findIdx(r.ecCoord);
                    throw new IllegalStateException("Cant find ens coord " + r.ecCoord);
                }
                int index = GribCollection.calcIndex(timeIdx, ensIdx, vertIdx, nens, nverts);
                if (vb.recordMap[index] != null) {
                    ++tot_dups;
                } else {
                    ++tot_used;
                }
                vb.recordMap[index] = r;
            }
        }
        counter.recordsUnique += tot_used;
        counter.dups += tot_dups;
        counter.vars += this.gribvars.size();
    }

    private VertCoord makeVertCoord(VariableBag vb) {
        Grib2Pds pdsFirst = vb.first.getPDS();
        VertCoord.VertUnit vertUnit = Grib2Utils.getLevelUnit(pdsFirst.getLevelType1());
        boolean isLayer = Grib2Utils.isLayer(vb.first);
        HashSet<VertCoord.Level> coords = new HashSet<VertCoord.Level>();
        for (Record r : vb.atomList) {
            Grib2Pds pds = r.gr.getPDS();
            r.vcCoord = new VertCoord.Level(pds.getLevelValue1(), pds.getLevelValue2());
            coords.add(r.vcCoord);
        }
        ArrayList<VertCoord.Level> vlist = new ArrayList<VertCoord.Level>(coords);
        Collections.sort(vlist);
        if (!vertUnit.isPositiveUp()) {
            Collections.reverse(vlist);
        }
        return new VertCoord(vlist, vertUnit, isLayer);
    }

    private EnsCoord makeEnsCoord(VariableBag vb) {
        if (!vb.first.getPDS().isEnsemble()) {
            return null;
        }
        HashSet<EnsCoord.Coord> coords = new HashSet<EnsCoord.Coord>();
        for (Record r : vb.atomList) {
            Grib2Pds.PdsEnsemble pds = (Grib2Pds.PdsEnsemble)((Object)r.gr.getPDS());
            r.ecCoord = new EnsCoord.Coord(pds.getPerturbationType(), pds.getPerturbationNumber());
            coords.add(r.ecCoord);
        }
        ArrayList<EnsCoord.Coord> elist = new ArrayList<EnsCoord.Coord>(coords);
        Collections.sort(elist);
        return new EnsCoord(elist);
    }

    private CalendarPeriod convertTimeDuration(int timeUnit) {
        return Grib2Utils.getCalendarPeriod(this.cust.convertTimeUnit(timeUnit));
    }

    private void setTimeUnit(VariableBag vb) {
        Record first = vb.atomList.get(0);
        Grib2Pds pds = first.gr.getPDS();
        int unit = this.cust.convertTimeUnit(pds.getTimeUnit());
        vb.timeUnit = Grib2Utils.getCalendarPeriod(unit);
    }

    private boolean checkTimeCoordsUniform(VariableBag vb) {
        boolean isUniform = true;
        CalendarDate refDate = null;
        int timeUnit = -1;
        boolean timeUnitOk = true;
        for (Record r : vb.atomList) {
            int offset;
            CalendarDate date2;
            Grib2Pds pds = r.gr.getPDS();
            int unit = this.cust.convertTimeUnit(pds.getTimeUnit());
            if (timeUnit < 0) {
                timeUnit = unit;
            } else if (unit != timeUnit) {
                isUniform = false;
            }
            CalendarDate cd = r.gr.getReferenceDate();
            if (refDate == null) {
                refDate = cd;
            } else if (!cd.equals((Object)refDate)) {
                isUniform = false;
                if (cd.compareTo(refDate) < 0) {
                    refDate = cd;
                }
            }
            int time = pds.getForecastTime();
            CalendarDate date1 = cd.add(Grib2Utils.getCalendarPeriod(unit).multiply(time));
            if (date1.equals((Object)(date2 = refDate.add(vb.timeUnit.multiply(offset = TimeCoord.getOffset(refDate, date1, vb.timeUnit)))))) continue;
            timeUnitOk = false;
        }
        if (!timeUnitOk) {
            timeUnit = 0;
        }
        vb.timeUnit = Grib2Utils.getCalendarPeriod(timeUnit);
        vb.refDate = refDate;
        return isUniform;
    }

    private TimeCoord makeTimeCoords(VariableBag vb, boolean uniform) {
        HashSet<Integer> times = new HashSet<Integer>();
        for (Record r : vb.atomList) {
            Grib2Pds pds = r.gr.getPDS();
            int time = pds.getForecastTime();
            CalendarPeriod duration = this.convertTimeDuration(pds.getTimeUnit());
            if (uniform) {
                r.tcCoord = time;
            } else {
                CalendarDate refDate = r.gr.getReferenceDate();
                CalendarDate date = refDate.add(duration.multiply(time));
                r.tcCoord = TimeCoord.getOffset(vb.refDate, date, vb.timeUnit);
            }
            times.add(r.tcCoord);
        }
        ArrayList tlist = new ArrayList(times);
        Collections.sort(tlist);
        return new TimeCoord(0, vb.refDate, vb.timeUnit, tlist);
    }

    private TimeCoord makeTimeCoordsIntv(VariableBag vb) {
        int timeIntvCode = 999;
        HashMap<Integer, TimeCoord.TinvDate> times = new HashMap<Integer, TimeCoord.TinvDate>();
        for (Record r : vb.atomList) {
            TimeCoord.TinvDate mine;
            TimeCoord.TinvDate org;
            Grib2Pds pds = r.gr.getPDS();
            if (timeIntvCode == 999) {
                timeIntvCode = pds.getStatisticalProcessType();
            }
            if ((org = (TimeCoord.TinvDate)times.get((mine = this.cust.getForecastTimeInterval(r.gr)).hashCode())) == null) {
                times.put(mine.hashCode(), mine);
            }
            r.tcIntvCoord = org == null ? mine : org;
        }
        ArrayList tlist = new ArrayList(times.values());
        Collections.sort(tlist);
        return new TimeCoord(timeIntvCode, vb.refDate, vb.timeUnit, tlist);
    }

    public void dump(Formatter f, Grib2Customizer tables) {
        Object coord;
        int i;
        f.format("%nTime Coordinates%n", new Object[0]);
        for (i = 0; i < this.timeCoords.size(); ++i) {
            TimeCoord time = this.timeCoords.get(i);
            f.format("  %d: (%d) %s%n", i, time.getSize(), time);
        }
        f.format("%nVert Coordinates%n", new Object[0]);
        for (i = 0; i < this.vertCoords.size(); ++i) {
            coord = this.vertCoords.get(i);
            f.format("  %d: (%d) %s%n", i, ((VertCoord)coord).getSize(), coord);
        }
        f.format("%nEns Coordinates%n", new Object[0]);
        for (i = 0; i < this.ensCoords.size(); ++i) {
            coord = this.ensCoords.get(i);
            f.format("  %d: (%d) %s%n", i, ((EnsCoord)coord).getSize(), coord);
        }
        f.format("%nVariables%n", new Object[0]);
        f.format("%n  %3s %3s %3s%n", "time", "vert", "ens");
        for (VariableBag vb : this.gribvars) {
            String vname = tables.getVariableName(vb.first);
            f.format("  %3d %3d %3d %s records = %d density = %d/%d hash=%d", vb.timeCoordIndex, vb.vertCoordIndex, vb.ensCoordIndex, vname, vb.atomList.size(), vb.countDensity(), vb.recordMap.length, vb.cdmHash);
            if (vb.countDensity() != vb.recordMap.length) {
                f.format(" HEY!!", new Object[0]);
            }
            f.format("%n", new Object[0]);
        }
    }

    public int cdmVariableHash(Grib2Record gr, int gdsHash) {
        Grib2SectionGridDefinition gdss = gr.getGDSsection();
        Grib2Pds pds2 = gr.getPDS();
        int result = 17;
        result = gdsHash == 0 ? (result += result * 37 + gdss.getGDS().hashCode()) : (result += result * 37 + gdsHash);
        result += result * 37 + gr.getDiscipline();
        result += result * 37 + pds2.getLevelType1();
        if (Grib2Utils.isLayer(gr)) {
            result += result * 37 + 1;
        }
        result += result * 37 + pds2.getParameterCategory();
        result += result * 37 + pds2.getTemplateNumber();
        if (pds2.isTimeInterval()) {
            if (!this.intvMerge) {
                double size;
                block13: {
                    size = 0.0;
                    try {
                        size = this.cust.getForecastTimeIntervalSizeInHours(gr);
                    }
                    catch (Throwable t) {
                        logger.error("bad", t);
                        if (this.files == null) break block13;
                        logger.error("Failed on file = " + this.files.get(gr.getFile()));
                    }
                }
                result += result * (int)(37.0 + 1000.0 * size);
            }
            result += result * 37 + pds2.getStatisticalProcessType();
        }
        if (pds2.isSpatialInterval()) {
            result += result * 37 + pds2.getStatisticalProcessType();
        }
        result += result * 37 + pds2.getParameterNumber();
        int ensDerivedType = -1;
        if (pds2.isEnsembleDerived()) {
            Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
            ensDerivedType = pdsDerived.getDerivedForecastType();
            result += result * 37 + ensDerivedType;
        } else if (pds2.isEnsemble()) {
            result += result * 37 + 1;
        }
        int probType = -1;
        if (pds2.isProbability()) {
            Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds2);
            probType = pdsProb.getProbabilityType();
            result += result * 37 + pdsProb.getProbabilityHashcode();
        }
        if (pds2.getParameterCategory() > 191 || pds2.getParameterNumber() > 191 || pds2.getLevelType1() > 191 || pds2.isTimeInterval() && pds2.getStatisticalProcessType() > 191 || ensDerivedType > 191 || probType > 191) {
            Grib2SectionIdentification id = gr.getId();
            result += result * 37 + id.getCenter_id();
            if (id.getSubcenter_id() > 0) {
                result += result * 37 + id.getSubcenter_id();
            }
        }
        int genType = pds2.getGenProcessType();
        if (this.useGenType || genType == 6 || genType == 7) {
            result += result * 37 + genType;
        }
        return result;
    }

    public String getTimeIntervalName(int timeIdx) {
        TimeCoord tc = this.timeCoords.get(timeIdx);
        return tc.getTimeIntervalName();
    }

    public class VariableBag
    implements Comparable<VariableBag> {
        Grib2Record first;
        int cdmHash;
        List<Record> atomList = new ArrayList<Record>(100);
        int timeCoordIndex = -1;
        int vertCoordIndex = -1;
        int ensCoordIndex = -1;
        CalendarDate refDate;
        CalendarPeriod timeUnit;
        Record[] recordMap;
        long pos;
        int length;

        private VariableBag(Grib2Record first, int cdmHash) {
            this.first = first;
            this.cdmHash = cdmHash;
        }

        @Override
        public int compareTo(VariableBag o) {
            return Grib2Utils.getVariableName(this.first).compareTo(Grib2Utils.getVariableName(o.first));
        }

        int countDensity() {
            int count = 0;
            for (Record r : this.recordMap) {
                if (r == null) continue;
                ++count;
            }
            return count;
        }
    }

    public class Record {
        Grib2Record gr;
        int tcCoord;
        TimeCoord.TinvDate tcIntvCoord;
        VertCoord.Level vcCoord;
        EnsCoord.Coord ecCoord;

        private Record(Grib2Record gr) {
            this.gr = gr;
        }
    }

    public static class Counter {
        public int recordsTotal;
        public int recordsUnique;
        public int dups;
        public int filter;
        public int vars;

        public String show() {
            Formatter f = new Formatter();
            float dupPercent = (float)this.dups / (float)(this.recordsTotal - this.filter);
            f.format(" Rectilyser2: nvars=%d records total=%d filtered=%d unique=%d dups=%d (%f)%n", this.vars, this.recordsTotal, this.filter, this.recordsUnique, this.dups, Float.valueOf(dupPercent));
            return f.toString();
        }
    }
}

