/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Misc;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public abstract class PartitionCollection
extends GribCollection {
    private static FileCache partitionCache;
    private static final FileFactory collectionFactory;
    protected final Logger logger;
    protected List<Partition> partitions;
    protected boolean isPartitionOfPartitions;
    int[] run2part;

    public static void initPartitionCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        partitionCache = new FileCache("TimePartitionCache", minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static FileCache getPartitionCache() {
        return partitionCache;
    }

    public static void disableNetcdfFileCache() {
        if (null != partitionCache) {
            partitionCache.disable();
        }
        partitionCache = null;
    }

    public boolean isPartitionOfPartitions() {
        return this.isPartitionOfPartitions;
    }

    protected PartitionCollection(String name, File directory, FeatureCollectionConfig config, boolean isGrib1, Logger logger) {
        super(name, directory, config, isGrib1);
        this.logger = logger;
        this.partitions = new ArrayList<Partition>();
        this.datasets = new ArrayList();
    }

    public GribCollection.VariableIndex getVariable2DByHash(GribCollection.HorizCoordSys hcs, int cdmHash) {
        GribCollection.Dataset ds2d = this.getDataset2D();
        if (ds2d == null) {
            return null;
        }
        for (GribCollection.GroupGC groupHcs : ds2d.getGroups()) {
            if (groupHcs.horizCoordSys != hcs) continue;
            return groupHcs.findVariableByHash(cdmHash);
        }
        return null;
    }

    private GribCollection.Dataset getDataset2D() {
        for (GribCollection.Dataset ds : this.datasets) {
            if (!ds.isTwoD()) continue;
            return ds;
        }
        return null;
    }

    @Override
    public List<String> getFilenames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Partition p : this.getPartitions()) {
            if (p.isBad()) continue;
            result.add(p.getIndexFilenameInCache());
        }
        return result;
    }

    public Partition addPartition(String name, String filename, long lastModified, String directory) {
        Partition partition = new Partition(name, filename, lastModified, directory);
        this.partitions.add(partition);
        return partition;
    }

    public void addPartition(MCollection dcm) {
        Partition partition = new Partition(dcm);
        this.partitions.add(partition);
    }

    public void sortPartitions() {
        Collections.sort(this.partitions);
        this.partitions = Collections.unmodifiableList(this.partitions);
    }

    public VariableIndexPartitioned makeVariableIndexPartitioned(GribCollection.GroupGC group, GribCollection.VariableIndex from, int nparts) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(group, from, nparts);
        group.addVariable(vip);
        if (from instanceof VariableIndexPartitioned && !this.isPartitionOfPartitions) {
            VariableIndexPartitioned fromp = (VariableIndexPartitioned)from;
            for (PartitionForVariable2D pv : fromp.partList) {
                vip.addPartition(pv);
            }
        }
        return vip;
    }

    public Iterable<Partition> getPartitions() {
        return this.partitions;
    }

    public Partition getPartition(int idx) {
        return this.partitions.get(idx);
    }

    public Partition getPartitionByName(String name) {
        for (Partition p : this.partitions) {
            if (!p.name.equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public int getPartitionSize() {
        return this.partitions.size();
    }

    public List<Partition> getPartitionsSorted() {
        ArrayList<Partition> c = new ArrayList<Partition>(this.partitions);
        Collections.sort(c);
        if (!this.config.gribConfig.filesSortIncreasing.booleanValue()) {
            Collections.reverse(c);
        }
        return c;
    }

    public void removePartition(Partition p) {
        this.partitions.remove(p);
    }

    public GribCollection getLatestGribCollection(List<String> paths) throws IOException {
        Partition last = this.partitions.get(this.partitions.size() - 1);
        paths.add(last.getName());
        GribCollection gc = last.getGribCollection();
        if (gc instanceof PartitionCollection) {
            PartitionCollection pc = (PartitionCollection)gc;
            GribCollection result = pc.getLatestGribCollection(paths);
            gc.close();
            return result;
        }
        return gc;
    }

    @Override
    public void showIndex(Formatter f) {
        super.showIndex(f);
        int count = 0;
        f.format("Partitions%n", new Object[0]);
        for (Partition p : this.getPartitions()) {
            f.format("%d:  %s%n", count++, p);
        }
        f.format("%n", new Object[0]);
        if (this.run2part == null) {
            f.format("run2part null%n", new Object[0]);
        } else {
            f.format(" master runtime -> partition %n", new Object[0]);
            count = 0;
            for (CalendarDate cd : this.masterRuntime.getRuntimesSorted()) {
                int partno = this.run2part[count];
                Partition part = this.getPartition(partno);
                f.format(" %d:  %s -> part %3d %s%n", count, cd, this.run2part[count], part);
                ++count;
            }
            f.format("%n", new Object[0]);
        }
    }

    public RandomAccessFile getRaf(int partno, int fileno) throws IOException {
        Partition part = this.getPartition(partno);
        try (GribCollection gc = part.getGribCollection();){
            RandomAccessFile randomAccessFile = gc.getDataRaf(fileno);
            return randomAccessFile;
        }
    }

    static {
        collectionFactory = new FileFactory(){

            public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                RandomAccessFile raf = new RandomAccessFile(location, "r");
                Partition p = (Partition)iospMessage;
                return GribCdmIndex.openGribCollectionFromIndexFile(raf, p.getConfig(), true, p.getLogger());
            }
        };
    }

    public class Partition
    implements Comparable<Partition> {
        private final String name;
        private final String directory;
        private final String filename;
        private long lastModified;
        private boolean isBad;
        private MCollection dcm;

        public Partition(String name, String filename, long lastModified, String directory) {
            this.name = name;
            this.filename = filename;
            this.lastModified = lastModified;
            this.directory = directory;
        }

        public String getName() {
            return this.name;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getDirectory() {
            return this.directory;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean isBad() {
            return this.isBad;
        }

        public void setBad(boolean isBad) {
            this.isBad = isBad;
        }

        public boolean isGrib1() {
            return PartitionCollection.this.isGrib1;
        }

        public FeatureCollectionConfig getConfig() {
            return PartitionCollection.this.config;
        }

        public Logger getLogger() {
            return PartitionCollection.this.logger;
        }

        public MCollection getDcm() {
            return this.dcm;
        }

        public String getIndexFilenameInCache() {
            File file = new File(this.directory, this.filename);
            File existingFile = GribCollection.getExistingFileOrCache(file.getPath());
            if (existingFile == null) {
                GribCollection.getExistingFileOrCache(file.getPath());
                return null;
            }
            return existingFile.getPath();
        }

        public GribCollection getGribCollection() throws IOException {
            String path = this.getIndexFilenameInCache();
            if (path == null) {
                if (GribIosp.debugIndexOnly) {
                    File orgParentDir = new File(this.directory);
                    File currentFile = new File(PartitionCollection.this.indexFilename);
                    File currentParent = currentFile.getParentFile();
                    File currentParentWithDir = new File(currentParent, orgParentDir.getName());
                    File nestedIndex = PartitionCollection.this.isPartitionOfPartitions ? new File(currentParentWithDir, this.filename) : new File(currentParent, this.filename);
                    path = nestedIndex.getPath();
                } else {
                    throw new FileNotFoundException("No index filename for partition= " + this.toString());
                }
            }
            GribCollection result = partitionCache != null ? (GribCollection)partitionCache.acquire(collectionFactory, (Object)path, path, -1, null, (Object)this) : (GribCollection)collectionFactory.open(path, -1, null, (Object)this);
            return result;
        }

        @Override
        public int compareTo(Partition o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "Partition{dcm=" + this.dcm + ", name='" + this.name + '\'' + ", directory='" + this.directory + '\'' + ", filename='" + this.filename + '\'' + ", lastModified='" + CalendarDate.of((long)this.lastModified) + '\'' + ", isBad=" + this.isBad + '}';
        }

        public Partition(MCollection dcm) {
            this.dcm = dcm;
            this.name = dcm.getCollectionName();
            this.lastModified = dcm.getLastModified();
            this.directory = StringUtil2.replace((String)dcm.getRoot(), (char)'\\', (String)"/");
            String indexFilename = StringUtil2.replace((String)dcm.getIndexFilename(), (char)'\\', (String)"/");
            if (indexFilename.startsWith(this.directory) && (indexFilename = indexFilename.substring(this.directory.length())).startsWith("/")) {
                indexFilename = indexFilename.substring(1);
            }
            this.filename = indexFilename;
            FeatureCollectionConfig config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
            if (config == null) {
                PartitionCollection.this.logger.warn("HEY Partition missing a FeatureCollectionConfig {}", (Object)dcm);
            }
        }

        public GribCollection makeGribCollection(CollectionUpdateType force) throws IOException {
            return GribCdmIndex.openGribCollectionFromMCollection(PartitionCollection.this.isGrib1, this.dcm, force, null, PartitionCollection.this.logger);
        }
    }

    class DataRecord
    extends GribIosp.DataRecord {
        PartitionCollection usePartition;
        int partno;

        DataRecord(PartitionCollection usePartition, int partno, GdsHorizCoordSys hcs, int fileno, long drsPos, long bmsPos, int scanMode) {
            super(-1, fileno, drsPos, bmsPos, scanMode, hcs);
            this.usePartition = usePartition;
            this.partno = partno;
        }

        @Override
        public int compareTo(GribIosp.DataRecord o) {
            DataRecord op = (DataRecord)o;
            int rp = this.usePartition.getName().compareTo(op.usePartition.getName());
            if (rp != 0) {
                return rp;
            }
            int r = Misc.compare((int)this.partno, (int)op.partno);
            if (r != 0) {
                return r;
            }
            r = Misc.compare((int)this.fileno, (int)o.fileno);
            if (r != 0) {
                return r;
            }
            return Misc.compare((long)this.dataPos, (long)o.dataPos);
        }

        public boolean usesSameFile(DataRecord o) {
            if (o == null) {
                return false;
            }
            int rp = this.usePartition.getName().compareTo(o.usePartition.getName());
            if (rp != 0) {
                return false;
            }
            int r = Misc.compare((int)this.partno, (int)o.partno);
            if (r != 0) {
                return false;
            }
            r = Misc.compare((int)this.fileno, (int)o.fileno);
            return r == 0;
        }
    }

    public class VariableIndexPartitioned
    extends GribCollection.VariableIndex {
        private List<PartitionForVariable2D> partList;

        VariableIndexPartitioned(GribCollection.GroupGC g, GribCollection.VariableIndex other, int nparts) {
            super(g, other);
            this.partList = new ArrayList<PartitionForVariable2D>(nparts);
        }

        public void addPartition(int partno, int groupno, int varno, int flag, int ndups, int nrecords, int missing, float density) {
            PartitionForVariable2D partVar = new PartitionForVariable2D();
            partVar.partno = partno;
            partVar.groupno = groupno;
            partVar.varno = varno;
            partVar.flag = flag;
            partVar.density = density;
            partVar.ndups = ndups;
            partVar.missing = missing;
            partVar.nrecords = nrecords;
            this.ndups += partVar.ndups;
            this.missing += partVar.missing;
            this.nrecords += partVar.nrecords;
            this.partList.add(partVar);
        }

        public void addPartition(int partno, int groupno, int varno, int flag, GribCollection.VariableIndex vi) {
            this.addPartition(partno, groupno, varno, flag, vi.ndups, vi.nrecords, vi.missing, vi.density);
        }

        public void addPartition(PartitionForVariable2D pv) {
            this.addPartition(pv.partno, pv.groupno, pv.varno, pv.flag, pv.ndups, pv.nrecords, pv.missing, pv.density);
        }

        public Iterable<PartitionForVariable2D> getPartitionsForVariable() {
            return this.partList;
        }

        public PartitionForVariable2D getPartitionsForVariable(int idx) {
            return this.partList.get(idx);
        }

        @Override
        public String toStringComplete() {
            Formatter sb = new Formatter();
            sb.format("VariableIndexPartitioned%n", new Object[0]);
            sb.format(" partno=", new Object[0]);
            for (PartitionForVariable2D partVar : this.partList) {
                sb.format("%d,", partVar.partno);
            }
            sb.format("%n groupno=", new Object[0]);
            for (PartitionForVariable2D partVar : this.partList) {
                sb.format("%d,", partVar.groupno);
            }
            sb.format("%n varno=", new Object[0]);
            for (PartitionForVariable2D partVar : this.partList) {
                sb.format("%d,", partVar.varno);
            }
            sb.format("%n flags=", new Object[0]);
            for (PartitionForVariable2D partVar : this.partList) {
                sb.format("%d,", partVar.flag);
            }
            sb.format("%n", new Object[0]);
            int count = 0;
            sb.format("     %7s %3s %3s %6s %3s%n", "N", "dups", "Miss", "density", "partition");
            int totalN = 0;
            int totalDups = 0;
            int totalMiss = 0;
            for (PartitionForVariable2D partVar : this.partList) {
                Partition part = PartitionCollection.this.partitions.get(partVar.partno);
                sb.format("   %2d: %7d %3d %3d   %6.2f   %d %s%n", count++, partVar.nrecords, partVar.ndups, partVar.missing, Float.valueOf(partVar.density), partVar.partno, part.getFilename());
                totalN += partVar.nrecords;
                totalDups += partVar.ndups;
                totalMiss += partVar.missing;
            }
            sb.format("total: %4d %3d %3d %n", totalN, totalDups, totalMiss);
            sb.format("%n", new Object[0]);
            sb.format("totalSize = %4d density=%6.2f%n", this.totalSize, Float.valueOf(this.density));
            sb.format(super.toStringComplete(), new Object[0]);
            return sb.toString();
        }

        public void show(Formatter f) {
            if (this.twot != null) {
                this.twot.showMissing(f);
            }
            if (this.time2runtime != null) {
                Coordinate run = this.getCoordinate(Coordinate.Type.runtime);
                Coordinate tcoord = this.getCoordinate(Coordinate.Type.time);
                if (tcoord == null) {
                    tcoord = this.getCoordinate(Coordinate.Type.timeIntv);
                }
                CoordinateTimeAbstract time = (CoordinateTimeAbstract)tcoord;
                CalendarDate ref = time.getRefDate();
                CalendarPeriod.Field unit = time.getTimeUnit().getField();
                f.format("time2runtime: %n", new Object[0]);
                int count = 0;
                for (int idx : this.time2runtime) {
                    if (idx == 0) {
                        f.format(" %2d: MISSING%n", count);
                        ++count;
                        continue;
                    }
                    Object val = time.getValue(count);
                    f.format(" %2d: %s -> %2d (%s)", count, val, idx - 1, run.getValue(idx - 1));
                    if (val instanceof Integer) {
                        int valI = (Integer)val;
                        f.format(" == %s ", ref.add((double)valI, unit));
                    }
                    f.format(" %n", new Object[0]);
                    ++count;
                }
                f.format("%n", new Object[0]);
            }
        }

        public void cleanup() throws IOException {
        }

        DataRecord getDataRecord(int[] indexWanted) throws IOException {
            int[] sourceIndex;
            int runIdx;
            if (GribIosp.debugRead) {
                System.out.printf("%nPartitionCollection debugRead index wanted = (%s) on %s isTwod=%s%n", Misc.showInts((int[])indexWanted), PartitionCollection.this.indexFilename, this.group.isTwod);
            }
            int firstIndex = indexWanted[0];
            int n = runIdx = this.group.isTwod ? firstIndex : this.time2runtime[firstIndex] - 1;
            if (GribIosp.debugRead && !this.group.isTwod) {
                System.out.printf("  firstIndex = %d time2runtime[firstIndex]=%d %n", firstIndex, runIdx);
            }
            if (runIdx < 0) {
                return null;
            }
            CoordinateRuntime runtime = (CoordinateRuntime)this.getCoordinate(Coordinate.Type.runtime);
            Object val = runtime.getValue(runIdx);
            int masterIdx = PartitionCollection.this.masterRuntime.getIndex(val);
            int partno = PartitionCollection.this.run2part[masterIdx];
            if (GribIosp.debugRead) {
                System.out.printf("  runCoord = %s masterRuntime.getIndex(runCoord)=%d partition=%d %n", val, masterIdx, partno);
            }
            if (partno < 0) {
                return null;
            }
            GribCollection.VariableIndex compVindex2D = this.getVindex2D(partno);
            if (compVindex2D == null) {
                return null;
            }
            if (PartitionCollection.this.isPartitionOfPartitions) {
                VariableIndexPartitioned compVindex2Dp = (VariableIndexPartitioned)compVindex2D;
                return this.getDataRecordPofP(indexWanted, compVindex2Dp);
            }
            int[] nArray = sourceIndex = this.group.isTwod ? this.translateIndex2D(indexWanted, compVindex2D) : this.translateIndex1D(indexWanted, compVindex2D);
            if (sourceIndex == null) {
                return null;
            }
            GribCollection.Record record = compVindex2D.getSparseArray().getContent(sourceIndex);
            if (GribIosp.debugRead) {
                System.out.printf("  result success: partno=%d fileno=%d %n", partno, record.fileno);
            }
            return new DataRecord(PartitionCollection.this, partno, compVindex2D.group.getGdsHorizCoordSys(), record.fileno, record.pos, record.bmsPos, record.scanMode);
        }

        private DataRecord getDataRecordPofP(int[] indexWanted, VariableIndexPartitioned compVindex2Dp) throws IOException {
            if (this.group.isTwod) {
                int[] indexWantedP = this.translateIndex2D(indexWanted, compVindex2Dp);
                if (GribIosp.debugRead) {
                    System.out.printf("  getDataRecordPofP= %s %n", Misc.showInts((int[])indexWantedP));
                }
                return compVindex2Dp.getDataRecord(indexWantedP);
            }
            int[] indexWantedP = this.translateIndex1D(indexWanted, compVindex2Dp);
            if (GribIosp.debugRead) {
                System.out.printf("  getDataRecordPofP= %s %n", Misc.showInts((int[])indexWantedP));
            }
            if (indexWantedP == null) {
                return null;
            }
            return compVindex2Dp.getDataRecord(indexWantedP);
        }

        private GribCollection.VariableIndex getVindex2D(int partno) throws IOException {
            VariableIndexPartitioned vip = PartitionCollection.this.isPartitionOfPartitions ? (VariableIndexPartitioned)PartitionCollection.this.getVariable2DByHash(this.group.horizCoordSys, this.cdmHash) : this;
            PartitionForVariable2D partVar = null;
            for (PartitionForVariable2D pvar : vip.partList) {
                if (pvar.partno != partno) continue;
                partVar = pvar;
                break;
            }
            if (partVar == null) {
                if (GribIosp.debugRead) {
                    System.out.printf("  cant find partition=%d in vip=%s%n", partno, vip);
                }
                return null;
            }
            Partition p = PartitionCollection.this.getPartition(partno);
            try (GribCollection gc = p.getGribCollection();){
                GribCollection.Dataset ds = gc.getDatasetCanonical();
                GribCollection.GroupGC g = ds.groups.get(partVar.groupno);
                GribCollection.VariableIndex vindex = g.variList.get(partVar.varno);
                vindex.readRecords();
                GribCollection.VariableIndex variableIndex = vindex;
                return variableIndex;
            }
        }

        private int[] translateIndex1D(int[] wholeIndex, GribCollection.VariableIndex compVindex2D) {
            int[] result = new int[wholeIndex.length + 1];
            int timeIdx = wholeIndex[0];
            int runtimeIdxWhole = this.time2runtime[timeIdx] - 1;
            int runtimeIdxPart = this.matchCoordinate(this.getCoordinate(0), runtimeIdxWhole, compVindex2D.getCoordinate(0));
            if (runtimeIdxPart < 0) {
                return null;
            }
            result[0] = runtimeIdxPart;
            for (int countDim = 0; countDim < wholeIndex.length; ++countDim) {
                int resultIdx;
                int idx = wholeIndex[countDim];
                Coordinate compCoord = compVindex2D.getCoordinate(countDim + 1);
                Coordinate wholeCoord1D = this.getCoordinate(countDim + 1);
                if (compCoord.getType() == Coordinate.Type.time2D) {
                    CoordinateTime2D compCoord2D = (CoordinateTime2D)compCoord;
                    CoordinateTimeAbstract wholeCoord1Dtime = (CoordinateTimeAbstract)wholeCoord1D;
                    Object wholeVal = wholeCoord1D.getValue(idx);
                    resultIdx = compCoord2D.matchTimeCoordinate(runtimeIdxPart, wholeVal, wholeCoord1Dtime.getRefDate());
                    if (resultIdx < 0) {
                        resultIdx = compCoord2D.matchTimeCoordinate(runtimeIdxPart, wholeVal, wholeCoord1Dtime.getRefDate());
                    }
                } else {
                    resultIdx = this.matchCoordinate(wholeCoord1D, idx, compCoord);
                }
                if (resultIdx < 0) {
                    PartitionCollection.this.logger.info("Couldnt match coordinates for variable {}", (Object)compVindex2D);
                    return null;
                }
                result[countDim + 1] = resultIdx;
            }
            return result;
        }

        private int[] translateIndex2D(int[] wholeIndex, GribCollection.VariableIndex compVindex2D) {
            int[] result = new int[wholeIndex.length];
            int countDim = 0;
            CoordinateTime2D compTime2D = (CoordinateTime2D)compVindex2D.getCoordinate(Coordinate.Type.time2D);
            if (compTime2D != null) {
                CoordinateTime2D time2D = (CoordinateTime2D)this.getCoordinate(Coordinate.Type.time2D);
                CoordinateTime2D.Time2D want = time2D.getOrgValue(wholeIndex[0], wholeIndex[1], GribIosp.debugRead);
                if (GribIosp.debugRead) {
                    System.out.printf("  translateIndex2D[runIdx=%d, timeIdx=%d] in componentVar coords = (%s,%s) %n", wholeIndex[0], wholeIndex[1], want == null ? "null" : want.getRun(), want);
                }
                if (want == null) {
                    return null;
                }
                compTime2D.getIndex(want, result);
                countDim = 2;
            }
            while (countDim < wholeIndex.length) {
                int idx = wholeIndex[countDim];
                int resultIdx = this.matchCoordinate(this.getCoordinate(countDim), idx, compVindex2D.getCoordinate(countDim));
                if (GribIosp.debugRead) {
                    System.out.printf("  translateIndex2D[idx=%d] resultIdx= %d %n", idx, resultIdx);
                }
                if (resultIdx < 0) {
                    this.matchCoordinate(this.getCoordinate(countDim), idx, compVindex2D.getCoordinate(countDim));
                    return null;
                }
                result[countDim] = resultIdx;
                ++countDim;
            }
            return result;
        }

        private int matchCoordinate(Coordinate whole, int wholeIdx, Coordinate part) {
            Object val = whole.getValue(wholeIdx);
            if (val == null) {
                return -1;
            }
            return part.getIndex(val);
        }
    }

    class PartitionForVariable2D {
        int partno;
        int groupno;
        int varno;
        int flag;
        public int ndups;
        public int nrecords;
        public int missing;
        public float density;

        PartitionForVariable2D() {
        }
    }
}

