/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.collection.Grib2CollectionBuilderFromIndex;
import ucar.nc2.grib.collection.Grib2Partition;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.PartitionCollection;
import ucar.nc2.grib.collection.PartitionCollectionProto;
import ucar.unidata.io.RandomAccessFile;

public class Grib2PartitionBuilderFromIndex
extends Grib2CollectionBuilderFromIndex {
    private PartitionCollection pc;

    public static PartitionCollection createTimePartitionFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, boolean dataOnly, Logger logger) throws IOException {
        Grib2PartitionBuilderFromIndex builder = new Grib2PartitionBuilderFromIndex(name, config, dataOnly, logger);
        if (builder.readIndex(raf)) {
            return builder.pc;
        }
        return null;
    }

    private Grib2PartitionBuilderFromIndex(String name, FeatureCollectionConfig config, boolean dataOnly, Logger logger) {
        super(name, config, dataOnly, logger);
        this.pc = new Grib2Partition(name, null, config, logger);
        this.gc = this.pc;
    }

    @Override
    public String getMagicStart() {
        return "Grib2Partition2Index";
    }

    @Override
    protected boolean readExtensions(GribCollectionProto.GribCollection proto) {
        this.pc.isPartitionOfPartitions = (Boolean)proto.getExtension(PartitionCollectionProto.isPartitionOfPartitions);
        List list = (List)proto.getExtension(PartitionCollectionProto.run2Part);
        this.pc.run2part = new int[list.size()];
        int count = 0;
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int partno = (Integer)i$.next();
            this.pc.run2part[count++] = partno;
        }
        List partList = (List)proto.getExtension(PartitionCollectionProto.partitions);
        for (PartitionCollectionProto.Partition partProto : partList) {
            this.makePartition(partProto);
        }
        return partList.size() > 0;
    }

    @Override
    protected GribCollection.VariableIndex readVariableExtensions(GribCollection.GroupGC group, GribCollectionProto.Variable proto, GribCollection.VariableIndex vi) {
        List pvList = (List)proto.getExtension(PartitionCollectionProto.partition);
        PartitionCollection.VariableIndexPartitioned vip = this.pc.makeVariableIndexPartitioned(group, vi, pvList.size());
        for (PartitionCollectionProto.PartitionVariable pv : pvList) {
            vip.addPartition(pv.getPartno(), pv.getGroupno(), pv.getVarno(), pv.getFlag(), pv.getNdups(), pv.getNrecords(), pv.getMissing(), pv.getDensity());
        }
        return vip;
    }

    private PartitionCollection.Partition makePartition(PartitionCollectionProto.Partition proto) {
        return this.pc.addPartition(proto.getName(), proto.getFilename(), proto.getLastModified(), proto.getDirectory());
    }
}

