/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.grib.QuasiRegular;
import ucar.nc2.grib.grib1.Grib1DataReader;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.grib.grib1.Grib1SectionBitMap;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Record {
    private final Grib1SectionIndicator is;
    private final Grib1SectionGridDefinition gdss;
    private final Grib1SectionProductDefinition pdss;
    private final Grib1SectionBitMap bitmap;
    private final Grib1SectionBinaryData dataSection;
    private final byte[] header;
    private int file;

    public Grib1Record(byte[] header, Grib1SectionIndicator is, Grib1SectionGridDefinition gdss, Grib1SectionProductDefinition pdss, Grib1SectionBitMap bitmap, Grib1SectionBinaryData dataSection) {
        this.header = header;
        this.is = is;
        this.gdss = gdss;
        this.pdss = pdss;
        this.bitmap = bitmap;
        this.dataSection = dataSection;
    }

    public Grib1Record(RandomAccessFile raf) throws IOException {
        this.header = null;
        this.is = new Grib1SectionIndicator(raf);
        this.pdss = new Grib1SectionProductDefinition(raf);
        this.gdss = this.pdss.gdsExists() ? new Grib1SectionGridDefinition(raf) : new Grib1SectionGridDefinition(this.pdss);
        this.bitmap = this.pdss.bmsExists() ? new Grib1SectionBitMap(raf) : null;
        this.dataSection = new Grib1SectionBinaryData(raf);
    }

    Grib1Record(Grib1Record from) {
        this.header = from.header;
        this.is = from.is;
        this.gdss = from.gdss;
        this.pdss = from.pdss;
        this.bitmap = from.bitmap;
        this.dataSection = from.dataSection;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public Grib1SectionIndicator getIs() {
        return this.is;
    }

    public Grib1SectionGridDefinition getGDSsection() {
        return this.gdss;
    }

    public Grib1SectionProductDefinition getPDSsection() {
        return this.pdss;
    }

    public Grib1SectionBitMap getBitMapSection() {
        return this.bitmap;
    }

    public Grib1SectionBinaryData getDataSection() {
        return this.dataSection;
    }

    public CalendarDate getReferenceDate() {
        return this.pdss.getReferenceDate();
    }

    public int getFile() {
        return this.file;
    }

    public void setFile(int file) {
        this.file = file;
    }

    public float[] readData(RandomAccessFile raf) throws IOException {
        Grib1Gds gds = this.gdss.getGDS();
        Grib1DataReader reader = new Grib1DataReader(this.pdss.getDecimalScale(), gds.getScanMode(), gds.getNx(), gds.getNy(), gds.getNpts(), this.dataSection.getStartingPosition());
        byte[] bm = this.bitmap == null ? null : this.bitmap.getBitmap(raf);
        float[] data = reader.getData(raf, bm);
        if (this.gdss.isThin()) {
            data = QuasiRegular.convertQuasiGrid(data, gds.getNptsInLine(), gds.getNxRaw(), gds.getNyRaw());
        }
        return data;
    }

    public void showDataInfo(RandomAccessFile raf, Formatter f) throws IOException {
        Grib1Gds gds = this.gdss.getGDS();
        f.format(" decimal scale = %d%n", this.pdss.getDecimalScale());
        f.format("     scan mode = %d%n", gds.getScanMode());
        f.format("            nx = %d%n", gds.getNx());
        f.format("            ny = %d%n", gds.getNy());
        f.format("          Npts = %d%n", gds.getNpts());
        f.format("        isThin = %s%n", this.gdss.isThin());
        Grib1DataReader reader = new Grib1DataReader(this.pdss.getDecimalScale(), gds.getScanMode(), gds.getNx(), gds.getNy(), gds.getNpts(), this.dataSection.getStartingPosition());
        reader.showDataInfo(raf, f);
    }

    public static float[] readData(RandomAccessFile raf, long startPos) throws IOException {
        raf.seek(startPos);
        Grib1Record gr = new Grib1Record(raf);
        return gr.readData(raf);
    }
}

