/*
 *
 *  * Copyright 1998-2014 University Corporation for Atmospheric Research/Unidata
 *  *
 *  *  Portions of this software were developed by the Unidata Program at the
 *  *  University Corporation for Atmospheric Research.
 *  *
 *  *  Access and use of this software shall impose the following obligations
 *  *  and understandings on the user. The user is granted the right, without
 *  *  any fee or cost, to use, copy, modify, alter, enhance and distribute
 *  *  this software, and any derivative works thereof, and its supporting
 *  *  documentation for any purpose whatsoever, provided that this entire
 *  *  notice appears in all copies of the software, derivative works and
 *  *  supporting documentation.  Further, UCAR requests that the user credit
 *  *  UCAR/Unidata in any publications that result from the use of this
 *  *  software or in any product that includes this software. The names UCAR
 *  *  and/or Unidata, however, may not be used in any advertising or publicity
 *  *  to endorse or promote any products or commercial entity unless specific
 *  *  written permission is obtained from UCAR/Unidata. The user also
 *  *  understands that UCAR/Unidata is not obligated to provide the user with
 *  *  any support, consulting, training or assistance of any kind with regard
 *  *  to the use, operation and performance of this software nor to provide
 *  *  the user with any updates, revisions, new versions or "bug fixes."
 *  *
 *  *  THIS SOFTWARE IS PROVIDED BY UCAR/UNIDATA "AS IS" AND ANY EXPRESS OR
 *  *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  *  DISCLAIMED. IN NO EVENT SHALL UCAR/UNIDATA BE LIABLE FOR ANY SPECIAL,
 *  *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *  *  FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *  *  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *  *  WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ucar/nc2/grib/collection/partitionCollection.proto

package ucar.nc2.grib.collection;

public final class PartitionCollectionProto {
  private PartitionCollectionProto() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registry.add(ucar.nc2.grib.collection.PartitionCollectionProto.partition);
    registry.add(ucar.nc2.grib.collection.PartitionCollectionProto.partitions);
    registry.add(ucar.nc2.grib.collection.PartitionCollectionProto.isPartitionOfPartitions);
    registry.add(ucar.nc2.grib.collection.PartitionCollectionProto.run2Part);
  }
  public interface PartitionVariableOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required uint32 groupno = 1;
    /**
     * <code>required uint32 groupno = 1;</code>
     */
    boolean hasGroupno();
    /**
     * <code>required uint32 groupno = 1;</code>
     */
    int getGroupno();

    // required uint32 varno = 2;
    /**
     * <code>required uint32 varno = 2;</code>
     */
    boolean hasVarno();
    /**
     * <code>required uint32 varno = 2;</code>
     */
    int getVarno();

    // required uint32 flag = 3;
    /**
     * <code>required uint32 flag = 3;</code>
     */
    boolean hasFlag();
    /**
     * <code>required uint32 flag = 3;</code>
     */
    int getFlag();

    // required uint32 partno = 4;
    /**
     * <code>required uint32 partno = 4;</code>
     */
    boolean hasPartno();
    /**
     * <code>required uint32 partno = 4;</code>
     */
    int getPartno();

    // optional float density = 7;
    /**
     * <code>optional float density = 7;</code>
     *
     * <pre>
     * optionally keep stats
     * </pre>
     */
    boolean hasDensity();
    /**
     * <code>optional float density = 7;</code>
     *
     * <pre>
     * optionally keep stats
     * </pre>
     */
    float getDensity();

    // optional uint32 ndups = 8;
    /**
     * <code>optional uint32 ndups = 8;</code>
     */
    boolean hasNdups();
    /**
     * <code>optional uint32 ndups = 8;</code>
     */
    int getNdups();

    // optional uint32 nrecords = 9;
    /**
     * <code>optional uint32 nrecords = 9;</code>
     */
    boolean hasNrecords();
    /**
     * <code>optional uint32 nrecords = 9;</code>
     */
    int getNrecords();

    // optional uint32 missing = 10;
    /**
     * <code>optional uint32 missing = 10;</code>
     */
    boolean hasMissing();
    /**
     * <code>optional uint32 missing = 10;</code>
     */
    int getMissing();
  }
  /**
   * Protobuf type {@code PartitionVariable}
   *
   * <pre>
   *&#47;////////////////////////////////////////////////////////////////////////
   * </pre>
   */
  public static final class PartitionVariable extends
      com.google.protobuf.GeneratedMessage
      implements PartitionVariableOrBuilder {
    // Use PartitionVariable.newBuilder() to construct.
    private PartitionVariable(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private PartitionVariable(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final PartitionVariable defaultInstance;
    public static PartitionVariable getDefaultInstance() {
      return defaultInstance;
    }

    public PartitionVariable getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private PartitionVariable(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              groupno_ = input.readUInt32();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              varno_ = input.readUInt32();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              flag_ = input.readUInt32();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              partno_ = input.readUInt32();
              break;
            }
            case 61: {
              bitField0_ |= 0x00000010;
              density_ = input.readFloat();
              break;
            }
            case 64: {
              bitField0_ |= 0x00000020;
              ndups_ = input.readUInt32();
              break;
            }
            case 72: {
              bitField0_ |= 0x00000040;
              nrecords_ = input.readUInt32();
              break;
            }
            case 80: {
              bitField0_ |= 0x00000080;
              missing_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_PartitionVariable_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_PartitionVariable_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.class, ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.Builder.class);
    }

    public static com.google.protobuf.Parser<PartitionVariable> PARSER =
        new com.google.protobuf.AbstractParser<PartitionVariable>() {
      public PartitionVariable parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PartitionVariable(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<PartitionVariable> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required uint32 groupno = 1;
    public static final int GROUPNO_FIELD_NUMBER = 1;
    private int groupno_;
    /**
     * <code>required uint32 groupno = 1;</code>
     */
    public boolean hasGroupno() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint32 groupno = 1;</code>
     */
    public int getGroupno() {
      return groupno_;
    }

    // required uint32 varno = 2;
    public static final int VARNO_FIELD_NUMBER = 2;
    private int varno_;
    /**
     * <code>required uint32 varno = 2;</code>
     */
    public boolean hasVarno() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint32 varno = 2;</code>
     */
    public int getVarno() {
      return varno_;
    }

    // required uint32 flag = 3;
    public static final int FLAG_FIELD_NUMBER = 3;
    private int flag_;
    /**
     * <code>required uint32 flag = 3;</code>
     */
    public boolean hasFlag() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required uint32 flag = 3;</code>
     */
    public int getFlag() {
      return flag_;
    }

    // required uint32 partno = 4;
    public static final int PARTNO_FIELD_NUMBER = 4;
    private int partno_;
    /**
     * <code>required uint32 partno = 4;</code>
     */
    public boolean hasPartno() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>required uint32 partno = 4;</code>
     */
    public int getPartno() {
      return partno_;
    }

    // optional float density = 7;
    public static final int DENSITY_FIELD_NUMBER = 7;
    private float density_;
    /**
     * <code>optional float density = 7;</code>
     *
     * <pre>
     * optionally keep stats
     * </pre>
     */
    public boolean hasDensity() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional float density = 7;</code>
     *
     * <pre>
     * optionally keep stats
     * </pre>
     */
    public float getDensity() {
      return density_;
    }

    // optional uint32 ndups = 8;
    public static final int NDUPS_FIELD_NUMBER = 8;
    private int ndups_;
    /**
     * <code>optional uint32 ndups = 8;</code>
     */
    public boolean hasNdups() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional uint32 ndups = 8;</code>
     */
    public int getNdups() {
      return ndups_;
    }

    // optional uint32 nrecords = 9;
    public static final int NRECORDS_FIELD_NUMBER = 9;
    private int nrecords_;
    /**
     * <code>optional uint32 nrecords = 9;</code>
     */
    public boolean hasNrecords() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional uint32 nrecords = 9;</code>
     */
    public int getNrecords() {
      return nrecords_;
    }

    // optional uint32 missing = 10;
    public static final int MISSING_FIELD_NUMBER = 10;
    private int missing_;
    /**
     * <code>optional uint32 missing = 10;</code>
     */
    public boolean hasMissing() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional uint32 missing = 10;</code>
     */
    public int getMissing() {
      return missing_;
    }

    private void initFields() {
      groupno_ = 0;
      varno_ = 0;
      flag_ = 0;
      partno_ = 0;
      density_ = 0F;
      ndups_ = 0;
      nrecords_ = 0;
      missing_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasGroupno()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasVarno()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasFlag()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasPartno()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt32(1, groupno_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt32(2, varno_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt32(3, flag_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt32(4, partno_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeFloat(7, density_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeUInt32(8, ndups_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeUInt32(9, nrecords_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeUInt32(10, missing_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, groupno_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, varno_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, flag_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, partno_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(7, density_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(8, ndups_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(9, nrecords_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(10, missing_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code PartitionVariable}
     *
     * <pre>
     *&#47;////////////////////////////////////////////////////////////////////////
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariableOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_PartitionVariable_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_PartitionVariable_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.class, ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.Builder.class);
      }

      // Construct using ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        groupno_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        varno_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        flag_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        partno_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        density_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000010);
        ndups_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        nrecords_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        missing_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_PartitionVariable_descriptor;
      }

      public ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable getDefaultInstanceForType() {
        return ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.getDefaultInstance();
      }

      public ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable build() {
        ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable buildPartial() {
        ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable result = new ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.groupno_ = groupno_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.varno_ = varno_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.flag_ = flag_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.partno_ = partno_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.density_ = density_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.ndups_ = ndups_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.nrecords_ = nrecords_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.missing_ = missing_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable) {
          return mergeFrom((ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable other) {
        if (other == ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.getDefaultInstance()) return this;
        if (other.hasGroupno()) {
          setGroupno(other.getGroupno());
        }
        if (other.hasVarno()) {
          setVarno(other.getVarno());
        }
        if (other.hasFlag()) {
          setFlag(other.getFlag());
        }
        if (other.hasPartno()) {
          setPartno(other.getPartno());
        }
        if (other.hasDensity()) {
          setDensity(other.getDensity());
        }
        if (other.hasNdups()) {
          setNdups(other.getNdups());
        }
        if (other.hasNrecords()) {
          setNrecords(other.getNrecords());
        }
        if (other.hasMissing()) {
          setMissing(other.getMissing());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasGroupno()) {
          
          return false;
        }
        if (!hasVarno()) {
          
          return false;
        }
        if (!hasFlag()) {
          
          return false;
        }
        if (!hasPartno()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required uint32 groupno = 1;
      private int groupno_ ;
      /**
       * <code>required uint32 groupno = 1;</code>
       */
      public boolean hasGroupno() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint32 groupno = 1;</code>
       */
      public int getGroupno() {
        return groupno_;
      }
      /**
       * <code>required uint32 groupno = 1;</code>
       */
      public Builder setGroupno(int value) {
        bitField0_ |= 0x00000001;
        groupno_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 groupno = 1;</code>
       */
      public Builder clearGroupno() {
        bitField0_ = (bitField0_ & ~0x00000001);
        groupno_ = 0;
        onChanged();
        return this;
      }

      // required uint32 varno = 2;
      private int varno_ ;
      /**
       * <code>required uint32 varno = 2;</code>
       */
      public boolean hasVarno() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint32 varno = 2;</code>
       */
      public int getVarno() {
        return varno_;
      }
      /**
       * <code>required uint32 varno = 2;</code>
       */
      public Builder setVarno(int value) {
        bitField0_ |= 0x00000002;
        varno_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 varno = 2;</code>
       */
      public Builder clearVarno() {
        bitField0_ = (bitField0_ & ~0x00000002);
        varno_ = 0;
        onChanged();
        return this;
      }

      // required uint32 flag = 3;
      private int flag_ ;
      /**
       * <code>required uint32 flag = 3;</code>
       */
      public boolean hasFlag() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required uint32 flag = 3;</code>
       */
      public int getFlag() {
        return flag_;
      }
      /**
       * <code>required uint32 flag = 3;</code>
       */
      public Builder setFlag(int value) {
        bitField0_ |= 0x00000004;
        flag_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 flag = 3;</code>
       */
      public Builder clearFlag() {
        bitField0_ = (bitField0_ & ~0x00000004);
        flag_ = 0;
        onChanged();
        return this;
      }

      // required uint32 partno = 4;
      private int partno_ ;
      /**
       * <code>required uint32 partno = 4;</code>
       */
      public boolean hasPartno() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>required uint32 partno = 4;</code>
       */
      public int getPartno() {
        return partno_;
      }
      /**
       * <code>required uint32 partno = 4;</code>
       */
      public Builder setPartno(int value) {
        bitField0_ |= 0x00000008;
        partno_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 partno = 4;</code>
       */
      public Builder clearPartno() {
        bitField0_ = (bitField0_ & ~0x00000008);
        partno_ = 0;
        onChanged();
        return this;
      }

      // optional float density = 7;
      private float density_ ;
      /**
       * <code>optional float density = 7;</code>
       *
       * <pre>
       * optionally keep stats
       * </pre>
       */
      public boolean hasDensity() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional float density = 7;</code>
       *
       * <pre>
       * optionally keep stats
       * </pre>
       */
      public float getDensity() {
        return density_;
      }
      /**
       * <code>optional float density = 7;</code>
       *
       * <pre>
       * optionally keep stats
       * </pre>
       */
      public Builder setDensity(float value) {
        bitField0_ |= 0x00000010;
        density_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional float density = 7;</code>
       *
       * <pre>
       * optionally keep stats
       * </pre>
       */
      public Builder clearDensity() {
        bitField0_ = (bitField0_ & ~0x00000010);
        density_ = 0F;
        onChanged();
        return this;
      }

      // optional uint32 ndups = 8;
      private int ndups_ ;
      /**
       * <code>optional uint32 ndups = 8;</code>
       */
      public boolean hasNdups() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional uint32 ndups = 8;</code>
       */
      public int getNdups() {
        return ndups_;
      }
      /**
       * <code>optional uint32 ndups = 8;</code>
       */
      public Builder setNdups(int value) {
        bitField0_ |= 0x00000020;
        ndups_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 ndups = 8;</code>
       */
      public Builder clearNdups() {
        bitField0_ = (bitField0_ & ~0x00000020);
        ndups_ = 0;
        onChanged();
        return this;
      }

      // optional uint32 nrecords = 9;
      private int nrecords_ ;
      /**
       * <code>optional uint32 nrecords = 9;</code>
       */
      public boolean hasNrecords() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional uint32 nrecords = 9;</code>
       */
      public int getNrecords() {
        return nrecords_;
      }
      /**
       * <code>optional uint32 nrecords = 9;</code>
       */
      public Builder setNrecords(int value) {
        bitField0_ |= 0x00000040;
        nrecords_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 nrecords = 9;</code>
       */
      public Builder clearNrecords() {
        bitField0_ = (bitField0_ & ~0x00000040);
        nrecords_ = 0;
        onChanged();
        return this;
      }

      // optional uint32 missing = 10;
      private int missing_ ;
      /**
       * <code>optional uint32 missing = 10;</code>
       */
      public boolean hasMissing() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional uint32 missing = 10;</code>
       */
      public int getMissing() {
        return missing_;
      }
      /**
       * <code>optional uint32 missing = 10;</code>
       */
      public Builder setMissing(int value) {
        bitField0_ |= 0x00000080;
        missing_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 missing = 10;</code>
       */
      public Builder clearMissing() {
        bitField0_ = (bitField0_ & ~0x00000080);
        missing_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:PartitionVariable)
    }

    static {
      defaultInstance = new PartitionVariable(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:PartitionVariable)
  }

  public interface PartitionOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required string name = 1;
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
     * </pre>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    // required string filename = 2;
    /**
     * <code>required string filename = 2;</code>
     *
     * <pre>
     * the gribCollection.ncx2 file
     * </pre>
     */
    boolean hasFilename();
    /**
     * <code>required string filename = 2;</code>
     *
     * <pre>
     * the gribCollection.ncx2 file
     * </pre>
     */
    java.lang.String getFilename();
    /**
     * <code>required string filename = 2;</code>
     *
     * <pre>
     * the gribCollection.ncx2 file
     * </pre>
     */
    com.google.protobuf.ByteString
        getFilenameBytes();

    // required string directory = 3;
    /**
     * <code>required string directory = 3;</code>
     *
     * <pre>
     * top directory
     * </pre>
     */
    boolean hasDirectory();
    /**
     * <code>required string directory = 3;</code>
     *
     * <pre>
     * top directory
     * </pre>
     */
    java.lang.String getDirectory();
    /**
     * <code>required string directory = 3;</code>
     *
     * <pre>
     * top directory
     * </pre>
     */
    com.google.protobuf.ByteString
        getDirectoryBytes();

    // optional uint64 lastModified = 4;
    /**
     * <code>optional uint64 lastModified = 4;</code>
     */
    boolean hasLastModified();
    /**
     * <code>optional uint64 lastModified = 4;</code>
     */
    long getLastModified();
  }
  /**
   * Protobuf type {@code Partition}
   */
  public static final class Partition extends
      com.google.protobuf.GeneratedMessage
      implements PartitionOrBuilder {
    // Use Partition.newBuilder() to construct.
    private Partition(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Partition(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Partition defaultInstance;
    public static Partition getDefaultInstance() {
      return defaultInstance;
    }

    public Partition getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Partition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              name_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              filename_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              directory_ = input.readBytes();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              lastModified_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_Partition_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_Partition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              ucar.nc2.grib.collection.PartitionCollectionProto.Partition.class, ucar.nc2.grib.collection.PartitionCollectionProto.Partition.Builder.class);
    }

    public static com.google.protobuf.Parser<Partition> PARSER =
        new com.google.protobuf.AbstractParser<Partition>() {
      public Partition parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Partition(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Partition> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required string name = 1;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // required string filename = 2;
    public static final int FILENAME_FIELD_NUMBER = 2;
    private java.lang.Object filename_;
    /**
     * <code>required string filename = 2;</code>
     *
     * <pre>
     * the gribCollection.ncx2 file
     * </pre>
     */
    public boolean hasFilename() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required string filename = 2;</code>
     *
     * <pre>
     * the gribCollection.ncx2 file
     * </pre>
     */
    public java.lang.String getFilename() {
      java.lang.Object ref = filename_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          filename_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string filename = 2;</code>
     *
     * <pre>
     * the gribCollection.ncx2 file
     * </pre>
     */
    public com.google.protobuf.ByteString
        getFilenameBytes() {
      java.lang.Object ref = filename_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        filename_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // required string directory = 3;
    public static final int DIRECTORY_FIELD_NUMBER = 3;
    private java.lang.Object directory_;
    /**
     * <code>required string directory = 3;</code>
     *
     * <pre>
     * top directory
     * </pre>
     */
    public boolean hasDirectory() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required string directory = 3;</code>
     *
     * <pre>
     * top directory
     * </pre>
     */
    public java.lang.String getDirectory() {
      java.lang.Object ref = directory_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          directory_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string directory = 3;</code>
     *
     * <pre>
     * top directory
     * </pre>
     */
    public com.google.protobuf.ByteString
        getDirectoryBytes() {
      java.lang.Object ref = directory_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        directory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional uint64 lastModified = 4;
    public static final int LASTMODIFIED_FIELD_NUMBER = 4;
    private long lastModified_;
    /**
     * <code>optional uint64 lastModified = 4;</code>
     */
    public boolean hasLastModified() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint64 lastModified = 4;</code>
     */
    public long getLastModified() {
      return lastModified_;
    }

    private void initFields() {
      name_ = "";
      filename_ = "";
      directory_ = "";
      lastModified_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasFilename()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasDirectory()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getFilenameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getDirectoryBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, lastModified_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getFilenameBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getDirectoryBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, lastModified_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.grib.collection.PartitionCollectionProto.Partition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(ucar.nc2.grib.collection.PartitionCollectionProto.Partition prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Partition}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements ucar.nc2.grib.collection.PartitionCollectionProto.PartitionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_Partition_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_Partition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                ucar.nc2.grib.collection.PartitionCollectionProto.Partition.class, ucar.nc2.grib.collection.PartitionCollectionProto.Partition.Builder.class);
      }

      // Construct using ucar.nc2.grib.collection.PartitionCollectionProto.Partition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        filename_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        directory_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        lastModified_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return ucar.nc2.grib.collection.PartitionCollectionProto.internal_static_Partition_descriptor;
      }

      public ucar.nc2.grib.collection.PartitionCollectionProto.Partition getDefaultInstanceForType() {
        return ucar.nc2.grib.collection.PartitionCollectionProto.Partition.getDefaultInstance();
      }

      public ucar.nc2.grib.collection.PartitionCollectionProto.Partition build() {
        ucar.nc2.grib.collection.PartitionCollectionProto.Partition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public ucar.nc2.grib.collection.PartitionCollectionProto.Partition buildPartial() {
        ucar.nc2.grib.collection.PartitionCollectionProto.Partition result = new ucar.nc2.grib.collection.PartitionCollectionProto.Partition(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.filename_ = filename_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.directory_ = directory_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.lastModified_ = lastModified_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof ucar.nc2.grib.collection.PartitionCollectionProto.Partition) {
          return mergeFrom((ucar.nc2.grib.collection.PartitionCollectionProto.Partition)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(ucar.nc2.grib.collection.PartitionCollectionProto.Partition other) {
        if (other == ucar.nc2.grib.collection.PartitionCollectionProto.Partition.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasFilename()) {
          bitField0_ |= 0x00000002;
          filename_ = other.filename_;
          onChanged();
        }
        if (other.hasDirectory()) {
          bitField0_ |= 0x00000004;
          directory_ = other.directory_;
          onChanged();
        }
        if (other.hasLastModified()) {
          setLastModified(other.getLastModified());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        if (!hasFilename()) {
          
          return false;
        }
        if (!hasDirectory()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        ucar.nc2.grib.collection.PartitionCollectionProto.Partition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (ucar.nc2.grib.collection.PartitionCollectionProto.Partition) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required string name = 1;
      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * name is used in TDS - eg the subdirectory when generated by TimePartitionCollections
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      // required string filename = 2;
      private java.lang.Object filename_ = "";
      /**
       * <code>required string filename = 2;</code>
       *
       * <pre>
       * the gribCollection.ncx2 file
       * </pre>
       */
      public boolean hasFilename() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required string filename = 2;</code>
       *
       * <pre>
       * the gribCollection.ncx2 file
       * </pre>
       */
      public java.lang.String getFilename() {
        java.lang.Object ref = filename_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          filename_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string filename = 2;</code>
       *
       * <pre>
       * the gribCollection.ncx2 file
       * </pre>
       */
      public com.google.protobuf.ByteString
          getFilenameBytes() {
        java.lang.Object ref = filename_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          filename_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string filename = 2;</code>
       *
       * <pre>
       * the gribCollection.ncx2 file
       * </pre>
       */
      public Builder setFilename(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        filename_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string filename = 2;</code>
       *
       * <pre>
       * the gribCollection.ncx2 file
       * </pre>
       */
      public Builder clearFilename() {
        bitField0_ = (bitField0_ & ~0x00000002);
        filename_ = getDefaultInstance().getFilename();
        onChanged();
        return this;
      }
      /**
       * <code>required string filename = 2;</code>
       *
       * <pre>
       * the gribCollection.ncx2 file
       * </pre>
       */
      public Builder setFilenameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        filename_ = value;
        onChanged();
        return this;
      }

      // required string directory = 3;
      private java.lang.Object directory_ = "";
      /**
       * <code>required string directory = 3;</code>
       *
       * <pre>
       * top directory
       * </pre>
       */
      public boolean hasDirectory() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required string directory = 3;</code>
       *
       * <pre>
       * top directory
       * </pre>
       */
      public java.lang.String getDirectory() {
        java.lang.Object ref = directory_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          directory_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string directory = 3;</code>
       *
       * <pre>
       * top directory
       * </pre>
       */
      public com.google.protobuf.ByteString
          getDirectoryBytes() {
        java.lang.Object ref = directory_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          directory_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string directory = 3;</code>
       *
       * <pre>
       * top directory
       * </pre>
       */
      public Builder setDirectory(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        directory_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string directory = 3;</code>
       *
       * <pre>
       * top directory
       * </pre>
       */
      public Builder clearDirectory() {
        bitField0_ = (bitField0_ & ~0x00000004);
        directory_ = getDefaultInstance().getDirectory();
        onChanged();
        return this;
      }
      /**
       * <code>required string directory = 3;</code>
       *
       * <pre>
       * top directory
       * </pre>
       */
      public Builder setDirectoryBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        directory_ = value;
        onChanged();
        return this;
      }

      // optional uint64 lastModified = 4;
      private long lastModified_ ;
      /**
       * <code>optional uint64 lastModified = 4;</code>
       */
      public boolean hasLastModified() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint64 lastModified = 4;</code>
       */
      public long getLastModified() {
        return lastModified_;
      }
      /**
       * <code>optional uint64 lastModified = 4;</code>
       */
      public Builder setLastModified(long value) {
        bitField0_ |= 0x00000008;
        lastModified_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 lastModified = 4;</code>
       */
      public Builder clearLastModified() {
        bitField0_ = (bitField0_ & ~0x00000008);
        lastModified_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Partition)
    }

    static {
      defaultInstance = new Partition(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Partition)
  }

  public static final int PARTITION_FIELD_NUMBER = 100;
  /**
   * <code>extend .Variable { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      ucar.nc2.grib.collection.GribCollectionProto.Variable,
      java.util.List<ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable>> partition = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.class,
        ucar.nc2.grib.collection.PartitionCollectionProto.PartitionVariable.getDefaultInstance());
  public static final int PARTITIONS_FIELD_NUMBER = 100;
  /**
   * <code>extend .GribCollection { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      ucar.nc2.grib.collection.GribCollectionProto.GribCollection,
      java.util.List<ucar.nc2.grib.collection.PartitionCollectionProto.Partition>> partitions = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        ucar.nc2.grib.collection.PartitionCollectionProto.Partition.class,
        ucar.nc2.grib.collection.PartitionCollectionProto.Partition.getDefaultInstance());
  public static final int ISPARTITIONOFPARTITIONS_FIELD_NUMBER = 101;
  /**
   * <code>extend .GribCollection { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      ucar.nc2.grib.collection.GribCollectionProto.GribCollection,
      java.lang.Boolean> isPartitionOfPartitions = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        java.lang.Boolean.class,
        null);
  public static final int RUN2PART_FIELD_NUMBER = 102;
  /**
   * <code>extend .GribCollection { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      ucar.nc2.grib.collection.GribCollectionProto.GribCollection,
      java.util.List<java.lang.Integer>> run2Part = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        java.lang.Integer.class,
        null);
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_PartitionVariable_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_PartitionVariable_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_Partition_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Partition_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n2ucar/nc2/grib/collection/partitionColl" +
      "ection.proto\032.ucar/nc2/grib/collection/g" +
      "ribCollection2.proto\"\224\001\n\021PartitionVariab" +
      "le\022\017\n\007groupno\030\001 \002(\r\022\r\n\005varno\030\002 \002(\r\022\014\n\004fl" +
      "ag\030\003 \002(\r\022\016\n\006partno\030\004 \002(\r\022\017\n\007density\030\007 \001(" +
      "\002\022\r\n\005ndups\030\010 \001(\r\022\020\n\010nrecords\030\t \001(\r\022\017\n\007mi" +
      "ssing\030\n \001(\r\"T\n\tPartition\022\014\n\004name\030\001 \002(\t\022\020" +
      "\n\010filename\030\002 \002(\t\022\021\n\tdirectory\030\003 \002(\t\022\024\n\014l" +
      "astModified\030\004 \001(\004:0\n\tpartition\022\t.Variabl" +
      "e\030d \003(\0132\022.PartitionVariable:/\n\npartition",
      "s\022\017.GribCollection\030d \003(\0132\n.Partition:0\n\027" +
      "isPartitionOfPartitions\022\017.GribCollection" +
      "\030e \002(\010:!\n\010run2part\022\017.GribCollection\030f \003(" +
      "\rB4\n\030ucar.nc2.grib.collectionB\030Partition" +
      "CollectionProto"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
      new com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner() {
        public com.google.protobuf.ExtensionRegistry assignDescriptors(
            com.google.protobuf.Descriptors.FileDescriptor root) {
          descriptor = root;
          internal_static_PartitionVariable_descriptor =
            getDescriptor().getMessageTypes().get(0);
          internal_static_PartitionVariable_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_PartitionVariable_descriptor,
              new java.lang.String[] { "Groupno", "Varno", "Flag", "Partno", "Density", "Ndups", "Nrecords", "Missing", });
          internal_static_Partition_descriptor =
            getDescriptor().getMessageTypes().get(1);
          internal_static_Partition_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_Partition_descriptor,
              new java.lang.String[] { "Name", "Filename", "Directory", "LastModified", });
          partition.internalInit(descriptor.getExtensions().get(0));
          partitions.internalInit(descriptor.getExtensions().get(1));
          isPartitionOfPartitions.internalInit(descriptor.getExtensions().get(2));
          run2Part.internalInit(descriptor.getExtensions().get(3));
          return null;
        }
      };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          ucar.nc2.grib.collection.GribCollectionProto.getDescriptor(),
        }, assigner);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
