/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionUpdateType;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.grib2.Grib2IndexProto;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Index
extends GribIndex {
    private static Logger logger = LoggerFactory.getLogger(Grib2Index.class);
    public static final String MAGIC_START = "Grib2Index";
    public static final int ScanModeMissing = 9999;
    private static final boolean debug = false;
    private static final int version = 6;
    private List<Grib2SectionGridDefinition> gdsList;
    private List<Grib2Record> records;

    public List<Grib2SectionGridDefinition> getGds() {
        return this.gdsList;
    }

    public List<Grib2Record> getRecords() {
        return this.records;
    }

    @Override
    public int getNRecords() {
        return this.records.size();
    }

    public boolean readIndex(String filename, long gribLastModified) throws IOException {
        return this.readIndex(filename, gribLastModified, CollectionUpdateType.test);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean readIndex(String filename, long gribLastModified, CollectionUpdateType force) throws IOException {
        File idxFile = GribCollection.getFileInCache(filename + ".gbx9");
        if (!idxFile.exists()) {
            return false;
        }
        long idxModified = idxFile.lastModified();
        if (force == CollectionUpdateType.test && idxModified < gribLastModified) {
            return false;
        }
        try (FileInputStream fin = new FileInputStream(idxFile);){
            if (!NcStream.readAndTest((InputStream)fin, (byte[])MAGIC_START.getBytes())) {
                logger.info("Bad magic number of grib index on file= {}", (Object)idxFile);
                boolean bl = false;
                return bl;
            }
            int v = NcStream.readVInt((InputStream)fin);
            if (v != 6) {
                if (v == 0) throw new IOException("GribIndex found version " + v + ", want version " + 6 + " on " + filename);
                if (v > 6) {
                    throw new IOException("GribIndex found version " + v + ", want version " + 6 + " on " + filename);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Grib2Index found version " + v + ", want version " + 6 + " on " + filename);
                }
                boolean bl = false;
                return bl;
            }
            int size = NcStream.readVInt((InputStream)fin);
            if (size <= 0 || size > 100000000) {
                logger.warn("Grib2Index bad size = " + size + " for " + filename + " index = " + idxFile.getPath());
                boolean bl = false;
                return bl;
            }
            byte[] m = new byte[size];
            NcStream.readFully((InputStream)fin, (byte[])m);
            Grib2IndexProto.Grib2Index proto = Grib2IndexProto.Grib2Index.parseFrom(m);
            String fname = proto.getFilename();
            this.gdsList = new ArrayList<Grib2SectionGridDefinition>(proto.getGdsListCount());
            for (Grib2IndexProto.GribGdsSection pgds : proto.getGdsListList()) {
                Grib2SectionGridDefinition gds = this.readGds(pgds);
                this.gdsList.add(gds);
            }
            this.records = new ArrayList<Grib2Record>(proto.getRecordsCount());
            Iterator<GeneratedMessage> iterator = proto.getRecordsList().iterator();
            while (iterator.hasNext()) {
                Grib2IndexProto.Grib2Record precord = (Grib2IndexProto.Grib2Record)iterator.next();
                this.records.add(this.readRecord(precord));
            }
            return true;
        }
        catch (NegativeArraySizeException e) {
            logger.error("GribIndex failed on " + filename, (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error("GribIndex failed on " + filename, (Throwable)e);
            return false;
        }
    }

    private Grib2Record readRecord(Grib2IndexProto.Grib2Record p) {
        Grib2SectionIndicator is = new Grib2SectionIndicator(p.getGribMessageStart(), p.getGribMessageLength(), p.getDiscipline());
        Grib2SectionIdentification ids = this.readIdMessage(p.getIds());
        Grib2SectionLocalUse lus = null;
        if (p.hasLus()) {
            lus = new Grib2SectionLocalUse(p.getLus().toByteArray());
        }
        int gdsIndex = p.getGdsIdx();
        Grib2SectionGridDefinition gds = this.gdsList.get(gdsIndex);
        Grib2SectionProductDefinition pds = new Grib2SectionProductDefinition(p.getPds().toByteArray());
        Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(p.getDrsPos(), p.getDrsNpoints(), p.getDrsTemplate());
        Grib2SectionBitMap bms = new Grib2SectionBitMap(p.getBmsPos(), p.getBmsIndicator());
        Grib2SectionData data = new Grib2SectionData(p.getDataPos(), p.getDataLen());
        boolean bmsReplaced = p.getBmsReplaced();
        int scanMode = p.getScanMode();
        return new Grib2Record(p.getHeader().toByteArray(), is, ids, lus, gds, pds, drs, bms, data, bmsReplaced, scanMode);
    }

    private Grib2SectionIdentification readIdMessage(Grib2IndexProto.GribIdSection p) {
        return new Grib2SectionIdentification(p.getCenterId(), p.getSubcenterId(), p.getMasterTableVersion(), p.getLocalTableVersion(), p.getSignificanceOfRT(), p.getRefDate(0), p.getRefDate(1), p.getRefDate(2), p.getRefDate(3), p.getRefDate(4), p.getRefDate(5), p.getProductionStatus(), p.getProcessedDataType());
    }

    private Grib2SectionGridDefinition readGds(Grib2IndexProto.GribGdsSection proto) {
        ByteString bytes = proto.getGds();
        return new Grib2SectionGridDefinition(bytes.toByteArray());
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean makeIndex(String filename, RandomAccessFile dataRaf) throws IOException {
        boolean bl;
        Throwable throwable;
        FileOutputStream fout;
        RandomAccessFile raf;
        boolean ok;
        File idxFileTmp;
        File idxFile;
        block25: {
            Grib2Record r;
            idxFile = GribCollection.getFileInCache(filename + ".gbx9");
            idxFileTmp = GribCollection.getFileInCache(filename + ".gbx9" + ".tmp");
            ok = false;
            raf = null;
            fout = new FileOutputStream(idxFileTmp);
            throwable = null;
            fout.write(MAGIC_START.getBytes(CDM.utf8Charset));
            NcStream.writeVInt((OutputStream)fout, (int)6);
            HashMap<Long, Integer> gdsMap = new HashMap<Long, Integer>();
            this.gdsList = new ArrayList<Grib2SectionGridDefinition>();
            this.records = new ArrayList<Grib2Record>(200);
            Grib2IndexProto.Grib2Index.Builder rootBuilder = Grib2IndexProto.Grib2Index.newBuilder();
            rootBuilder.setFilename(filename);
            if (dataRaf == null) {
                dataRaf = raf = new RandomAccessFile(filename, "r");
            }
            Grib2RecordScanner scan = new Grib2RecordScanner(dataRaf);
            while (scan.hasNext() && (r = scan.next()) != null) {
                this.records.add(r);
                Grib2SectionGridDefinition gdss = r.getGDSsection();
                Integer index = (Integer)gdsMap.get(gdss.calcCRC());
                if (index == null) {
                    this.gdsList.add(gdss);
                    index = this.gdsList.size() - 1;
                    gdsMap.put(gdss.calcCRC(), index);
                    rootBuilder.addGdsList(this.makeGdsProto(gdss));
                }
                rootBuilder.addRecords(this.makeRecordProto(r, index, gdss.getGDS().scanMode));
            }
            Grib2IndexProto.Grib2Index index = rootBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt((OutputStream)fout, (int)b.length);
            fout.write(b);
            logger.debug("  made gbx9 index for {} size={}", (Object)filename, (Object)b.length);
            ok = true;
            bl = true;
            if (raf == null) break block25;
            raf.close();
        }
        if (ok) {
            boolean deleteOk = !idxFile.exists() || idxFile.delete();
            boolean renameOk = idxFileTmp.renameTo(idxFile);
            if (!deleteOk) {
                logger.error("  could not delete Grib2Index= {}", (Object)idxFile.getPath());
            }
            if (!renameOk) {
                logger.error("  could not rename Grib2Index= {}", (Object)idxFile.getPath());
            }
        }
        return bl;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fout != null) {
                    if (throwable != null) {
                        try {
                            fout.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fout.close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    if (raf != null) {
                        raf.close();
                    }
                    if (ok) {
                        boolean deleteOk2 = !idxFile.exists() || idxFile.delete();
                        boolean renameOk2 = idxFileTmp.renameTo(idxFile);
                        if (!deleteOk2) {
                            logger.error("  could not delete Grib2Index= {}", (Object)idxFile.getPath());
                        }
                        if (!renameOk2) {
                            logger.error("  could not rename Grib2Index= {}", (Object)idxFile.getPath());
                        }
                    }
                    throw throwable4;
                }
            }
        }
    }

    private Grib2IndexProto.Grib2Record makeRecordProto(Grib2Record r, int gdsIndex, int scanMode) throws IOException {
        Grib2IndexProto.Grib2Record.Builder b = Grib2IndexProto.Grib2Record.newBuilder();
        b.setHeader(ByteString.copyFrom((byte[])r.getHeader()));
        b.setGribMessageStart(r.getIs().getStartPos());
        b.setGribMessageLength(r.getIs().getMessageLength());
        b.setDiscipline(r.getDiscipline());
        b.setIds(this.makeIdProto(r.getId()));
        byte[] lus = r.getLocalUseSection().getRawBytes();
        if (lus != null && lus.length > 0) {
            b.setLus(ByteString.copyFrom((byte[])lus));
        }
        b.setGdsIdx(gdsIndex);
        b.setPds(ByteString.copyFrom((byte[])r.getPDSsection().getRawBytes()));
        Grib2SectionDataRepresentation drs = r.getDataRepresentationSection();
        b.setDrsPos(drs.getStartingPosition());
        b.setDrsNpoints(drs.getDataPoints());
        b.setDrsTemplate(drs.getDataTemplate());
        Grib2SectionBitMap bms = r.getBitmapSection();
        b.setBmsPos(bms.getStartingPosition());
        b.setBmsIndicator(bms.getBitMapIndicator());
        b.setBmsReplaced(r.isBmsReplaced());
        Grib2SectionData ds = r.getDataSection();
        b.setDataPos(ds.getStartingPosition());
        b.setDataLen(ds.getMsgLength());
        b.setScanMode(scanMode);
        return b.build();
    }

    private Grib2IndexProto.GribGdsSection makeGdsProto(Grib2SectionGridDefinition gds) throws IOException {
        Grib2IndexProto.GribGdsSection.Builder b = Grib2IndexProto.GribGdsSection.newBuilder();
        b.setGds(ByteString.copyFrom((byte[])gds.getRawBytes()));
        return b.build();
    }

    private Grib2IndexProto.GribIdSection makeIdProto(Grib2SectionIdentification id) throws IOException {
        Grib2IndexProto.GribIdSection.Builder b = Grib2IndexProto.GribIdSection.newBuilder();
        b.setCenterId(id.getCenter_id());
        b.setSubcenterId(id.getSubcenter_id());
        b.setMasterTableVersion(id.getMaster_table_version());
        b.setLocalTableVersion(id.getLocal_table_version());
        b.setSignificanceOfRT(id.getSignificanceOfRT());
        b.addRefDate(id.getYear());
        b.addRefDate(id.getMonth());
        b.addRefDate(id.getDay());
        b.addRefDate(id.getHour());
        b.addRefDate(id.getMinute());
        b.addRefDate(id.getSecond());
        b.setProductionStatus(id.getProductionStatus());
        b.setProcessedDataType(id.getTypeOfProcessedData());
        return b.build();
    }

    public static void main(String[] args) throws IOException {
        String gribName = args[0];
        new Grib2Index().makeIndex(gribName, null);
    }
}

