/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilderImpl;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.TwoDTimeInventory;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Indent;

public class CoordinateTime2D
extends CoordinateTimeAbstract
implements Coordinate {
    private final CoordinateRuntime runtime;
    private final List<Coordinate> times;
    private final CoordinateTimeAbstract otime;
    private final SortedMap<Integer, CoordinateTimeAbstract> regTimes;
    private int[] offset;
    private final boolean isRegular;
    private final boolean isOrthogonal;
    private final boolean isTimeInterval;
    private final int nruns;
    private final int ntimes;
    private final List<Time2D> vals;

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, List<Time2D> vals, CoordinateRuntime runtime, List<Coordinate> times) {
        super(code, timeUnit, runtime.getFirstDate());
        this.runtime = runtime;
        this.times = times;
        this.otime = null;
        this.regTimes = null;
        this.isRegular = false;
        this.isOrthogonal = false;
        this.isTimeInterval = times.get(0) instanceof CoordinateTimeIntv;
        int nmax = 0;
        for (Coordinate time : times) {
            nmax = Math.max(nmax, time.getSize());
        }
        this.ntimes = nmax;
        this.nruns = runtime.getSize();
        assert (this.nruns == times.size());
        this.makeOffsets(times);
        this.vals = vals;
    }

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, CoordinateRuntime runtime, CoordinateTimeAbstract otime, List<Coordinate> times) {
        super(code, timeUnit, runtime.getFirstDate());
        this.runtime = runtime;
        this.times = times;
        this.otime = otime;
        this.isOrthogonal = true;
        this.isRegular = false;
        this.regTimes = null;
        this.isTimeInterval = otime instanceof CoordinateTimeIntv;
        this.ntimes = otime.getSize();
        this.nruns = runtime.getSize();
        this.makeOffsets(timeUnit);
        this.vals = null;
    }

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, CoordinateRuntime runtime, List<Coordinate> regList, List<Coordinate> times) {
        super(code, timeUnit, runtime.getFirstDate());
        this.runtime = runtime;
        this.nruns = runtime.getSize();
        this.times = times;
        this.otime = null;
        this.isOrthogonal = false;
        this.isRegular = true;
        CoordinateTimeAbstract first = (CoordinateTimeAbstract)regList.get(0);
        this.isTimeInterval = first instanceof CoordinateTimeIntv;
        int nmax = 0;
        for (Coordinate time : regList) {
            nmax = Math.max(nmax, time.getSize());
        }
        this.ntimes = nmax;
        this.regTimes = new TreeMap<Integer, CoordinateTimeAbstract>();
        for (Coordinate coord : regList) {
            CoordinateTimeAbstract time = (CoordinateTimeAbstract)coord;
            CalendarDate ref = time.getRefDate();
            int hour = ref.getHourOfDay();
            this.regTimes.put(hour, time);
        }
        this.makeOffsets(timeUnit);
        this.vals = null;
    }

    private void makeOffsets(List<Coordinate> orgTimes) {
        CalendarDate firstDate = this.runtime.getFirstDate();
        this.offset = new int[this.nruns];
        for (int idx = 0; idx < this.nruns; ++idx) {
            CoordinateTimeAbstract coordTime = (CoordinateTimeAbstract)orgTimes.get(idx);
            CalendarPeriod period = coordTime.getPeriod();
            this.offset[idx] = period.getOffset(firstDate, this.runtime.getDate(idx));
        }
    }

    private void makeOffsets(CalendarPeriod period) {
        CalendarDate firstDate = this.runtime.getFirstDate();
        this.offset = new int[this.nruns];
        for (int idx = 0; idx < this.nruns; ++idx) {
            this.offset[idx] = period.getOffset(firstDate, this.runtime.getDate(idx));
        }
    }

    public CoordinateRuntime getRuntimeCoordinate() {
        return this.runtime;
    }

    public boolean isTimeInterval() {
        return this.isTimeInterval;
    }

    public boolean isOrthogonal() {
        return this.isOrthogonal;
    }

    public boolean isRegular() {
        return this.isRegular;
    }

    public int getNtimes() {
        return this.ntimes;
    }

    public int getNruns() {
        return this.nruns;
    }

    public int getOffset(int runIndex) {
        return this.offset[runIndex];
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s nruns=%d ntimes=%d isOrthogonal=%s isRegular=%s%n", this.name, this.nruns, this.ntimes, this.isOrthogonal, this.isRegular);
        this.runtime.showInfo(info, indent);
        indent.incr();
        info.format("%nAll time values=", new Object[0]);
        List<? extends Object> timeValues = this.getOffsetsSorted();
        for (Object object : timeValues) {
            info.format(" %s,", object);
        }
        info.format(" (n=%d)%n%n", timeValues.size());
        if (this.isOrthogonal) {
            this.otime.showInfo(info, indent);
        } else if (this.isRegular) {
            Iterator<? extends Object> i$ = this.regTimes.keySet().iterator();
            while (i$.hasNext()) {
                int n = (Integer)i$.next();
                CoordinateTimeAbstract timeCoord = (CoordinateTimeAbstract)this.regTimes.get(n);
                info.format("%shour %d: ", indent, n);
                timeCoord.showInfo(info, new Indent(0));
            }
        } else {
            for (Coordinate coordinate : this.times) {
                info.format("%s%s:", indent, ((CoordinateTimeAbstract)coordinate).getRefDate());
                coordinate.showInfo(info, new Indent(0));
            }
        }
        indent.decr();
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("%s nruns=%d ntimes=%d isOrthogonal=%s isRegular=%s%n", this.name, this.nruns, this.ntimes, this.isOrthogonal, this.isRegular);
        this.runtime.showCoords(info);
        if (this.isOrthogonal) {
            this.otime.showCoords(info);
        } else if (this.isRegular) {
            for (int hour : this.regTimes.keySet()) {
                CoordinateTimeAbstract timeCoord = (CoordinateTimeAbstract)this.regTimes.get(hour);
                info.format("hour %d: ", hour);
                timeCoord.showInfo(info, new Indent(0));
            }
        } else {
            for (Coordinate time : this.times) {
                time.showCoords(info);
            }
        }
    }

    @Override
    public List<? extends Object> getValues() {
        return this.vals;
    }

    @Override
    public Object getValue(int idx) {
        return this.vals == null ? null : this.vals.get(idx);
    }

    @Override
    public int getIndex(Object val) {
        return this.vals == null ? -1 : Collections.binarySearch(this.vals, (Time2D)val);
    }

    @Override
    public int getSize() {
        return this.vals == null ? 0 : this.vals.size();
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.time2D;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateTime2D that = (CoordinateTime2D)o;
        if (this.isOrthogonal != that.isOrthogonal) {
            return false;
        }
        if (this.isRegular != that.isRegular) {
            return false;
        }
        if (this.isTimeInterval != that.isTimeInterval) {
            return false;
        }
        if (this.otime != null ? !this.otime.equals(that.otime) : that.otime != null) {
            return false;
        }
        if (this.regTimes != null ? !this.regTimes.equals(that.regTimes) : that.regTimes != null) {
            return false;
        }
        if (!this.runtime.equals(that.runtime)) {
            return false;
        }
        return !(this.times != null ? !this.times.equals(that.times) : that.times != null);
    }

    public int hashCode() {
        int result = this.runtime.hashCode();
        result = 31 * result + (this.times != null ? this.times.hashCode() : 0);
        result = 31 * result + (this.otime != null ? this.otime.hashCode() : 0);
        result = 31 * result + (this.regTimes != null ? this.regTimes.hashCode() : 0);
        result = 31 * result + (this.isRegular ? 1 : 0);
        result = 31 * result + (this.isOrthogonal ? 1 : 0);
        result = 31 * result + (this.isTimeInterval ? 1 : 0);
        return result;
    }

    public String getTimeIntervalName() {
        if (!this.isTimeInterval) {
            return null;
        }
        if (this.isOrthogonal) {
            return ((CoordinateTimeIntv)this.otime).getTimeIntervalName();
        }
        if (this.isRegular) {
            String firstValue = null;
            for (CoordinateTimeAbstract timeCoord : this.regTimes.values()) {
                CoordinateTimeIntv timeCoordi = (CoordinateTimeIntv)timeCoord;
                String value = timeCoordi.getTimeIntervalName();
                if (firstValue == null) {
                    firstValue = value;
                    continue;
                }
                if (!value.equals(firstValue)) {
                    return "Mixed_intervals";
                }
                if (!value.equals("Mixed_intervals")) continue;
                return "Mixed_intervals";
            }
            return firstValue;
        }
        String firstValue = null;
        for (Coordinate timeCoord : this.times) {
            CoordinateTimeIntv timeCoordi = (CoordinateTimeIntv)timeCoord;
            String value = timeCoordi.getTimeIntervalName();
            if (firstValue == null) {
                firstValue = value;
                continue;
            }
            if (!value.equals(firstValue)) {
                return "Mixed_intervals";
            }
            if (!value.equals("Mixed_intervals")) continue;
            return "Mixed_intervals";
        }
        return firstValue;
    }

    @Override
    public CalendarDateRange makeCalendarDateRange(Calendar cal) {
        CoordinateTimeAbstract firstCoord = this.getTimeCoordinate(0);
        CoordinateTimeAbstract lastCoord = this.getTimeCoordinate(this.nruns - 1);
        CalendarDateRange firstRange = firstCoord.makeCalendarDateRange(cal);
        CalendarDateRange lastRange = lastCoord.makeCalendarDateRange(cal);
        return CalendarDateRange.of((CalendarDate)firstRange.getStart(), (CalendarDate)lastRange.getEnd());
    }

    public CoordinateTimeAbstract getTimeCoordinate(int runIdx) {
        if (this.isOrthogonal) {
            return this.factory(this.otime, this.getRefDate(runIdx));
        }
        if (this.isRegular) {
            CalendarDate ref = this.getRefDate(runIdx);
            int hour = ref.getHourOfDay();
            return (CoordinateTimeAbstract)this.regTimes.get(hour);
        }
        return (CoordinateTimeAbstract)this.times.get(runIdx);
    }

    public CalendarDate getRefDate(int runIdx) {
        return this.runtime.getDate(runIdx);
    }

    private CoordinateTimeAbstract factory(CoordinateTimeAbstract org, CalendarDate refDate) {
        if (this.isTimeInterval) {
            return new CoordinateTimeIntv((CoordinateTimeIntv)org, refDate);
        }
        return new CoordinateTime((CoordinateTime)org, refDate);
    }

    public Time2D getOrgValue(int runIdx, int timeIdx, boolean debug) {
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        CalendarDate runDate = this.runtime.getDate(runIdx);
        if (this.isTimeInterval) {
            TimeCoord.Tinv valIntv = (TimeCoord.Tinv)time.getValue(timeIdx);
            if (valIntv == null) {
                return null;
            }
            return new Time2D(runDate, null, valIntv);
        }
        Integer val = (Integer)time.getValue(timeIdx);
        if (val == null) {
            return null;
        }
        return new Time2D(runDate, val, null);
    }

    public boolean getIndex(Time2D want, int[] wholeIndex) {
        int runIdx = this.runtime.getIndex(want.run);
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        wholeIndex[0] = runIdx;
        wholeIndex[1] = this.isTimeInterval ? time.getIndex(want.tinv) : time.getIndex(want.time);
        return wholeIndex[0] >= 0 && wholeIndex[1] >= 0;
    }

    public int matchTimeCoordinate(int runIdx, Object value, CalendarDate refDateOfValue) {
        Comparable<TimeCoord.Tinv> valueWithOffset;
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        int offset = this.timeUnit.getOffset(this.getRefDate(runIdx), refDateOfValue);
        if (this.isTimeInterval) {
            TimeCoord.Tinv tinv = (TimeCoord.Tinv)value;
            valueWithOffset = tinv.offset(offset);
        } else {
            Integer val = (Integer)value;
            valueWithOffset = val + offset;
        }
        int result = time.getIndex(valueWithOffset);
        if (GribIosp.debugRead) {
            System.out.printf("  matchTimeCoordinate value wanted = (%s) valueWithOffset=%s result=%d %n", value, valueWithOffset, result);
        }
        return result;
    }

    @Override
    public CoordinateTimeAbstract makeBestTimeCoordinate(List<Double> runOffsets) {
        if (this.isTimeInterval) {
            HashSet<TimeCoord.Tinv> values = new HashSet<TimeCoord.Tinv>();
            for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
                CoordinateTimeIntv timeIntv = this.times == null ? (CoordinateTimeIntv)this.getTimeCoordinate(runIdx) : (CoordinateTimeIntv)this.times.get(runIdx);
                for (TimeCoord.Tinv tinv : timeIntv.getTimeIntervals()) {
                    values.add(tinv.offset(this.getOffset(runIdx)));
                }
            }
            ArrayList<TimeCoord.Tinv> offsetSorted = new ArrayList<TimeCoord.Tinv>(values.size());
            for (Object e : values) {
                offsetSorted.add((TimeCoord.Tinv)e);
            }
            Collections.sort(offsetSorted);
            return new CoordinateTimeIntv(this.getCode(), this.getTimeUnit(), this.getRefDate(), offsetSorted);
        }
        HashSet<Integer> values = new HashSet<Integer>();
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTime timeInt = this.times == null ? (CoordinateTime)this.getTimeCoordinate(runIdx) : (CoordinateTime)this.times.get(runIdx);
            for (Integer offset : timeInt.getOffsetSorted()) {
                values.add(offset + this.getOffset(runIdx));
            }
        }
        ArrayList<Integer> offsetSorted = new ArrayList<Integer>(values.size());
        for (Object e : values) {
            offsetSorted.add((Integer)e);
        }
        Collections.sort(offsetSorted);
        return new CoordinateTime(this.getCode(), this.getTimeUnit(), this.getRefDate(), offsetSorted);
    }

    public int[] makeTime2RuntimeMap(CoordinateTimeAbstract coordBest, TwoDTimeInventory timeInventory) {
        if (this.isTimeInterval) {
            return this.makeTime2RuntimeMap((CoordinateTimeIntv)coordBest, timeInventory);
        }
        return this.makeTime2RuntimeMap((CoordinateTime)coordBest, timeInventory);
    }

    private int[] makeTime2RuntimeMap(CoordinateTimeIntv coordBest, TwoDTimeInventory twot) {
        int[] result = new int[coordBest.getSize()];
        HashMap<TimeCoord.Tinv, Integer> map = new HashMap<TimeCoord.Tinv, Integer>();
        int count = 0;
        for (TimeCoord.Tinv val : coordBest.getTimeIntervals()) {
            map.put(val, count++);
        }
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTimeIntv timeIntv = this.times == null ? (CoordinateTimeIntv)this.getTimeCoordinate(runIdx) : (CoordinateTimeIntv)this.times.get(runIdx);
            int timeIdx = 0;
            for (TimeCoord.Tinv bestVal : timeIntv.getTimeIntervals()) {
                if (twot == null || twot.getCount(runIdx, timeIdx) > 0) {
                    Integer bestValIdx = (Integer)map.get(bestVal.offset(this.getOffset(runIdx)));
                    if (bestValIdx == null) {
                        throw new IllegalStateException();
                    }
                    result[bestValIdx.intValue()] = runIdx + 1;
                }
                ++timeIdx;
            }
        }
        return result;
    }

    private int[] makeTime2RuntimeMap(CoordinateTime coordBest, TwoDTimeInventory twot) {
        int[] result = new int[coordBest.getSize()];
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int count = 0;
        for (Integer val : coordBest.getOffsetSorted()) {
            map.put(val, count++);
        }
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTime timeInt = this.times == null ? (CoordinateTime)this.getTimeCoordinate(runIdx) : (CoordinateTime)this.times.get(runIdx);
            int timeIdx = 0;
            for (Integer bestVal : timeInt.getOffsetSorted()) {
                if (twot == null || twot.getCount(runIdx, timeIdx) > 0) {
                    Integer bestValIdx = (Integer)map.get(bestVal + this.getOffset(runIdx));
                    if (bestValIdx == null) {
                        throw new IllegalStateException();
                    }
                    result[bestValIdx.intValue()] = runIdx + 1;
                }
                ++timeIdx;
            }
        }
        return result;
    }

    public List<? extends Coordinate> getTimesForSerialization() {
        if (this.isOrthogonal) {
            ArrayList<CoordinateTimeAbstract> list = new ArrayList<CoordinateTimeAbstract>(1);
            list.add(this.otime);
            return list;
        }
        if (this.isRegular) {
            return new ArrayList<CoordinateTimeAbstract>(this.regTimes.values());
        }
        return this.times;
    }

    public List<? extends Object> getOffsetsSorted() {
        List<Coordinate> coords;
        if (this.isOrthogonal) {
            return this.otime.getValues();
        }
        List<Coordinate> list = coords = this.isRegular ? new ArrayList<CoordinateTimeAbstract>(this.regTimes.values()) : this.times;
        if (this.isTimeInterval) {
            return this.getIntervalsSorted(coords);
        }
        return this.getIntegersSorted(coords);
    }

    private List<Integer> getIntegersSorted(List<? extends Coordinate> coords) {
        HashSet<Integer> set = new HashSet<Integer>(100);
        for (Coordinate coordinate : coords) {
            for (Object object : coordinate.getValues()) {
                set.add((Integer)object);
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer val : set) {
            result.add(val);
        }
        Collections.sort(result);
        return result;
    }

    private List<TimeCoord.Tinv> getIntervalsSorted(List<? extends Coordinate> coords) {
        HashSet<TimeCoord.Tinv> set = new HashSet<TimeCoord.Tinv>(100);
        for (Coordinate coordinate : coords) {
            for (Object object : coordinate.getValues()) {
                set.add((TimeCoord.Tinv)object);
            }
        }
        ArrayList<TimeCoord.Tinv> result = new ArrayList<TimeCoord.Tinv>();
        for (TimeCoord.Tinv val : set) {
            result.add(val);
        }
        Collections.sort(result);
        return result;
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        private final boolean isTimeInterval;
        private final Grib1Customizer cust;
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CoordinateRuntime.Builder1 runBuilder;
        private final Map<Object, CoordinateBuilderImpl<Grib1Record>> timeBuilders;

        public Builder1(boolean isTimeInterval, Grib1Customizer cust, CalendarPeriod timeUnit, int code) {
            this.isTimeInterval = isTimeInterval;
            this.cust = cust;
            this.timeUnit = timeUnit;
            this.code = code;
            this.runBuilder = new CoordinateRuntime.Builder1(timeUnit);
            this.timeBuilders = new HashMap<Object, CoordinateBuilderImpl<Grib1Record>>();
        }

        @Override
        public void addRecord(Grib1Record gr) {
            super.addRecord(gr);
            this.runBuilder.addRecord(gr);
            Time2D val = (Time2D)this.extract(gr);
            CoordinateBuilderImpl<Grib1Record> timeBuilder = this.timeBuilders.get(val.run);
            timeBuilder.addRecord(gr);
        }

        @Override
        public Object extract(Grib1Record gr) {
            Object time;
            CalendarDate run = (CalendarDate)this.runBuilder.extract(gr);
            CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(run);
            if (timeBuilder == null) {
                timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder1(this.cust, this.code, this.timeUnit, run) : new CoordinateTime.Builder1(this.cust, this.code, this.timeUnit, run);
                this.timeBuilders.put(run, timeBuilder);
            }
            if ((time = timeBuilder.extract((Grib1Record)gr)) instanceof Integer) {
                return new Time2D(run, (Integer)time, null);
            }
            return new Time2D(run, null, (TimeCoord.Tinv)time);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            CoordinateRuntime runCoord = (CoordinateRuntime)this.runBuilder.finish();
            ArrayList<Coordinate> times = new ArrayList<Coordinate>();
            for (CalendarDate runtimeDate : runCoord.getRuntimesSorted()) {
                CoordinateBuilderImpl<Grib1Record> timeBuilder = this.timeBuilders.get(runtimeDate);
                times.add(timeBuilder.finish());
            }
            ArrayList<Time2D> vals = new ArrayList<Time2D>(values.size());
            for (Object val : values) {
                vals.add((Time2D)val);
            }
            Collections.sort(vals);
            return new CoordinateTime2D(this.code, this.timeUnit, vals, runCoord, times);
        }

        @Override
        public void addAll(Coordinate coord) {
            super.addAll(coord);
            for (Object object : coord.getValues()) {
                Time2D val2D = (Time2D)object;
                this.runBuilder.add(val2D.run);
                CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(val2D.run);
                if (timeBuilder == null) {
                    timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder1(this.cust, this.code, this.timeUnit, val2D.run) : new CoordinateTime.Builder1(this.cust, this.code, this.timeUnit, val2D.run);
                    this.timeBuilders.put(val2D.run, timeBuilder);
                }
                timeBuilder.add(this.isTimeInterval ? val2D.tinv : val2D.time);
            }
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        private final boolean isTimeInterval;
        private final Grib2Customizer cust;
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CoordinateRuntime.Builder2 runBuilder;
        private final Map<Object, CoordinateBuilderImpl<Grib2Record>> timeBuilders;

        public Builder2(boolean isTimeInterval, Grib2Customizer cust, CalendarPeriod timeUnit, int code) {
            this.isTimeInterval = isTimeInterval;
            this.cust = cust;
            this.timeUnit = timeUnit;
            this.code = code;
            this.runBuilder = new CoordinateRuntime.Builder2(timeUnit);
            this.timeBuilders = new HashMap<Object, CoordinateBuilderImpl<Grib2Record>>();
        }

        @Override
        public void addRecord(Grib2Record gr) {
            super.addRecord(gr);
            this.runBuilder.addRecord(gr);
            Time2D val = (Time2D)this.extract(gr);
            CoordinateBuilderImpl<Grib2Record> timeBuilder = this.timeBuilders.get(val.run);
            timeBuilder.addRecord(gr);
        }

        @Override
        public Object extract(Grib2Record gr) {
            Object time;
            CalendarDate run = (CalendarDate)this.runBuilder.extract(gr);
            CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(run);
            if (timeBuilder == null) {
                timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder2(this.cust, this.code, this.timeUnit, run) : new CoordinateTime.Builder2(this.code, this.timeUnit, run);
                this.timeBuilders.put(run, timeBuilder);
            }
            if ((time = timeBuilder.extract((Grib2Record)gr)) instanceof Integer) {
                return new Time2D(run, (Integer)time, null);
            }
            return new Time2D(run, null, (TimeCoord.Tinv)time);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            CoordinateRuntime runCoord = (CoordinateRuntime)this.runBuilder.finish();
            ArrayList<Coordinate> times = new ArrayList<Coordinate>();
            for (CalendarDate runtimeDate : runCoord.getRuntimesSorted()) {
                CoordinateBuilderImpl<Grib2Record> timeBuilder = this.timeBuilders.get(runtimeDate);
                times.add(timeBuilder.finish());
            }
            ArrayList<Time2D> vals = new ArrayList<Time2D>(values.size());
            for (Object val : values) {
                vals.add((Time2D)val);
            }
            Collections.sort(vals);
            return new CoordinateTime2D(this.code, this.timeUnit, vals, runCoord, times);
        }

        @Override
        public void addAll(Coordinate coord) {
            super.addAll(coord);
            for (Object object : coord.getValues()) {
                Time2D val2D = (Time2D)object;
                this.runBuilder.add(val2D.run);
                CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(val2D.run);
                if (timeBuilder == null) {
                    timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder2(this.cust, this.code, this.timeUnit, val2D.run) : new CoordinateTime.Builder2(this.code, this.timeUnit, val2D.run);
                    this.timeBuilders.put(val2D.run, timeBuilder);
                }
                timeBuilder.add(this.isTimeInterval ? val2D.tinv : val2D.time);
            }
        }
    }

    public static class Time2D
    implements Comparable<Time2D> {
        CalendarDate run;
        Integer time;
        TimeCoord.Tinv tinv;

        public Time2D(CalendarDate run, Integer time, TimeCoord.Tinv tinv) {
            this.run = run;
            this.time = time;
            this.tinv = tinv;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Time2D time2D = (Time2D)o;
            if (!this.run.equals((Object)time2D.run)) {
                return false;
            }
            if (this.time != null ? !this.time.equals(time2D.time) : time2D.time != null) {
                return false;
            }
            return !(this.tinv != null ? !this.tinv.equals(time2D.tinv) : time2D.tinv != null);
        }

        public int hashCode() {
            int result = this.run.hashCode();
            result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
            result = 31 * result + (this.tinv != null ? this.tinv.hashCode() : 0);
            return result;
        }

        public String toString() {
            if (this.time != null) {
                return this.time.toString();
            }
            return this.tinv.toString();
        }

        @Override
        public int compareTo(Time2D o) {
            int r = this.run.compareTo(o.run);
            if (r == 0) {
                r = this.time != null ? this.time.compareTo(o.time) : this.tinv.compareTo(o.tinv);
            }
            return r;
        }

        public CalendarDate getRun() {
            return this.run;
        }
    }
}

