/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateND;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateSharer;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateVert;
import ucar.coord.Counter;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.Grib1CollectionWriter;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCollectionBuilder;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Utils;
import ucar.nc2.grib.grib1.Grib1Variable;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.CloseableIterator;

public class Grib1CollectionBuilder
extends GribCollectionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(Grib1CollectionBuilder.class);
    private FeatureCollectionConfig.GribConfig gribConfig;
    private Grib1Customizer cust;

    public Grib1CollectionBuilder(String name, MCollection dcm, Logger logger) {
        super(true, name, dcm, logger);
        FeatureCollectionConfig config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
        this.gribConfig = config.gribConfig;
    }

    public List<Grib1CollectionWriter.Group> makeGroups(List<MFile> allFiles, boolean singleRuntime, Formatter errlog) throws IOException {
        HashMap<GribCollectionBuilder.GroupAndRuntime, Grib1CollectionWriter.Group> gdsMap = new HashMap<GribCollectionBuilder.GroupAndRuntime, Grib1CollectionWriter.Group>();
        logger.debug("Grib2CollectionBuilder {}: makeGroups", (Object)this.name);
        int fileno = 0;
        Counter statsAll = new Counter();
        logger.debug(" dcm={}", (Object)this.dcm);
        int totalRecords = 0;
        try (CloseableIterator iter = this.dcm.getFileIterator();){
            while (iter.hasNext()) {
                Grib1Index index;
                MFile mfile = (MFile)iter.next();
                try {
                    if (GribIosp.debugGbxIndexOnly) {
                        index = (Grib1Index)GribIndex.open(true, mfile);
                        if (index == null) {
                            continue;
                        }
                    } else {
                        index = (Grib1Index)GribIndex.readOrCreateIndexFromSingleFile(true, mfile, CollectionUpdateType.test, logger);
                    }
                    allFiles.add(mfile);
                }
                catch (IOException ioe) {
                    logger.error("Grib2CollectionBuilder " + this.name + " : reading/Creating gbx9 index for file " + mfile.getPath() + " failed", (Throwable)ioe);
                    continue;
                }
                if (index == null) {
                    logger.error("Grib2CollectionBuilder " + this.name + " : reading/Creating gbx9 index for file " + mfile.getPath() + " failed");
                    continue;
                }
                int n = index.getNRecords();
                totalRecords += n;
                for (Grib1Record gr : index.getRecords()) {
                    if (this.cust == null) {
                        this.cust = Grib1Customizer.factory(gr, null);
                        this.cust.setTimeUnitConverter(this.gribConfig.getTimeUnitConverter());
                    }
                    if (this.filterIntervals(gr, this.gribConfig.intvFilter)) {
                        ++statsAll.filter;
                        continue;
                    }
                    gr.setFile(fileno);
                    Grib1Gds gdsHashObject = gr.getGDS();
                    int gdsHash = this.gribConfig.convertGdsHash(gdsHashObject.hashCode());
                    if (0 == gdsHash) continue;
                    CalendarDate runtimeDate = gr.getReferenceDate();
                    long runtime = singleRuntime ? runtimeDate.getMillis() : 0L;
                    GribCollectionBuilder.GroupAndRuntime gar = new GribCollectionBuilder.GroupAndRuntime(gdsHashObject, runtime);
                    Grib1CollectionWriter.Group g = (Grib1CollectionWriter.Group)gdsMap.get(gar);
                    if (g == null) {
                        g = new Grib1CollectionWriter.Group(gr.getGDSsection(), gdsHashObject, runtimeDate);
                        gdsMap.put(gar, g);
                    }
                    g.records.add(gr);
                    g.runtimes.add(runtimeDate.getMillis());
                }
                ++fileno;
                statsAll.recordsTotal += index.getRecords().size();
            }
        }
        ArrayList<Grib1CollectionWriter.Group> groups = new ArrayList<Grib1CollectionWriter.Group>(gdsMap.values());
        for (Grib1CollectionWriter.Group g : groups) {
            Counter stats = new Counter();
            Grib1Rectilyser rect = new Grib1Rectilyser(g.records, g.gdsHashObject);
            rect.make(this.gribConfig, stats, errlog);
            g.gribVars = rect.gribvars;
            g.coords = rect.coords;
            statsAll.add(stats);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(statsAll.show());
        }
        return groups;
    }

    private boolean filterIntervals(Grib1Record gr, FeatureCollectionConfig.GribIntvFilter intvFilter) {
        Grib1SectionProductDefinition pdss = gr.getPDSsection();
        Grib1ParamTime ptime = gr.getParamTime(this.cust);
        if (!ptime.isInterval()) {
            return false;
        }
        int[] intv = ptime.getInterval();
        if (intv == null) {
            return false;
        }
        int haveLength = intv[1] - intv[0];
        if (haveLength == 0 && intvFilter != null && intvFilter.isZeroExcluded()) {
            return true;
        }
        if (intvFilter != null && intvFilter.hasFilter()) {
            int param;
            int version;
            int subcenter;
            int center = pdss.getCenter();
            int id = (center << 8) + ((subcenter = pdss.getSubCenter()) << 16) + ((version = pdss.getTableVersion()) << 24) + (param = pdss.getParameterNumber());
            return !intvFilter.filterOk(id, haveLength, Integer.MIN_VALUE);
        }
        return false;
    }

    @Override
    protected boolean writeIndex(String name, String indexFilepath, CoordinateRuntime masterRuntime, List<? extends GribCollectionBuilder.Group> groups, List<MFile> files) throws IOException {
        Grib1CollectionWriter writer = new Grib1CollectionWriter(this.dcm, logger);
        ArrayList<Grib1CollectionWriter.Group> groups2 = new ArrayList<Grib1CollectionWriter.Group>();
        for (GribCollectionBuilder.Group group : groups) {
            groups2.add((Grib1CollectionWriter.Group)group);
        }
        File indexFileInCache = GribIndexCache.getFileOrCache(indexFilepath);
        return writer.writeIndex(name, indexFileInCache, masterRuntime, groups2, files, this.type);
    }

    private class Grib1Rectilyser {
        private final int gdsHashOverride;
        private final List<Grib1Record> records;
        private List<VariableBag> gribvars;
        private List<Coordinate> coords;

        Grib1Rectilyser(List<Grib1Record> records, Object gdsHashObject) {
            this.records = records;
            int gdsHash = Grib1CollectionBuilder.this.gribConfig.convertGdsHash(gdsHashObject.hashCode());
            this.gdsHashOverride = gdsHash == gdsHashObject.hashCode() ? 0 : gdsHash;
        }

        public void make(FeatureCollectionConfig.GribConfig config, Counter counter, Formatter info) throws IOException {
            CalendarPeriod userTimeUnit = config.userTimeUnit;
            HashMap<Grib1Variable, VariableBag> vbHash = new HashMap<Grib1Variable, VariableBag>(100);
            for (Grib1Record gr : this.records) {
                Grib1Variable cdmHash;
                try {
                    cdmHash = new Grib1Variable(Grib1CollectionBuilder.this.cust, gr, this.gdsHashOverride, ((Grib1CollectionBuilder)Grib1CollectionBuilder.this).gribConfig.useTableVersion, ((Grib1CollectionBuilder)Grib1CollectionBuilder.this).gribConfig.intvMerge, ((Grib1CollectionBuilder)Grib1CollectionBuilder.this).gribConfig.useCenter);
                }
                catch (Throwable t) {
                    logger.warn("Exception on record ", t);
                    continue;
                }
                VariableBag bag = (VariableBag)vbHash.get(cdmHash);
                if (bag == null) {
                    bag = new VariableBag(gr, cdmHash);
                    vbHash.put(cdmHash, bag);
                }
                bag.atomList.add(gr);
            }
            this.gribvars = new ArrayList(vbHash.values());
            Collections.sort(this.gribvars);
            for (VariableBag vb : this.gribvars) {
                Grib1SectionProductDefinition pdss = vb.first.getPDSsection();
                Grib1ParamTime ptime = vb.first.getParamTime(Grib1CollectionBuilder.this.cust);
                int unit = Grib1CollectionBuilder.this.cust.convertTimeUnit(pdss.getTimeUnit());
                vb.timeUnit = userTimeUnit == null ? Grib2Utils.getCalendarPeriod(unit) : userTimeUnit;
                CoordinateND.Builder<Grib1Record> coordNBuilder = new CoordinateND.Builder<Grib1Record>();
                boolean isTimeInterval = ptime.isInterval();
                CoordinateTime2D.Builder1 builder2D = new CoordinateTime2D.Builder1(isTimeInterval, Grib1CollectionBuilder.this.cust, vb.timeUnit, unit);
                coordNBuilder.addBuilder(builder2D);
                if (vb.first.getPDSsection().isEnsemble()) {
                    coordNBuilder.addBuilder(new CoordinateEns.Builder1(Grib1CollectionBuilder.this.cust, 0));
                }
                if (Grib1CollectionBuilder.this.cust.isVerticalCoordinate(pdss.getLevelType())) {
                    coordNBuilder.addBuilder(new CoordinateVert.Builder1(Grib1CollectionBuilder.this.cust, pdss.getLevelType()));
                }
                for (Grib1Record gr : vb.atomList) {
                    coordNBuilder.addRecord(gr);
                }
                vb.coordND = coordNBuilder.finish(vb.atomList, info);
            }
            CoordinateSharer<Grib1Record> sharify = new CoordinateSharer<Grib1Record>(config.unionRuntimeCoord);
            for (VariableBag vb : this.gribvars) {
                sharify.addCoords(vb.coordND.getCoordinates());
            }
            sharify.finish();
            this.coords = sharify.getUnionCoords();
            int tot_used = 0;
            int tot_dups = 0;
            int total = 0;
            for (VariableBag vb : this.gribvars) {
                vb.coordND = sharify.reindexCoordND(vb.coordND);
                vb.coordIndex = sharify.reindex2shared(vb.coordND.getCoordinates());
                tot_used += vb.coordND.getSparseArray().countNotMissing();
                tot_dups += vb.coordND.getSparseArray().getNdups();
                total += vb.coordND.getSparseArray().getTotalSize();
            }
            counter.recordsUnique += tot_used;
            counter.dups += tot_dups;
            counter.vars += this.gribvars.size();
            counter.recordsTotal += total;
        }

        public void showInfo(Formatter f, Grib1Customizer cust1) {
            Counter all = new Counter();
            for (VariableBag vb : this.gribvars) {
                f.format("Variable %s (%d)%n", Grib1Iosp.makeVariableName(Grib1CollectionBuilder.this.cust, Grib1CollectionBuilder.this.gribConfig, vb.first.getPDSsection()), vb.hashCode());
                vb.coordND.showInfo(f, all);
                f.format("%n", new Object[0]);
            }
            f.format("%n all= %s", all.show());
        }
    }

    public static class VariableBag
    implements Comparable<VariableBag> {
        Grib1Record first;
        Grib1Variable gv;
        public List<Grib1Record> atomList = new ArrayList<Grib1Record>(100);
        public CoordinateND<Grib1Record> coordND;
        CalendarPeriod timeUnit;
        public List<Integer> coordIndex;
        long pos;
        int length;

        private VariableBag(Grib1Record first, Grib1Variable gv) {
            this.first = first;
            this.gv = gv;
        }

        @Override
        public int compareTo(VariableBag o) {
            return Grib1Utils.extractParameterCode(this.first).compareTo(Grib1Utils.extractParameterCode(o.first));
        }
    }
}

